/**
 * Copyright harmonic ( http://wonderfl.net/user/harmonic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1NJs
 */

//Flash CS3のビルトインクラスで3Dっぽい表現
//
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.Rectangle;
	import flash.geom.Point;
	import flash.geom.ColorTransform; 
	import flash.filters.BlurFilter;
	import net.hires.debug.Stats;
	[SWF(backgroundColor=0x0, frameRate=30)]
	public class Main extends Sprite {
		
		private const WIDTH:int = 465;
		private const HEIGHT:int = 465;
		private const RADIUS:Number = 150;
		private const ROWS:int = 36;
		private const COLS:int = 36;
		private const TO_RADIAN:Number = Math.PI / 180;
		private const MARGIN:int = 10;
		
		private var _canvas:BitmapData;
		private var _dots:Array;
		private var _rect:Rectangle;
		private var _colorTransForm:ColorTransform; 
		private var _gradientX:Number;
		private var _gradientZ:Number;
		
		public function Main() {
			_dots = [];
			_canvas = new BitmapData( WIDTH , HEIGHT , false , 0x0 );
			_rect = new Rectangle( 0 , 0 , WIDTH , HEIGHT );
			_colorTransForm = new ColorTransform(.95, .95, .95, 1.0); 
			_gradientZ = 0;
			_gradientX = 0;
			
			var dot:Dot;
			var radian:Number;
			for( var i:int = 0 ; i < ROWS ; i++ ){
				for( var j:int = 0 ; j < COLS ; j++ ){
					dot = new Dot();
					dot.latitude = ( 180 / ROWS ) * i;
					dot.y = Math.cos( dot.latitude * TO_RADIAN ) * RADIUS;
					dot.fixedY = dot.y;
					dot.radius = Math.sin( dot.latitude * TO_RADIAN ) * RADIUS;
					
					dot.longitude = ( 360 / COLS ) * j;
					dot.x = Math.sin( dot.longitude * TO_RADIAN ) * dot.radius;
					_dots.push( dot );
				}
			}
			addChild( new Bitmap( _canvas ) );
			addChild( new Stats() );
			addEventListener( Event.ENTER_FRAME , onEnterFrameHandler );
		}
		
		private function onEnterFrameHandler( event:Event ):void {
			_canvas.lock();
			_canvas.colorTransform( _rect , _colorTransForm );
			_canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(2, 2));	
			_gradientZ += ( ( stage.mouseY / HEIGHT ) * 360 - _gradientZ ) * 0.1;
			_gradientX = ( stage.mouseX - WIDTH / 2 ) / ( WIDTH * 0.3 );
			var n:int = _dots.length;
			var dot:Dot;
			var offsetY:Number;
			for( var i:int = 0 ; i < n ; i++ ){
				dot = _dots[ i ];
				offsetY = Math.cos( _gradientZ * TO_RADIAN ) * dot.fixedY;
				dot.longitude += _gradientX;
				dot.x = Math.sin( dot.longitude * TO_RADIAN ) * dot.radius;
				dot.y = Math.cos( ( _gradientZ - 90 ) * TO_RADIAN ) * ( Math.cos( dot.longitude * TO_RADIAN ) * dot.radius );
				_canvas.setPixel32( dot.x + WIDTH * 0.5 , offsetY + dot.y + HEIGHT * 0.5 , 0x66FFFF );
			}
			
			_canvas.unlock();
		}
	}
}

//===========================================

class Dot {
	public var x:Number;
	public var y:Number;
	public var fixedY:Number;
	public var radius:Number;
	private var _longitude:Number;//経度
	public function get longitude():Number{  return _longitude; };
	public function set longitude( value:Number ){ _longitude = value % 360; };
	private var _latitude:Number;//緯度
	public function get latitude():Number{  return _latitude; };
	public function set latitude( value:Number ){ _latitude = value % 360; };
	
	public function Dot(){}
}