/**
 * Copyright misusu1224 ( http://wonderfl.net/user/misusu1224 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Lua
 */

// forked from misusu1224's flash on 2011-5-16
package
{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import caurina.transitions.Tweener;
    import flash.display.BlendMode;
    
    
    public class Tweener_advanced01 extends Sprite
    {
        public function Tweener_advanced01()
        {
            // テキストフィールドの作成
            _characters = newCharacters('MSZ');
            // ラインの作成
            _lines = [newLine(0, 160, 550), 
                      newLine(0, 100, 550),
                      newLine(0, 40, 550),
                      newLine(0, 280, 550),
                      newLine(0, 340, 550),
                      newLine(0, 400, 550),
                      newLine(0, 460, 550),
                      newLine(640, 220, -280),
                      newLine(103, 220, -550)
                      ];
            // ボタンの作成
            _button = newButton('NEXT', 450, 356);
            // ボタンのクリックイベントハンドラの設定
            _button.addEventListener(MouseEvent.CLICK, nextButtonClickHandler);
            
            // トゥイーンの開始
            startTweens();
        }
        
        private var _characters:Array;
        private var _lines:Array;
        private var _button:Sprite;
        
        // トゥイーンをさせるメソッド
        private function startTweens():void
        {
            var i:uint;
            var l:uint;
            
            // 1文字ごとにトゥイーンを設定するループ
            for (i = 0, l = _characters.length; i < l; ++i) {
                // 文字のテキストフィールド
                var tf:TextField = _characters[i] as TextField;
                // 元の位置を覚えておく
                var originalY:int = tf.y;
                // ステージ外に移動
                tf.y = -30;
                // トゥイーンを設定
                Tweener.addTween(tf, {
                    y: originalY,
                    transition: 'easeOutBack',
                    time: 0.8,
                    delay: i * 0.06
                });
            }
            // 1ラインごとにトゥイーンを設定するループ
            for (i = 0, l = _lines.length; i < l; ++i) {
                // ライン
                var line:Shape = _lines[i];
                // スケールを 0.0 にしておく
                line.scaleX = 1;
                // トゥイーンを設定
                Tweener.addTween(line, {
                    scaleX: 1.0,
                    transition: 'eaesInSine',
                    time: 0.6,
                    delay: _characters.length * 0.06 + 0.6,
                    onComplete: (i == (l - 1)) ? startTweens : null
                       
                    
                });
            }
        }
        
        // ボタンがクリックされたときのハンドラ
        private function nextButtonClickHandler(e:MouseEvent):void
        {
            // イベントハンドラの削除
            _button.removeEventListener(MouseEvent.CLICK, nextButtonClickHandler);
            
            // 現在のトゥイーンの停止
            Tweener.removeAllTweens();
            
            // すべての要素をフェードするトゥイーンの開始
            Tweener.addTween(_characters, {
                alpha: 0.0,
                transition: 'easeOutSine',
                time: 0.3
            });
            Tweener.addTween(_lines, {
                alpha: 0.0,
                transition: 'easeOutSine',
                time: 0.3
            });
            Tweener.addTween(_button, {
                alpha: 0.0,
                transition: 'easeOutSine',
                time: 0.3
            });
        }
        
        // 文字を作るための便利メソッド
        private function newCharacters(text:String):Array
        {
            // テキストの長さ
            var l:uint = text.length;
            // 作成した文字(テキストフィールド)を入れるための配列
            var result:Array = new Array(l);
            // 文字に使用するテキストフォーマット
            var format:TextFormat = new TextFormat('Stencil Std', 150, 0x000000, true);
            // 後半のレイアウト用にテキストの高さを保持しておくための変数
            var textHeight:Number = 0;
            // 後半のレイアウト用にテキストの幅を保持しておくための変数
            var totalWidth:Number = 0;
            // ループ用のカウンタ
            var i:uint;
            // テキストフィールドを入れるための一時変数
            var tf:TextField;
            // 文字(テキストフィールド)の作成ループ (一文字ずつ作る、を文字数分繰り返す)
            for (i = 0; i < l; ++i) {
                // 文字を表示するためのテキストフィールドを作成
                tf = new TextField();
                // 作成しておいたテキストフォーマットを設定
                tf.defaultTextFormat = format;
                // 文字の幅によって左寄せで自動的にテキストフィールドの幅が設定されるよう設定
                tf.autoSize = TextFieldAutoSize.LEFT;
                // 表示する文字を設定
                tf.text = text.charAt(i);
                // X 座標を設定
                tf.x = totalWidth;
                // 最も高いテキストの高さを覚えておく
                textHeight = Math.max(textHeight, tf.textHeight);
                // いま作成した文字のテキスト幅を加算 (+2はマージン)
                totalWidth += tf.textWidth + 2;
                // 作成したテキストフィールドを保持
                result[i] = tf;
               
            }
            // ここからレイアウト (画面中央にセンタリングする)
            // センタリングするために必要な X 方向のオフセット
            var offsetX:Number = (stage.stageWidth - (totalWidth - 2)) / 2;
            // センタリングするための必要な Y 方向のオフセット
            var offsetY:Number = (stage.stageHeight - textHeight) / 2;
            // レイアウトのループ
            for (i = 0; i < l; ++i) {
                // 算出したオフセットを加算してレイアウトする
                tf = result[i] as TextField;
                tf.x += offsetX;
                tf.y += offsetY;
                // 画面に表示
                addChild(tf);
            }
            // 作成したテキストフィールドを返す
            return result;
        }
        
        // ラインを作るための便利メソッド
        private function newLine(x:uint, y:uint, w:int):Shape
        {
            var box:Shape = new Shape();
            box.graphics.beginFill(0x333333);
            box.graphics.drawRect(0, 0, w, 3);
            box.graphics.endFill();
            box.x = x;
            box.y = y;
            addChild(box);
            return box;
        }
        
        // ボタンを作るための便利メソッド
        private function newButton(text:String, x:uint, y:uint):Sprite
        {
            var label:TextField = new TextField();
            label.selectable = false;
            label.defaultTextFormat = new TextFormat('Verdana', 12, 0x666666);
            label.autoSize = TextFieldAutoSize.LEFT;
            label.text = text;
            label.x = Math.round((80 - label.textWidth) / 2.0);
            label.y = Math.round((24 - label.textHeight) / 2.0);
            var button:Sprite = new Sprite();
            button.buttonMode = true;
            button.mouseChildren = false;
            button.graphics.lineStyle(0, 0xcccccc);
            button.graphics.beginFill(0xeeeeee);
            button.graphics.drawRoundRect(0, 0, 80, 24, 4);
            button.graphics.endFill();
            button.addChild(label);
            button.x = x;
            button.y = y;
            addChild(button);
            return button;
        }
    }
}