/**
 * Copyright TetsuroKato ( http://wonderfl.net/user/TetsuroKato )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1L7H
 */

// forked from undo's カメラ映像を分解したり戻したり
/*
* カメラ画像を取得してRGBに分解します。
* 画面をクリックすると分割した画像を1点に重ねます。
* 背景が黒、ブレンドモードがADDなら元画像と同じになるはずです。
* ブレンドモードをいじったりしてみてください。
*/
package
{
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.system.Security;
    import flash.system.SecurityPanel;
    import com.bit101.components.Slider;
    
    [SWF(backgroundColor = 0x0)]

    public class CameraTests extends Sprite
    {
        public function CameraTests()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            this.camWidth = this.stage.stageWidth;
            this.camHeight = this.stage.stageHeight;
            init();
        }

        private var _cam:Camera;
        private var _vid:Video;
        private var _bmd:BitmapData;

        private var _redBmd:BitmapData;
        private var _greenBmd:BitmapData;
        private var _blueBmd:BitmapData;

        private var _rbm:Bitmap;
        private var _gbm:Bitmap;
        private var _bbm:Bitmap;

        private var camWidth:Number;
        private var camHeight:Number;
        private var camFPS:Number = 15;
        
        private var h_min:Slider;
        private var h_max:Slider;
        private var s_min:Slider;
        private var v_min:Slider;

        private var bMode:String = BlendMode.ADD;
        private var conved:Boolean = false;
        private function init():void
        {
            Security.allowDomain('*');
            
            _cam = Camera.getCamera();
            if(!_cam) return;
            
            _vid = new Video(camWidth, camHeight);
            _cam.setMode(camWidth, camHeight, camFPS);
            _vid.attachCamera(_cam);
            _bmd = new BitmapData(camWidth, camHeight, false);
            
            this.addChild(new Bitmap(_bmd));

            addEventListener(Event.ENTER_FRAME, onEnter);
            
            h_min = new Slider(Slider.HORIZONTAL, this, 10, 10, onSliderClick);
            h_min.maximum = 360;
            h_min.value = 20;
            h_max = new Slider(Slider.HORIZONTAL, this, 10, 30, onSliderClick);
            h_max.maximum = 360;
            h_max.value = 100;
            s_min = new Slider(Slider.HORIZONTAL, this, 10, 50, onSliderClick);
            s_min.value = 40;
            v_min = new Slider(Slider.HORIZONTAL, this, 10, 70, onSliderClick);
            v_min.value = 40;
            
//            stage.addEventListener(MouseEvent.CLICK, onClick);
        }

        private function onEnter(evt:Event):void
        {
            var matrix:Matrix = new Matrix();
            matrix.scale(-1, 1);
            matrix.translate(camWidth, 0);
            _bmd.draw(_vid, matrix);
            
            for(var y:int = 0 ; y < _bmd.height; y++){
                for(var x:int = 0 ; x < _bmd.width; x++){
                    var pixel:Number = _bmd.getPixel(x,y);
                    var hsv:Object = rgb2hsv((pixel&0xff0000) >> 16,
                            (pixel & 0xff00) >> 8, (pixel & 0xff));
                    if( 
                        h_min.value < hsv.h
                        && hsv.h < h_max.value
                        && s_min.value < hsv.s*100
                        && v_min.value < hsv.v*100
                       )
                    {// color of beer!
                        
                    }else{ // gray
                        _bmd.setPixel(x, y, 
                        rgb2gray((pixel&0xff0000) >> 16,
                            (pixel & 0xff00) >> 8, (pixel & 0xff)));
                    }
                }
            }
        }
        
        private function onSliderClick(evt:MouseEvent):void{
            
        }


        /*
         * functions
         */
        private function selectCamera():void
        {
            //ダイアログを表示して、ユーザにカメラを選択してもらう
            Security.showSettings(SecurityPanel.CAMERA);
        }

        private function setCamToVideo(c:Camera, v:Video = null):Video
        {
            //Videoへカメラを設定する
            if (!v)
                v = new Video();

//            v.attachCamera(c);
            return v;
        }
        // convert color hsv
        private function rgb2hsv(r:int, g:int, b:int):Object{
            var hsv:Object = new Object();

            hsv.h = hsv.s = hsv.v = 0.0;
            var cmax:Number = Math.max(r,Math.max(g,b));
            var cmin:Number = Math.min(r,Math.min(g,b));
            hsv.v = cmax;
            var c:Number = cmax - cmin;
            if (cmax == 0.0) hsv.s = 0.0; else hsv.s = c/cmax;
            if (hsv.s != 0.0){
                if (r == cmax)
                {
                    hsv.h = (g - b)/c;
                }else if (g == cmax) {
                    hsv.h = 2 + (b - r)/c;
                }else{
                    if (b == cmax) hsv.h = 4 + ( r - g)/c;
                }
                hsv.h *= 60.0;
                if (hsv.h < 0.0) hsv.h += 360.0;
            }

            return hsv;
        }
        
        // convert color gray
        private function rgb2gray(r:int, g:int, b:int):uint{
            var intensity:int = 0.299*r + 0.587*g + 0.114*b;
            return (intensity<<16)|(intensity<<8)|intensity;
        }

    }
}
