/**
 * Copyright randomizer ( http://wonderfl.net/user/randomizer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1KvK
 */

// forked from randomizer's wave sphere
package{
    import flash.events.Event;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;

    public class test extends BasicView {
        public var sphere:Sphere;
        public var cnt:int;
        public var distArray:Array;
        public var sx:Array;
        public var sy:Array;
        public var sz:Array;
        public var t:Number = 0.0;

        public function test() : void {
            var light:PointLight3D = new PointLight3D();
           
           light.x = 30.0;
           light.y = 30.0;
           light.z = -30.0;            
            
            var material:FlatShadeMaterial = new FlatShadeMaterial( light , 0xFFFFFF , 0x000000 );
            var i:int;
            var px:Number,py:Number,pz:Number;

            distArray = new Array();

            sphere = new Sphere( material , 500 , 72 , 72 );

            px = sphere.geometry.vertices[0].x;
            py = sphere.geometry.vertices[0].y;
            pz = sphere.geometry.vertices[0].z;

            sx = new Array();
            sy = new Array();
            sz = new Array();

            cnt = 0;
            for each( var it:* in sphere.geometry.vertices ) {
                cnt++;
            }

            for( i = 0 ; i < cnt ; i++ ) {
                var vx:Number;
                var vy:Number;
                var vz:Number;
                var r:Number;

                sx[i] = vx = sphere.geometry.vertices[i].x;
                sy[i] = vy = sphere.geometry.vertices[i].y;
                sz[i] = vz = sphere.geometry.vertices[i].z;

                distArray[i] = Math.sqrt( (px-vx)*(px-vx) +
                                      (py-vy)*(py-vy) +
                                      (pz-vz)*(pz-vz) );

                r = Math.sqrt( vx*vx + vy*vy + vz*vz );

                sphere.geometry.vertices[i].x = 20.0*vx/r*Math.sin(distArray[i]/20.0);
                sphere.geometry.vertices[i].y = 20.0*vy/r*Math.sin(distArray[i]/20.0);
                sphere.geometry.vertices[i].z = 20.0*vz/r*Math.sin(distArray[i]/20.0);
            }

            scene.addChild( sphere );
            startRendering();
            addEventListener( Event.ENTER_FRAME , onIdle );
        }

        public function onIdle( e:Event ) : void {
            var i:int;

            sphere.rotationY += 1;
            sphere.rotationZ += 1;
            sphere.rotationX += 1;

            t += 0.5;
            
            if( t > 2.0*3.1415926 ) {
                t -= 2.0*3.1415926;
            }

            for( i = 0 ; i < cnt ; i++ ) {
                var r:Number;

                r = Math.sqrt( sx[i]*sx[i] + sy[i]*sy[i] + sz[i]*sz[i] );

                sphere.geometry.vertices[i].x = sx[i] + 20.0*sx[i]/r*Math.sin(distArray[i]/20.0+t);
                sphere.geometry.vertices[i].y = sy[i] + 20.0*sy[i]/r*Math.sin(distArray[i]/20.0+t);
                sphere.geometry.vertices[i].z = sz[i] + 20.0*sz[i]/r*Math.sin(distArray[i]/20.0+t);
            }
        }
    }
}