/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1KPh
 */

// Papervision3D intersection test
package {
    import flash.display.DisplayObject;
    
    import flash.events.Event;
    
    import org.papervision3d.view.BasicView;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.PhongMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;    
    import org.papervision3d.render.QuadrantRenderEngine;
    
    import com.bit101.components.HUISlider;

    public class Pv3dTest extends BasicView {
        
        private const RADIUS:Number = 300;

        private var rlSlider:HUISlider;
        private var rrSlider:HUISlider;
        
        private var swSlider:HUISlider;
        private var shSlider:HUISlider;
        
        private var dstSlider:HUISlider;
        private var rotSlider:HUISlider;
           
        private var spheres:DisplayObject3D;

        private var light:PointLight3D;
        
        private var sphere1:Sphere = null;
        private var sphere2:Sphere = null;
              
        public function Pv3dTest() {

            spheres = new DisplayObject3D();
            scene.addChild(spheres);

            light = new PointLight3D();
            light.x = -RADIUS;
            light.y =  RADIUS;
            
            rlSlider = new HUISlider(this, 50, 380, "radiusL", changeRadiusL);
            rlSlider.setSliderParams(1, 2 * RADIUS, RADIUS);

            rrSlider = new HUISlider(this, 250, 380, "radiusR", changeRadiusR);
            rrSlider.setSliderParams(1, 2 * RADIUS, RADIUS);

            swSlider = new HUISlider(this, 50, 400, "segmentsW", changeSegments);
            swSlider.setSliderParams(Sphere.MIN_SEGMENTSW, 60, Sphere.DEFAULT_SEGMENTSW);
            swSlider.tick = 1;
            swSlider.labelPrecision = 0;
            
            shSlider = new HUISlider(this, 50, 420, "segmentsH", changeSegments);
            shSlider.setSliderParams(Sphere.MIN_SEGMENTSH, 60, Sphere.DEFAULT_SEGMENTSH);
            shSlider.tick = 1;
            shSlider.labelPrecision = 0;

            dstSlider = new HUISlider(this, 250, 400, "distance", move);
            dstSlider.setSliderParams(0, 4 * RADIUS, RADIUS);

            rotSlider = new HUISlider(this, 250, 420, "rotation", rotate);
            rotSlider.setSliderParams(0, 360, 0);
          
            makeSpheres(swSlider.value, shSlider.value, rlSlider.value, rrSlider.value, dstSlider.value);
            
//          renderer = new QuadrantRenderEngine(QuadrantRenderEngine.ALL_FILTERS);
            startRendering();
            
        }
        
        private function makeSpheres(segmentsW:int, segmentsH:int, rl:Number, rr:Number, dst:Number):void {
            if (sphere1 != null) {
                spheres.removeChild(sphere1);
                sphere1 = null;
            }
            sphere1 = new Sphere(new PhongMaterial(light, 0xFF0000, 0x111111, 1), 1, segmentsW, segmentsH);
            sphere1.scale = rl;
            sphere1.x = -dst / 2;
            spheres.addChild(sphere1);

            if (sphere2 != null) {
                spheres.removeChild(sphere2);
                sphere2 = null;
            }
            sphere2 = new Sphere(new PhongMaterial(light, 0xFFFF00, 0x111111, 1), 1, segmentsW, segmentsH);
            sphere2.scale = rr;
            sphere2.x = dst / 2;
            spheres.addChild(sphere2);
        }

        private function changeRadiusL(e:Event):void {
           sphere1.scale = e.target.value;
        }

        private function changeRadiusR(e:Event):void {
           sphere2.scale = e.target.value;
        }

        private function changeSegments(e:Event):void {
            makeSpheres(swSlider.value, shSlider.value, rlSlider.value, rrSlider.value, dstSlider.value);
        }
        
        private function rotate(e:Event):void {
            spheres.rotationY = e.target.value; 
        }

        private function move(e:Event):void {
            sphere1.x = -dstSlider.value / 2;
            sphere2.x =  dstSlider.value / 2;
        }

    }
}