/**
 * Copyright windy ( http://wonderfl.net/user/windy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1KNp
 */

// forked from kimo0517's forked from: Saqoosha challenge for professionals [Voice to Text (through microphone)]
// forked from checkmate's Saqoosha challenge for professionals
package {
    
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.b2DebugDraw;
    
   // import com.flashdynamix.utils.SWFProfiler;
    
    import flash.display.StageQuality;
    import flash.display.BlendMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.media.Microphone;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Back;

    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]

    public class WaraWara extends Sprite {
        private var mic:Microphone;
        
        private static const RADtoDEG:Number = 180 / Math.PI;
        
        private static const NUM_ITERATIONS:int = 20;
        private static const DRAW_SCALE:Number = 30;
        
        private static const BLUR_FILTER:BlurFilter = new BlurFilter(12, 12, 1);
        private static const DIM_COLOR:ColorTransform = new ColorTransform(0.3, 0.3, 0.3, 0.2);
        private static const ZERO_POINT:Point = new Point(0, 0);
        
        private var _world:b2World;
        private var _lastTime:int;
        
        private var waraTimer:Timer;
        
        private var mouthOpen:Sprite;
        private var mouthClose:Sprite;
        
        private var txtVolume:TextField;
        
        private var canvas:Bitmap;
            
        private var cacheSprite:Sprite;
        private var cacheMatrix:Matrix;
        
        public function WaraWara():void {
            stage.quality = StageQuality.LOW;
            
            mic = Microphone.getMicrophone();
            if (mic == null) {
                var tmpTxt:TextField = new TextField;
                var tmpFmt:TextFormat = new TextFormat('Verdana', 16, 0xFFFFFF, true);
                tmpFmt.letterSpacing = 0;
                tmpTxt.defaultTextFormat = tmpFmt;
                tmpTxt.autoSize = "left";
                tmpTxt.text = "Please install a microphone to play!";
                addChild(tmpTxt);
                tmpTxt.x = 10;
                tmpTxt.y = 10;
                return;
            }
            mic.setLoopBack(true);
            
            cacheSprite = new Sprite;
            canvas = new Bitmap(new BitmapData(465, 465, true, 0));
            addChild(canvas);
            
            var txt:TextField = new TextField;
            var fmt:TextFormat = new TextFormat('Verdana', 16, 0xFFFFFF, true);
            fmt.letterSpacing = 0;
            txt.defaultTextFormat = fmt;
            txt.autoSize = "left";
            txt.text = "";
            txt.x = 2;
            txt.y = 0.1;
            txt.scaleX /= DRAW_SCALE;
            txt.scaleY /= DRAW_SCALE;
            cacheSprite.addChild(txt);
        
            var txt2:TextField = new TextField;
            txt2.defaultTextFormat = fmt;
            txt2.autoSize = "left";
            txt2.text = "";
            txt2.x = 2;
            txt2.y = 0.8;
            txt2.scaleX /= DRAW_SCALE;
            txt2.scaleY /= DRAW_SCALE;
            cacheSprite.addChild(txt2);

            txtVolume = new TextField;
            txtVolume.defaultTextFormat = fmt;
            txtVolume.autoSize = "left";
            txtVolume.text = "0";
            txtVolume.x = 8;
            txtVolume.y = txt2.y;
            txtVolume.scaleX /= DRAW_SCALE;
            txtVolume.scaleY /= DRAW_SCALE;
            cacheSprite.addChild(txtVolume);
        
            cacheSprite.scaleX = cacheSprite.scaleY = DRAW_SCALE;
            cacheMatrix = new Matrix();
            cacheMatrix.scale(DRAW_SCALE, DRAW_SCALE);
            
            //SWFProfiler.init(this);
            
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(465 + 100, 465 + 100);
            _world = new b2World(worldAABB, new b2Vec2(0, 10.0), true);
            
            _buildFloor();
            Wara.init();
            
            _lastTime = getTimer();
            addEventListener(Event.ENTER_FRAME, _update);
            
            waraTimer = new Timer(100, 0);
            waraTimer.addEventListener(TimerEvent.TIMER, _checkWara);
            
            //draw and init the face
            var face:Sprite = drawFace();
            face.scaleX /= DRAW_SCALE;
            face.scaleY /= DRAW_SCALE;
            cacheSprite.addChild(face);
        
            mouthOpen = drawMouthOpen();
            mouthOpen.scaleX /= DRAW_SCALE;
            mouthOpen.scaleY /= DRAW_SCALE;
            cacheSprite.addChild(mouthOpen);
            mouthOpen.visible = false;
        
            mouthClose = drawMouthClose();
            mouthClose.scaleX /= DRAW_SCALE;
            mouthClose.scaleY /= DRAW_SCALE;
            cacheSprite.addChild(mouthClose);
        
            waraTimer.start();
        }
        
        private function _buildFloor():void {
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(465 / 2 / DRAW_SCALE, (465 + 20) / DRAW_SCALE);
            var boxDef:b2PolygonDef = new b2PolygonDef();
            boxDef.SetAsBox(465 / 2 / DRAW_SCALE, 20 / DRAW_SCALE);
            boxDef.friction = 0.3;
            boxDef.density = 0;
            var body:b2Body = _world.CreateBody(bodyDef);
            body.CreateShape(boxDef);
            body.SetMassFromShapes();
        }
        
        private function _checkWara(e:Event):void {    
            if (mic.activityLevel > 15) {
                mouthOpen.visible = true;
                mouthClose.visible = false;
                _shootWara(mic.activityLevel / 70.0);
            } else {
                mouthOpen.visible = false;
                mouthClose.visible = true;
            }
            txtVolume.text = (int(mic.activityLevel)).toString();
        }
        
        private function _shootWara(_scale:Number):void {
            var force:b2Vec2 = new b2Vec2(_scale*10,_scale*10);
            
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.angle = Math.random() * Math.PI * 2;
            bodyDef.position.x = (10+Math.random()*20)/DRAW_SCALE;
            bodyDef.position.y = (30+Math.random()*20)/DRAW_SCALE;
            
            var wara:Wara = cacheSprite.addChild(new Wara(_scale + 0.2)) as Wara;
            wara.y = -100;
            
            var boxDef:b2PolygonDef = new b2PolygonDef();
            boxDef.SetAsBox(wara.width / 2 / DRAW_SCALE, wara.height / 2 / DRAW_SCALE);
            boxDef.density = 1.0;
            boxDef.friction = 0.5;
            boxDef.restitution = 0.2;
            
            bodyDef.userData = wara;
            wara.scaleX = wara.scaleY = 0.1/DRAW_SCALE;
            BetweenAS3.tween(wara, {scaleX: 1 / DRAW_SCALE, scaleY: 1 / DRAW_SCALE}, null, 0.5, Back.easeOut).play();
            
            var body:b2Body = _world.CreateBody(bodyDef);
            body.CreateShape(boxDef);
            body.SetMassFromShapes();
            body.SetLinearVelocity(force);
        }
        
        private function _update(e:Event):void {
            var now:int = getTimer();
            var dt:Number = now - _lastTime;
            _lastTime = now;
            _world.Step(dt / 1000, NUM_ITERATIONS);
            
            for (var bb:b2Body = _world.m_bodyList; bb; bb = bb.m_next){
                var px:Number = bb.GetPosition().x * DRAW_SCALE;
                var py:Number = bb.GetPosition().y * DRAW_SCALE;
                if (px < 0 - 50 || 465 + 100 < px || 465 + 100 < py) {
                    cacheSprite.removeChild(bb.GetUserData());
                    _world.DestroyBody(bb);
                    break;
                }
                if (bb.m_userData is Sprite){
                    bb.m_userData.x = bb.GetPosition().x;
                    bb.m_userData.y = bb.GetPosition().y;
                    bb.m_userData.rotation = bb.GetAngle() * RADtoDEG;
                }
            }
            
            canvas.bitmapData.applyFilter(canvas.bitmapData, canvas.bitmapData.rect, ZERO_POINT, BLUR_FILTER);
            canvas.bitmapData.draw(canvas.bitmapData, null, DIM_COLOR);
            canvas.bitmapData.draw(cacheSprite,cacheMatrix, null, BlendMode.ADD);
        }
        
        private static function drawFace():Sprite {
            var output:Sprite = new Sprite;
            output.graphics.lineStyle(1, 0xFFFFFF);
            output.graphics.moveTo(22.3, 0);
            output.graphics.lineTo(27.4, 7.9);
            output.graphics.moveTo(28.4, 10);
            output.graphics.lineTo(37.4, 9.3);
            output.graphics.moveTo(23.7, 8.3);
            output.graphics.lineTo(19.4, 15.9);
            output.graphics.moveTo(29.1, 12.4);
            output.graphics.lineTo(26.3, 18.1);
            output.graphics.moveTo(23.4, 22.1);
            output.graphics.lineTo(23.1, 27.3);
            output.graphics.lineTo(19.9, 27.3);
            return output;
        }
        
        private static function drawMouthOpen():Sprite {
            var output:Sprite = new Sprite;
            output.graphics.lineStyle(1, 0xFFFFFF);
            output.graphics.moveTo(23.3, 32);
            output.graphics.lineTo(4.6, 32);
            output.graphics.lineTo(6.5, 52.8);    
            return output;
        }
        
        private static function drawMouthClose():Sprite {
            var output:Sprite = new Sprite;
            output.graphics.lineStyle(1, 0xFFFFFF);
            output.graphics.moveTo(20.2, 36.8);
            output.graphics.lineTo(4.6, 32);
            return output;
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.getTimer;

import frocessing.color.ColorHSV;

class Wara extends Sprite {
    
    public static var _waraImages:Array;
    
    public static function init():void {
        _waraImages = new Array();
        var tf:TextField = new TextField();
        var fmt:TextFormat = new TextFormat('Verdana', 64, 0xffffff, true);
        fmt.letterSpacing = -10;
        tf.defaultTextFormat = fmt;
        tf.autoSize = TextFieldAutoSize.LEFT;
        var tmp:BitmapData;
        
        tf.text = 'あ';
        tmp = new BitmapData(tf.width, tf.height, true, 0x0);
        tmp.draw(tf);
        var rect:Rectangle = tmp.getColorBoundsRect(0xff000000, 0xff000000, true);
        _waraImages[0] = new BitmapData(rect.width, rect.height, true, 0x0);
        _waraImages[0].draw(tmp, new Matrix(1, 0, 0, 1, -rect.x, -rect.y));
        
        
        tf.text = 'ア';
        tmp = new BitmapData(tf.width, tf.height, true, 0x0);
        tmp.draw(tf);
        rect = tmp.getColorBoundsRect(0xff000000, 0xff000000, true);
        _waraImages[1] = new BitmapData(rect.width, rect.height, true, 0x0);
        _waraImages[1].draw(tmp, new Matrix(1, 0, 0, 1, -rect.x, -rect.y));
    }
    
    public function Wara(scale:Number) {
        var b:Bitmap = addChild(new Bitmap(_waraImages[int(Math.random()*1.999999)])) as Bitmap;
        b.scaleX = b.scaleY = scale;
        b.x = -b.width / 2;
        b.y = -b.height / 2;
        var col:ColorHSV = new ColorHSV((getTimer() / 30) % 360);
        transform.colorTransform = new ColorTransform(col.r / 255, col.g / 255, col.b / 255);
    }
}