/**
 * Copyright elbib ( http://wonderfl.net/user/elbib )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Jno
 */

// forked from makc3d's Triple Pendulum in QuickBox2D
// forked from makc3d's Double Pendulum in QuickBox2D
// forked from makc3d's forked from: Double Pendulum Symplectic Euler
// forked from aont's Double Pendulum
package {
    import com.actionsnippet.qbox.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.Timer;
    [SWF(backgroundColor=0x3f7f00)]
    public class TriplePendulum extends MovieClip
    {
        private var circle:Sprite;
        private var circleObject:QuickObject;
        private var circleCoords:Array = [];
        private var line_ratio:Number;
        private var length_1:Number = 0.5;
        private var length_2:Number = 0.25;
        private var radius:Number = 2;
        
        private var mass_1:Number = 0.005;
        private var mass_2:Number = 0.001;
        private var color_3:Number = 0xff7f00;
        private var center:Number;
        private var bd:BitmapData;
        private var ct:ColorTransform;
        public function TriplePendulum()
        {
            this.center = 230;
            this.line_ratio = center /  (this.length_1+1.6*this.length_2);

            bd = new BitmapData (465, 465, true, 0); addChild (new Bitmap (bd));
            ct = new ColorTransform; ct.color = color_3;
            ct.alphaMultiplier = 1 - 1e-3;

            circle = new Sprite; circle.graphics.beginFill (0xffffff);
            circle.graphics.drawCircle (0, 0, radius);

            var sim:QuickBox2D = new QuickBox2D(this, { debug:false } );
            var circleA:QuickObject = sim.addCircle({x:465/2/30, y:465/2/30,
                radius:6/30, density:0});
            var circleB:QuickObject = sim.addCircle({x:465/2/30, y:(465/2 + this.length_1*line_ratio)/30,
                radius:6/30, density:mass_1});
            var circleC:QuickObject = sim.addCircle({x:465/2/30, y:(465/2 + (this.length_1 + this.length_2)*line_ratio)/30,
                radius:6/30, density:mass_2});
            circleObject = sim.addCircle({x:465/2/30, y:(465/2 + (this.length_1 + 1.6*this.length_2)*line_ratio)/30,
                radius:6/30, density:mass_2 * mass_2 / mass_1});

            sim.addJoint({type:"distance", a:circleA.body, b:circleB.body});
            sim.addJoint({type:"distance", a:circleB.body, b:circleC.body});
            sim.addJoint({type:"distance", a:circleC.body, b:circleObject.body});

            sim.start();
            sim.mouseDrag();

            addEventListener (Event.ENTER_FRAME, ReDraw);
        }
        private function ReDraw(e:Event=null):void
        {
            if (circleCoords.length == 4) circleCoords.shift ();
            while (circleCoords.length != 4) circleCoords.push (new Point (circleObject.x*30, circleObject.y*30));
            var m:Matrix = new Matrix, n:Number = 40 / radius;
            for (var i:int = 1; i < n + 1; i++) {
                var p:Point = spline (circleCoords [0], circleCoords [1], circleCoords [2], circleCoords [3], i / n);
                m.tx = p.x; m.ty = p.y;
                bd.draw (circle, m);
            }
            bd.colorTransform (bd.rect, ct);
        }
        /* 
        * Calculates 2D cubic Catmull-Rom spline.
        * @see http://www.mvps.org/directx/articles/catmull/ 
        */ 
        private function spline (p0:Point, p1:Point, p2:Point, p3:Point, t:Number):Point {
            return new Point (
                0.5 * ((          2*p1.x) +
                    t * (( -p0.x           +p2.x) +
                    t * ((2*p0.x -5*p1.x +4*p2.x -p3.x) +
                    t * (  -p0.x +3*p1.x -3*p2.x +p3.x)))),
                0.5 * ((          2*p1.y) +
                    t * (( -p0.y           +p2.y) +
                    t * ((2*p0.y -5*p1.y +4*p2.y -p3.y) +
                    t * (  -p0.y +3*p1.y -3*p2.y +p3.y))))
            );
        }
    }
}