/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1J1y
 */

// forked from greentec's Trianglular Tiling
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = "465", height = "465", backgroundColor = "#292929")]
    public class Main extends Sprite 
    {
        public var triCellArray:Array = [];
        public var rowNum:int = 28;
        public var colNum:int = 50;
        public var visited:Vector.<Boolean> = new Vector.<Boolean>(rowNum * colNum);
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            
            addChild(new Bitmap(new BitmapData(465, 465, false, 0x003300)));            
            
            var i:int;
            var j:int;
            var triCell:TriCell;
            var edgeLength:int = 20;
            var cellWidth:Number = edgeLength;
            var cellHeight:Number = cellWidth * Math.sqrt(3) / 2;
            var indentX:Number = -cellWidth / 2;
            var indentY:Number = -cellHeight / 2;
            var color:uint = 0x004000;
            
            for (i = 0; i < rowNum; i += 1)
            {
                for (j = 0; j < colNum; j += 1)
                {    
                    triCell = new TriCell(j, i, false, edgeLength);
                    triCell.y = i * cellHeight + indentY;
                    if (i % 2 == 1)
                    {
                        triCell.x = int(j / 2) * cellWidth - cellWidth / 2 + indentX;
                        if (j % 2 == 1)
                        {
                            triCell.x += cellWidth;
                        }
                    }
                    else
                    {
                        triCell.x = int(j / 2) * cellWidth + indentX;
                    }
                    
                    addChild(triCell);
                    triCellArray.push(triCell);
                }
            }
            
            
            initMaze();
            drawMaze();
        }
        
        public function initMaze():void
        {
            var allCellNum:int = rowNum * colNum;
            var visitedCellNum:int = 0;
            var nowY:int = Math.random() * rowNum;
            var nowX:int = Math.random() * colNum;
            var emptyCells:Array = [];
            var cellStack:Vector.<int> = new Vector.<int>();
            
            visited[nowY * rowNum + nowX] = true;
            visitedCellNum += 1;
            
            while (visitedCellNum < allCellNum)
            {
                emptyCells = [];
                
                if (nowX > 0 && visited[nowY * colNum + nowX - 1] != true) //left
                {
                    emptyCells.push("L");
                }
                if (nowX + 1 < colNum && visited[nowY * colNum + nowX + 1] != true) //right
                {
                    emptyCells.push("R");
                }
                if ((nowX + nowY) % 2 == 0) //normal triangle - has down leg
                {
                    if (nowY + 1 < rowNum && visited[(nowY + 1) * colNum + nowX] != true) //down
                    {
                        emptyCells.push("D");
                    }
                }
                else //inverse triangle - has up leg
                {
                    if (nowY > 0 && visited[(nowY - 1) * colNum + nowX] != true) //up
                    {
                        emptyCells.push("U");
                    }
                }
                
                if (emptyCells.length != 0)
                {
                    cellStack.push(nowX + nowY * colNum);
                    var rand:int = Math.random() * emptyCells.length;
                    
                    switch(emptyCells[rand])
                    {
                        case "L":
                            triCellArray[nowY * colNum + nowX]._left = true;
                            triCellArray[nowY * colNum + nowX - 1]._right = true;
                            
                            nowX -= 1;
                            break;
                        case "R":
                            triCellArray[nowY * colNum + nowX]._right = true;
                            triCellArray[nowY * colNum + nowX + 1]._left = true;
                            
                            nowX += 1;
                            break;
                        case "U":
                            triCellArray[nowY * colNum + nowX]._up = true;
                            triCellArray[(nowY - 1) * colNum + nowX]._down = true;
                            
                            nowY -= 1;
                            break;
                        case "D":
                            triCellArray[nowY * colNum + nowX]._down = true;
                            triCellArray[(nowY + 1) * colNum + nowX]._up = true;
                            
                            nowY += 1;
                            break;
                    }
                        
                    visited[nowY * colNum + nowX] = true;
                    visitedCellNum += 1;
                    
                }
                else
                {
                    if (cellStack.length != 0)
                    {
                        var newCell:int = cellStack.pop();
                        nowX = newCell % colNum;
                        nowY = newCell / colNum;
                    }
                }
                
            }
        }
        
        public function drawMaze():void
        {
            var i:int;
            var len:int = triCellArray.length;
            var triCell:TriCell;
            
            for (i = 0; i < len; i += 1)
            {
                triCell = triCellArray[i];
                triCell.drawLine();
            }
        }        
   }
   
}

Class
{
    import flash.display.Sprite;
    /**
     * ...
     * @author ypc
     */
    class TriCell extends Sprite
    {
        public var _x:int;
        public var _y:int;
        public var edgeLength:int;
        public var _G:Sprite;
        public var _left:Boolean = false;
        public var _right:Boolean = false;
        public var _up:Boolean = false;
        public var _down:Boolean = false;
        
        public function TriCell(_x:int, _y:int, _draw:Boolean = true, edge:int = 20, color:uint = 0x000000) 
        {
            this._x = _x;
            this._y = _y;
            this.edgeLength = edge;
            
            _G = new Sprite();
            addChild(_G);
        }
        
        public function drawLine():void
        {
            _G.graphics.clear();
            _G.graphics.lineStyle(0, 0xcccccc);
            var h:Number = edgeLength * Math.sqrt(3) / 2;
            if ((_x + _y) % 2 == 0) //normal triangle
            {
                with (_G.graphics)
                {
                    if (_left == false)
                    {
                        moveTo(0, 0);
                        lineTo( -edgeLength / 2, h);
                    }
                    if (_right == false)
                    {
                        moveTo(0, 0);
                        lineTo( edgeLength / 2, h);
                    }
                    if (_down == false)
                    {
                        moveTo( -edgeLength / 2, h);
                        lineTo( edgeLength / 2, h);
                    }
                }
            }
            else
            {
                with (_G.graphics)
                {
                    if (_left == false)
                    {
                        moveTo(0, 0);
                        lineTo( edgeLength / 2, h);
                    }
                    if (_right == false)
                    {
                        moveTo( edgeLength, 0);
                        lineTo( edgeLength / 2, h);
                    }
                    if (_up == false)
                    {
                        moveTo(0, 0);
                        lineTo( edgeLength, 0);
                    }
                }
            }
        }
   }
}