/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Ixi
 */

package
{
    import flash.display.Sprite;
 
    public class Main extends Sprite
    {
        public function Main()
        {
            // 背景を真っ黒に
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
 
            var panel:Panel = new Panel();
            addChild(panel);
        }
    }
}
 
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.filters.BevelFilter;
import flash.geom.Point;
 
class Panel extends Sprite // ブロックはパネルに貼る
{
    public static const WIDTH:int = 10;     // ブロックの数 - 横
    public static const HEIGHT:int = 10;     // ブロックの数　- 縦
 
    private var blocks:Array;
 
    public function Panel()
    {
        createBlocks();
    }
 
    private function createBlocks():void
    {
        blocks = new Array(WIDTH);
 
        for (var y:int = 0; y < HEIGHT; y++)
        {
            blocks[y] = new Array(HEIGHT);
 
            for (var x:int = 0; x < WIDTH; x++)
            {
                var block:Block = new Block();
                block.x = x * Block.WIDTH;
                block.y = y * Block.HEIGHT;
                addChild(block);
 
                blocks[y][x] = block;
            }
        }
    }
    
    // 二次元配列から引数のブロック位置を検索。
    // 見つかったらPoint(x, y)で返却。
    // 見つからなかったらnullを返す
    public function searchBlock(block:Block):Point
    {
        for (var y:int = 0; y < HEIGHT; y++)
        {
            for (var x:int = 0; x < WIDTH; x++)
            {
                if (blocks[y][x] == block)
                {
                    return new Point(x, y); // ブロックが見つかったので、Pointで返却。
                }
            }
        }
        
        return null; // 見つからなかったのでnullを返す。
    }
}
 
class Block extends Sprite
{
    public static const COLORS:Array = [0xED1A3D, 0x00B16B, 0x007DC5];
    public static const WIDTH:int = 30; // ブロックの横幅
    public static const HEIGHT:int = 30; // ブロックの縦幅
    public static const MARGIN_W:int = 1;
    public static const MARGIN_H:int = 1;
    public static const ELLIPSE_WIDTH:int = 15;
    public static const ELLIPSE_HEIGHT:int = 15;
 
    public var color:int;
    
    public function Block()
    {    
        color = COLORS[int(Math.random() * COLORS.length)];
        graphics.beginFill(color); // 色をランダムで指定
        graphics.drawRoundRect(MARGIN_W, MARGIN_H, WIDTH - MARGIN_W * 2, HEIGHT - MARGIN_H * 2, ELLIPSE_WIDTH, ELLIPSE_HEIGHT);
        graphics.endFill();

        // ベベルフィルターでブロックに質感を持たせる
        this.filters = [new BevelFilter(4, 45, 0xFFFFFF, 1, 0x0, 1, 20, 20, 1, 3, "inner")];
        
        addEventListener(MouseEvent.CLICK, onMouseDown);
    }

    private function onMouseDown(e:MouseEvent):void 
    {
        var panel:Panel = this.parent as Panel
        panel.removeChild(this);
        
        var point:Point = panel.searchBlock(this);
        if (point)
        {
            // 周りのブロックを削除する処理
        }
    }
}