/**
 * Copyright 9balls ( http://wonderfl.net/user/9balls )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1ISH
 */

// forked from zahir's Matrix3Dのクローン
// forked from zahir's 速度比較用テンプレ
package {
    import flash.geom.Matrix3D;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.utils.getTimer;

    [SWF(width="465",height="465")]
    public class Main extends Sprite {
        private const LOOP:int = 1000000;
        private var t:TextField;

        public function Main(){
            addChild((t = new TextField())).width = t.height = 465;
            addEventListener(MouseEvent.CLICK, onClick);
            ex();
        }

        private function onClick(e:MouseEvent):void {
            ex();
        }

        private function ex():void {
            var i:int = 0;
            var time1:int;
            var time2:int;
            var recode:Array = [];
            var count:int = 0;
            t.text = "各 " + LOOP + " 回ループ\n\n";

            // ここから処理
            var m:Matrix3D = new Matrix3D();
            var _m:Matrix3D = m.clone();
            _m.appendScale(2, 3, 4);

            time1 = getTimer();
            for (i = 0; i < LOOP; i++){
                m = _m.clone();
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData("clone()", time2, "");


            time1 = getTimer();
            for (i = 0; i < LOOP; i++){
                m.rawData = _m.rawData;
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData("rawData 2 rawData", time2, "");


            time1 = getTimer();
            for (i = 0; i < LOOP; i++){
                m = new Matrix3D(_m.rawData);
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData("new", time2, "");


            time1 = getTimer();
            var v:Vector.<Number> = _m.rawData;
            for (i = 0; i < LOOP; i++){
                m.rawData = v;
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData("rawData -> vector -> rawData", time2, "複数クローンを作る場合にはこんな感じでしょうか");

            
            time1 = getTimer();
            for (i = 0; i < LOOP; i++){
                m.copyFrom(_m);
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData("copyFrom", time2, "FP11新機能");
            
            time1 = getTimer();
            for (i = 0; i < LOOP; i++){
                _m.copyToMatrix3D(m);
            }
            time2 = getTimer() - time1;
            recode[count++] = new TimeData("copyToMatrix3D", time2, "FP11新機能");

            // ここまで処理

            if (recode.length){
                result(recode);
            }

            t.appendText("clickで再計算");
        }

        private function result(recode:Array):void {
            recode.sortOn("time", Array.NUMERIC);
            var max:int = (recode[recode.length - 1] as TimeData).time;
            for (var i:int = 0, len:int = recode.length; i < len; i++){
                var data:TimeData = recode[i] as TimeData;
                var n:int = max / data.time * 100;
                t.appendText(data.title + " :: " + data.time + " ms\n\t\t最低速に比べて約 " + n + " %高速 \n");
                if (data.ms == "")
                    t.appendText("\n");
                else
                    t.appendText("\t\t" + data.ms + "\n\n");
            }
        }
    }
}
import flash.geom.Matrix3D;

class TimeData {
    public var title:String;
    public var time:int;
    public var ms:String; // なんか、おまけ要素

    public function TimeData(title:String = "", time:int = 0, ms:String = ""){
        this.title = title;
        this.time = time;
        this.ms = ms;
    }
}