/**
 * Copyright keenblaze ( http://wonderfl.net/user/keenblaze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1INU
 */

// It doesn't works on this site, you can try it here: http://dl.dropbox.com/u/24458146/test.swf

package 
{
    import Box2D.Common.Math.b2Vec2;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.external.ExternalInterface;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import com.actionsnippet.qbox.*;
    
    [SWF(width='465', height='465', backgroundColor='#191919', frameRate='60')]
    public class Main extends MovieClip 
    {
        private const RATIO:int = 30;

        ///////////////////// VARS /////////////////////
        private var _sim:QuickBox2D;
        private var _oldPos:Point = null;
        private var _balls:Vector.<QuickObject> = new Vector.<QuickObject>();
        
        
        public function Main():void 
        {
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0x191919);
            s.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight); 
            addChild(s);
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);                
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);                
            
            _sim = new QuickBox2D(this);
            _sim.setDefault( { fillColor:0, lineAlpha:0.2, radius:1.5 } );
            _sim.createStageWalls();
            
            // Add some stuff
            for (var i:int = 0; i < 15; i++) 
                _balls.push(_sim.addCircle({ 
                    x:Math.random() * stage.stageWidth / RATIO, 
                    y:Math.random() * stage.stageWidth / RATIO, 
                    radius:Math.random() + 0.5,
                    fillColor:Math.random() * 0xFFFFFF
                }));            
            _sim.start();
            
            var l:TextField = new TextField();
            l.text = "Shake The Browser";
            l.x = 90;
            l.y = 50;
            l.width = 300;
            l.alpha = 0.8;
            l.setTextFormat(new TextFormat("Arial",30, 0xffffff));
            addChild(l);     
            
                 
        }
        
        private function onEnterFrame(e:Event):void 
        {
            // Get browser window position
            var x:int = ExternalInterface.call("eval", "window.screenX");
            var y:int = ExternalInterface.call("eval", "window.screenY");
            
            if (_oldPos == null) _oldPos = new Point(x, y);
            
            var vel:b2Vec2 = new b2Vec2();
            for each (var o:QuickObject in _balls) {                
                vel.x = o.body.GetMass() * (x - _oldPos.x) * 10;
                vel.y = o.body.GetMass() * (y - _oldPos.y) * 10;
                o.body.ApplyForce(vel, o.body.GetLocalCenter());
            }
            
            _oldPos.x = x;
            _oldPos.y = y;                    
        }
        
        private function debug(str:String):void 
        {
            ExternalInterface.call("eval", "console.log(" + str + ")"); 
        }
        
    }
    
}