/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1HRQ
 */

package {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	import org.as3lib.kitchensync.*;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.action.tween.*;
	import org.as3lib.kitchensync.action.group.*;
	import org.as3lib.kitchensync.easing.*;
	import org.as3lib.kitchensync.utils.FrameRateView;
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;

	[SWF(backgroundColor='#333333', frameRate='50')]
	public class CMYKSprayer3D extends Sprite
	{
		public const NUMBER_OF_PARTICLES:int = 40;
		public const SPRAY_RADIUS:int = 300;
		private var mainView:BasicView;
		
		public function CMYKSprayer3D()
		{
			KitchenSync.initialize(this, "2.0");
			Oscillate.defaultFrequency = .2;
			
			mainView = new BasicView(stage.width, stage.height, true, false, CameraType.TARGET);
			var origin:DisplayObject3D = new DisplayObject3D();
			mainView.camera.target = origin;
			addChild(mainView);
			
			var fps:FrameRateView = new FrameRateView();
			fps.textColor = 0xFFFFFF;
			addChild(fps);
			
			// a group executes a tween each frame
			var group:AbstractActionGroup = new KSStaggeredGroup(80);
			var particle:DisplayObject3D;	
			for (var i:int = 0; i < NUMBER_OF_PARTICLES; i++) {
				particle = new CMYKParticle();
				mainView.scene.addChild(particle);
				
				var delay:int = 0;
				var angleZ:int = Math.random() * 360;
				var angleY:int = Math.random() * 360;
				var x:int = particle.position.x + Math.cos(angleZ) * SPRAY_RADIUS;
				var y:int = particle.position.y + Math.sin(angleZ) * SPRAY_RADIUS;
				var z:int = particle.position.z + Math.sin(angleY) * SPRAY_RADIUS;
				x = particle.position.x + Math.cos(angleY) * SPRAY_RADIUS;
				
				// create tweens for x y and scale
				var tweenx:KSTween = TweenFactory.newTween(particle, "x", AUTO_TWEEN_VALUE, x, "1d", delay, Oscillate.absoluteSine);
				var tweeny:KSTween = TweenFactory.newTween(particle, "y", AUTO_TWEEN_VALUE, y, "1d", delay, Oscillate.absoluteSine);
				var tweenz:KSTween = TweenFactory.newTween(particle, "z", AUTO_TWEEN_VALUE, z, "1d", delay, Oscillate.absoluteSine);
				
				// add these to the group
				group.addAction(new KSParallelGroup(tweenx, tweeny, tweenz));
			}
			
			mainView.startRendering();
			
			// execute the group.
			group.start();
		
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
		
		private function onMouseMove(event:MouseEvent):void {
			mainView.camera.position = new Number3D(mainView.mouseX - mainView.width/2, 0, mainView.mouseY-1000);
		}
		
	}
}

import flash.display.BlendMode;	
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.objects.primitives.Sphere;

class CMYKParticle extends Sphere
{
	public static const MIN_RADIUS:int = 5;
	public static const MAX_RADIUS:int = 80;
		
	public function CMYKParticle()
	{
		var color:uint;
		switch(Math.floor(Math.random() * 4)) {
			case 0: color = 0xFFFF00; break; // yellow
			case 1: color = 0xFF00FF; break; // magenta
		 	case 2: color = 0x00FFFF; break; // cyan
		 	default: color = 0x111111; // black
		}
		var material:ColorMaterial = new ColorMaterial(color);
		material.fillAlpha = 0.6;
		
		var r:int = Math.round(Math.random() * (MAX_RADIUS - MIN_RADIUS) + MIN_RADIUS);
			
		super(material, r, 10, 8);
	}		
}