/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1H69
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    
    /**
     * ...
     * @author lizhi http://game-develop.net/
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class Main extends Sprite 
    {
        private var w:int;
        private var h:int;
        private var ps:Array;
        private var pen:Shape = new Shape;
        private var bmd:BitmapData;
        private var ct:ColorTransform = new ColorTransform(0.999, 0.95, 0.99);
        private var max:Number = ct.redMultiplier;
        private var min:Number = ct.blueMultiplier;
        private var vr:Number = 0.0001;
        private var vg:Number = vr;
        private var vb:Number = vr;
        
        public function Main():void 
        {
            w = stage.stageWidth;
            h = stage.stageHeight;
            bmd = new BitmapData(w, h, false, 0);
            addChild(new Bitmap(bmd));
            
            var c:int = 10;
            ps = [];
            while (c-->0) {
                ps.push(new Particle(w * Math.random(), h * Math.random(),(Math.random()-0.5)*2,(Math.random()-0.5)*2));
            }
            addEventListener(Event.ENTER_FRAME, init);
        }
        
        private function init(e:Event = null):void 
        {
            for each(var p:Particle in ps) {
                p.x += p.vx;
                p.y += p.vy;
                if (p.x<0) {
                    p.x = 0;
                    p.vx = Math.abs(p.vx);
                }
                if (p.y<0) {
                    p.y = 0;
                    p.vy = Math.abs(p.vy);
                }
                if (p.x>w) {
                    p.x = w;
                    p.vx = -Math.abs(p.vx);
                }
                if (p.y>h) {
                    p.y = h;
                    p.vy = -Math.abs(p.vy);
                }
            }
            
            pen.graphics.clear();
            pen.graphics.lineStyle(3,0xffffff);
            pen.graphics.moveTo(ps[0].x/2+ps[1].x/2,ps[0].y/2+ps[1].y/2);
            for (var i:int = 1; i < ps.length; i++ ) {
                p = ps[i + 1];
                if (p == null) p = ps[0];
                pen.graphics.curveTo(ps[i].x, ps[i].y, ps[i].x / 2 + p.x / 2, ps[i].y / 2+ p.y / 2);
            }
            pen.graphics.curveTo(ps[0].x, ps[0].y, ps[0].x/2+ps[1].x/2,ps[0].y/2+ps[1].y/2);
            
            ct.redMultiplier += vr;
            ct.greenMultiplier += vg;
            ct.blueMultiplier += vb;
            if (ct.redMultiplier > max) {
                ct.redMultiplier = max;
                vr = -Math.abs(vr);
            }
            if (ct.redMultiplier<min) {
                ct.redMultiplier = min;
                vr = Math.abs(vr);
            }
            
            if (ct.greenMultiplier > max) {
                ct.greenMultiplier = max;
                vg = -Math.abs(vg);
            }
            if (ct.greenMultiplier<min) {
                ct.greenMultiplier = min;
                vg = Math.abs(vg);
            }
            
            if (ct.blueMultiplier > max) {
                ct.blueMultiplier = max;
                vb = -Math.abs(vb);
            }
            if (ct.blueMultiplier<min) {
                ct.blueMultiplier = min;
                vb = Math.abs(vb);
            }
            
            bmd.colorTransform(bmd.rect, ct);
            bmd.draw(pen);
        }
        
    }
}
import flash.geom.Point;

class Particle extends Point
{
    public var vx:Number;
    public var vy:Number;
    public function Particle(x:Number,y:Number,vx:Number,vy:Number) 
    {
        super(x, y);
        this.vx = vx;
        this.vy = vy;
    }
}