/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1G3I
 */

package {
    import flash.filters.GlowFilter;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var center:Point;
        private var lastPoint:Point;
        private var canvas:Sprite;
        
        private var circles:Array = [];
        
        public function FlashTest() {
            // write as3 code here..
            center = new Point(stage.stageWidth/2, stage.stageHeight/2);
            
//            circles.push(new Circle(center.x, center.y, 144));
            circles.push(new Circle(center.x, center.y, 5));
            widthCircles = circles[0].radius;
            
            addCircle(31, 3);        // FIBBONACHI !!!!
            addCircle(23, -2);
            addCircle(12, 9);
            addCircle(5, 5);
          //  addCircle(3, 13);
          //  addCircle(2, 13);
          //  addCircle(1, 21);
            
            lastPoint = new Point(circles[circles.length-1].x, circles[circles.length-1].y);
            canvas = new Sprite();
            var color:uint = 0x3333ff; 
            canvas.filters = [new GlowFilter(color)];
            canvas.graphics.lineStyle(1,color);
            canvas.graphics.moveTo(lastPoint.x, lastPoint.y);
            addChild(canvas);
            
            drawCircles();
            
        //    stage.frameRate = 60;
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private var widthCircles:Number = 50;
        private function addCircle(radius:Number=30, rotation:Number=Math.PI):void{
            //widthCircles += radius+radius/2;
            var nCircle:Circle = new Circle(center.x+widthCircles, center.y, radius, circles[circles.length-1], rotation);
            nCircle.update();
            circles.push( nCircle );
        }

        
        private function loop(e:Event):void{
            for(var i:int = 0;  i<circles.length; i++){
                circles[i].update();
                if(i==circles.length-1){
                    lastPoint.x = circles[i].x;
                    lastPoint.y = circles[i].y;
                    canvas.graphics.lineTo(lastPoint.x, lastPoint.y);
                }
            }
            drawCircles();
        }
        
        private function drawCircles():void{
            this.graphics.clear();
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            for(var i:int = 0;  i<circles.length; i++){
                this.graphics.lineStyle(2, 0x333333);
                this.graphics.drawCircle(circles[i].x, circles[i].y, circles[i].radius );
            }
        }
    }
}
import flash.geom.Point;

Class {
    class Circle extends Point {
        public var radius:Number;
        public var connect:Circle;
        public var sp:Number;
        public function Circle(x:Number, y:Number, radius:Number, connect:Circle=null, sp:Number=1):void{
            super(x,y);
            this.radius = radius;
            this.connect = connect;
            this.sp = sp;
        }
        public function update():void {
            if(connect) {    // Вычислим большой радиус
                var bigRadius:Number = this.radius+connect.radius;
                // Теперь нужно понять как по отношению к нам находится большой круг
                var dx:Number = this.x - connect.x;
                var dy:Number = this.y - connect.y;
                var direct:Number = Math.atan2(dy, dx);
                // Теперь нужно добавить пару градусов, к вращению
                direct += this.sp/180*Math.PI;
                this.x = connect.x + Math.cos(direct)*bigRadius;
                this.y = connect.y + Math.sin(direct)*bigRadius;
            }
        }
    }
}
