/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1G0D
 */

package 

{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.utils.ByteArray;
    import flash.media.Camera;
    import flash.media.Video;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    /**
     * ...
     * @author rettuce
     */
    public class DocumentClass extends Sprite 
    {
        private var _bm:Bitmap;
        private var _bmd:BitmapData;
        private var _bmB:Bitmap;
        private var _bmdB:BitmapData;
        private var _video:Video;        
        
        public function DocumentClass()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);        
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            imageProcessing();
        }
        
        private function imageProcessing():void
        {
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight);
            _bmdB = new BitmapData(stage.stageWidth, stage.stageHeight);            

            _bm = new Bitmap(R_filter(_bmd));
            _bmB = new Bitmap(B_filter(_bmdB));
          
            _bm.x += 3;
            _bmB.x -= 3;            

            _bm.alpha = 0.5;
            _bmB.alpha = 1;            

            addChildAt(_bm, 0);
            addChildAt(_bmB, 0);            
            cameraSet();
        }        

        // Rフィルター
        public function R_filter(s:BitmapData):BitmapData {
            var d:BitmapData = new BitmapData(s.width, s.height, true, 0xff000000);
            d.copyChannel( s, s.rect, new Point(), 1, 1 );
            return d;
        }
        // Gフィルター
        public function G_filter(s:BitmapData):BitmapData {
            var d:BitmapData = new BitmapData(s.width, s.height, true, 0xff000000);
            d.copyChannel( s, s.rect, new Point(), 2, 2 );
            return d;
        }
        // Bフィルター
        public function B_filter(s:BitmapData):BitmapData {
            var d:BitmapData = new BitmapData(s.width, s.height, true, 0xff000000);
            d.copyChannel( s, s.rect, new Point(), 4, 4 );    
            return d;
        }
        
        // camera
        private function cameraSet():void
        {
            var camera:Camera = Camera.getCamera();
            if (camera == null) {
                // カメラが存在しない
                var txt : TextField = new TextField();
                txt.textColor = 0xFFFFFF;
                txt.text = 'カメラが認識できません';
                addChild(txt);
                return;
            } else {
                // カメラの設定
                camera.setMode(stage.stageWidth, stage.stageHeight, 30);
                _video = new Video(camera.width, camera.height);
                // videoにアタッチ
                _video.attachCamera(camera);
                // 表示オブジェクトに追加
                addEventListener(Event.ENTER_FRAME, function(e:Event):void { 
                    _bm.bitmapData.lock();
                    _bmd.draw(_video);
                    _bm.bitmapData = R_filter(_bmd);
                    _bm.bitmapData.unlock();
                    
                    _bmB.bitmapData.lock();
                    _bmdB.draw(_video);
                    _bmB.bitmapData = B_filter(_bmdB);
                    _bmB.bitmapData.unlock();
                } );
            }
        }
        
    }
}