/**
 * Copyright hgw ( http://wonderfl.net/user/hgw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1FnN
 */

// forked from hgw's forked from: Mouse Toy
// forked from shapevent's Mouse Toy



package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
		
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
	
	public class MouseToy extends Sprite {
		
		private var circles:Vector.<Shape>;
		private var NUM_CIRCLE:int = 150;
		private var colorObj:Object = {cr:0, cg:0, cb:0};		
		
		private var canvas:Bitmap;
		

		
		
		public function MouseToy(){

			circles = new Vector.<Shape>();;
			canvas = new Bitmap(new BitmapData( 465, 465, true, 0x0 ));
			addChild( canvas );
			
			for (var i:int = 0; i<NUM_CIRCLE; i++){
				var c:Shape  = makeCircle(NUM_CIRCLE, i);
				c.x = stage.stageWidth / 2;
				c.y = stage.stageHeight / 2;
				c.scaleX = 0.01 + (NUM_CIRCLE-i)/32;
				c.scaleY = 0.01 + (NUM_CIRCLE-i)/32;
				circles.push(c);
			}

			circles.reverse();
			
			addEventListener(Event.ENTER_FRAME, onLoop);
			
			nextColor();
		}
		
		
		
		private function nextColor():void
		{
			Tweener.addTween( colorObj, { 
				cr:Math.random()*200+55,
				cg:Math.random()*200+55, 
				cb:Math.random()*200+55, 
				time:5, 
				transition:Equations.easeNone, 
				onComplete:nextColor
			});
		}
		
		
		private function makeCircle(all:Number, now:Number):Shape{
			
			var s:Shape = new Shape();
			var g:Graphics = s.graphics;
			g.beginFill( 0xFFFFFF );
//			g.drawCircle( -3, -3, 3);
//			g.drawCircle( 3, -3, 3);
//			g.drawCircle( -3, 3, 3);
//			g.drawCircle( 3, 3, 3);
			g.drawCircle( 0, 0, 4);
			g.drawCircle( -12, -12, 4);
			g.drawCircle( 12, -12, 4);
			g.drawCircle( -12, 12, 4);
			g.drawCircle( 12, 12, 4);
			g.drawCircle( -12, 0, 4);
			g.drawCircle( 0, -12, 4);
			g.drawCircle( 12, 0, 4);
			g.drawCircle( 0, 12, 4);
			
			g.drawCircle( 0, 0, 2);
			g.drawCircle( -12, -12, 2);
			g.drawCircle( 12, -12, 2);
			g.drawCircle( -12, 12, 2);
			g.drawCircle( 12, 12, 2);
			g.drawCircle( -12, 0, 2);
			g.drawCircle( 0, -12, 2);
			g.drawCircle( 12, 0, 2);
			g.drawCircle( 0, 12, 2);
			g.endFill();
			
			return s;
		}

		
		
		
		private function onLoop(e:Event):void
		{
			update();
			draw();			
		}
		
		private function update():void
		{	
			circles[0].y += ( mouseY - circles[0].y) * .8;
			circles[0].x += ( mouseX - circles[0].x) * .8;
			for (var i:int = 1; i<circles.length; i++){
				var pre:Shape = circles[i - 1];
				circles[i].y += (pre.y - circles[i].y) * .8;
				circles[i].x += (pre.x - circles[i].x) * .8;
			}
		}
		
		
		private var alpCt:ColorTransform = new ColorTransform(1,1,1,0.90);
		private function draw():void
		{	

			var ct:ColorTransform = new ColorTransform();
			
			canvas.bitmapData.lock();
			for (var i:int = 0; i<NUM_CIRCLE; i++){
				var s:Shape = circles[i];
				var al:Number = 1-(i/NUM_CIRCLE);
				var cr:uint = 255- colorObj.cr * al;
				var cg:uint = 255- colorObj.cg * al;
				var cb:uint = 255- colorObj.cb * al;
				ct.color = cr <<16 | cg <<8 | cb;				
				
				canvas.bitmapData.draw(s, s.transform.matrix, ct);
			}
			canvas.bitmapData.colorTransform( canvas.bitmapData.rect, alpCt ); 
			canvas.bitmapData.unlock();
		}
		
	}
	
}