/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Fhz
 */

package 
{
    import flash.text.TextFormat;
    import flash.text.TextFieldType;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    import flash.display.Sprite;

    public class Main extends Sprite {
        private var driver : SiONDriver;
        private var note : SiONData;
        private var _w : int;
        private var _h : int;
        private var playButton : Button;
        private var stopButton : Button;
        private var mml : String;
        private var tf : TextField;
        public function Main()
        {
            if (stage) initialize();
            else addEventListener(Event.ADDED_TO_STAGE, initialize);

        }

        private function initialize(event : Event=null) : void {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);            

            // ステージ設定
            // stage.quality = StageQuality.LOW;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            // 背景設定
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            var bmd : BitmapData = new BitmapData(_w, _h, false, 0xFFFFFF);
            addChild(new Bitmap(bmd));
            
            //UI設定
            tf = new TextField();
            var tfmt:TextFormat = new TextFormat();
            tfmt.size = 15;
            tf.defaultTextFormat = tfmt;
            tf.type =TextFieldType.INPUT;
            tf.multiline = true;
            tf.wordWrap = true;
            tf.border= true;
            tf.width = _w - 20;
            tf.height = _h -60;
            tf.x = tf.y = 10;
            addChild(tf);

            playButton = new Button('PLAY >>',60);
            playButton.addEventListener(MouseEvent.CLICK, onPlay);
            stopButton = new Button('STOP []',60);
            stopButton.addEventListener(MouseEvent.CLICK, onStop);
            playButton.x = tf.x;
            playButton.y = tf.y+tf.height+5;
            stopButton.x = playButton.x+playButton.width+5;
            stopButton.y = playButton.y;
            addChild(playButton);
            addChild(stopButton);
            
            //SiON設定
            driver = new SiONDriver(8192);
            //初期MMLデータ作成
            var mml_Init:String = "#SIGN{E}; t185";
            var mml_Main:String = "@v20 l4 o5 r2 [efg1&g2]3gab2g2f2e2o6c2co5affgabbbg e2rga2c2edcde1";
            var mml_Base:String = "@v15 l4 o4 r1>e<e2e>e<e2e>g<g2g>g<g2>b<c<c2c>c<c2c>e>e2e>efg-ga<a2a>b<b2b>e<e>d<d>c<c>b<bf<f2f>b<b>b<be";
            mml = mml_Init+"\n"+mml_Main+";\n"+mml_Base;
            tf.text = mml;
            
            
        }

        private function onStop(event : MouseEvent) : void {
            driver.stop();
        }

        private function onPlay(event : MouseEvent) : void {
            mml = tf.text;
            note = driver.compile(mml);
            driver.play(note);
        }

    }
}
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;

    /**
     * @author fumix
     */
    class Button extends SimpleButton {
        public function Button(label : String, width : int = 0) : void {
            var up : Sprite = _buildImage(label, 0x0, width);
            var over : Sprite = _buildImage(label, 0x333333, width);
            var down : Sprite = _buildImage(label, 0x333333, width);
            down.y = 1;
            super(up, over, down, up);
        }

        private static function _buildImage(label : String, color : int, width : int = 0) : Sprite {
            var text : TextField = new TextField();
            text.defaultTextFormat = new TextFormat('Verdana', 10, 0xffffff, true, null, null, null, null, TextFormatAlign.CENTER);
            text.autoSize = TextFieldAutoSize.LEFT;
            text.selectable = false;
            text.text = label;
            text.x = (width - text.width) >> 1;
            text.y = 5;
            var base : Shape = new Shape();
            var g : Graphics = base.graphics;
            g.beginFill(color);
            g.drawRect(0, 0, width, text.height + 10);
            g.endFill();
            var sp : Sprite = new Sprite();
            sp.addChild(base);
            sp.addChild(text);
            return sp;
        }
    }
