/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1F5F
 */

package
{
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2World; 
    import flash.events.Event; 
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView; 
    [SWF(width="475", height="475", backgroundColor="#000000", frameRate="30")]
    public class Box2DFlashWithPapervision3D extends BasicView
    {
        private var world : b2World; 
        public function Box2DFlashWithPapervision3D()
        {
            camera.focus = 10;
            camera.zoom = 60;
            var worldBounds : b2AABB = new b2AABB();
            worldBounds.lowerBound = new b2Vec2(-100, -100);
            worldBounds.upperBound = new b2Vec2(600, 600);
            var gravity : b2Vec2 = new b2Vec2(0, 0);
            world = new b2World(worldBounds, gravity, true);
            for (var i : int = 0; i < 7; i++)
            {
                var bodyDef : b2BodyDef = new b2BodyDef();
                bodyDef.position = new b2Vec2(50, i * 30 + 10);
                var body : b2Body = world.CreateBody(bodyDef);
                var shapeDef : b2CircleDef = new b2CircleDef();
                shapeDef.radius = 15;
                shapeDef.density = 1;
                shapeDef.friction = .7;
                shapeDef.restitution = .7;
                body.CreateShape(shapeDef);
                body.SetMassFromShapes();
                var sphere : Sphere = new Sphere(null, 30);
                scene.addChild(sphere);
                body.m_userData = sphere;
            }
            var ballshape : b2CircleDef = new b2CircleDef();
            ballshape.radius = 20;
            ballshape.density = 8;
            ballshape.friction = 8;
            ballshape.restitution = 0.9;
            var balldef : b2BodyDef = new b2BodyDef();
            balldef.position.Set(200, 100);
            var ball : b2Body = world.CreateBody(balldef);
            ball.CreateShape(ballshape);
            var pow : b2Vec2 = new b2Vec2(-10, 0);
            ball.SetLinearVelocity(pow);
            ball.SetMassFromShapes();
            var sphere0 : Sphere = new Sphere(null, 40);
            scene.addChild(sphere0);
            ball.m_userData = sphere0;
            startRendering();
        }
        override protected function onRenderTick(event : Event = null) : void
        {
            var iterations : int = 10;
            var timeStep : Number = 1.0 / 30.0; 
            world.Step(timeStep, iterations);
            for (var bb : b2Body = world.m_bodyList; bb; bb = bb.m_next)
            {
                if (bb.m_userData is DisplayObject3D)
                {
                    bb.m_userData.x = bb.GetPosition().x * 2 - 475 * .5;
                    bb.m_userData.y = -bb.GetPosition().y * 2 + 475 * .5;
                    bb.m_userData.rotationZ = -bb.GetAngle() * (180 / Math.PI);
                }
            }
            renderer.renderScene(scene, camera, viewport);
        }
    }
}
