/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Ewi
 */

package
{
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.events.Event;
	import com.bit101.components.RadioButton;
	import flash.display.Bitmap;
	import camo.core.decal.Decal;
	import camo.core.decal.DecalSheet;
	import camo.core.display.CamoDisplay;

	import com.bit101.components.Label;
	import com.bit101.components.PushButton;

	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.SimpleButton;
	import flash.display.SpreadMethod;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;

	/**
	 * @author jessefreeman
	 */
	public class FlashTest extends Sprite
	{

		private var states : Array = new Array( "Up", "Over", "Down" );
		public var buttonHeight : Number = 30;
		public var buttonWidth : Number = 100;
		private var buttonOffset : int = 1;
		private var decalSheet : DecalSheet;
		private var uiContainer : Sprite = new Sprite( );
		private var decalSheetLabel : Label;
		private var registeredDecalLabel : Label;
		private var decalLabel : Label;
		private var decalPreviewArea : Sprite;
		private var activeDecal : Decal;
		private var _top_highlight_size : Number = 10;
		private var _mid_highlight_size : Number = 10;
		private var skinnedButton : SimpleButton;
		private var skinnedLabel : Label;
		private var colors:Array = [{a:0x212121, b:0x111111, c:0x080808, d:0x000000, e:0xB6B6B6},
									{a:0x646464, b:0x363636, c:0x262626, d:0x0d0d0d, e:0xFFFFFF},
									{a:0x75A5CB, b:0x1567A7, c:0x1567A7, d:0x14619D, e:0xFFFFFF} ];
		private var skin1BMD : Bitmap;
		private var skin3BMD : Bitmap;
		private var skin2BMD : Bitmap;
		private var skin1Label : RadioButton;
		private var skin3Label : RadioButton;
		private var skin2Label : RadioButton;
		private var currentSelectedSkin : RadioButton;

		public function FlashTest(autoStart : Boolean = true)
		{
			if(autoStart)
			{
				configureStage( );
				start( );
			}
		}
		
		protected function configureStage() : void
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
		}

		public function start() : void
		{
			createDecalSheetUI();
		}
		
		private function createDecalSheetUI() : void
		{
			addChild(uiContainer);
			uiContainer.x = uiContainer.y = 0;
			
			decalSheetLabel = new Label(uiContainer, 0, 0, "DecalSheet Preview");
			
			decalSheet = new DecalSheet( );
			
			skin1BMD = new Bitmap(createDecalSheetBitmapData(0));
			skin2BMD = new Bitmap(createDecalSheetBitmapData(1));
			skin3BMD = new Bitmap(createDecalSheetBitmapData(2));
			
			decalSheet.bitmapData = skin1BMD.bitmapData;
			
			decalSheet.y = decalSheetLabel.y + decalSheetLabel.height + 10;
			uiContainer.addChild( decalSheet );
			
			skin1BMD.x = decalSheet.x + decalSheet.width + 10;
			uiContainer.addChild(skin1BMD);
			skin1Label = new RadioButton(uiContainer, skin1BMD.x, decalSheetLabel.y, "DecalSheet Skin 1",true, onSkinSelect );
			currentSelectedSkin = skin1Label;
			
			skin2BMD.x = skin1BMD.x + skin1BMD.width + 10;
			uiContainer.addChild(skin2BMD);
			skin2Label = new RadioButton(uiContainer, skin2BMD.x, decalSheetLabel.y, "DecalSheet Skin 2",false , onSkinSelect);
			
			skin3BMD.x = skin2BMD.x + skin2BMD.width + 10;
			uiContainer.addChild(skin3BMD);
			skin3Label = new RadioButton(uiContainer, skin3BMD.x, decalSheetLabel.y, "DecalSheet Skin 3",false, onSkinSelect);
			
			skin1BMD.y = skin2BMD.y = skin3BMD.y = decalSheet.y;
			
			registeredDecalLabel = new Label(uiContainer, decalSheet.x, decalSheet.y + decalSheet.height + 10, "Registered Decals");
			
			var total : int = decalSheet.decalNames.length;
			var decalButtonGroup:Sprite = new Sprite();
			decalButtonGroup.y = registeredDecalLabel.y + registeredDecalLabel.height;
			decalButtonGroup.addEventListener(MouseEvent.CLICK, onPreviewDecal);
			uiContainer.addChild(decalButtonGroup);
			
			for (var i : int = 0; i < total	; i++) 
			{
				var button:PushButton = new PushButton( decalButtonGroup, 0, (i * 22), "Preview: "+decalSheet.decalNames[i]);
				button.name = decalSheet.decalNames[i];
			}

			decalLabel = new Label(uiContainer, decalSheet.x + decalSheet.width+10, registeredDecalLabel.y, "Decal Preview");
			
			decalPreviewArea = new Sprite( );
			decalPreviewArea.x = decalLabel.x;
			decalPreviewArea.y = decalLabel.y + decalLabel.height;
			
			uiContainer.addChild( decalPreviewArea );
			
			skinnedLabel = new Label(uiContainer, 225, decalLabel.y, "Simple Button Test");
			
			skinnedButton = new SimpleButton(decalSheet.getDecal(states[0]), decalSheet.getDecal(states[1]), decalSheet.getDecal(states[2]));
			skinnedButton.x = skinnedLabel.x;
			skinnedButton.y = skinnedLabel.y + skinnedLabel.height;

			skinnedButton.hitTestState = skinnedButton.upState;
			skinnedButton.useHandCursor = true;
			
			uiContainer.addChild(skinnedButton);
			//uiContainer.addChild( decalSheet.getDecal( states[0] ) );
		}
		
		private function onSkinSelect(event: Event):void
		{
				var target:RadioButton = event.target as RadioButton;
			if(currentSelectedSkin != target)
			{
				currentSelectedSkin.selected = false;
			
				
				currentSelectedSkin = target;
				
				switch (currentSelectedSkin)
				{
					case skin1Label:
						decalSheet.bitmapData = skin1BMD.bitmapData;
						break;
					case skin2Label:
						decalSheet.bitmapData = skin2BMD.bitmapData;
						break;
					case skin3Label:
						decalSheet.bitmapData = skin3BMD.bitmapData;
						break;
				}
			}
		}
		
		private function onPreviewDecal(event : MouseEvent) : void
		{
			if(activeDecal && decalPreviewArea.contains(activeDecal))
			{
				decalPreviewArea.removeChild(activeDecal);
				activeDecal = null;	 
			}
			
			activeDecal = decalSheet.getDecal(PushButton(event.target).name);
			decalPreviewArea.addChild( activeDecal );
		}

		private function createDecalSheetBitmapData(colorSet:Number = 0) : BitmapData
		{
			var tempSheet : CamoDisplay = new CamoDisplay( );
				
			tempSheet.width = 100;
			tempSheet.height = 100;
			tempSheet.padding = [ 1 ];
			tempSheet.backgroundColor = 0xff0000;
				
			var total : int = states.length;
			var lastX : int = 0;
			var lastY : int = 0;
			var tempButton : CamoDisplay;
			
			for (var i : int = 0; i < total ; i ++) 
			{
				
				var stateName : String = states[i];
				tempButton = drawButton( stateName, colorSet );
				tempButton.x = lastX;
				tempButton.y = lastY;
				tempSheet.addChild( tempButton );
				
				if(decalSheet.decalNames.indexOf( stateName ) == -1)
					decalSheet.registerDecal( stateName, new Rectangle( lastX + buttonOffset, lastY+buttonOffset, tempButton.width, tempButton.height ) );
				
				lastY += tempButton.height + buttonOffset;
			}
			tempSheet.refresh( );
			
			return tempSheet.bitmapData;
		}

		private function drawButton(state:String, colorSet:Number = 0) : CamoDisplay {
			var button : CamoDisplay = new CamoDisplay();
			button.addChild(create_gradient( buttonWidth, (_top_highlight_size + _mid_highlight_size + 1), colors[colorSet].a, colors[colorSet].b));
			button.addChild(create_gradient(buttonWidth, (_top_highlight_size + _mid_highlight_size), colors[colorSet].c, colors[colorSet].d, 0, (_top_highlight_size + _mid_highlight_size + 1)));
			
			var label : TextField = new TextField( );
			label.defaultTextFormat = new TextFormat( "Arial", 20, colors[colorSet].e, true);
			label.autoSize = "left";
			label.text = state;
			
			label.x = (buttonWidth * .5) - (label.width * .5);
			label.y = (buttonHeight * .5) - (label.height * .5) + 5;
			
			
			button.addChild( label );
			
			return button;
		}
		
		public function create_gradient(width:int,height:int,color_a:uint,color_b:uint,x:int = 0,y:int = 0,alpha_a:int = 1, alpha_b:int = 1):Sprite{
			var temp_container:Sprite = new Sprite();
			
			var fillType : String = GradientType.LINEAR;
			var colors : Array = [color_a, color_b];
			var alphas : Array = [alpha_a, alpha_b];
			var ratios : Array = [0x00, 0xFF];
			var matr : Matrix = new Matrix();
			matr.createGradientBox(height + x, height + x, Math.PI / 2, x, y);

			var spreadMethod : String = SpreadMethod.PAD;

			temp_container.graphics.moveTo(x, y);
			temp_container.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr, spreadMethod);  
			temp_container.graphics.drawRect(x, y, width, height);
			
			
			return temp_container;
		}
		
	}
}
