/**
 * Copyright akinojp ( http://wonderfl.net/user/akinojp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Eel
 */

// forked from minon's forked from: Water Pool
// forked from Wanson's Water Pool
// write as3 code here..

package  {
    import flash.display.*;
    import flash.events.Event;
    import flash.net.*;
    import flash.geom.*;
    import flash.filters.*;
    
    [SWF(width="1200", height="1200", frameRate="500")]
    public class Program extends Sprite {
        private var demo:Demo;
        private var _screen:Sprite;
        private var _load:Loader;
        private var _filter:DisplacementMapFilter;
        private var _mtx:Matrix;
        
        public function Program() {
            
            _load = new Loader();
            _load.load( new URLRequest("http://upload.wikimedia.org/wikipedia/commons/a/ae/Doni_aux_Maldives_cropped.jpg") );
            _load.contentLoaderInfo.addEventListener( Event.COMPLETE, loadComplete );
            this.addChild( _load );
            
            _screen = new Sprite();
            this.addChild( _screen );
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            demo = new Demo(_screen);
            _screen.blendMode = "overlay";
            
            _filter = new DisplacementMapFilter( null, new Point(0,0), 0, 0, 400, 400 )
            _mtx = new Matrix();
            _mtx.scale( 5, 5 );
            
        }

        public function onEnterFrame(ev:Event):void {
            demo.frame();
            this.attach();
        }
        
        public function loadComplete(e:Event):void {
        }
        
        public function attach():void {
            var bmp:BitmapData = new BitmapData(800,800);
            bmp.draw( demo.bmpdata, _mtx );
            _filter.mapBitmap = bmp;
            _load.filters = [ _filter ];
        }
        
    }
}

import flash.display.*;
import flash.events.MouseEvent;

class Demo {
    public var bmpdata:BitmapData;
    private var field1:Array = [];
    private var field2:Array = [];
    private const SIZEX:int = 400;
    private const SIZEY:int = 250;
    private const FSIZEX:int = SIZEX + 2;
    private const FSIZEY:int = SIZEY + 2;
    private const SCALE:int = 8;
    private var ox:int;
    private var oy:int;
    private const c1:Number = 0.501;
    private const c2:Number = 0.01;
    private const cc:Number = 1 / (1.01 + c2);
    private var filters:Array;

    public function Demo(screen:Sprite) {
        screen.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);

        bmpdata = new BitmapData(SIZEX, SIZEY);
        var mapimg:Bitmap = new Bitmap(bmpdata);
        mapimg.scaleX = mapimg.scaleY = SCALE;
        screen.addChild(mapimg);

        var i:uint;
        var j:uint;
        for (i = 0; i < FSIZEY; ++i) {
            field1.push([]);
            field2.push([]);
            for (j = 0; j < FSIZEX; ++j)
                field1[i][j] = 0.0;
        }

        // initialize
        for (i = 0; i < FSIZEX; i++)
            field1[0][i] = field1[FSIZEY - 1][i] =
                field2[0][i] = field2[FSIZEY - 1][i] = 0.0;
        for (i = 0; i < FSIZEY; i++)
            field1[i][0] = field1[i][FSIZEX - 1] =
                field2[i][0] = field2[i][FSIZEX - 1] = 0.0;

        for (i = 1; i < FSIZEY - 1; ++i)
            for (j = 1; j < FSIZEX - 1; ++j)
                field2[i][j] = field1[i][j]
                    + 0.25 * (field1[i+1][j] + field1[i-1][j] 
                            + field1[i][j+1] + field1[i][j-1] - 4 * field1[i][j]);

        put(50, 50, 300);
    }

    private function onMouseMove(ev:MouseEvent):void {
        put((ev.localX + 1) / SCALE, (ev.localY + 1) / SCALE, 15);
    }

    private function put(px:Number, py:Number, pow:Number):void {
        const r:uint = 10;
        const bx:int = (px - r < 1) ? 1 : px - r;
        const ex:int = (px + r > FSIZEX - 1) ? FSIZEX - 1 : px + r;
        const by:int = (py - r < 1) ? 1 : py - r;
        const ey:int = (py + r > FSIZEY - 1) ? FSIZEY - 1 : py + r;
        for (var y:uint = by; y < ey; ++y) {
            for (var x:uint = bx; x < ex; ++x) {
                const d:Number = Math.sqrt((px - x) * (px - x) + (py - y) * (py - y));
                if (d < r) {
                    var p:Number = pow * Math.cos(Math.PI / 2 * d / r);
                    field1[y][x] += p;
                    field2[y][x] += p;
                }
            }
        }
    } 

    public function frame():void {
        // draw
        var r:uint, g:uint, b:uint, c:uint;
        var x:uint, y:uint;
        var line_c:Array, line_p:Array, line_n:Array;
        bmpdata.lock();
        for (y = 1; y < SIZEY + 1; ++y) {
            line_c = field2[y];
            for (x = 1; x < SIZEX + 1; ++x) {
                c = Math.abs(line_c[x]);
                r = c + 0;
                g = c + 50;
                b = c + 100;
                if (r > 255) r = 255;
                if (g > 255) g = 255;
                if (b > 255) b = 255;
                bmpdata.setPixel(x - 1, y - 1, (r << 16) + (g << 8) + b);
            }
        }
        bmpdata.unlock();

        // step
        for (y = 1; y < FSIZEY - 1; ++y) {
            line_p = field2[y - 1];
            line_c = field2[y];
            line_n = field2[y + 1];
            for (x = 1; x < FSIZEX - 1; ++x) {
                field1[y][x] = (line_c[x] * (2 - 4 * c1)
                        - field1[y][x] * (1 - c2)
                        + c1 * (line_n[x] + line_p[x] 
                            + line_c[x + 1] + line_c[x - 1])) * cc;
            }
        }

        // next
        const tmp:Array = field1;
        field1 = field2;
        field2 = tmp;
    }
    
}



