/**
 * Copyright logicalyze ( http://wonderfl.net/user/logicalyze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1EeC
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.render.BasicRenderEngine;

	[SWF(width = "450", height = "450", backgroundColor = "#000000", frameRate = "30")]
	public class PV3DEarth extends Sprite
	{
		
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var material1:WireframeMaterial;
		private var material2:WireframeMaterial;
		private var earth:Sphere;
		private var moon:Sphere;
		private var renderer:BasicRenderEngine;
		private var angle:Number;
		private var speed:Number;
		private var position:Number;
		
		public function PV3DEarth():void
		{
			set_3dscene();
			init();
		}
		
		private function set_3dscene():void
		{
			viewport = new Viewport3D(450, 450, true, false);
			addChild(viewport);
			scene = new Scene3D();
			camera = new Camera3D();
			renderer = new BasicRenderEngine();
			camera.z = -3000;
			camera.focus = 100;
			camera.zoom = 6;
		}
		
		private function init():void
		{
			material1 = new WireframeMaterial(0xFFCC00);
			material1.smooth = true;
			earth = new Sphere(material1, 400, 20, 20);
			earth.rotationZ = 30;
			material2 = new WireframeMaterial(0xFF0000);
			material2.smooth = true;
			moon = new Sphere(material2, 100, 8, 6);
			moon.y = 100;
			speed = -.03;
			angle = 0;
			position = 700;
			moon.z = Math.sin(angle) * position;
			moon.x = Math.cos(angle) * position;
			earth.addChild(moon);
			scene.addChild(earth);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);

		}
		private function move_moon():void{
			moon.z = Math.sin(angle) * position;
			moon.x = Math.cos(angle) * position;
			angle += speed;
			moon.rotationY += 5;
		}
		private function onEnterFrame(e:Event):void
		{
			earth.rotationY -= 1;
			move_moon();
			renderer.renderScene(scene, camera, viewport);
		}
		
	}
	
}