/**
 * Copyright say0 ( http://wonderfl.net/user/say0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Dfl
 */

// forked from actionscriptbible's Chapter 31 Example 5
package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.media.*;
  import flash.net.URLRequest;
  import flash.utils.ByteArray;
  
  [SWF(frameRate="60",backgroundColor="#808080")]
  public class ch31ex5 extends Sprite {
    protected var sound:Sound;
    protected var waveform:ByteArray;
    
    public function ch31ex5() {
      var songurl:String = "http://actionscriptbible.com/files/winter.mp3";
      sound = new Sound(new URLRequest(songurl),
                        new SoundLoaderContext(1000,true));
      sound.play();
      waveform = new ByteArray();
      this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      graphics.clear();
      SoundMixer.computeSpectrum(waveform, true, 2);
      //draw the left channel in blue
      graphics.lineStyle(1, 0x0000ff);
      drawChannel(1);
      //and the right in red
      graphics.lineStyle(1, 0xff0000);
      drawChannel(-1);
    }
    protected function drawChannel(a:int):void {
      var W:Number = stage.stageWidth;
      var H:Number = stage.stageHeight;
      var SAMPLES:Number = 256;
      var xstep:Number = W/SAMPLES;

      graphics.moveTo(0, H/2*a);
      //assumes that the ByteArray is already at the correct location 
      for (var i:int = 0, x:Number = 0; i < SAMPLES; i++, x+=xstep) {
        var amplitude:Number = waveform.readFloat();
        var y:Number = H/2 +(amplitude * H/2)*a +H/2*-a; //amplitude is from -1 to 1
        graphics.lineTo(x, y);
      }
    }
  }
}
