/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Dbr
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.net.*;
  import flash.utils.ByteArray;
  import flash.utils.getTimer;
  
  [SWF(backgroundColor="#000000")]
  public class ch35ex14 extends Sprite {
    protected var plasma:Shader;
    protected var shape:Shape;

    public function ch35ex14() {
      plasma = new Shader();
      shape = new Shape();
      shape.x = stage.stageWidth/2; shape.y = stage.stageHeight/2;
      addChild(shape);
      var loader:URLLoader = new URLLoader();
      loader.dataFormat = URLLoaderDataFormat.BINARY;
      //plasma shader courtesy the inimitable mrdoob (Ricardo Cabello)
      loader.load(new URLRequest(
        "http://actionscriptbible.com/files/mrdoob-plasma.pbj"));
      loader.addEventListener(Event.COMPLETE, onLoadComplete);
    }
    
    protected function onLoadComplete(event:Event):void {
      var loader:URLLoader = URLLoader(event.target);
      plasma.byteCode = ByteArray(loader.data);
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    protected function onEnterFrame(event:Event):void {
      var t:int = getTimer();
      var w:Number = stage.stageWidth/2; var h:Number = stage.stageHeight/2;
      var d:ShaderData = plasma.data;
      d.center.value = [Math.sin(t*.002)*300+w, Math.cos(t*.0001)*300+h];
      d.wave.value = [Math.sin(t*.001)*.06+0.01, Math.cos(t*.00005)*.05];
      d.offset.value = [Math.sin(t*.004)*200, Math.cos(t*.0003)*200];
      d.color_offset.value = [Math.sin(t*.002)*2, Math.sin(t*.00009)*2,
        Math.cos(t*.00005)*2];
      d.distort.value = [Math.sin(t*.0008)*.05];
      
      shape.graphics.clear();
      shape.graphics.lineStyle(6, 0, 1, false, null, CapsStyle.NONE);
      shape.graphics.lineShaderStyle(plasma);
      drawLissajous();
    }
    
    protected function drawLissajous():void {
      var H:Number = stage.stageHeight, W:Number = stage.stageWidth;
      var a:Number = ((stage.mouseX / W) - 0.5) * 16;
      var b:Number = ((stage.mouseY / H) - 0.5) * 16;
      for (var t:Number = 0; t < Math.PI * 2; t += 0.02) {
        var x:Number = W/2 * Math.sin(a * t + Math.PI/2);
        var y:Number = H/2 * Math.sin(b * t);
        if (t == 0) {
          shape.graphics.moveTo(x, y);
        } else {
          shape.graphics.lineTo(x, y);
        }
      }
    }
  }
}