package {
	import flash.display.Sprite;
	
	/**
	* World map :)
	* @author makc
	* @license WTFPLv2, http://sam.zoy.org/wtfpl/
	*/
	public class WorldMap extends Sprite {
		
		public function WorldMap () {
			var x0:Number = -1e6;
			var y0:Number = -1e6;
			var lines:Array = world.toString().split("\n");
			for each (var line:String in lines) {
				var a:Array = line.match (/\s*([\-\d\.]+)\s+([\-\d\.]+)\s*/);
				if (a) {
					var x1:Number = 220 + parseFloat (a[1]);
					var y1:Number = 200 - parseFloat (a[2]);
					var d:Number = (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1);
					if (d > 30) {
						graphics.moveTo (x1, y1);
						if (d > 1000) {
							graphics.lineStyle (0);
						}
					} else {
						graphics.lineTo (x1, y1);
					}
					x0 = x1;
					y0 = y1;
				}
			}
			trace (0)
		}

		/**
		 * world.prn file dated 30 Apr 1996 (origin unknown)
		 */
		public var world:XML = <world>-131.00  55.00
-130.70  54.00
-130.00  53.30
-128.70  52.30
-128.10  51.50
-127.00  50.80
-126.60  50.50
-128.00  50.90
-127.90  50.30
-127.50  50.10
-126.60  49.40
-125.50  48.90
-125.20  48.70
-123.70  48.40
-123.50  48.90
-124.80  49.50
-124.70  50.00
-123.20  49.40
-122.40  48.50
-123.80  48.20
-124.60  47.90
-124.00  46.60
-124.00  45.50
-124.10  44.40
-124.20  43.80
-124.50  42.80
-124.30  42.30
-124.20  41.80
-124.10  41.10
-124.40  40.50
-123.90  39.80
-123.70  38.90
-123.00  38.00
-122.50  38.10
-122.20  38.10
-122.00  37.40
-122.50  37.80
-122.40  37.20
-121.80  36.90
-122.00  36.60
-121.50  35.90
-120.90  35.20
-120.60  34.60
-120.00  34.50
-119.00  34.10
-118.40  33.70
-117.50  33.40
-117.00  32.30
-116.70  31.80
-116.30  31.30
-116.00  30.80
-115.80  30.40
-115.70  29.70
-114.60  29.00
-114.20  28.00
-115.10  27.90
-113.70  26.70
-113.00  26.50
-112.10  25.50
-111.80  24.40
-110.70  23.70
-110.10  22.90
-109.50  23.10
-109.80  24.00
-110.30  24.20
-110.70  24.80
-111.40  25.80
-112.00  27.00
-112.90  27.90
-113.10  28.50
-113.60  29.00
-114.30  29.30
-114.50  29.80
-114.70  30.90
-114.80  31.70
-114.00  31.70
-113.10  31.20
-112.80  30.30
-112.20  29.00
-111.20  28.00
-110.70  27.40
-109.80  26.60
-109.50  26.00
-108.70  25.40
-108.00  24.60
-106.90  23.80
-106.00  22.70
-105.60  22.10
-105.30  21.50
-105.60  20.70
-105.40  20.50
-105.60  20.00
-105.00  19.30
-103.70  18.70
-103.00  18.20
-102.00  18.00
-101.70  17.70
-100.00  16.90
 -98.80  16.60
 -98.60  16.30
 -97.80  16.00
 -97.40  15.90
 -96.90  15.80
 -96.30  15.70
 -95.70  15.90
 -95.10  16.30
 -94.40  16.20
 -93.70  15.90
 -93.10  15.50
 -92.50  14.80
 -91.90  14.30
 -91.20  13.90
 -90.50  13.90
 -89.90  13.70
 -89.50  13.50
 -88.80  13.30
 -87.90  13.20
 -87.90  13.40
 -87.70  13.40
 -87.60  13.40
 -87.60  13.50
 -87.50  13.30
 -87.40  13.00
 -87.70  13.10
 -87.60  12.80
 -87.20  12.50
 -86.70  12.00
 -86.20  11.60
 -85.70  11.10
 -85.90  11.00
 -85.70  10.80
 -85.80  10.50
 -85.80  10.10
 -85.40   9.90
 -85.10   9.60
 -84.90   9.90
 -85.30  10.30
 -84.80  10.00
 -84.70   9.60
 -84.20   9.40
 -83.60   9.00
 -83.80   8.60
 -83.30   8.40
 -83.50   8.60
 -83.50   8.70
 -83.20   8.60
 -83.00   8.30
 -82.90   8.30
 -82.20   8.20
 -81.60   7.70
 -81.20   7.90
 -80.90   7.50
 -80.40   7.30
 -80.00   7.50
 -80.50   8.10
 -80.20   8.30
 -79.80   8.60
 -79.60   8.90
 -79.00   9.00
 -78.40   8.40
 -78.30   8.30
 -78.30   7.70
 -77.70   7.00
 -77.50   6.70
 -77.50   6.30
 -77.40   6.00
 -77.40   5.60
 -77.50   5.50
 -77.40   5.50
 -77.30   4.70
 -77.50   4.30
 -77.10   3.90
 -77.70   3.00
 -78.00   2.60
 -78.50   2.60
 -78.50   1.90
 -78.80   1.80
 -78.80   1.40
 -79.50   1.00
 -80.00   0.40
 -80.40  -0.20
 -80.50  -0.60
 -80.90  -1.10
 -80.90  -1.60
 -80.80  -2.20
 -80.70  -2.40
 -80.30  -2.70
 -80.00  -2.30
 -79.70  -2.50
 -80.00  -3.20
 -80.80  -3.70
 -81.30  -4.30
 -81.40  -4.60
 -81.20  -5.10
 -81.00  -5.40
 -81.10  -5.80
 -80.80  -6.30
 -79.90  -6.90
 -79.60  -7.50
 -79.10  -8.10
 -78.70  -8.60
 -78.60  -9.10
 -78.20 -10.00
 -77.70 -10.90
 -77.30 -11.50
 -77.20 -12.10
 -77.00 -12.20
 -76.80 -12.50
 -76.50 -13.10
 -76.20 -13.60
 -76.30 -14.20
 -75.90 -14.60
 -75.20 -15.20
 -74.70 -15.60
 -73.80 -16.20
 -72.90 -16.50
 -72.80 -16.60
 -71.90 -17.10
 -71.50 -17.30
 -71.00 -17.90
 -70.30 -18.40
 -70.30 -19.00
 -70.20 -19.60
 -70.20 -20.50
 -70.10 -21.30
 -70.20 -22.20
 -70.50 -23.10
 -70.70 -23.50
 -70.40 -23.60
 -70.50 -24.20
 -70.50 -25.10
 -70.70 -25.70
 -70.70 -26.30
 -70.80 -27.00
 -70.90 -27.60
 -71.20 -28.10
 -71.60 -28.90
 -71.30 -29.40
 -71.70 -30.30
 -71.70 -31.20
 -71.60 -31.60
 -71.50 -32.30
 -71.60 -32.80
 -71.80 -33.10
 -71.60 -33.60
 -72.00 -34.20
 -72.20 -34.90
 -72.40 -35.30
 -72.50 -35.80
 -72.80 -36.30
 -73.20 -36.70
 -73.30 -37.30
 -73.70 -37.40
 -73.70 -37.60
 -73.50 -38.50
 -73.20 -39.40
 -73.40 -39.80
 -73.70 -40.20
 -74.00 -41.00
 -73.70 -41.60
 -74.00 -41.80
 -74.20 -41.50
 -74.20 -43.00
 -73.70 -43.50
 -73.40 -43.00
 -73.10 -42.70
 -72.90 -43.30
 -73.10 -43.60
 -73.60 -44.00
 -74.10 -43.90
 -74.50 -44.50
 -74.50 -45.00
 -74.70 -45.70
 -75.10 -46.30
 -75.70 -46.90
 -75.10 -46.60
 -74.20 -46.80
 -74.80 -47.70
 -75.20 -47.80
 -75.70 -48.50
 -75.70 -49.30
 -75.60 -49.60
 -75.00 -50.00
 -75.50 -50.50
 -75.30 -50.70
 -75.00 -50.80
 -75.20 -51.40
 -75.20 -51.60
 -75.10 -51.50
 -75.10 -51.80
 -74.70 -52.40
 -74.10 -52.70
 -73.30 -53.20
 -74.70 -52.70
 -73.90 -53.30
 -73.40 -53.80
 -72.70 -54.20
 -72.00 -54.60
 -72.50 -54.80
 -71.00 -55.10
 -70.50 -55.20
 -70.10 -55.40
 -69.10 -55.70
 -68.50 -55.50
 -68.00 -55.80
 -68.50 -55.30
 -67.50 -55.30
 -67.00 -55.20
 -66.80 -55.00
 -66.20 -55.00
 -65.70 -54.90
 -65.30 -54.90
 -65.20 -54.60
 -66.30 -54.50
 -66.80 -54.30
 -67.50 -54.00
 -68.00 -53.60
 -68.60 -53.30
 -68.20 -53.20
 -68.80 -52.60
 -69.50 -52.50
 -69.10 -52.20
 -68.50 -52.40
 -68.70 -52.00
 -69.10 -51.20
 -69.00 -50.40
 -67.90 -50.00
 -67.70 -49.30
 -67.40 -48.90
 -67.10 -48.60
 -66.70 -48.40
 -66.10 -48.10
 -65.90 -47.90
 -65.70 -47.40
 -66.30 -47.10
 -67.10 -46.70
 -67.50 -46.50
 -67.40 -45.70
 -67.00 -45.30
 -66.40 -45.10
 -65.60 -45.00
 -65.80 -44.80
 -65.20 -44.30
 -65.00 -43.30
 -65.00 -42.70
 -64.20 -42.60
 -63.60 -42.80
 -63.80 -42.10
 -64.00 -42.30
 -64.60 -42.50
 -64.90 -42.20
 -65.00 -41.50
 -64.90 -40.70
 -63.70 -41.20
 -62.30 -40.90
 -62.50 -40.40
 -62.10 -39.90
 -62.30 -39.20
 -62.10 -38.90
 -61.40 -39.00
 -60.60 -38.90
 -59.20 -38.70
 -58.10 -38.40
 -57.50 -37.80
 -56.60 -36.90
 -57.10 -36.30
 -57.10 -35.40
 -57.90 -34.10
 -58.50 -34.40
 -58.00 -34.30
 -57.40 -34.50
 -56.80 -34.60
 -56.10 -34.90
 -54.90 -34.90
 -54.10 -34.60
 -53.50 -34.10
 -53.00 -33.50
 -52.50 -32.80
 -51.80 -31.90
 -50.80 -31.20
 -50.30 -30.50
 -49.90 -29.50
 -49.10 -28.80
 -48.70 -28.20
 -48.70 -27.70
 -48.70 -26.80
 -48.50 -26.30
 -48.40 -25.50
 -47.90 -25.00
 -47.00 -24.40
 -46.60 -24.10
 -46.20 -23.80
 -45.20 -23.90
 -45.40 -23.60
 -44.60 -23.40
 -44.70 -23.30
 -44.10 -23.00
 -43.50 -23.00
 -42.50 -22.90
 -42.00 -22.60
 -41.30 -22.10
 -41.00 -21.50
 -40.80 -20.80
 -40.30 -20.40
 -40.00 -19.30
 -39.60 -19.40
 -39.70 -18.40
 -39.20 -17.70
 -39.20 -17.20
 -39.00 -16.30
 -38.90 -15.60
 -39.00 -14.70
 -38.90 -13.70
 -38.80 -12.90
 -38.50 -12.80
 -38.00 -12.50
 -37.40 -11.50
 -36.80 -10.60
 -36.00 -10.00
 -35.20  -9.00
 -34.90  -8.00
 -35.00  -7.00
 -35.10  -6.00
 -35.60  -5.10
 -36.60  -5.10
 -37.10  -4.90
 -37.80  -4.40
 -38.50  -3.70
 -39.50  -3.10
 -40.50  -2.80
 -41.30  -2.80
 -41.80  -2.70
 -42.30  -2.70
 -43.10  -2.40
 -43.90  -2.50
 -44.40  -2.50
 -44.60  -1.80
 -45.40  -1.50
 -46.40  -1.00
 -47.40  -0.60
 -48.30  -0.90
 -48.80  -1.50
 -48.50  -0.60
 -48.80  -0.20
 -49.60  -0.30
 -50.30  -0.10
 -50.70   0.  
 -50.80   0.20
 -49.90   1.10
 -50.00   1.80
 -50.70   2.20
 -51.00   3.20
 -51.10   3.90
 -51.50   4.50
 -51.80   4.70
 -52.70   5.30
 -53.00   5.50
 -53.90   5.80
 -54.00   5.90
 -55.10   6.00
 -55.90   6.00
 -56.40   5.90
 -57.20   5.90
 -57.50   6.30
 -58.30   6.90
 -58.50   7.00
 -58.70   7.70
 -59.70   8.40
 -60.40   8.60
 -60.70   8.60
 -60.70   9.40
 -61.20   9.50
 -61.80   9.80
 -62.30   9.90
 -62.90  10.60
 -61.90  10.70
 -62.20  10.80
 -63.30  10.70
 -64.30  10.70
 -63.70  10.50
 -64.20  10.40
 -64.70  10.20
 -65.30  10.10
 -66.10  10.50
 -66.60  10.70
 -67.60  10.50
 -68.30  10.70
 -68.50  11.30
 -69.30  11.60
 -69.80  11.90
 -70.10  12.20
 -70.30  11.60
 -69.70  11.50
 -70.50  11.30
 -71.50  11.00
 -71.30  10.20
 -71.10   9.30
 -71.70   9.10
 -72.10   9.80
 -71.60  10.50
 -71.70  11.00
 -72.00  11.60
 -71.10  12.10
 -71.70  12.50
 -72.20  12.30
 -72.70  11.70
 -73.40  11.30
 -74.00  11.40
 -74.30  11.00
 -74.50  11.00
 -75.30  10.80
 -75.50  10.10
 -75.60   9.50
 -76.10   9.40
 -76.60   8.70
 -76.90   8.50
 -76.70   7.90
 -77.00   8.30
 -77.80   9.00
 -78.50   9.50
 -79.10   9.60
 -79.90   9.40
 -80.00   9.10
 -80.20   9.20
 -80.70   8.90
 -81.60   8.80
 -81.80   9.00
 -82.40   9.50
 -82.60   9.60
 -83.10  10.10
 -83.60  10.90
 -83.90  11.40
 -83.70  12.00
 -83.50  12.50
 -83.50  13.50
 -83.20  14.30
 -83.10  15.00
 -83.90  15.50
 -84.70  15.90
 -85.20  15.90
 -86.00  16.00
 -86.50  15.80
 -87.50  15.80
 -88.10  15.70
 -88.60  15.70
 -88.70  16.30
 -88.30  16.70
 -88.20  17.50
 -88.10  18.00
 -88.40  18.40
 -88.00  18.50
 -87.90  18.00
 -87.70  18.50
 -87.50  19.30
 -87.60  19.40
 -87.40  19.60
 -87.70  19.70
 -87.50  20.20
 -86.90  20.80
 -86.90  21.50
 -87.10  21.50
 -88.00  21.60
 -88.70  21.50
 -89.10  21.40
 -90.20  21.20
 -90.50  20.50
 -90.70  19.70
 -91.00  19.10
 -91.30  18.80
 -91.60  18.50
 -91.80  18.70
 -92.30  18.70
 -92.90  18.50
 -94.00  18.30
 -94.70  18.50
 -95.60  18.70
 -95.90  18.90
 -96.30  19.30
 -96.80  20.30
 -97.40  21.20
 -97.70  22.00
 -97.70  23.00
 -97.70  24.00
 -97.70  25.00
 -97.40  25.40
 -97.10  26.10
 -97.40  26.50
 -97.40  27.40
 -96.80  28.20
 -96.00  28.60
 -95.10  29.10
 -95.10  29.80
 -94.70  29.80
 -94.20  29.60
 -93.20  29.80
 -92.10  29.60
 -91.90  29.90
 -91.20  29.40
 -90.90  29.10
 -90.20  29.10
 -90.00  29.20
 -89.50  29.30
 -89.00  29.20
 -89.60  29.70
 -89.50  30.00
 -89.70  30.10
 -90.40  30.10
 -90.00  30.40
 -89.40  30.30
 -88.40  30.40
 -88.00  30.80
 -87.70  30.30
 -86.70  30.50
 -85.80  30.20
 -85.40  29.90
 -85.00  29.70
 -84.30  29.90
 -84.00  30.10
 -83.10  29.20
 -82.70  28.70
 -82.90  27.90
 -82.70  28.00
 -82.70  27.50
 -82.20  26.80
 -82.00  27.00
 -81.80  26.50
 -81.70  25.90
 -81.20  25.50
 -80.80  25.20
 -80.50  25.00
 -80.20  25.80
 -80.00  26.80
 -80.40  27.80
 -80.60  28.50
 -81.10  29.50
 -81.40  30.50
 -81.30  31.50
 -81.00  31.90
 -80.50  32.40
 -80.00  32.60
 -79.20  33.40
 -78.50  33.90
 -77.80  34.30
 -77.00  34.70
 -76.30  35.00
 -76.50  35.30
 -76.50  35.50
 -75.70  35.60
 -75.60  36.00
 -76.70  36.00
 -75.80  36.20
 -75.90  36.90
 -76.30  37.10
 -76.30  38.20
 -76.50  39.00
 -76.00  39.60
 -76.20  39.30
 -76.30  38.50
 -75.90  38.30
 -75.70  37.80
 -76.00  37.30
 -75.60  37.60
 -75.10  38.50
 -75.50  39.10
 -75.60  39.70
 -74.90  39.20
 -74.50  39.40
 -74.00  40.40
 -74.10  40.50
 -74.00  40.60
 -73.00  40.70
 -72.00  41.00
 -72.50  40.90
 -72.60  41.00
 -73.70  40.80
 -73.70  41.00
 -72.50  41.30
 -71.50  41.40
 -71.10  41.70
 -70.70  41.70
 -70.00  41.70
 -70.10  42.10
 -70.00  41.80
 -70.60  41.90
 -71.00  42.40
 -70.80  42.70
 -70.40  43.50
 -69.50  43.90
 -69.00  44.30
 -67.70  44.50
 -67.00  45.10
 -65.80  45.30
 -64.60  45.80
 -64.80  45.50
 -64.20  45.40
 -64.00  45.30
 -64.30  45.10
 -64.90  45.10
 -66.00  44.50
 -66.00  43.70
 -65.30  43.60
 -64.30  44.30
 -64.00  44.70
 -63.50  44.50
 -62.30  44.90
 -61.00  45.30
 -61.00  45.60
 -59.90  46.00
 -60.50  46.40
 -60.60  47.00
 -61.20  46.30
 -61.50  45.70
 -61.90  45.80
 -63.20  45.80
 -63.80  46.10
 -64.70  46.30
 -64.90  47.10
 -65.00  47.30
 -64.50  48.00
 -65.70  47.60
 -65.80  47.90
 -65.90  48.30
 -64.80  48.20
 -64.10  48.90
 -65.40  49.30
 -67.00  49.00
 -68.50  48.50
 -69.60  47.80
 -70.50  47.00
 -70.80  47.10
 -69.90  47.70
 -69.20  48.50
 -68.60  48.90
 -68.00  49.30
 -67.10  49.80
 -66.50  50.30
 -65.00  50.30
 -63.50  50.30
 -62.10  50.30
 -60.80  50.20
 -59.50  50.50
 -58.70  51.20
 -58.00  51.30
 -57.10  51.40
 -56.80  51.50
 -55.80  52.20
 -55.90  53.00
 -56.60  53.60
 -57.30  54.10
 -57.60  54.20
 -58.10  54.30
 -58.30  54.10
 -58.80  53.90
 -59.00  53.70
 -59.40  53.70
 -59.90  53.50
 -60.10  53.40
 -60.40  53.40
 -60.10  53.70
 -59.90  53.80
 -59.30  53.90
 -58.90  54.00
 -58.40  54.30
 -58.00  54.40
 -57.50  54.40
 -57.40  54.50
 -57.30  54.60
 -57.70  54.60
 -57.90  54.80
 -58.10  54.80
 -58.40  54.70
 -58.80  54.80
 -59.00  55.00
 -59.10  55.20
 -59.30  55.30
 -59.50  55.00
 -59.60  55.20
 -60.00  55.10
 -59.80  55.30
 -60.00  55.30
 -60.40  55.20
 -60.40  55.40
 -60.30  55.70
 -60.50  55.60
 -60.80  55.60
 -61.00  55.80
 -61.40  56.00
 -61.60  56.20
 -62.00  56.30
 -61.90  56.40
 -61.60  56.60
 -61.70  56.80
 -61.80  56.80
 -61.40  57.00
 -61.60  57.20
 -61.80  57.40
 -62.20  57.60
 -61.80  57.80
 -61.90  57.80
 -62.10  57.90
 -62.50  58.00
 -62.40  58.20
 -62.90  58.20
 -62.60  58.40
 -62.80  58.50
 -63.20  58.50
 -62.90  58.60
 -63.00  58.70
 -62.80  58.90
 -63.10  58.80
 -63.10  59.00
 -63.60  59.10
 -63.40  59.30
 -63.50  59.40
 -63.70  59.30
 -63.70  59.50
 -63.60  59.60
 -64.00  59.70
 -64.10  59.90
 -64.10  60.10
 -64.30  60.30
 -64.50  60.50
 -64.70  60.40
 -65.00  60.00
 -65.50  59.70
 -65.10  59.40
 -65.70  59.20
 -65.60  58.80
 -66.00  58.60
 -66.60  58.60
 -67.00  58.40
 -67.70  58.20
 -67.80  58.40
 -68.20  58.50
 -68.30  58.80
 -69.00  58.90
 -69.50  58.70
 -69.20  59.00
 -69.20  59.30
 -69.70  59.30
 -69.60  59.40
 -69.70  59.50
 -69.50  59.70
 -69.70  59.90
 -69.60  60.10
 -69.70  60.40
 -69.60  60.60
 -69.40  60.80
 -69.50  61.10
 -69.70  61.00
 -70.00  60.70
 -70.10  61.10
 -70.40  61.00
 -71.40  61.20
 -71.70  61.40
 -71.80  61.60
 -71.80  61.80
 -72.00  61.80
 -72.60  62.00
 -73.00  62.20
 -73.50  62.40
 -73.80  62.40
 -74.30  62.20
 -74.70  62.10
 -75.00  62.20
 -75.70  62.30
 -76.50  62.50
 -77.40  62.60
 -78.00  62.40
 -78.20  62.00
 -77.90  61.70
 -77.70  62.60
 -77.80  61.10
 -77.80  60.70
 -77.80  60.50
 -77.60  60.10
 -77.30  60.00
 -77.50  59.70
 -77.80  59.60
 -77.90  59.40
 -78.00  59.30
 -78.50  58.90
 -78.30  58.50
 -77.60  58.20
 -77.00  57.90
 -76.70  57.50
 -76.60  57.00
 -76.60  56.50
 -76.70  56.20
 -76.40  56.50
 -75.90  56.10
 -76.70  56.10
 -77.00  55.80
 -77.70  55.30
 -78.50  55.00
 -79.50  54.70
 -79.50  54.50
 -79.20  54.20
 -79.00  53.50
 -78.90  53.00
 -78.70  52.50
 -78.70  52.20
 -78.70  51.80
 -78.80  51.50
 -79.00  51.50
 -79.30  51.70
 -79.60  51.40
 -80.00  51.30
 -80.50  51.60
 -80.80  51.90
 -81.40  52.10
 -81.50  52.50
 -81.70  52.70
 -82.30  53.00
 -82.10  53.40
 -82.10  53.80
 -82.40  54.30
 -82.20  54.80
 -82.70  55.20
 -83.00  55.30
 -83.80  55.40
 -84.40  55.30
 -85.30  55.40
 -86.00  55.70
 -87.00  55.90
 -87.80  56.30
 -88.40  56.70
 -89.40  56.90
 -90.20  57.10
 -91.00  57.30
 -92.00  57.10
 -92.50  57.00
 -92.50  57.20
 -92.50  57.50
 -93.00  58.40
 -93.60  58.80
 -94.00  58.80
 -94.40  58.70
 -94.80  59.50
 -94.50  60.50
 -93.80  61.40
 -93.50  61.70
 -93.50  61.90
 -92.80  62.20
 -92.60  62.50
 -91.90  62.60
 -92.20  62.70
 -92.00  62.80
 -91.00  62.90
 -90.60  63.10
 -91.10  63.50
 -91.70  63.70
 -91.00  63.70
 -90.20  63.70
 -89.80  64.00
 -89.00  64.00
 -88.20  64.20
 -87.80  64.60
 -87.50  64.70
 -87.00  65.00
 -86.90  65.20
 -87.40  65.30
 -88.20  65.30
 -89.00  65.30
 -89.80  65.70
 -90.30  65.80
 -89.60  65.90
 -89.00  65.70
 -88.30  65.50
 -87.60  65.50
 -87.00  65.60
 -86.30  65.90
 -86.30  66.30
 -86.50  66.50
 -85.70  66.50
 -85.20  66.40
 -84.80  66.20
 -84.00  65.80
 -83.30  65.60
 -83.50  65.80
 -84.30  66.20
 -84.10  66.30
 -83.90  66.40
 -83.80  66.80
 -83.80  66.50
 -83.00  66.50
 -82.60  66.60
 -82.00  66.80
 -81.50  66.90
 -81.10  67.50
 -82.00  68.00
 -82.50  68.50
 -81.80  68.50
 -81.20  68.70
 -81.70  68.80
 -81.50  68.90
 -81.30  69.40
 -82.00  69.40
 -82.40  69.60
 -82.90  69.70
 -83.70  69.70
 -84.50  69.80
 -85.30  69.80
 -85.40  69.40
 -84.90  69.10
 -85.00  68.90
 -85.00  68.70
 -85.60  68.70
 -85.70  68.60
 -86.00  68.00
 -86.40  68.00
 -86.60  68.30
 -86.80  67.80
 -86.50  67.40
 -87.00  67.30
 -87.50  67.40
 -88.30  67.80
 -88.30  68.40
 -88.10  68.30
 -87.80  68.50
 -87.90  68.70
 -88.40  69.00
 -89.00  69.30
 -89.40  69.10
 -89.60  68.70
 -90.00  68.30
 -90.20  68.30
 -90.40  68.50
 -90.40  68.80
 -90.60  69.10
 -91.00  69.30
 -90.90  69.40
 -90.70  69.30
 -90.20  69.30
 -90.30  69.50
 -90.90  69.50
 -91.40  69.70
 -92.00  69.50
 -92.60  69.70
 -92.00  70.00
 -91.60  70.20
 -92.00  70.40
 -92.50  70.50
 -93.00  70.80
 -92.90  71.00
 -93.00  71.40
 -93.80  71.70
 -94.00  71.80
 -94.30  72.00
 -93.60  72.50
 -93.50  72.80
 -92.50  72.70
 -91.50  73.00
 -90.50  73.70
 -90.50  73.90
 -91.50  74.00
 -92.00  74.00
 -93.00  74.10
 -94.00  74.10
 -95.00  74.00
 -95.20  73.80
 -95.90  73.80
 -95.70  73.00
 -95.30  72.40
 -95.30  71.80
 -95.50  71.50
 -96.00  71.40
 -96.50  70.80
 -96.60  70.30
 -96.40  69.90
 -95.50  69.70
 -94.50  69.50
 -93.70  69.40
 -94.00  69.30
 -94.40  69.00
 -94.70  68.70
 -94.00  68.80
 -93.80  68.80
 -94.00  68.40
 -95.00  68.00
 -95.50  68.00
 -95.50  67.30
 -96.30  67.30
 -96.10  68.00
 -95.60  68.80
 -96.00  69.00
 -97.00  69.60
 -98.00  69.80
 -98.50  69.40
 -99.50  69.00
 -99.00  68.90
 -98.00  68.50
 -98.50  68.40
 -98.80  67.80
 -99.50  67.80
-100.50  67.90
-101.50  67.80
-103.00  67.90
-104.00  68.00
-104.70  68.10
-105.30  68.30
-106.00  68.70
-107.00  68.80
-108.00  68.60
-108.50  68.50
-108.40  68.10
-107.50  68.20
-106.50  68.50
-106.50  68.30
-107.50  68.00
-107.90  67.70
-107.30  66.90
-108.00  67.10
-109.00  67.30
-109.50  67.70
-110.50  67.90
-111.50  67.80
-112.50  67.70
-113.50  67.70
-114.50  67.70
-115.30  67.80
-115.20  68.20
-114.50  68.20
-114.80  68.70
-115.50  68.90
-116.50  68.90
-117.50  68.90
-118.50  69.10
-119.00  69.20
-120.00  69.30
-121.00  69.60
-122.00  69.80
-123.00  69.80
-124.00  69.40
-124.20  69.70
-124.80  70.10
-125.30  69.60
-126.00  69.50
-127.00  70.00
-128.00  70.50
-128.50  70.00
-129.00  69.80
-130.00  69.80
-130.00  69.90
-129.50  70.20
-130.50  70.10
-131.50  69.90
-132.50  69.70
-133.50  69.40
-134.00  69.60
-134.50  69.50
-135.50  69.00
-136.00  68.90
-137.00  68.90
-138.00  69.10
-139.00  69.40
-140.00  69.60
-141.00  69.60
-142.00  69.70
-143.00  70.00
-144.00  70.00
-145.00  70.00
-146.00  70.10
-147.00  70.20
-148.00  70.20
-149.00  70.40
-150.00  70.40
-151.00  70.40
-152.00  70.50
-152.00  70.90
-153.50  70.80
-154.50  70.80
-155.00  71.10
-156.00  71.20
-157.00  71.10
-158.00  70.80
-158.50  70.80
-159.50  70.90
-160.50  70.50
-161.50  70.20
-162.50  70.00
-163.30  69.30
-164.00  69.00
-165.00  68.80
-166.00  68.90
-166.40  68.40
-166.40  68.20
-165.50  68.10
-164.50  67.80
-163.70  67.10
-163.00  67.00
-162.00  67.00
-161.80  66.80
-161.00  66.70
-160.30  66.60
-160.50  66.40
-161.50  66.50
-161.50  66.30
-162.00  66.00
-163.00  66.00
-163.50  66.10
-163.80  66.50
-164.50  66.50
-165.50  66.30
-165.80  66.10
-166.80  66.00
-167.50  65.70
-167.50  65.40
-166.50  65.30
-166.50  64.80
-166.00  64.50
-165.00  64.40
-164.00  64.50
-163.00  64.40
-162.40  64.40
-161.50  64.70
-161.00  64.50
-161.00  64.00
-161.00  63.60
-161.80  63.50
-162.50  63.40
-163.50  63.00
-164.30  63.20
-165.00  62.60
-165.50  62.30
-165.80  62.00
-166.20  61.80
-165.80  61.30
-165.30  61.00
-165.40  60.50
-164.50  60.10
-163.70  59.80
-162.80  59.90
-162.30  60.20
-161.70  59.50
-161.80  58.80
-161.70  58.70
-161.00  58.80
-160.30  59.00
-159.70  58.90
-159.00  58.30
-158.80  58.80
-158.30  58.50
-157.50  58.70
-157.50  58.50
-157.70  57.70
-158.50  57.20
-158.80  56.80
-159.00  56.80
-160.00  56.40
-160.80  55.90
-161.50  56.00
-162.50  55.50
-163.00  55.20
-164.00  55.00
-165.00  54.60
-164.60  54.40
-164.00  54.60
-163.30  54.70
-163.20  54.90
-162.20  55.10
-161.60  55.60
-161.50  55.40
-160.50  55.60
-159.70  55.80
-159.40  55.80
-158.50  56.00
-158.30  56.20
-158.40  56.40
-157.80  56.60
-157.00  56.90
-156.40  57.20
-156.40  57.30
-155.50  57.70
-154.50  58.20
-154.00  58.50
-153.30  58.80
-153.70  59.00
-154.00  59.30
-153.00  59.70
-152.30  60.40
-151.50  61.00
-150.70  61.30
-150.00  61.20
-150.10  60.90
-151.00  60.90
-151.30  60.50
-151.90  59.90
-151.30  59.70
-151.80  59.30
-151.00  59.30
-150.00  59.70
-149.30  60.00
-148.50  60.00
-148.00  60.40
-147.70  60.90
-147.30  60.90
-146.70  60.80
-146.50  60.70
-145.70  60.40
-144.90  60.40
-144.50  60.20
-143.50  60.10
-142.50  60.10
-141.50  60.00
-141.00  59.80
-140.00  60.00
-139.80  59.60
-139.00  59.30
-138.00  59.00
-137.00  58.40
-136.20  58.40
-135.90  58.30
-136.60  58.10
-136.10  57.60
-135.70  57.20
-135.00  56.50
-134.70  56.70
-134.50  57.10
-133.80  57.80
-133.70  57.80
-133.10  57.10
-134.00  57.00
-134.40  56.90
-134.10  56.10
-133.30  56.50
-133.60  56.40
-133.80  56.00
-133.40  55.70
-133.20  55.40
-133.10  55.00
-132.90  55.00
-132.60  55.20
-132.00  54.70
-132.00  55.30
-132.70  56.00
-132.90  56.40
-132.60  56.30
-132.00  56.10
-131.90  55.70
-131.80  55.30
-131.40  55.30
-131.00  55.00
 136.50  55.50
 137.00  55.80
 137.70  56.20
 138.20  56.40
 138.50  56.80
 139.00  57.00
 139.50  57.30
 140.20  57.70
 140.60  58.00
 141.50  58.50
 142.20  59.00
 143.00  59.30
 144.00  59.30
 145.00  59.30
 146.00  59.30
 146.30  59.10
 146.60  59.40
 147.50  59.20
 147.80  59.30
 148.50  59.30
 149.00  59.20
 148.80  59.30
 149.20  59.60
 150.00  59.70
 150.50  59.60
 151.00  59.40
 151.50  59.60
 151.80  59.30
 152.00  59.20
 151.20  59.20
 151.70  58.80
 152.30  59.00
 153.20  59.10
 153.60  59.20
 154.30  59.10
 154.80  59.20
 155.20  59.50
 154.50  59.60
 154.20  59.80
 155.00  60.30
 156.00  61.00
 156.80  61.30
 157.50  61.80
 158.50  61.80
 159.50  61.80
 160.00  61.80
 160.00  61.50
 159.90  61.20
 159.80  61.00
 160.10  60.60
 161.00  61.00
 162.00  61.40
 162.80  61.70
 163.20  61.60
 163.00  61.80
 163.20  62.30
 163.70  62.60
 164.70  62.60
 165.20  62.50
 164.30  62.40
 164.00  61.70
 163.70  61.40
 163.90  61.20
 163.50  61.00
 163.50  60.80
 162.50  60.60
 161.80  60.40
 161.40  60.00
 160.70  59.60
 160.30  59.40
 159.80  59.00
 159.00  58.50
 158.50  58.20
 157.70  58.00
 157.30  57.80
 157.00  57.50
 156.50  57.00
 156.80  56.40
 155.60  55.50
 155.70  54.50
 156.00  53.50
 156.40  52.50
 156.50  51.50
 157.00  51.20
 158.00  51.80
 158.40  52.20
 158.50  52.90
 159.50  53.30
 159.80  53.40
 160.00  54.20
 161.00  54.60
 161.20  54.50
 162.20  54.90
 161.70  55.60
 162.50  56.30
 163.30  56.30
 163.10  56.70
 162.80  57.10
 163.30  57.80
 162.50  58.00
 162.10  57.80
 162.40  58.70
 163.30  59.50
 163.70  60.00
 164.50  60.00
 165.10  59.90
 165.50  60.30
 166.30  60.40
 166.00  59.80
 166.50  60.00
 167.50  60.40
 168.50  60.60
 169.50  60.50
 170.40  59.90
 170.50  60.40
 171.50  60.70
 172.20  61.00
 173.00  61.40
 173.80  61.70
 174.50  61.90
 175.00  62.00
 176.00  62.30
 177.00  62.50
 178.00  62.50
 179.00  62.30
 179.50  62.60
 179.30  63.00
 179.00  63.30
 178.60  63.80
 178.30  64.30
 177.70  64.20
 177.50  64.70
 179.00  64.80
 180.00  65.00
 179.00  69.30
 177.00  69.60
 175.00  69.90
 173.00  69.90
 171.00  70.00
 170.30  69.80
 170.80  69.30
 169.60  68.90
 168.30  69.20
 169.20  69.60
 168.40  70.00
 167.10  69.60
 166.00  69.60
 164.00  69.80
 163.00  69.70
 161.50  69.50
 160.00  69.70
 160.10  70.30
 159.00  70.90
 157.00  71.00
 155.00  70.90
 153.00  70.80
 152.40  71.20
 151.00  71.40
 149.80  71.60
 150.20  71.80
 149.00  72.30
 147.00  72.30
 145.00  72.50
 143.00  72.60
 140.80  72.80
 140.30  72.50
 139.20  72.20
 140.20  71.50
 138.90  71.60
 137.00  71.40
 135.50  71.70
 133.40  71.60
 132.90  71.90
 131.00  71.20
 129.70  71.20
 128.60  71.90
 129.20  72.80
 128.00  73.40
 126.00  73.50
 124.00  73.80
 123.50  73.00
 122.00  73.00
 120.00  73.00
 118.40  73.20
 118.90  73.60
 117.00  73.70
 115.00  73.80
 113.70  73.60
 112.90  73.80
 111.50  73.90
 110.20  74.00
 110.30  73.70
 108.00  73.20
 107.50  73.60
 110.00  74.20
 112.00  74.80
 113.00  75.10
 113.60  75.90
 112.00  76.50
 109.00  76.70
 108.40  77.00
 105.80  77.00
 104.00  77.60
 102.00  77.20
 102.00  76.40
  99.00  76.40
  99.00  76.20
  97.00  76.00
  94.00  76.10
  92.70  75.90
  89.00  75.40
  87.00  74.80
  87.20  73.90
  85.00  73.90
  81.00  73.60
  80.60  73.00
  82.40  72.20
  81.80  71.80
  79.00  72.30
  77.50  72.20
  77.40  72.10
  76.30  71.90
  78.60  71.00
  75.30  71.30
  75.50  72.20
  75.00  72.80
  73.80  72.00
  73.10  71.40
  74.00  70.90
  73.70  70.00
  73.80  69.10
  75.00  68.90
  74.50  68.40
  74.00  67.50
  72.50  66.90
  72.50  67.50
  73.50  68.50
  72.60  69.50
  72.60  70.50
  72.00  71.30
  72.50  72.00
  72.90  72.80
  71.00  72.90
  69.30  73.00
  69.00  72.50
  68.00  71.50
  66.70  70.80
  67.30  70.50
  66.80  70.00
  68.00  69.40
  68.60  68.50
  68.00  68.30
  67.00  68.90
  65.00  69.30
  63.00  69.70
  61.00  69.90
  60.70  69.30
  60.00  68.70
  58.00  68.80
  56.00  68.70
  53.80  68.20
  53.80  69.00
  52.00  68.60
  50.00  68.10
  48.00  67.30
  46.30  66.90
  46.40  67.90
  45.00  68.60
  44.00  68.60
  44.30  68.30
  44.00  67.50
  44.60  66.90
  44.00  66.20
  42.20  66.50
  40.00  65.70
  40.00  65.00
  39.00  64.70
  37.00  65.10
  37.00  64.50
  37.70  63.80
  36.00  64.20
  35.00  64.80
  34.80  65.80
  33.40  66.70
  35.00  66.60
  37.00  66.30
  39.00  66.10
  41.00  66.60
  41.00  67.50
  39.00  68.30
  37.00  68.90
  35.00  69.20
  34.00  69.30
  32.20  69.60
  33.00  69.70
  31.50  69.80
  30.00  70.00
  30.00  70.70
  28.00  71.00
  27.00  71.00
  25.00  70.90
  23.00  70.40
  21.00  70.00
  19.00  69.70
  17.00  69.20
  17.20  68.80
  16.00  68.20
  15.00  67.50
  13.30  66.50
  12.40  65.50
  11.10  64.50
   9.80  63.50
   8.00  63.10
   6.00  62.40
   5.10  61.50
   5.20  60.50
   5.30  60.20
   5.60  60.00
   5.30  59.40
   5.60  59.00
   6.00  58.30
   7.50  58.00
   8.50  58.20
   9.70  59.00
  10.50  59.50
  11.30  58.50
  12.00  57.50
  12.80  56.60
  12.50  56.30
  13.00  55.50
  14.00  55.30
  14.20  55.80
  15.00  56.20
  16.20  56.50
  16.60  57.50
  16.80  58.50
  18.00  59.00
  18.40  59.50
  19.10  59.90
  18.00  60.50
  17.20  60.80
  17.20  61.50
  17.50  62.40
  18.40  63.00
  19.50  63.50
  20.50  63.80
  21.50  64.40
  21.40  65.00
  22.50  65.80
  24.50  65.70
  25.30  65.30
  24.70  64.90
  23.40  64.00
  22.60  63.70
  21.60  63.20
  21.20  62.50
  21.50  61.50
  21.50  60.70
  22.50  60.30
  23.40  59.90
  25.00  60.20
  27.00  60.50
  28.50  60.60
  29.00  60.20
  29.60  60.20
  29.20  60.00
  28.40  59.80
  28.00  59.80
  27.00  59.50
  25.00  59.50
  23.40  59.30
  23.70  58.30
  24.50  58.50
  24.50  57.50
  23.80  57.00
  23.00  57.40
  21.60  57.60
  21.20  57.00
  21.20  56.70
  21.30  55.00
  21.10  54.80
  20.90  54.90
  20.50  54.90
  20.00  54.90
  20.20  54.70
  20.20  54.60
  19.80  54.40
  19.50  54.20
  19.30  54.30
  18.80  54.30
  18.50  54.60
  18.20  54.80
  17.80  54.80
  17.30  54.70
  16.70  54.60
  16.40  54.40
  15.90  54.30
  15.30  54.20
  14.80  54.00
  14.20  53.90
  13.90  54.20
  13.50  54.20
  13.00  54.50
  12.50  54.50
  12.10  54.20
  11.60  54.00
  11.30  54.00
  10.90  54.00
  11.10  54.30
  10.90  54.40
  10.50  54.40
  10.30  54.40
   9.90  54.40
  10.00  54.80
   9.60  55.10
   9.80  55.50
  10.10  55.70
  10.30  56.00
  10.70  56.20
  10.90  56.50
  10.30  56.80
  10.50  57.80
   9.50  57.30
   8.40  57.00
   8.20  56.00
   8.40  55.40
   8.70  55.10
   8.90  54.60
   8.90  54.40
   8.70  54.30
   8.90  54.20
   9.00  53.90
   9.00  53.80
   8.50  53.70
   8.40  53.60
   8.20  53.50
   8.00  53.70
   7.60  53.70
   7.20  53.60
   6.80  53.50
   6.20  53.40
   5.70  53.30
   5.50  53.00
   5.70  52.80
   6.00  52.60
   5.70  52.40
   5.30  52.40
   5.00  52.60
   5.30  52.70
   5.00  52.90
   4.70  52.80
   4.40  52.30
   4.10  52.00
   4.40  51.70
   4.30  51.50
   3.80  51.40
   3.30  51.40
   2.80  51.20
   2.50  51.10
   2.10  51.00
   1.90  50.90
   1.60  50.60
   1.50  50.20
   1.00  49.90
   0.50  49.70
   0.    49.50
   0.50  49.50
   0.10  49.30
  -0.30  49.30
  -0.80  49.40
  -1.20  49.30
  -1.30  49.70
  -1.70  49.70
  -1.80  49.60
  -1.60  49.30
  -1.60  48.80
  -1.40  48.70
  -1.80  48.60
  -2.00  48.70
  -2.50  48.60
  -2.80  48.60
  -3.20  48.80
  -3.50  48.70
  -4.00  48.70
  -4.20  48.70
  -4.70  48.60
  -4.80  48.40
  -4.40  48.30
  -4.60  48.20
  -4.50  47.90
  -4.30  47.70
  -3.80  47.80
  -3.20  47.60
  -2.60  47.50
  -2.50  47.40
  -2.20  47.30
  -2.00  47.00
  -2.00  46.80
  -1.50  46.50
  -1.20  46.40
  -1.10  46.00
  -1.20  45.70
  -0.80  45.50
  -0.70  45.20
  -0.60  45.00
  -1.00  45.50
  -1.10  45.40
  -1.20  45.00
  -1.30  44.80
  -1.30  44.40
  -1.40  44.00
  -1.50  43.60
  -1.80  43.40
  -2.20  43.30
  -2.60  43.40
  -3.00  43.40
  -3.50  43.50
  -4.00  43.50
  -4.40  43.40
  -4.80  43.40
  -5.30  43.50
  -5.70  43.50
  -6.00  43.60
  -6.50  43.60
  -6.90  43.60
  -7.30  43.60
  -7.60  43.80
  -8.00  43.70
  -8.30  43.50
  -8.50  43.40
  -9.00  43.20
  -9.20  43.00
  -9.20  42.90
  -9.10  42.70
  -9.00  42.50
  -8.80  42.40
  -8.80  42.30
  -8.90  42.10
  -8.90  41.70
  -8.80  41.30
  -8.70  40.90
  -8.80  40.50
  -8.90  40.00
  -9.10  39.60
  -9.30  39.40
  -9.50  39.00
  -9.30  38.80
  -9.20  38.40
  -8.90  38.50
  -8.70  38.40
  -8.80  38.20
  -8.80  37.80
  -8.90  37.30
  -8.80  37.10
  -8.40  37.20
  -8.00  37.00
  -7.90  36.90
  -7.60  37.20
  -7.20  37.30
  -6.70  37.10
  -6.50  36.90
  -6.50  36.70
  -6.20  36.30
  -5.80  36.10
  -5.40  36.10
  -5.30  36.30
  -4.90  36.50
  -4.50  36.60
  -4.20  36.70
  -3.80  36.70
  -3.40  36.70
  -3.00  36.70
  -2.60  36.60
  -2.30  36.80
  -2.00  36.80
  -1.80  37.20
  -1.40  37.50
  -1.00  37.50
  -0.80  37.60
  -0.80  37.90
  -0.60  38.00
  -0.40  38.40
   0.    38.60
   0.    38.90
  -0.20  39.20
  -0.30  39.60
   0.    39.90
   0.30  40.30
   0.60  40.60
   0.70  40.80
   1.20  41.10
   1.60  41.30
   2.00  41.30
   2.20  41.40
   2.70  41.70
   3.20  41.90
   3.20  42.10
   3.20  42.30
   3.10  42.50
   3.10  42.90
   3.30  43.30
   3.70  43.40
   4.10  43.50
   4.50  43.50
   4.60  43.50
   4.80  43.40
   5.20  43.30
   5.30  43.20
   5.80  43.10
   6.30  43.20
   6.60  43.40
   7.20  43.70
   7.60  43.80
   8.00  43.90
   8.40  44.20
   8.70  44.50
   9.10  44.40
   9.50  44.20
  10.00  44.10
  10.20  43.80
  10.30  43.50
  10.50  43.20
  10.60  42.90
  11.00  42.70
  11.40  42.40
  11.80  42.20
  12.20  41.80
  12.70  41.50
  12.80  41.40
  13.10  41.20
  13.40  41.20
  13.80  41.10
  14.10  40.90
  14.20  40.90
  14.20  40.70
  14.60  40.70
  14.90  40.60
  14.90  40.20
  15.30  40.00
  15.60  40.10
  15.80  39.80
  16.00  39.50
  16.10  39.00
  16.20  38.80
  15.90  38.70
  15.90  38.50
  15.80  38.30
  15.70  38.00
  16.10  37.90
  16.20  38.20
  16.50  38.40
  16.50  38.80
  16.70  38.90
  17.00  38.90
  17.10  39.10
  17.10  39.40
  16.80  39.60
  16.50  39.80
  16.60  40.20
  16.90  40.50
  17.20  40.40
  17.60  40.30
  18.00  40.20
  18.10  39.90
  18.40  40.00
  18.40  40.30
  18.00  40.70
  17.60  40.80
  17.20  41.00
  16.80  41.20
  16.30  41.40
  15.90  41.60
  16.20  41.80
  16.00  41.90
  15.60  41.90
  15.30  41.90
  15.00  42.00
  14.80  42.20
  14.40  42.30
  14.00  42.70
  13.90  43.00
  13.60  43.50
  13.30  43.70
  13.00  43.90
  12.60  44.20
  12.20  44.50
  12.20  44.80
  12.50  45.00
  12.20  45.30
  12.40  45.50
  12.80  45.70
  13.20  45.80
  13.70  45.80
  13.60  45.60
  13.60  45.30
  13.80  45.00
  13.90  44.80
  14.10  45.00
  14.30  45.40
  14.70  45.20
  14.90  45.20
  14.90  44.80
  15.10  44.50
  15.10  44.30
  15.30  44.00
  15.70  43.80
  16.00  43.50
  16.40  43.50
  16.80  43.40
  17.20  43.20
  17.50  43.00
  17.40  43.00
  17.00  43.10
  17.40  42.90
  17.90  42.70
  18.30  42.50
  18.80  42.30
  19.00  42.20
  19.20  41.90
  19.50  41.80
  19.40  41.40
  19.40  41.00
  19.30  40.60
  19.40  40.30
  19.50  40.20
  19.90  40.00
  20.00  39.70
  20.10  39.60
  20.30  39.30
  20.60  39.00
  21.00  39.00
  21.00  38.90
  20.70  38.90
  20.60  38.60
  20.70  38.70
  20.90  38.60
  21.10  38.40
  21.40  38.40
  21.70  38.40
  22.20  38.40
  22.40  38.50
  22.80  38.30
  23.20  38.30
  22.90  38.10
  22.70  38.10
  22.20  38.20
  21.70  38.30
  21.30  38.20
  21.20  38.00
  21.30  37.70
  21.70  37.30
  21.60  37.10
  21.80  36.80
  21.90  37.00
  22.10  36.90
  22.40  36.50
  22.50  36.60
  22.80  36.80
  22.90  36.60
  23.20  36.40
  23.10  36.80
  22.90  37.20
  22.70  37.60
  23.10  37.50
  23.10  37.30
  23.40  37.40
  23.30  37.60
  23.00  37.80
  23.20  37.90
  23.50  38.10
  23.90  37.80
  24.10  37.80
  24.00  38.00
  24.00  38.30
  23.60  38.40
  23.30  38.50
  23.10  38.60
  22.80  38.70
  22.50  38.90
  23.00  39.00
  22.90  39.30
  23.20  39.20
  23.30  39.30
  23.00  39.60
  22.80  39.80
  22.50  40.20
  22.60  40.50
  23.00  40.70
  23.00  40.40
  23.30  40.10
  23.60  39.90
  23.60  40.00
  23.40  40.30
  23.70  40.10
  24.00  40.00
  23.70  40.40
  23.90  40.40
  24.30  40.20
  24.00  40.50
  23.90  40.60
  23.90  40.80
  24.20  40.80
  24.50  40.90
  24.90  40.90
  25.10  41.10
  25.30  40.90
  25.70  40.80
  26.00  40.80
  26.30  40.60
  26.70  40.70
  26.70  40.60
  26.20  40.30
  26.30  40.20
  26.70  40.40
  27.30  40.70
  27.40  40.90
  27.70  41.00
  28.00  40.90
  28.40  41.10
  28.60  40.90
  28.80  41.00
  29.20  40.90
  29.60  40.70
  29.70  40.60
  29.30  40.60
  28.80  40.50
  29.10  40.40
  28.80  40.30
  28.40  40.30
  28.00  40.30
  27.80  40.40
  27.80  40.30
  27.30  40.40
  26.80  40.30
  26.40  40.10
  26.20  39.80
  26.10  39.40
  26.50  39.50
  26.90  39.60
  26.60  39.30
  26.90  39.10
  26.80  38.90
  27.00  38.80
  26.90  38.50
  27.20  38.50
  26.70  38.40
  26.50  38.60
  26.30  38.30
  26.60  38.10
  26.90  38.10
  27.20  38.00
  27.00  37.70
  27.20  37.40
  27.20  37.10
  27.40  37.00
  27.80  37.00
  28.20  37.10
  28.00  36.80
  27.60  36.80
  27.60  36.60
  28.00  36.50
  28.40  36.80
  28.80  36.60
  29.00  36.60
  29.30  36.30
  29.80  36.20
  30.20  36.30
  30.50  36.30
  30.50  36.50
  30.50  36.90
  30.90  36.90
  31.30  36.80
  31.80  36.60
  32.20  36.40
  32.50  36.20
  32.80  36.10
  33.20  36.20
  33.70  36.30
  34.00  36.20
  34.30  36.60
  34.80  36.80
  35.30  36.60
  35.70  36.70
  36.00  36.90
  36.20  36.60
  35.80  36.30
  36.00  36.00
  35.70  35.60
  35.90  35.20
  35.80  34.80
  35.90  34.50
  35.60  34.30
  35.60  34.10
  35.40  33.70
  35.10  33.20
  35.00  32.80
  34.80  32.40
  34.70  32.00
  34.50  31.60
  34.30  31.30
  34.00  31.20
  33.60  31.10
  33.20  31.10
  32.80  31.10
  32.40  31.20
  32.00  31.00
  31.80  31.30
  31.80  31.40
  31.30  31.50
  30.80  31.50
  30.40  31.50
  30.10  31.40
  29.80  31.20
  29.50  31.00
  29.10  30.80
  28.70  31.00
  28.50  31.10
  28.10  31.10
  27.90  31.20
  27.50  31.20
  27.20  31.30
  26.80  31.40
  26.30  31.60
  25.80  31.70
  25.40  31.50
  25.20  31.70
  25.00  32.00
  24.60  32.00
  24.20  32.00
  23.80  32.20
  23.40  32.20
  23.10  32.40
  22.80  32.70
  22.40  32.90
  22.00  32.90
  21.60  32.90
  21.30  32.80
  20.80  32.70
  20.30  32.40
  20.00  32.10
  19.90  32.00
  19.90  31.60
  20.10  31.30
  20.10  30.90
  19.80  30.70
  19.40  30.50
  19.00  30.30
  18.60  30.40
  18.30  30.70
  18.00  30.80
  17.70  31.00
  17.40  31.10
  17.00  31.20
  16.60  31.20
  16.20  31.30
  15.80  31.40
  15.50  31.70
  15.40  32.00
  15.30  32.30
  15.00  32.40
  14.60  32.50
  14.20  32.70
  13.80  32.70
  13.40  32.90
  13.20  32.90
  12.70  32.80
  12.30  32.80
  12.00  33.00
  11.60  33.10
  11.40  33.20
  11.10  33.40
  11.00  33.60
  10.70  33.50
  10.50  33.70
  10.10  34.00
  10.20  34.30
  10.60  34.50
  10.90  34.80
  11.00  35.20
  11.00  35.40
  11.10  35.70
  10.60  35.80
  10.50  36.20
  10.70  36.50
  11.10  36.80
  11.00  37.10
  10.70  36.90
  10.60  36.80
  10.40  36.80
  10.20  37.00
  10.00  37.30
   9.50  37.30
   9.00  37.10
   8.70  37.00
   8.30  36.90
   8.00  36.80
   7.80  37.00
   7.50  37.10
   7.20  37.10
   6.90  36.90
   6.70  37.00
   6.30  37.10
   6.00  36.80
   5.50  36.70
   5.20  36.60
   4.80  36.90
   4.50  36.90
   4.00  36.90
   3.60  36.80
   3.30  36.80
   3.00  36.80
   2.70  36.70
   2.50  36.60
   2.00  36.60
   1.50  36.50
   1.00  36.50
   0.50  36.30
   0.10  36.00
  -0.10  35.80
  -0.30  35.90
  -0.60  35.70
  -1.00  35.70
  -1.30  35.40
  -1.70  35.20
  -2.20  35.10
  -2.60  35.10
  -3.00  35.50
  -3.50  35.30
  -4.00  35.30
  -4.40  35.40
  -4.80  35.30
  -5.20  35.50
  -5.40  35.90
  -5.80  35.80
  -6.00  35.60
  -6.20  35.30
  -6.30  35.20
  -6.40  34.70
  -6.60  34.40
  -6.80  34.20
  -7.00  33.90
  -7.40  33.70
  -7.90  33.50
  -8.30  33.30
  -8.60  33.10
  -8.90  32.90
  -9.20  32.70
  -9.30  32.30
  -9.40  32.00
  -9.70  31.70
  -9.80  31.30
  -9.80  30.80
  -9.70  30.50
  -9.60  30.20
  -9.80  29.80
 -10.20  29.40
 -10.50  29.00
 -11.00  28.80
 -11.30  28.50
 -11.80  28.20
 -12.10  28.10
 -12.70  28.00
 -13.10  27.80
 -13.30  27.50
 -13.50  27.00
 -13.80  26.50
 -14.20  26.30
 -14.50  26.00
 -14.70  25.70
 -14.80  25.30
 -14.90  24.70
 -15.20  24.50
 -15.50  24.30
 -15.80  24.00
 -16.10  23.70
 -15.80  23.90
 -15.90  23.70
 -16.10  23.40
 -16.20  23.00
 -16.30  22.70
 -16.50  22.40
 -16.80  22.20
 -17.00  21.80
 -17.00  21.40
 -17.10  21.20
 -17.10  20.80
 -16.90  21.10
 -16.70  20.80
 -16.50  20.70
 -16.30  20.30
 -16.20  20.00
 -16.30  19.60
 -16.50  19.30
 -16.20  19.00
 -16.20  18.60
 -16.10  18.30
 -16.10  17.80
 -16.20  17.40
 -16.40  16.80
 -16.50  16.30
 -16.50  15.80
 -16.80  15.40
 -17.10  15.00
 -17.50  14.70
 -17.00  14.40
 -16.80  14.10
 -16.70  13.70
 -16.50  13.30
 -16.30  13.30
 -16.50  13.20
 -16.80  13.40
 -16.70  13.00
 -16.80  12.60
 -16.60  12.30
 -16.40  12.30
 -16.40  12.00
 -16.00  11.90
 -15.60  11.90
 -15.30  11.90
 -15.20  11.80
 -15.50  11.80
 -15.30  11.40
 -15.20  11.00
 -15.10  11.00
 -14.90  10.90
 -14.80  10.90
 -14.60  10.50
 -14.30  10.20
 -14.00  10.00
 -13.80   9.80
 -13.70   9.70
 -13.70   9.50
 -13.50   9.40
 -13.30   9.20
 -13.20   8.90
 -13.30   8.60
 -13.00   8.50
 -13.10   8.40
 -13.30   8.40
 -13.00   8.20
 -12.90   7.90
 -12.50   7.70
 -12.30   7.40
 -11.80   7.10
 -11.50   6.90
 -11.10   6.60
 -10.80   6.40
 -10.50   6.20
 -10.20   6.00
 -10.00   5.80
  -9.60   5.50
  -9.30   5.10
  -8.80   4.90
  -8.40   4.60
  -8.00   4.50
  -7.60   4.30
  -7.40   4.40
  -7.00   4.60
  -6.60   4.80
  -6.20   4.90
  -5.80   5.00
  -5.40   5.10
  -5.00   5.20
  -4.50   5.20
  -4.00   5.30
  -3.70   5.20
  -3.40   5.20
  -2.70   5.00
  -2.30   4.90
  -1.90   4.80
  -1.60   5.00
  -1.30   5.10
  -1.00   5.20
  -0.60   5.30
  -0.40   5.50
   0.     5.70
   0.40   5.80
   0.90   5.80
   1.10   6.00
   1.40   6.20
   1.60   6.30
   2.20   6.40
   3.00   6.40
   3.50   6.40
   4.00   6.40
   4.50   6.30
   4.80   6.10
   5.00   5.80
   5.20   5.50
   5.40   5.20
   5.50   4.90
   5.70   4.50
   6.00   4.30
   6.50   4.30
   7.00   4.40
   7.30   4.40
   7.70   4.50
   8.10   4.50
   8.30   4.60
   8.20   4.90
   8.40   4.80
   8.60   4.80
   8.90   4.30
   9.00   4.10
   9.10   4.00
   9.30   4.00
   9.70   4.00
   9.60   3.60
   9.90   3.30
   9.90   2.80
   9.80   2.30
   9.80   1.90
   9.60   1.70
   9.50   1.40
   9.40   1.20
   9.60   1.00
   9.60   0.70
   9.50   0.70
   9.30   0.60
   9.50   0.30
   9.90   0.20
   9.50   0.20
   9.40   0.40
   9.30   0.20
   9.30  -0.20
   9.20  -0.60
   9.00  -0.70
   8.70  -0.70
   8.80  -0.80
   9.00  -1.30
   9.20  -1.70
   9.50  -2.20
   9.80  -2.60
  10.20  -2.90
  10.40  -3.20
  10.70  -3.50
  11.00  -3.80
  11.20  -4.00
  11.50  -4.40
  11.80  -4.70
  12.00  -5.00
  12.20  -5.40
  12.30  -5.80
  12.60  -6.00
  12.90  -5.90
  12.90  -6.00
  12.60  -6.10
  12.30  -6.20
  12.50  -6.50
  12.80  -6.90
  12.90  -7.20
  13.00  -7.70
  13.10  -7.90
  13.30  -8.20
  13.50  -8.70
  13.10  -9.00
  13.10  -9.20
  13.30  -9.60
  13.40 -10.10
  13.60 -10.50
  13.70 -10.80
  13.90 -11.00
  13.80 -11.40
  13.80 -11.80
  13.60 -12.30
  13.40 -12.70
  13.00 -12.80
  13.00 -13.00
  12.70 -13.30
  12.60 -13.60
  12.40 -14.00
  12.30 -14.40
  12.20 -14.90
  12.10 -15.30
  11.90 -15.80
  11.80 -15.90
  11.90 -16.00
  11.90 -16.50
  11.80 -17.00
  11.80 -17.40
  11.80 -17.80
  11.80 -18.20
  12.00 -18.50
  12.40 -18.80
  12.70 -19.20
  12.90 -19.60
  13.10 -20.10
  13.30 -20.50
  13.50 -21.00
  13.80 -21.50
  14.00 -21.90
  14.30 -22.20
  14.50 -22.70
  14.40 -23.00
  14.50 -23.30
  14.50 -23.60
  14.50 -24.00
  14.60 -24.30
  14.70 -24.70
  14.90 -25.10
  14.80 -25.30
  14.80 -25.70
  15.00 -26.00
  15.00 -26.30
  15.20 -26.60
  15.10 -26.80
  15.20 -27.20
  15.50 -27.60
  15.70 -28.00
  16.00 -28.30
  16.40 -28.60
  16.70 -28.90
  16.90 -29.20
  17.10 -29.70
  17.30 -30.20
  17.50 -30.70
  17.70 -31.10
  18.00 -31.50
  18.20 -31.80
  18.30 -32.20
  18.30 -32.70
  18.00 -32.80
  17.90 -33.10
  18.20 -33.30
  18.30 -33.50
  18.50 -33.80
  18.40 -33.90
  18.40 -34.40
  18.60 -34.20
  18.90 -34.20
  19.10 -34.40
  19.40 -34.50
  19.60 -34.70
  20.00 -34.80
  20.20 -34.70
  20.60 -34.50
  20.90 -34.40
  21.30 -34.50
  21.70 -34.40
  22.00 -34.30
  22.20 -34.10
  22.60 -34.00
  23.00 -34.10
  23.40 -34.20
  23.70 -34.00
  24.20 -34.10
  24.70 -34.30
  25.00 -34.00
  25.20 -34.00
  25.60 -34.10
  25.70 -34.00
  25.90 -33.70
  26.20 -33.70
  26.60 -33.80
  27.00 -33.60
  27.40 -33.40
  28.00 -33.00
  28.40 -32.70
  29.00 -32.20
  29.40 -31.70
  30.00 -31.30
  30.30 -31.00
  30.60 -30.70
  31.00 -30.00
  31.20 -29.80
  31.50 -29.40
  31.80 -29.00
  32.10 -28.80
  32.50 -28.50
  32.60 -28.00
  32.70 -27.50
  32.90 -27.00
  32.90 -26.80
  32.90 -26.40
  33.00 -26.10
  32.80 -26.30
  32.60 -26.00
  32.70 -25.70
  33.00 -25.50
  33.40 -25.30
  34.10 -25.00
  34.60 -24.80
  35.10 -24.60
  35.40 -24.40
  35.50 -24.00
  35.40 -23.90
  35.30 -23.80
  35.40 -23.40
  35.60 -23.00
  35.50 -22.60
  35.50 -22.20
  35.30 -22.20
  35.30 -21.80
  35.20 -21.30
  35.10 -20.90
  34.90 -20.70
  34.90 -20.60
  34.70 -20.30
  34.80 -20.00
  35.00 -19.80
  35.50 -19.40
  35.80 -19.10
  36.10 -18.90
  36.30 -18.70
  36.60 -18.40
  36.90 -18.10
  37.20 -17.80
  37.70 -17.50
  38.00 -17.30
  38.60 -17.10
  39.10 -17.00
  39.50 -16.70
  39.80 -16.50
  39.80 -16.20
  40.10 -16.10
  40.30 -15.80
  40.60 -15.40
  40.60 -15.20
  40.70 -15.00
  40.80 -14.60
  40.80 -14.40
  40.70 -14.50
  40.70 -14.00
  40.60 -13.60
  40.60 -13.20
  40.50 -13.00
  40.60 -12.90
  40.50 -12.50
  40.50 -12.00
  40.50 -11.60
  40.40 -11.30
  40.60 -11.00
  40.70 -10.60
  40.30 -10.30
  39.90 -10.00
  39.80  -9.90
  39.60  -9.70
  39.60  -9.10
  39.50  -9.00
  39.40  -8.70
  39.30  -8.30
  39.40  -8.10
  39.10  -8.10
  39.20  -8.00
  39.40  -8.00
  39.40  -7.70
  39.40  -7.50
  39.60  -7.20
  39.60  -6.90
  39.30  -6.70
  38.90  -6.40
  38.80  -6.20
  38.80  -5.80
  39.00  -5.50
  39.20  -5.20
  39.30  -4.80
  39.40  -4.60
  39.60  -4.30
  39.80  -4.00
  39.90  -3.70
  40.00  -3.30
  40.20  -3.20
  40.20  -2.80
  40.40  -2.60
  40.60  -2.60
  40.80  -2.40
  41.00  -2.30
  40.90  -2.10
  41.00  -2.10
  41.40  -1.90
  41.60  -1.70
  41.80  -1.20
  42.00  -1.00
  42.20  -0.80
  42.50  -0.50
  42.80  -0.10
  43.10   0.20
  43.50   0.50
  43.90   1.00
  44.30   1.20
  44.50   1.50
  44.80   1.70
  45.10   1.90
  45.50   2.20
  46.00   2.40
  46.30   2.60
  46.60   3.00
  46.90   3.30
  47.20   3.50
  47.40   3.90
  47.70   4.20
  48.00   4.50
  48.10   4.70
  48.30   5.00
  48.50   5.30
  48.80   5.70
  49.10   6.20
  49.20   6.50
  49.40   7.00
  49.60   7.40
  49.80   7.90
  50.00   8.10
  50.20   8.30
  50.30   8.60
  50.50   9.00
  50.80   9.30
  50.80   9.70
  50.90  10.20
  51.10  10.40
  51.40  10.50
  51.20  10.60
  51.20  11.00
  51.20  11.30
  51.30  11.60
  51.20  11.80
  50.90  11.90
  50.80  12.00
  50.60  11.80
  50.40  11.60
  49.80  11.50
  49.50  11.30
  49.00  11.20
  48.50  11.30
  48.30  11.20
  47.90  11.20
  47.50  11.20
  47.10  11.00
  46.80  10.80
  46.50  10.60
  46.30  10.70
  45.90  10.80
  45.60  10.70
  45.30  10.60
  45.00  10.40
  44.60  10.40
  44.40  10.30
  44.00  10.70
  43.70  11.00
  43.50  11.40
  43.20  11.60
  43.00  11.60
  42.60  11.50
  42.70  11.60
  43.00  11.80
  43.40  12.00
  43.30  12.40
  43.10  12.80
  43.00  12.80
  42.70  12.80
  42.60  13.20
  42.40  13.40
  42.20  13.70
  41.80  13.90
  41.50  14.20
  41.30  14.60
  41.00  14.70
  40.80  14.80
  40.50  15.00
  40.20  15.00
  40.10  15.30
  39.90  15.50
  39.80  15.10
  39.60  15.50
  39.40  15.70
  39.40  15.80
  39.30  16.00
  39.20  16.60
  39.10  17.00
  38.90  17.40
  38.70  17.80
  38.50  18.10
  38.20  18.30
  38.00  18.50
  37.70  18.70
  37.40  19.00
  37.30  19.40
  37.30  19.80
  37.20  20.00
  37.20  20.40
  37.10  20.80
  37.20  21.20
  37.30  21.10
  37.00  21.40
  36.80  21.80
  36.70  22.20
  36.30  22.50
  36.00  22.70
  35.80  22.80
  35.70  23.00
  35.50  23.50
  35.50  23.90
  35.60  24.00
  35.40  24.30
  35.20  24.60
  34.90  25.00
  34.70  25.50
  34.40  25.90
  34.20  26.30
  34.00  26.60
  34.00  26.80
  33.80  27.20
  33.60  27.50
  33.50  27.80
  33.30  28.00
  33.00  28.40
  32.80  28.70
  32.70  29.00
  32.60  29.30
  32.40  29.70
  32.90  29.90
  32.70  29.80
  32.80  29.30
  33.00  29.10
  33.20  28.90
  33.20  28.50
  33.60  28.10
  33.90  27.90
  34.20  27.70
  34.40  28.00
  34.30  28.30
  34.60  28.70
  34.70  29.00
  34.80  29.40
  35.00  29.40
  34.80  28.70
  34.70  28.30
  34.70  28.10
  35.00  28.10
  35.30  27.80
  35.80  27.30
  36.00  26.90
  36.20  26.50
  36.50  26.10
  36.60  25.90
  36.80  25.80
  37.00  25.50
  37.10  25.30
  37.20  25.00
  37.10  24.80
  37.30  24.50
  37.80  24.30
  38.10  24.00
  38.50  23.70
  38.80  23.20
  38.80  22.90
  39.10  22.50
  39.00  22.20
  39.00  21.80
  39.10  21.50
  39.10  21.30
  39.30  21.00
  39.60  20.50
  39.90  20.30
  40.30  20.20
  40.40  20.00
  40.60  19.80
  40.70  19.60
  40.90  19.30
  41.20  19.00
  41.20  18.70
  41.30  18.60
  41.50  18.30
  41.70  17.90
  42.10  17.60
  42.20  17.20
  42.50  17.00
  42.70  16.70
  42.80  16.30
  42.80  15.90
  42.70  15.50
  42.60  15.40
  42.70  15.20
  42.80  15.00
  42.90  14.70
  43.10  14.20
  43.20  13.90
  43.30  13.50
  43.30  13.20
  43.40  12.90
  43.70  12.70
  44.20  12.70
  44.60  12.80
  45.10  12.80
  45.40  13.00
  45.50  13.20
  45.90  13.30
  46.50  13.40
  46.90  13.50
  47.50  13.70
  47.80  13.80
  48.10  14.00
  48.30  14.00
  48.80  14.10
  49.00  14.50
  49.70  14.80
  50.30  15.00
  50.80  15.10
  51.30  15.30
  51.90  15.50
  52.30  15.70
  52.20  16.00
  52.50  16.50
  53.00  16.70
  53.50  16.80
  53.80  16.90
  54.10  17.00
  54.50  17.00
  54.70  16.90
  55.00  17.00
  55.20  17.20
  55.30  17.40
  55.30  17.80
  55.80  17.90
  56.20  17.90
  56.50  18.00
  56.60  18.40
  56.80  18.70
  57.30  18.90
  57.70  18.90
  57.80  19.20
  57.70  19.50
  57.80  20.00
  58.00  20.30
  58.30  20.60
  58.50  20.40
  58.70  20.70
  59.00  21.20
  59.40  21.60
  59.60  21.90
  59.80  22.20
  59.80  22.50
  59.30  22.70
  59.20  22.90
  59.00  23.10
  58.80  23.50
  58.40  23.50
  57.80  23.60
  57.10  24.00
  56.80  24.20
  56.40  24.80
  56.30  25.20
  56.30  25.50
  56.20  25.70
  56.40  26.00
  56.50  26.20
  56.30  26.20
  56.10  26.00
  55.80  25.70
  55.30  25.30
  54.80  24.90
  54.60  24.50
  54.30  24.30
  53.90  24.10
  53.60  24.00
  53.30  24.20
  52.80  24.20
  52.60  24.20
  52.20  24.00
  51.90  24.00
  51.80  24.20
  51.50  24.20
  51.40  24.40
  51.40  24.60
  51.60  25.00
  51.50  25.50
  51.60  25.90
  51.40  26.10
  51.20  26.10
  50.90  25.70
  50.80  25.50
  50.80  25.00
  50.90  24.70
  50.70  24.90
  50.60  25.20
  50.30  25.60
  50.10  26.00
  50.00  26.20
  50.20  26.20
  50.00  26.60
  49.80  26.90
  49.60  27.20
  49.20  27.30
  49.20  27.40
  49.00  27.60
  48.80  27.80
  48.70  28.10
  48.30  28.50
  48.20  28.90
  48.10  29.20
  47.90  29.30
  47.90  29.50
  48.00  29.80
  48.20  29.90
  48.60  29.90
  48.90  30.00
  48.80  30.30
  49.20  30.10
  49.50  30.00
  49.80  30.20
  50.20  30.00
  50.30  29.80
  50.60  29.50
  50.60  29.20
  50.80  29.10
  50.80  28.90
  51.00  28.80
  51.20  28.30
  51.40  28.00
  51.70  27.80
  52.20  27.70
  52.70  27.40
  52.80  27.20
  53.30  27.00
  53.50  26.80
  54.00  26.70
  54.40  26.60
  54.60  26.50
  55.00  26.60
  55.50  26.70
  55.70  26.90
  56.20  27.20
  56.60  27.20
  56.90  26.90
  57.10  26.60
  57.20  26.20
  57.30  25.80
  57.70  25.70
  58.10  25.60
  58.50  25.60
  59.00  25.40
  59.40  25.50
  59.80  25.40
  60.20  25.40
  60.40  25.40
  60.60  25.30
  61.00  25.20
  61.40  25.10
  61.60  25.30
  61.70  25.10
  62.00  25.20
  62.30  25.30
  62.70  25.30
  63.20  25.30
  63.50  25.40
  64.00  25.40
  64.10  25.50
  64.20  25.40
  64.40  25.30
  64.60  25.20
  64.70  25.30
  65.20  25.30
  65.70  25.40
  65.90  25.40
  66.40  25.40
  66.80  25.20
  66.70  24.80
  67.20  24.80
  67.40  24.60
  67.50  24.80
  67.50  24.40
  67.40  24.20
  67.50  23.90
  67.90  23.80
  68.20  23.70
  68.50  23.70
  68.50  23.30
  68.90  23.00
  69.20  22.80
  69.50  22.70
  69.80  22.80
  70.10  22.90
  70.30  22.80
  70.00  22.60
  69.80  22.40
  69.20  22.30
  69.00  22.40
  68.90  22.30
  69.20  22.00
  69.50  21.70
  69.80  21.50
  70.00  21.20
  70.40  20.90
  70.80  20.70
  71.20  20.80
  71.60  21.00
  71.90  21.10
  72.10  21.20
  72.20  21.40
  72.20  21.80
  72.30  22.10
  72.40  22.30
  72.80  22.30
  72.50  22.20
  72.50  21.90
  72.50  21.70
  72.90  21.70
  72.60  21.50
  72.60  21.20
  72.70  21.10
  72.80  20.80
  72.90  20.60
  72.70  20.30
  72.70  19.90
  72.70  19.60
  72.80  19.10
  72.90  19.10
  72.90  18.90
  72.80  18.60
  72.90  18.20
  73.10  17.80
  73.20  17.40
  73.30  17.00
  73.30  16.60
  73.40  16.20
  73.50  15.90
  73.70  15.80
  73.90  15.40
  73.90  15.10
  74.10  14.90
  74.30  14.70
  74.40  14.30
  74.60  13.90
  74.70  13.50
  74.80  13.00
  74.80  12.90
  75.00  12.40
  75.20  12.20
  75.30  11.90
  75.50  11.60
  75.70  11.30
  75.80  10.80
  76.00  10.50
  76.30  10.00
  76.30   9.70
  76.40   9.30
  76.70   8.80
  76.90   8.40
  77.30   8.20
  77.70   8.20
  78.10   8.50
  78.20   8.90
  78.50   9.20
  78.90   9.30
  79.30   9.30
  79.30   9.30
  78.80   9.50
  79.00   9.70
  79.30  10.10
  79.20  10.20
  79.50  10.30
  79.80  10.40
  79.80  10.80
  79.80  11.20
  79.70  11.40
  79.80  11.80
  79.90  12.10
  80.10  12.40
  80.20  12.80
  80.20  13.10
  80.30  13.50
  80.20  13.90
  80.20  14.30
  80.10  14.70
  80.10  15.20
  80.20  15.50
  80.50  15.80
  80.80  15.90
  81.00  15.80
  81.20  16.00
  81.30  16.30
  81.80  16.30
  82.20  16.50
  82.30  16.60
  82.30  16.90
  82.50  17.20
  83.00  17.50
  83.40  17.80
  83.80  18.20
  84.20  18.50
  84.60  18.90
  84.80  19.20
  85.30  19.50
  85.90  19.80
  86.40  20.00
  86.60  20.20
  86.70  20.40
  86.90  20.60
  86.90  20.80
  86.80  21.20
  87.10  21.50
  87.60  21.70
  88.00  22.00
  88.00  22.20
  88.00  22.30
  88.20  22.00
  88.30  21.70
  88.30  21.60
  88.70  21.60
  89.10  21.60
  89.50  21.70
  89.80  22.00
  89.90  22.00
  90.20  21.70
  90.30  22.00
  90.30  22.50
  90.50  22.90
  90.70  22.80
  91.20  22.80
  91.50  22.70
  91.70  22.30
  91.90  22.00
  91.80  21.70
  92.00  21.50
  92.00  21.30
  92.20  21.00
  92.50  20.60
  92.70  20.40
  92.80  20.20
  92.90  20.10
  93.20  19.80
  93.10  20.00
  93.40  20.00
  93.70  19.90
  93.90  19.50
  94.00  19.20
  94.00  18.90
  94.30  18.60
  94.50  18.00
  94.60  17.60
  94.40  17.20
  94.40  16.80
  94.20  16.40
  94.20  15.90
  94.50  16.20
  94.70  16.50
  94.70  16.10
  94.70  15.80
  95.10  15.70
  95.50  15.80
  95.70  16.00
  95.90  16.20
  96.20  16.30
  96.50  16.50
  96.80  16.80
  96.90  17.00
  96.90  17.30
  97.10  17.10
  97.20  17.00
  97.30  16.70
  97.60  16.50
  97.50  16.00
  97.70  15.80
  97.70  15.40
  97.80  15.00
  97.90  14.90
  97.90  14.70
  97.90  14.40
  98.10  14.20
  98.10  13.80
  98.20  13.80
  98.30  13.90
  98.40  13.50
  98.50  13.00
  98.60  12.60
  98.50  12.20
  98.60  11.90
  98.80  11.90
  98.70  11.50
  98.70  11.30
  98.60  10.80
  98.50  10.50
  98.50  10.00
  98.70  10.40
  98.60  10.00
  98.50   9.70
  98.30   9.30
  98.30   8.90
  98.20   8.80
  98.20   8.40
  98.30   8.20
  98.50   8.40
  98.70   8.30
  98.90   8.00
  99.10   7.90
  99.00   7.70
  99.20   7.70
  99.30   7.40
  99.50   7.30
  99.70   7.20
  99.70   6.80
 100.00   6.60
 100.20   6.30
 100.30   6.10
 100.40   5.80
 100.30   5.40
 100.30   5.00
 100.60   4.80
 100.60   4.40
 100.60   4.20
 100.70   4.00
 100.90   3.80
 101.10   3.50
 101.30   3.10
 101.30   2.90
 101.60   2.60
 102.00   2.40
 102.30   2.10
 102.70   1.80
 103.00   1.70
 103.40   1.50
 103.70   1.30
 104.00   1.40
 104.10   1.50
 104.30   1.30
 104.20   1.80
 104.00   2.20
 103.90   2.30
 103.80   2.60
 103.50   2.80
 103.40   3.20
 103.50   3.50
 103.40   3.90
 103.50   4.30
 103.40   4.80
 103.30   5.20
 103.00   5.50
 102.70   5.70
 102.50   5.80
 102.30   6.20
 101.80   6.40
 101.60   6.80
 101.20   6.80
 100.90   6.90
 100.70   7.00
 100.50   7.40
 100.40   7.80
 100.30   8.20
 100.20   8.50
 100.00   8.50
  99.90   9.00
  99.90   9.20
  99.70   9.30
  99.30   9.20
  99.30   9.40
  99.10   9.60
  99.20  10.00
  99.30  10.40
  99.40  10.80
  99.60  11.20
  99.70  11.60
  99.80  11.90
 100.00  12.20
  99.90  12.70
 100.10  13.00
  99.90  13.30
 100.30  13.50
 100.60  13.60
 101.00  13.50
 100.90  13.30
 100.90  12.80
 101.00  12.60
 101.50  12.60
 102.00  12.50
 102.30  12.30
 102.30  12.20
 102.60  12.10
 102.70  12.00
 102.80  11.80
 103.00  11.50
 103.10  11.20
 103.10  10.80
 103.40  10.80
 103.50  11.20
 103.70  10.80
 103.50  10.70
 103.60  10.50
 103.80  10.70
 104.30  10.60
 104.50  10.40
 104.70  10.30
 105.00  10.10
 105.10   9.90
 104.80   9.80
 104.80   9.40
 104.80   9.00
 104.90   8.80
 104.70   8.60
 105.10   8.70
 105.30   8.80
 105.70   9.20
 106.00   9.30
 106.20   9.40
 106.00   9.70
 106.00   9.90
 106.40   9.50
 106.40   9.80
 106.50   9.90
 106.80  10.00
 106.80  10.30
 107.10  10.40
 107.80  10.60
 108.10  10.90
 108.40  11.10
 108.70  11.20
 109.00  11.30
 109.10  11.50
 109.30  11.90
 109.30  12.30
 109.20  12.60
 109.50  12.90
 109.30  13.10
 109.30  13.50
 109.30  13.70
 109.20  14.20
 109.10  14.60
 108.90  15.00
 108.90  15.30
 108.60  15.50
 108.30  16.00
 108.20  16.20
 107.90  16.30
 107.40  16.70
 107.20  17.10
 106.70  17.40
 106.50  17.70
 106.60  17.90
 106.40  18.10
 106.10  18.30
 105.70  18.70
 105.60  19.00
 105.80  19.30
 105.90  19.70
 106.20  20.60
 106.50  20.20
 106.60  20.60
 106.60  20.90
 106.60  21.00
 107.00  20.90
 107.20  21.00
 107.20  20.90
 107.30  21.30
 107.60  21.40
 108.00  21.50
 108.30  21.70
 108.50  21.60
 108.50  21.80
 108.70  21.80
 109.00  21.60
 109.20  21.40
 109.50  21.50
 109.60  21.60
 109.90  21.50
 109.80  21.30
 109.70  21.00
 109.80  20.60
 110.00  20.40
 109.90  20.30
 110.20  20.30
 110.50  20.50
 110.30  20.70
 110.20  20.80
 110.30  21.10
 110.80  21.40
 111.20  21.50
 111.80  21.60
 112.10  21.80
 112.20  21.70
 112.50  21.70
 112.90  21.80
 113.00  22.20
 113.20  22.10
 113.30  22.30
 113.50  22.50
 113.50  22.90
 113.60  22.90
 113.90  22.50
 114.00  22.40
 114.20  22.30
 114.20  22.50
 114.50  22.40
 114.60  22.70
 114.80  22.60
 115.00  22.80
 115.40  22.80
 115.40  22.70
 115.60  22.80
 115.80  22.80
 116.30  23.00
 116.50  23.00
 116.70  23.30
 116.90  23.60
 117.10  23.50
 117.50  23.80
 117.80  24.00
 118.10  24.30
 117.90  24.40
 118.00  24.50
 118.20  24.60
 118.60  24.50
 118.70  24.70
 118.90  24.80
 118.90  25.20
 119.20  25.20
 119.20  25.40
 119.50  25.40
 119.50  25.60
 119.60  25.80
 119.50  26.10
 119.60  26.30
 119.70  26.40
 119.60  26.60
 119.90  26.70
 120.20  26.90
 120.30  27.10
 120.60  27.40
 120.70  27.80
 120.70  28.00
 121.00  28.10
 121.20  28.40
 121.40  28.20
 121.60  28.30
 121.50  28.60
 121.70  28.80
 121.80  28.90
 121.70  29.10
 121.60  29.20
 121.90  29.20
 121.90  29.40
 121.90  29.50
 121.80  29.60
 121.50  29.40
 121.70  29.60
 121.80  29.70
 122.00  29.80
 121.90  29.90
 121.50  30.20
 121.00  30.20
 120.60  30.30
 120.30  30.20
 120.20  30.30
 120.60  30.40
 120.90  30.50
 121.30  30.70
 121.70  30.80
 121.90  31.00
 121.70  31.30
 121.30  31.50
 120.90  31.70
 120.80  31.90
 120.30  31.90
 120.50  32.20
 120.90  32.00
 121.20  31.80
 121.60  31.70
 121.80  32.00
 121.50  32.30
 121.40  32.40
 121.00  32.60
 120.90  32.80
 120.80  33.00
 120.60  33.50
 120.50  33.80
 120.40  34.20
 120.00  34.40
 119.70  34.60
 119.30  34.80
 119.40  35.10
 119.60  35.50
 119.90  35.70
 120.10  35.90
 120.10  36.10
 120.30  36.20
 120.60  36.20
 120.90  36.50
 121.20  36.70
 121.80  36.90
 122.10  36.90
 122.50  37.00
 122.60  37.20
 122.40  37.40
 122.20  37.50
 121.90  37.50
 121.50  37.40
 121.10  37.60
 121.00  37.70
 120.70  37.80
 120.30  37.60
 119.90  37.40
 119.80  37.20
 119.50  37.10
 119.10  37.20
 118.90  37.40
 119.00  37.70
 118.70  38.00
 118.50  38.10
 118.10  38.10
 117.80  38.20
 117.60  38.60
 117.70  39.00
 118.00  39.30
 118.20  39.10
 118.50  39.30
 118.90  39.30
 119.30  39.50
 119.30  39.70
 119.50  39.90
 119.90  40.00
 120.30  40.20
 120.50  40.30
 120.90  40.70
 121.20  40.90
 121.50  40.90
 121.80  41.00
 122.00  40.70
 122.20  40.50
 122.20  40.30
 121.80  40.00
 121.50  39.90
 121.50  39.60
 121.50  39.40
 121.90  39.40
 121.70  39.10
 121.30  38.90
 121.10  38.70
 121.50  38.80
 121.90  39.00
 122.10  39.20
 122.40  39.40
 122.60  39.50
 123.00  39.70
 123.20  39.80
 123.60  39.80
 124.00  39.80
 124.40  39.80
 124.60  39.70
 125.00  39.70
 125.30  39.50
 125.40  39.40
 125.40  39.20
 125.10  38.80
 125.00  38.60
 124.90  38.40
 125.00  38.20
 124.70  38.20
 125.00  38.10
 125.10  38.00
 125.20  37.90
 125.60  37.70
 125.60  38.00
 125.90  37.90
 126.10  37.70
 126.40  37.80
 126.40  37.70
 126.70  37.50
 126.90  37.00
 126.50  37.00
 126.20  36.80
 126.30  36.60
 126.50  36.30
 126.70  36.00
 126.80  35.90
 126.50  35.60
 126.50  35.40
 126.30  35.20
 126.30  34.90
 126.40  34.60
 126.60  34.40
 126.70  34.50
 127.20  34.70
 127.30  34.60
 127.30  34.40
 127.40  34.70
 127.60  34.70
 127.60  34.90
 128.10  35.10
 128.20  34.80
 128.30  34.90
 128.40  35.00
 128.80  35.10
 129.10  35.10
 129.30  35.30
 129.40  35.70
 129.50  35.90
 129.40  36.00
 129.40  36.30
 129.40  36.50
 129.40  36.70
 129.40  37.00
 129.20  37.40
 129.00  37.80
 128.70  38.20
 128.30  38.70
 128.00  38.90
 127.90  39.10
 127.50  39.20
 127.50  39.40
 127.50  39.60
 127.70  39.80
 128.00  40.00
 128.20  40.20
 128.40  40.10
 128.70  40.30
 129.10  40.40
 129.30  40.70
 129.80  40.80
 129.80  41.20
 129.70  41.40
 129.80  41.70
 130.00  41.90
 130.10  42.10
 130.50  42.30
 130.90  42.50
 131.00  42.70
 131.20  42.60
 131.50  42.90
 131.70  43.20
 132.00  43.30
 132.00  43.10
 132.30  43.30
 132.30  43.00
 132.40  42.90
 132.80  42.80
 133.00  42.80
 133.20  42.70
 133.50  42.80
 133.90  42.90
 134.30  43.20
 134.70  43.30
 135.20  43.50
 135.60  43.80
 135.70  44.20
 136.00  44.40
 136.30  44.60
 136.70  45.00
 136.80  45.20
 137.20  45.40
 137.80  45.80
 138.00  46.10
 138.20  46.30
 138.50  46.70
 138.60  47.00
 139.00  47.30
 139.30  47.70
 139.60  47.90
 139.70  48.10
 140.00  48.30
 140.20  48.60
 140.40  48.90
 140.40  49.00
 140.40  49.30
 140.50  49.70
 140.60  50.00
 140.60  50.10
 140.60  50.30
 140.50  50.70
 140.70  50.90
 140.80  51.20
 140.90  51.40
 141.00  51.60
 141.20  51.80
 141.40  51.90
 141.30  52.10
 141.40  52.30
 141.10  52.50
 141.20  52.70
 141.00  52.90
 140.70  53.10
 140.30  53.20
 140.60  53.20
 140.90  53.20
 141.10  53.00
 141.20  53.10
 141.30  53.10
 141.20  53.30
 140.90  53.50
 140.60  53.70
 140.30  53.90
 140.00  54.10
 139.70  54.30
 139.00  54.20
 138.80  54.10
 138.70  53.70
 138.30  53.60
 138.60  54.00
 138.30  53.80
 137.70  53.60
 137.20  53.60
 137.50  53.70
 137.90  54.00
 137.50  54.00
 137.60  54.20
 137.60  54.30
 137.20  54.20
 137.20  53.90
 136.90  53.50
 136.90  54.10
 136.90  54.30
 136.90  54.70
 136.50  54.60
 136.00  54.60
 135.70  54.70
 135.30  54.80
 135.50  55.10
 135.80  55.20
 136.20  55.40
 136.50  55.50
-179.00  68.70
-179.30  65.50
-179.70  66.20
-178.80  65.90
-178.60  65.40
-176.70  65.60
-175.90  65.00
-174.50  64.70
-173.10  64.20
-172.30  64.40
-172.90  64.60
-172.30  65.20
-172.60  65.70
-171.00  65.50
-170.50  65.90
-170.90  66.40
-172.00  67.00
-174.00  67.10
-174.30  66.50
-175.00  67.30
-177.00  68.10
-179.00  68.70
  30.00  41.20
  29.60  41.20
  29.20  41.30
  28.80  41.30
  28.30  41.50
  28.10  41.70
  28.00  42.00
  27.80  42.40
  27.70  42.60
  27.90  43.00
  28.00  43.30
  28.30  43.40
  28.60  43.60
  28.70  43.90
  28.80  44.40
  29.00  44.70
  29.40  44.80
  29.70  45.00
  29.70  45.40
  29.80  45.60
  30.20  45.90
  30.50  46.20
  30.80  46.40
  31.00  46.60
  31.20  46.60
  31.60  46.60
  32.00  46.70
  32.40  46.60
  32.20  46.50
  31.80  46.50
  31.70  46.40
  31.80  46.30
  32.30  46.20
  32.70  46.20
  33.10  46.20
  33.50  46.10
  33.60  46.00
  33.40  45.80
  32.80  45.60
  32.50  45.40
  32.90  45.40
  33.30  45.20
  33.60  45.10
  33.50  44.80
  33.40  44.60
  33.70  44.40
  34.20  44.50
  34.60  44.80
  34.80  44.80
  35.10  44.70
  35.40  45.00
  35.60  45.20
  35.80  45.00
  36.20  45.10
  36.60  45.20
  37.00  45.10
  37.30  44.80
  37.70  44.70
  38.00  44.60
  38.50  44.30
  38.90  44.20
  39.10  44.10
  39.40  43.80
  39.70  43.60
  40.00  43.40
  40.30  43.20
  40.70  43.10
  40.90  43.00
  41.10  42.90
  41.50  42.70
  41.70  42.30
  41.80  42.00
  41.80  41.80
  41.50  41.50
  41.00  41.20
  40.70  41.10
  40.30  41.00
  40.00  41.00
  39.70  41.10
  39.30  41.10
  38.60  41.00
  38.20  41.00
  37.90  41.00
  37.70  41.20
  37.40  41.10
  37.00  41.30
  36.60  41.40
  36.30  41.40
  36.10  41.70
  35.80  41.70
  35.40  41.70
  35.10  42.00
  34.90  42.00
  34.50  42.00
  34.00  42.00
  33.60  42.00
  33.30  42.10
  33.00  41.90
  32.70  41.80
  32.00  41.60
  31.60  41.40
  31.40  41.20
  31.00  41.20
  30.60  41.20
  30.30  41.20
  30.00  41.20
 140.30  41.30
 140.00  40.70
 139.90  40.10
 140.00  39.80
 139.90  39.30
 139.60  38.70
 139.50  38.20
 138.60  37.50
 138.20  37.10
 137.40  36.90
 137.20  36.70
 137.00  37.00
 136.90  37.20
 137.40  37.50
 136.80  37.40
 136.70  36.70
 136.00  36.00
 135.50  35.50
 134.90  35.60
 134.00  35.50
 133.40  35.40
 132.70  35.40
 132.10  34.90
 131.40  34.40
 130.90  34.40
 130.50  33.80
 130.30  33.60
 130.00  33.40
 129.70  33.00
 130.20  32.80
 130.40  32.70
 130.10  33.10
 130.50  33.10
 130.70  32.70
 130.20  32.10
 130.40  31.50
 130.60  31.20
 130.70  31.70
 130.70  31.50
 130.70  31.00
 131.00  31.40
 131.30  31.40
 131.60  32.40
 131.90  33.20
 131.50  33.40
 131.60  33.60
 131.10  33.70
 131.30  33.90
 131.40  34.00
 132.10  33.90
 132.20  34.30
 132.50  34.30
 133.60  34.50
 134.50  34.70
 135.30  34.70
 135.10  34.30
 135.40  33.70
 136.20  33.90
 136.90  34.30
 136.50  34.60
 136.90  35.10
 137.00  34.90
 137.30  34.80
 137.50  34.70
 138.20  34.60
 138.70  35.10
 138.80  34.90
 139.00  34.60
 139.10  35.10
 139.60  35.30
 139.80  35.20
 139.90  35.70
 140.10  35.50
 139.90  34.90
 140.40  35.10
 140.70  35.70
 140.50  36.20
 140.80  36.90
 141.10  37.40
 140.90  38.10
 141.40  38.40
 141.50  38.60
 142.00  39.50
 141.60  40.50
 141.40  40.80
 141.50  41.40
 140.90  41.60
 141.30  41.30
 141.20  40.80
 140.90  40.80
 140.70  41.00
 140.50  41.20
 140.30  41.30
 134.70  33.80
 134.20  34.30
 133.60  34.30
 133.20  33.90
 132.80  34.00
 132.30  33.50
 132.40  33.30
 132.50  32.90
 132.70  32.80
 133.00  33.00
 133.30  33.40
 134.20  33.30
 134.70  33.80
 122.00  25.00
 121.40  25.10
 120.90  24.70
 120.30  24.00
 120.40  23.80
 120.10  23.60
 120.10  23.00
 120.40  22.50
 120.70  22.00
 120.90  22.30
 121.30  23.00
 121.60  24.00
 121.80  24.50
 122.00  25.00
 122.00  25.00
 122.30  18.50
 122.00  18.30
 121.40  18.50
 120.90  18.50
 120.50  18.50
 120.40  18.00
 120.50  17.50
 120.40  16.70
 120.50  16.20
 119.90  16.40
 119.70  16.40
 119.80  15.90
 119.90  15.40
 120.10  14.90
 120.60  14.40
 120.80  14.70
 120.60  14.30
 120.90  13.90
 121.00  13.80
 121.40  13.60
 121.80  13.90
 122.30  13.50
 122.50  13.40
 122.70  13.20
 122.70  13.40
 122.40  13.90
 122.80  13.60
 123.40  13.00
 123.80  12.80
 124.00  12.90
 123.80  12.80
 124.10  12.50
 123.90  13.10
 123.80  13.30
 123.50  13.60
 124.00  13.70
 123.40  13.90
 123.20  14.00
 123.00  13.70
 122.80  14.30
 122.20  14.10
 122.30  13.90
 121.70  14.10
 121.60  14.60
 121.50  15.00
 121.60  15.70
 121.50  15.90
 122.20  16.20
 122.40  16.60
 122.40  17.10
 122.30  17.30
 122.20  18.10
 122.30  18.50
 125.50   9.80
 125.50   9.30
 125.20   9.00
 125.10   8.80
 124.70   8.50
 124.40   8.60
 124.20   8.20
 123.70   8.00
 123.70   8.60
 123.30   8.50
 123.00   8.20
 122.30   8.00
 122.10   7.50
 121.90   6.90
 122.30   7.30
 122.80   7.70
 123.00   7.30
 123.40   7.40
 123.70   7.80
 124.20   7.30
 124.00   6.50
 124.60   6.00
 125.10   6.10
 125.30   5.90
 125.20   5.80
 125.70   5.90
 125.50   6.50
 125.40   6.80
 125.70   7.30
 126.00   6.90
 126.30   6.70
 126.60   7.70
 126.40   8.20
 126.10   8.50
 126.30   8.80
 126.20   9.20
 126.00   9.50
 125.50   9.80
 110.70  20.10
 110.00  19.90
 109.50  19.80
 109.20  19.70
 108.90  19.50
 108.60  18.80
 109.20  18.30
 109.70  18.40
 110.20  18.60
 110.50  19.00
 111.00  19.70
 110.80  20.00
 110.70  20.10
 117.10   7.00
 117.00   6.80
 116.70   6.60
 116.70   7.00
 116.20   6.20
 115.90   5.80
 115.50   5.50
 115.50   5.20
 115.30   4.90
 115.00   5.00
 114.00   4.60
 113.70   4.00
 113.20   3.30
 112.50   3.00
 111.50   2.80
 111.20   2.40
 111.00   1.50
 110.50   1.70
 109.70   1.80
 109.30   1.90
 109.00   1.50
 109.00   0.90
 108.90   0.30
 109.10  -0.30
 109.20  -0.60
 109.30  -0.70
 109.50  -1.00
 109.40  -1.30
 109.70  -1.00
 109.90  -1.20
 109.90  -1.80
 110.10  -2.30
 110.20  -3.00
 110.60  -3.00
 111.40  -2.90
 111.70  -2.70
 111.80  -3.60
 112.50  -3.50
 113.00  -3.00
 113.60  -3.20
 114.00  -3.30
 114.60  -3.70
 115.20  -3.90
 116.00  -3.60
 116.20  -3.20
 116.50  -2.50
 116.30  -2.20
 116.50  -1.50
 116.90  -1.20
 117.60  -0.70
 117.40  -0.30
 117.50   0.50
 118.40   0.80
 119.00   1.00
 118.00   1.80
 118.10   2.30
 117.60   3.00
 117.50   3.70
 117.80   3.80
 117.60   4.40
 118.50   4.30
 118.30   4.60
 118.40   5.00
 118.80   4.90
 119.30   5.40
 118.20   5.80
 117.90   5.80
 118.00   6.00
 117.60   6.20
 117.50   6.60
 117.10   7.00
 141.90  45.50
 141.80  44.70
 141.70  44.30
 141.40  43.80
 141.20  43.20
 140.50  43.30
 140.50  43.00
 139.90  42.60
 140.10  41.90
 140.20  41.40
 140.60  41.60
 141.00  41.70
 140.80  42.10
 140.40  42.50
 141.00  42.30
 141.70  42.60
 142.80  42.20
 143.30  42.40
 144.30  43.00
 145.20  43.10
 146.00  43.40
 145.30  43.30
 145.10  43.70
 145.30  44.30
 144.90  43.90
 144.40  43.90
 143.60  44.30
 142.60  44.80
 141.90  45.50
 130.00 -13.50
 129.70 -13.90
 129.40 -14.20
 129.70 -14.70
 129.30 -14.90
 128.50 -14.80
 128.10 -15.10
 127.90 -14.50
 127.40 -13.90
 127.00 -13.80
 126.60 -14.30
 126.30 -14.30
 125.90 -14.20
 125.20 -14.30
 125.30 -15.20
 124.70 -15.30
 124.50 -16.00
 124.00 -16.30
 123.60 -16.60
 123.60 -17.00
 123.30 -17.20
 122.90 -16.40
 122.20 -17.10
 122.10 -17.60
 122.20 -18.00
 122.30 -18.10
 121.70 -18.50
 121.30 -19.40
 120.50 -19.80
 119.70 -19.90
 119.00 -20.00
 118.30 -20.40
 117.30 -20.70
 116.80 -20.70
 116.30 -20.80
 115.40 -21.50
 114.60 -21.80
 114.30 -22.50
 114.10 -22.20
 113.90 -22.00
 113.60 -22.60
 113.70 -23.50
 113.40 -24.50
 113.60 -25.10
 114.20 -25.90
 114.00 -26.50
 113.70 -26.20
 113.70 -25.80
 113.50 -25.50
 113.50 -26.10
 113.60 -26.60
 113.30 -26.50
 113.90 -27.20
 114.10 -28.10
 114.70 -28.90
 114.90 -29.60
 115.00 -30.50
 115.60 -31.50
 115.70 -32.20
 115.60 -33.00
 115.30 -33.60
 115.00 -34.00
 115.40 -34.40
 116.50 -35.00
 117.50 -35.10
 118.40 -34.90
 118.70 -34.60
 119.20 -34.50
 119.70 -34.10
 120.50 -33.90
 121.50 -33.80
 122.10 -34.00
 122.50 -34.00
 123.10 -34.00
 124.00 -33.60
 124.30 -32.90
 125.00 -32.70
 125.90 -32.30
 127.00 -32.30
 128.10 -32.00
 129.30 -31.60
 130.40 -31.60
 131.10 -31.50
 132.10 -32.00
 132.50 -31.90
 133.40 -32.20
 133.90 -32.50
 134.30 -32.70
 134.20 -33.20
 134.80 -33.60
 135.30 -34.50
 135.10 -34.50
 135.60 -34.90
 135.90 -35.00
 135.80 -34.80
 136.10 -34.50
 136.30 -34.10
 137.20 -33.70
 137.80 -33.00
 138.00 -33.00
 137.80 -33.20
 137.50 -34.00
 137.40 -34.90
 136.80 -35.30
 137.70 -35.20
 138.10 -34.20
 138.50 -34.70
 138.40 -35.40
 138.50 -35.60
 139.10 -35.70
 139.70 -36.40
 139.70 -37.00
 140.20 -37.70
 141.00 -38.10
 141.60 -38.40
 142.10 -38.40
 142.90 -38.60
 143.50 -38.80
 144.40 -38.30
 144.90 -38.50
 145.40 -38.50
 145.90 -38.90
 146.30 -39.10
 146.50 -38.70
 147.40 -38.30
 148.40 -37.90
 149.50 -37.80
 150.00 -37.50
 149.90 -36.90
 150.10 -36.30
 150.50 -35.40
 150.90 -34.50
 151.30 -34.00
 151.70 -33.10
 152.40 -32.60
 152.80 -32.00
 153.00 -31.00
 153.00 -30.70
 153.30 -29.70
 153.60 -28.80
 153.50 -28.20
 153.50 -27.40
 153.40 -27.70
 153.10 -27.30
 153.10 -27.20
 153.10 -26.60
 153.20 -25.90
 153.30 -25.20
 153.30 -24.70
 153.20 -24.80
 153.00 -25.30
 152.90 -25.30
 152.50 -25.00
 152.00 -24.50
 151.50 -24.00
 151.00 -23.60
 150.80 -23.00
 150.70 -22.40
 150.70 -22.60
 150.00 -22.20
 150.00 -22.60
 149.60 -22.40
 149.40 -21.60
 149.00 -20.90
 148.60 -20.50
 148.80 -20.20
 148.50 -20.20
 147.90 -19.90
 147.80 -19.70
 147.70 -19.80
 147.50 -19.40
 147.00 -19.20
 146.50 -19.20
 146.40 -18.50
 146.10 -18.00
 146.00 -17.30
 145.50 -16.60
 145.40 -15.60
 145.40 -15.00
 144.90 -14.70
 144.50 -14.20
 144.10 -14.50
 143.60 -14.00
 143.60 -13.40
 143.50 -12.90
 143.40 -12.60
 143.20 -12.00
 142.90 -11.90
 142.70 -11.00
 142.40 -10.70
 142.10 -10.90
 142.00 -11.70
 141.70 -12.00
 141.80 -12.60
 141.70 -13.40
 141.50 -14.00
 141.50 -14.50
 141.50 -15.50
 141.30 -16.50
 140.90 -17.40
 140.00 -17.70
 139.30 -17.40
 139.00 -16.90
 138.30 -16.70
 137.70 -16.30
 136.60 -16.00
 135.90 -15.30
 135.30 -15.00
 135.00 -14.80
 135.50 -14.60
 136.00 -14.00
 136.00 -13.80
 136.00 -13.30
 136.40 -13.30
 136.50 -12.80
 136.90 -12.30
 136.70 -12.20
 136.50 -12.00
 136.40 -12.30
 136.00 -12.50
 135.70 -12.30
 135.80 -12.00
 135.10 -12.30
 134.50 -12.10
 133.80 -11.70
 133.20 -11.70
 132.80 -11.40
 132.40 -11.20
 132.10 -11.50
 132.60 -11.70
 132.00 -12.30
 131.30 -12.10
 131.00 -12.20
 130.80 -12.40
 130.60 -12.40
 130.70 -12.70
 130.40 -12.80
 130.20 -12.90
 130.30 -13.30
 130.00 -13.50
 -80.00  62.30
 -80.20  62.10
 -80.20  61.90
 -79.90  61.70
 -79.50  61.80
 -79.20  62.30
 -79.70  62.40
 -80.00  62.30
 -83.00  62.80
 -83.20  62.90
 -83.50  62.60
 -83.70  62.20
 -83.40  62.30
 -83.10  62.20
 -82.60  62.40
 -82.30  62.60
 -81.90  62.90
 -82.40  62.90
 -83.00  62.80
 -83.00  64.80
 -83.30  65.10
 -84.00  65.20
 -84.50  65.50
 -85.00  65.50
 -85.00  65.70
 -84.60  65.80
 -85.20  65.80
 -85.50  65.90
 -86.00  65.60
 -86.20  64.80
 -86.30  64.30
 -86.40  64.10
 -87.00  63.80
 -87.00  63.60
 -86.50  63.80
 -85.90  63.80
 -85.60  63.40
 -85.30  63.20
 -84.60  63.40
 -84.50  63.50
 -84.00  63.70
 -83.60  63.80
 -83.60  64.10
 -83.30  64.10
 -82.90  64.10
 -82.80  63.90
 -82.30  63.80
 -82.30  63.60
 -81.80  63.60
 -80.00  63.40
 -80.30  63.70
 -80.40  63.80
 -80.40  63.90
 -80.80  64.00
 -81.60  64.00
 -81.50  64.20
 -81.80  64.50
 -82.30  64.70
 -83.00  64.80
 -90.00  72.00
 -89.90  71.80
 -90.00  71.40
 -89.40  71.30
 -88.60  71.20
 -88.00  71.30
 -87.90  71.20
 -87.30  71.00
 -87.30  70.90
 -88.00  70.90
 -88.40  71.00
 -89.00  71.00
 -89.50  71.10
 -89.30  70.90
 -89.30  70.70
 -88.80  70.40
 -88.10  70.30
 -87.90  70.20
 -87.30  70.30
 -87.00  70.40
 -86.60  70.30
 -86.00  70.00
 -85.30  70.00
 -85.30  70.10
 -85.00  70.10
 -84.80  70.00
 -84.00  69.90
 -83.40  69.90
 -83.00  70.00
 -82.70  69.80
 -82.30  69.70
 -81.90  69.80
 -82.00  70.00
 -82.80  70.30
 -82.30  70.30
 -81.60  69.90
 -81.00  69.70
 -81.00  69.90
 -81.50  70.00
 -81.40  70.20
 -80.60  70.10
 -80.00  70.00
 -79.30  69.80
 -78.80  69.80
 -78.60  70.00
 -78.90  70.30
 -79.20  70.30
 -79.50  70.40
 -79.50  70.50
 -78.90  70.50
 -78.30  70.20
 -77.60  70.20
 -77.60  69.70
 -76.80  69.70
 -76.80  69.50
 -76.00  69.30
 -76.00  69.00
 -76.60  69.00
 -76.50  68.80
 -76.40  68.60
 -75.60  68.90
 -75.20  68.90
 -74.80  69.20
 -74.90  68.90
 -74.60  68.60
 -74.00  68.50
 -73.60  68.30
 -73.00  68.20
 -73.00  67.90
 -72.80  67.70
 -72.40  67.30
 -72.40  67.10
 -72.80  67.10
 -72.60  66.80
 -71.80  66.70
 -71.30  66.80
 -71.20  67.00
 -70.50  66.90
 -70.00  66.80
 -69.50  66.50
 -69.50  66.30
 -70.30  66.20
 -70.80  66.20
 -71.10  65.90
 -71.10  66.30
 -71.70  66.60
 -72.40  66.70
 -72.80  66.70
 -73.40  66.60
 -74.00  66.30
 -74.30  66.10
 -74.00  65.80
 -73.50  65.70
 -73.40  65.50
 -74.20  65.60
 -74.80  65.40
 -75.10  65.40
 -75.40  65.30
 -75.80  65.40
 -76.20  65.40
 -77.00  65.50
 -77.30  65.40
 -77.30  65.30
 -77.60  65.20
 -78.10  64.90
 -78.20  64.70
 -77.80  64.40
 -77.30  64.30
 -76.80  64.30
 -76.70  64.30
 -76.00  64.50
 -75.70  64.60
 -75.10  64.50
 -74.50  64.50
 -74.20  64.60
 -74.00  64.50
 -73.70  64.40
 -73.00  64.30
 -72.80  64.20
 -72.60  64.00
 -72.60  63.80
 -72.10  63.80
 -72.00  63.70
 -71.50  63.70
 -71.50  63.40
 -72.10  63.40
 -71.70  63.20
 -71.20  63.00
 -70.90  63.00
 -70.20  62.70
 -69.50  62.70
 -69.00  62.40
 -68.40  62.30
 -67.60  62.20
 -66.90  62.00
 -66.30  61.80
 -65.90  61.80
 -66.10  62.10
 -66.10  62.40
 -66.20  62.50
 -67.00  62.80
 -67.50  63.00
 -68.30  63.40
 -68.90  63.80
 -68.50  63.80
 -67.70  63.40
 -67.40  63.40
 -66.60  63.00
 -66.40  63.00
 -65.80  63.00
 -65.50  62.80
 -65.20  62.80
 -65.10  62.60
 -64.90  62.70
 -65.20  63.00
 -64.80  62.80
 -64.80  63.00
 -65.00  63.30
 -65.00  63.50
 -65.20  63.80
 -64.80  63.50
 -64.50  63.60
 -64.50  63.80
 -64.50  64.00
 -65.10  64.00
 -65.10  64.20
 -65.20  64.30
 -65.00  64.40
 -65.00  64.50
 -65.20  64.60
 -65.70  64.80
 -66.00  64.80
 -66.60  65.10
 -66.60  64.80
 -66.70  65.20
 -66.80  65.30
 -67.20  65.40
 -67.00  65.50
 -67.40  65.60
 -67.30  65.70
 -68.00  65.50
 -67.80  65.80
 -68.20  65.90
 -68.00  66.00
 -67.90  65.90
 -67.20  65.90
 -67.30  66.20
 -67.80  66.50
 -67.20  66.30
 -67.00  66.50
 -66.40  66.30
 -66.00  66.10
 -66.00  66.00
 -65.40  65.90
 -64.90  66.10
 -65.30  65.80
 -65.30  65.60
 -64.70  65.20
 -64.50  65.30
 -63.80  65.20
 -63.50  64.80
 -63.50  65.50
 -63.30  65.70
 -62.50  65.70
 -62.20  65.80
 -62.60  66.00
 -62.00  66.00
 -62.40  66.30
 -62.50  66.50
 -62.00  66.40
 -61.40  66.50
 -61.30  66.70
 -62.00  67.00
 -62.50  66.90
 -62.90  66.90
 -63.20  67.00
 -63.30  67.20
 -63.20  67.40
 -63.50  67.30
 -64.00  67.40
 -64.10  67.60
 -64.70  67.80
 -65.20  67.70
 -65.10  68.10
 -65.70  68.00
 -66.00  68.00
 -66.80  68.10
 -67.00  68.30
 -67.20  68.40
 -67.60  68.50
 -68.40  68.50
 -68.80  68.60
 -68.10  68.60
 -68.90  68.70
 -68.90  68.80
 -68.10  68.80
 -68.00  68.90
 -67.80  69.00
 -68.50  69.10
 -68.50  69.30
 -68.10  69.30
 -67.50  69.20
 -66.70  69.20
 -66.70  69.40
 -67.40  69.50
 -68.20  69.50
 -68.20  69.60
 -67.60  69.70
 -67.00  69.70
 -67.20  70.00
 -67.30  70.10
 -68.00  70.30
 -68.30  70.20
 -68.50  70.00
 -68.90  69.90
 -68.90  70.00
 -69.00  70.20
 -69.70  70.10
 -69.70  70.20
 -68.90  70.30
 -68.50  70.40
 -68.60  70.60
 -69.30  70.80
 -70.00  70.60
 -69.90  70.80
 -70.40  70.70
 -71.20  70.50
 -70.50  70.90
 -70.70  71.10
 -71.20  70.90
 -71.20  71.00
 -71.30  71.10
 -71.20  71.40
 -71.80  71.60
 -72.20  71.70
 -72.80  71.70
 -73.20  71.50
 -73.70  71.50
 -74.00  71.80
 -74.60  71.60
 -74.50  71.80
 -74.30  72.00
 -74.70  72.10
 -75.20  72.00
 -75.20  72.50
 -75.50  72.60
 -76.10  72.60
 -76.60  72.70
 -76.60  72.80
 -77.40  72.80
 -78.10  72.70
 -78.70  72.50
 -78.70  72.40
 -79.00  72.30
 -79.50  72.30
 -80.20  72.30
 -80.80  71.90
 -80.60  72.40
 -80.40  72.70
 -80.70  73.00
 -81.00  73.30
 -81.30  73.50
 -81.90  73.70
 -82.70  73.70
 -83.40  73.60
 -84.20  73.40
 -85.10  73.20
 -85.10  73.10
 -85.10  73.00
 -85.00  72.90
 -85.60  72.90
 -85.70  72.50
 -85.50  72.40
 -84.80  72.20
 -85.40  72.10
 -85.40  71.80
 -84.80  71.70
 -84.90  71.40
 -85.40  71.60
 -86.00  71.80
 -86.50  72.20
 -86.50  72.60
 -86.40  73.00
 -85.60  73.60
 -84.90  73.80
 -85.70  73.80
 -86.50  73.80
 -87.30  73.70
 -88.10  73.50
 -89.00  73.40
 -89.30  72.90
 -89.70  72.60
 -89.80  72.10
 -90.00  72.00
 -66.00  79.10
 -65.00  79.50
 -65.00  79.70
 -64.50  79.80
 -64.30  79.90
 -64.50  80.10
 -65.50  80.00
 -66.50  80.10
 -67.00  80.20
 -67.40  80.40
 -66.50  80.50
 -65.50  80.60
 -64.70  81.00
 -63.80  81.10
 -63.00  81.20
 -62.00  81.10
 -61.00  81.10
 -60.90  81.50
 -61.70  81.70
 -61.00  81.80
 -60.00  81.90
 -59.00  81.80
 -58.50  81.60
 -58.50  81.70
 -59.00  81.90
 -59.80  82.00
 -59.00  82.10
 -58.00  82.20
 -57.00  82.30
 -56.40  82.30
 -55.40  82.40
 -54.50  82.30
 -54.00  81.80
 -53.80  81.60
 -53.50  82.10
 -52.50  81.90
 -51.50  81.80
 -50.50  81.90
 -50.50  82.00
 -51.50  82.30
 -51.90  82.60
 -51.00  82.60
 -50.00  82.60
 -49.00  82.40
 -48.40  82.30
 -47.50  82.20
 -46.80  82.00
 -46.00  81.80
 -45.50  81.80
 -45.50  81.90
 -46.40  82.20
 -47.00  82.30
 -48.00  82.50
 -49.00  82.70
 -48.50  82.90
 -47.50  83.00
 -46.50  83.10
 -45.50  83.20
 -44.50  83.30
 -43.50  83.30
 -42.50  83.40
 -41.50  83.40
 -40.00  83.50
 -39.00  83.50
 -38.00  83.50
 -37.00  83.60
 -36.00  83.60
 -35.00  83.70
 -34.00  83.70
 -33.00  83.70
 -32.00  83.70
 -31.00  83.50
 -30.50  83.50
 -29.50  83.50
 -28.50  83.50
 -27.50  83.40
 -26.50  83.30
 -27.00  83.20
 -28.00  83.20
 -28.00  83.10
 -27.00  83.10
 -26.00  83.20
 -25.50  82.90
 -24.50  82.90
 -23.50  82.80
 -22.50  82.70
 -22.00  82.40
 -23.00  82.30
 -24.00  82.20
 -25.00  82.20
 -26.00  82.10
 -27.00  82.10
 -28.00  82.10
 -29.00  82.10
 -30.00  82.10
 -31.00  82.10
 -31.50  82.00
 -32.50  81.90
 -33.00  81.80
 -34.00  81.70
 -33.00  81.70
 -32.00  81.80
 -31.00  81.90
 -30.00  82.00
 -29.00  82.00
 -28.00  82.00
 -27.00  82.00
 -26.00  82.00
 -26.50  81.70
 -27.50  81.60
 -27.50  81.50
 -26.50  81.60
 -25.50  81.70
 -24.50  82.00
 -23.50  82.10
 -22.50  82.00
 -22.50  81.30
 -23.50  81.30
 -24.50  80.50
 -23.50  80.80
 -23.00  81.00
 -22.00  81.20
 -21.00  81.60
 -20.50  81.50
 -19.50  81.60
 -18.50  81.50
 -18.00  81.70
 -17.00  81.90
 -16.00  82.00
 -15.00  81.90
 -14.00  81.80
 -13.00  81.70
 -12.20  81.50
 -13.00  81.40
 -14.00  81.20
 -15.00  81.20
 -14.80  80.90
 -15.50  80.80
 -16.50  80.70
 -17.50  80.70
 -18.50  80.70
 -19.50  80.70
 -19.50  80.60
 -18.50  80.60
 -18.00  80.60
 -17.00  80.60
 -16.20  80.60
 -17.00  80.40
 -18.00  80.30
 -19.00  80.30
 -20.00  80.30
 -20.50  79.80
 -19.50  80.00
 -18.50  80.10
 -17.50  80.10
 -18.50  79.80
 -19.50  79.80
 -19.80  79.30
 -19.00  79.20
 -20.00  79.10
 -20.20  78.80
 -20.90  78.80
 -21.50  78.20
 -22.00  77.80
 -21.50  77.70
 -20.50  78.00
 -19.50  77.80
 -19.00  77.60
 -19.50  77.60
 -20.50  77.70
 -20.50  77.60
 -20.00  77.40
 -19.00  77.30
 -18.50  77.40
 -18.30  76.80
 -19.00  76.80
 -20.00  77.00
 -21.00  77.00
 -21.50  76.70
 -22.50  76.80
 -22.30  76.50
 -21.50  76.30
 -20.50  76.30
 -19.80  75.80
 -19.50  75.20
 -20.50  75.30
 -20.70  75.20
 -20.70  74.60
 -20.00  74.60
 -19.30  74.60
 -19.50  74.30
 -20.50  74.10
 -21.00  74.10
 -22.00  74.20
 -21.50  74.00
 -20.50  73.90
 -20.50  73.80
 -20.80  73.50
 -21.60  73.50
 -22.30  73.30
 -23.00  73.30
 -22.50  73.00
 -22.10  72.50
 -22.80  72.20
 -23.50  72.30
 -24.00  72.30
 -23.00  72.00
 -22.00  71.50
 -21.70  71.00
 -22.00  70.50
 -22.40  70.60
 -23.00  70.40
 -24.00  70.60
 -24.60  71.20
 -25.50  71.20
 -25.20  70.70
 -25.50  70.60
 -26.50  70.50
 -26.00  70.30
 -25.00  70.30
 -24.00  70.20
 -23.00  70.20
 -22.10  70.20
 -23.00  69.90
 -24.00  69.50
 -25.00  69.10
 -25.80  68.90
 -26.50  68.80
 -27.50  68.60
 -28.50  68.50
 -29.50  68.30
 -30.00  68.60
 -30.50  68.30
 -31.00  68.10
 -32.00  68.30
 -32.50  67.80
 -33.30  67.60
 -34.00  67.00
 -34.40  66.60
 -35.20  66.30
 -35.70  66.30
 -36.20  65.90
 -37.00  65.90
 -37.70  65.70
 -38.00  65.80
 -38.00  66.20
 -39.00  65.60
 -39.70  65.60
 -40.50  65.20
 -41.20  65.00
 -40.50  64.50
 -40.50  63.80
 -41.50  63.00
 -42.30  62.60
 -42.30  61.80
 -42.80  61.00
 -43.30  60.30
 -43.70  59.90
 -44.50  59.80
 -45.30  60.20
 -46.00  60.70
 -47.00  60.90
 -48.00  61.00
 -49.00  61.40
 -49.50  61.70
 -50.40  62.60
 -50.80  63.10
 -51.50  63.50
 -51.50  64.00
 -52.00  64.20
 -52.30  65.00
 -52.50  65.40
 -53.50  66.00
 -53.50  66.50
 -53.70  66.90
 -54.00  67.50
 -53.30  68.00
 -52.70  68.40
 -52.00  68.50
 -51.00  68.50
 -51.20  68.70
 -51.00  69.50
 -50.30  70.10
 -51.00  70.00
 -52.00  70.10
 -53.00  70.30
 -54.00  70.30
 -54.70  70.70
 -54.20  70.80
 -53.50  70.70
 -52.50  70.80
 -51.50  70.40
 -51.00  70.60
 -50.90  70.80
 -51.90  71.00
 -52.00  71.10
 -52.50  71.10
 -53.30  71.30
 -52.50  71.60
 -53.50  71.60
 -54.00  71.40
 -55.00  71.30
 -55.80  71.60
 -55.50  72.20
 -55.00  72.60
 -54.50  72.80
 -55.50  73.10
 -55.50  73.60
 -56.00  73.80
 -56.00  74.00
 -56.00  74.50
 -56.60  74.70
 -57.00  74.80
 -57.50  75.00
 -58.20  75.60
 -59.00  75.80
 -60.00  76.00
 -61.00  76.00
 -62.00  76.20
 -63.00  76.30
 -63.80  76.10
 -64.50  76.20
 -65.50  76.10
 -66.00  76.30
 -66.80  76.30
 -67.00  76.10
 -67.00  76.00
 -68.00  76.10
 -69.00  76.20
 -70.00  76.40
 -69.00  76.50
 -68.00  76.60
 -68.50  76.70
 -69.50  76.70
 -70.50  76.80
 -71.20  77.00
 -71.00  77.20
 -70.00  77.30
 -69.00  77.40
 -68.00  77.40
 -67.00  77.40
 -66.00  77.50
 -67.00  77.60
 -68.00  77.60
 -69.00  77.50
 -70.00  77.60
 -70.50  77.70
 -70.50  77.80
 -71.50  77.90
 -72.50  78.10
 -72.70  78.30
 -72.50  78.50
 -71.50  78.70
 -70.50  78.80
 -69.50  78.80
 -69.40  79.00
 -68.50  79.10
 -67.50  79.20
 -66.50  79.10
 -66.00  79.10
  -3.30  57.80
  -3.80  58.00
  -3.00  58.70
  -3.50  58.60
  -4.20  58.60
  -4.60  58.60
  -5.00  58.70
  -5.10  58.50
  -5.30  58.30
  -5.50  57.80
  -5.70  57.60
  -5.70  57.40
  -5.60  57.30
  -5.80  57.10
  -5.90  56.80
  -6.00  56.70
  -6.20  56.70
  -6.10  56.60
  -5.90  56.60
  -5.50  56.60
  -5.10  56.80
  -5.40  56.50
  -5.50  56.20
  -5.60  55.90
  -5.50  55.80
  -5.60  55.50
  -5.60  55.40
  -5.40  55.60
  -5.40  55.80
  -5.50  56.00
  -5.40  56.00
  -5.30  55.80
  -5.00  56.00
  -4.70  55.90
  -4.90  55.90
  -4.90  55.70
  -4.70  55.50
  -4.90  55.20
  -5.10  55.00
  -5.20  54.80
  -4.90  54.60
  -4.90  54.80
  -4.60  54.60
  -4.40  54.60
  -4.30  54.80
  -4.00  54.70
  -3.90  54.80
  -3.60  54.80
  -3.60  55.00
  -3.30  54.90
  -3.10  54.90
  -3.30  54.70
  -3.60  54.50
  -3.30  54.30
  -3.00  54.30
  -2.80  54.20
  -2.90  53.90
  -3.10  53.80
  -2.90  53.70
  -2.90  53.60
  -3.00  53.40
  -3.10  53.20
  -3.40  53.40
  -3.60  53.30
  -3.90  53.30
  -4.10  53.20
  -4.20  53.40
  -4.60  53.50
  -4.50  53.20
  -4.50  53.00
  -4.70  52.80
  -4.50  52.80
  -4.40  52.80
  -4.20  52.70
  -4.00  52.50
  -4.20  52.30
  -4.50  52.20
  -5.00  52.00
  -5.30  51.80
  -5.20  51.80
  -5.00  51.60
  -4.80  51.70
  -4.50  51.70
  -4.20  51.50
  -3.90  51.60
  -3.50  51.40
  -3.20  51.40
  -2.90  51.50
  -2.70  51.60
  -2.60  51.60
  -2.90  51.40
  -3.20  51.20
  -3.60  51.30
  -3.90  51.30
  -4.20  51.20
  -4.50  51.00
  -4.60  50.80
  -4.90  50.60
  -5.20  50.30
  -5.50  50.20
  -5.50  50.10
  -5.30  50.00
  -5.10  50.20
  -4.80  50.40
  -4.50  50.40
  -4.10  50.30
  -3.70  50.20
  -3.50  50.60
  -3.00  50.80
  -2.60  50.70
  -2.30  50.80
  -2.00  50.70
  -1.90  50.80
  -1.50  50.80
  -1.20  50.80
  -0.90  50.80
  -0.60  50.80
   0.    50.80
   0.40  50.80
   0.80  50.90
   1.00  50.90
   1.40  51.30
   1.20  51.40
   0.80  51.40
   0.80  51.60
   1.10  51.80
   1.60  52.20
   1.80  52.50
   1.60  52.80
   1.20  52.90
   0.80  52.90
   0.30  52.80
   0.    52.90
   0.40  53.20
   0.30  53.40
   0.    53.60
   0.    53.70
   0.    53.80
  -0.10  54.10
  -0.40  54.40
  -0.70  54.60
  -1.20  54.70
  -1.40  55.00
  -1.60  55.40
  -1.70  55.60
  -2.00  55.80
  -2.30  55.90
  -2.60  56.10
  -2.90  55.90
  -3.10  55.90
  -3.40  56.00
  -3.10  56.20
  -2.80  56.30
  -2.80  56.50
  -2.80  56.60
  -2.30  56.80
  -2.10  57.30
  -1.80  57.50
  -2.10  57.70
  -2.50  57.70
  -2.90  57.70
  -3.30  57.80
  -8.00  55.30
  -8.30  55.20
  -8.50  55.00
  -8.60  54.80
  -8.60  54.60
  -8.20  54.60
  -8.50  54.40
  -8.80  54.30
  -9.20  54.20
  -9.50  54.30
 -10.00  54.20
  -9.90  53.90
  -9.50  53.90
  -9.70  53.70
  -9.90  53.60
 -10.10  53.50
  -9.80  53.30
  -9.40  53.20
  -9.00  53.30
  -9.20  53.10
  -9.50  53.00
  -9.60  52.70
  -9.60  52.60
  -9.20  52.60
  -9.00  52.70
  -9.00  52.60
  -9.50  52.50
  -9.90  52.40
 -10.00  52.30
 -10.30  52.20
  -9.90  52.20
 -10.20  52.00
 -10.10  51.70
 -10.00  51.70
  -9.50  51.50
  -9.10  51.60
  -8.70  51.70
  -8.00  51.90
  -7.50  52.10
  -7.00  52.20
  -6.50  52.20
  -6.40  52.40
  -6.20  52.70
  -6.10  53.10
  -6.10  53.50
  -6.30  53.90
  -6.00  54.00
  -5.90  54.30
  -5.70  54.30
  -5.40  54.50
  -5.70  54.70
  -5.80  54.90
  -6.00  55.30
  -6.50  55.30
  -6.90  55.20
  -7.20  55.10
  -6.90  55.40
  -7.50  55.40
  -8.00  55.30
-180.00 -78.30
-176.00 -78.50
-172.00 -78.50
-168.00 -78.50
-164.20 -78.40
-161.00 -78.00
-158.30 -77.80
-156.00 -77.00
-152.00 -77.30
-150.50 -77.20
-150.00 -76.50
-147.00 -76.40
-146.20 -76.00
-142.00 -75.70
-138.00 -75.20
-137.00 -74.80
-134.90 -74.80
-131.50 -74.20
-130.00 -74.20
-127.00 -74.10
-123.40 -73.50
-122.40 -73.10
-120.00 -73.60
-116.00 -73.80
-114.00 -73.80
-111.00 -74.00
-108.00 -74.00
-106.00 -74.80
-106.80 -74.00
-104.80 -74.40
-100.80 -74.60
-100.40 -74.00
-101.80 -73.50
-100.80 -73.20
-101.40 -72.70
-101.80 -72.40
-102.70 -72.10
-100.90 -71.80
 -97.80 -72.00
 -95.00 -72.00
 -94.00 -72.60
 -90.00 -72.90
 -87.00 -72.90
 -84.00 -72.80
 -81.00 -73.00
 -77.80 -72.60
 -77.00 -72.40
 -74.00 -72.90
 -72.00 -73.20
 -73.10 -72.40
 -76.00 -71.50
 -75.50 -71.00
 -76.00 -70.50
 -75.40 -69.80
 -73.00 -69.50
 -71.00 -68.90
 -69.70 -69.40
 -68.80 -69.50
 -67.00 -67.50
 -67.00 -66.60
 -66.00 -66.80
 -65.70 -66.20
 -64.00 -65.30
 -62.00 -64.60
 -59.00 -63.80
 -56.90 -63.50
 -58.50 -64.00
 -59.80 -64.50
 -59.50 -65.30
 -60.30 -66.00
 -60.70 -67.00
 -60.00 -68.00
 -59.90 -68.20
 -59.10 -68.60
 -60.30 -69.20
 -60.70 -70.00
 -60.50 -71.00
 -60.00 -72.00
 -60.00 -73.00
 -61.00 -73.50
 -61.00 -74.20
 -61.80 -74.70
 -63.00 -74.80
 -62.80 -75.70
 -61.00 -75.50
 -59.00 -75.60
 -55.00 -76.40
 -51.00 -77.10
 -47.00 -77.80
 -43.00 -77.80
 -40.00 -77.90
 -36.00 -78.00
 -35.00 -77.70
 -31.00 -76.80
 -26.50 -75.80
 -25.00 -75.30
 -23.90 -74.80
 -22.00 -74.20
 -20.00 -73.50
 -18.90 -72.50
 -15.00 -72.00
 -12.40 -71.60
 -11.00 -71.00
  -9.00 -70.50
  -5.00 -70.30
  -1.30 -70.00
  -0.90 -69.00
   0.   -68.90
   1.00 -69.90
   5.00 -70.00
   9.00 -70.00
  11.90 -69.50
  13.00 -69.10
  13.50 -69.80
  16.00 -70.00
  20.00 -69.90
  21.00 -70.20
  24.00 -70.30
  28.00 -69.80
  30.00 -69.70
  31.50 -69.50
  33.50 -69.30
  34.00 -68.50
  36.00 -69.40
  38.00 -69.70
  39.70 -69.50
  41.00 -68.50
  43.00 -67.80
  44.60 -67.70
  46.00 -67.30
  48.00 -67.70
  46.50 -67.00
  50.00 -67.10
  50.20 -66.80
  52.00 -66.00
  55.00 -66.00
  57.00 -66.40
  56.80 -66.90
  57.00 -67.10
  59.00 -67.20
  60.40 -67.30
  64.00 -67.50
  68.00 -67.80
  69.50 -67.70
  70.10 -68.20
  72.20 -68.50
  73.50 -68.40
  74.10 -68.70
  75.00 -69.40
  75.60 -69.50
  78.00 -69.00
  79.00 -68.20
  82.40 -67.30
  83.10 -66.70
  83.00 -66.50
  86.00 -66.50
  88.30 -66.20
  89.50 -66.80
  92.00 -66.50
  94.70 -66.60
  98.10 -65.80
  99.60 -65.80
 100.20 -66.00
 101.00 -66.20
 102.50 -65.50
 104.10 -65.60
 106.00 -66.20
 109.10 -66.80
 109.40 -66.60
 111.00 -66.00
 113.90 -65.80
 115.80 -66.60
 118.00 -66.80
 121.50 -66.80
 123.30 -66.70
 125.50 -66.40
 127.00 -66.20
 128.40 -67.00
 130.00 -66.50
 132.00 -66.20
 134.00 -66.10
 136.00 -66.10
 138.00 -66.40
 140.00 -66.70
 142.00 -66.80
 143.50 -66.90
 144.50 -67.00
 145.30 -67.00
 145.40 -67.50
 147.80 -67.70
 147.60 -67.30
 148.30 -67.30
 148.80 -67.70
 147.90 -68.30
 149.00 -68.30
 151.20 -68.30
 153.00 -68.70
 155.00 -68.90
 157.00 -69.10
 159.00 -69.30
 161.00 -69.60
 162.70 -70.00
 163.20 -70.20
 164.00 -70.70
 166.00 -70.60
 168.00 -71.00
 170.00 -71.60
 170.20 -71.20
 171.30 -71.80
 170.40 -72.50
 169.00 -73.00
 169.30 -73.50
 166.00 -74.20
 165.50 -74.50
 164.00 -75.00
 164.80 -75.60
 163.00 -75.50
 163.00 -76.50
 164.00 -75.50
 166.50 -77.90
 166.50 -77.20
 170.00 -77.40
 173.00 -77.60
 177.00 -77.90
 180.00 -78.30
 174.70 -41.30
 175.20 -41.40
 175.70 -41.50
 176.50 -40.50
 177.00 -39.60
 177.10 -39.20
 178.00 -39.00
 178.40 -38.00
 178.30 -37.50
 177.50 -38.00
 176.50 -37.80
 175.90 -37.30
 175.40 -36.50
 175.40 -37.20
 174.70 -36.70
 174.50 -36.00
 174.00 -35.10
 173.50 -34.90
 173.20 -35.00
 173.00 -34.40
 173.10 -35.10
 173.40 -35.50
 174.00 -36.30
 174.50 -37.00
 174.80 -37.50
 174.70 -38.50
 174.10 -39.00
 173.80 -39.40
 174.30 -39.80
 175.10 -40.00
 175.00 -40.80
 174.70 -41.30
 174.30 -41.30
 174.00 -40.90
 173.40 -41.10
 173.00 -40.80
 172.70 -40.50
 172.10 -40.80
 172.00 -41.40
 171.40 -42.00
 170.50 -43.00
 169.50 -43.60
 168.80 -44.00
 168.00 -44.30
 167.00 -45.00
 166.20 -46.00
 167.00 -46.50
 167.40 -47.40
 168.20 -47.00
 169.00 -46.80
 169.80 -46.00
 170.70 -45.00
 171.20 -44.30
 172.00 -44.00
 173.00 -43.90
 172.70 -43.40
 172.70 -43.20
 173.20 -42.80
 174.00 -42.00
 174.10 -41.60
 174.30 -41.30
 -20.00  63.50
 -18.20  63.40
 -16.80  63.80
 -15.00  64.30
 -13.50  65.00
 -13.50  65.50
 -14.80  65.80
 -15.00  66.10
 -15.50  66.20
 -16.50  66.60
 -17.10  66.20
 -18.30  66.20
 -18.70  66.20
 -19.10  66.10
 -19.50  65.80
 -20.30  65.60
 -21.00  65.30
 -21.40  66.10
 -22.50  66.40
 -23.00  66.40
 -22.90  66.20
 -22.40  66.00
 -23.80  66.00
 -24.00  65.40
 -23.00  65.50
 -22.80  65.20
 -21.80  65.10
 -23.00  65.00
 -24.00  64.80
 -22.30  64.80
 -21.70  64.20
 -22.70  63.80
 -21.20  63.80
 -20.00  63.50
 -84.50  46.60
 -84.80  47.00
 -85.00  47.50
 -85.70  47.90
 -86.30  48.70
 -87.50  48.90
 -88.20  49.00
 -89.00  48.50
 -90.00  47.80
 -91.00  47.30
 -92.10  46.70
 -91.00  47.00
 -90.90  46.60
 -89.80  46.80
 -89.00  47.00
 -88.00  47.40
 -88.40  46.90
 -87.40  46.50
 -86.50  46.40
 -86.00  46.50
 -85.00  46.70
 -84.60  46.50
 -84.50  46.60
 -84.00  46.00
 -85.00  46.00
 -86.00  46.00
 -87.00  45.90
 -87.80  45.00
 -87.40  45.00
 -87.20  45.00
 -87.80  44.00
 -87.90  43.00
 -87.80  42.00
 -87.00  41.70
 -86.20  42.50
 -86.40  43.50
 -86.20  44.50
 -85.80  45.10
 -85.20  44.80
 -85.00  45.30
 -84.80  45.80
 -84.30  45.70
 -83.50  45.40
 -83.30  44.50
 -83.90  43.90
 -83.50  43.70
 -82.90  44.10
 -82.80  44.00
 -82.40  43.00
 -81.80  43.40
 -81.80  44.00
 -81.30  44.70
 -81.70  45.20
 -81.00  44.80
 -80.00  44.50
 -80.30  45.50
 -81.00  45.90
 -82.00  46.10
 -83.00  46.20
 -83.80  46.20
 -84.00  46.00
 -78.90  42.90
 -79.50  42.90
 -80.30  42.70
 -81.00  42.70
 -82.00  42.20
 -83.00  42.00
 -83.00  41.60
 -82.00  41.50
 -81.30  41.70
 -80.50  42.00
 -80.00  42.20
 -79.00  42.70
 -78.90  42.90
 -78.00  43.30
 -77.20  43.20
 -76.50  43.50
 -76.20  43.70
 -76.20  44.00
 -76.20  44.20
 -77.00  44.00
 -77.70  44.00
 -78.50  43.90
 -79.50  43.60
 -79.70  43.20
 -79.30  43.10
 -78.50  43.30
 -78.00  43.30
  57.00  70.60
  56.30  70.60
  55.50  70.60
  54.60  70.80
  53.70  71.10
  53.40  71.50
  51.50  71.40
  51.70  72.10
  52.60  72.50
  52.30  72.70
  53.00  73.10
  54.40  73.60
  53.80  73.80
  55.50  74.20
  56.00  75.00
  56.00  75.20
  57.70  75.30
  60.00  76.00
  61.00  76.30
  62.40  76.20
  66.00  76.60
  67.00  77.00
  69.00  76.80
  68.30  76.20
  68.00  76.20
  64.00  75.70
  60.80  75.00
  60.00  74.60
  58.00  74.00
  56.50  73.20
  55.50  72.50
  55.80  71.50
  57.80  70.80
  57.00  70.60
  24.60  77.90
  22.70  77.20
  20.90  77.40
  20.50  78.40
  19.30  78.60
  18.50  78.00
  17.60  77.40
  16.80  76.60
  14.00  77.50
  14.00  77.70
  16.00  78.30
  15.00  78.50
  13.00  78.20
  11.50  79.00
  12.00  79.80
  14.00  79.80
  15.50  79.30
  16.50  80.10
  20.00  80.50
  23.00  80.40
  24.50  80.30
  26.00  79.50
  21.00  79.40
  19.00  79.30
  21.00  78.80
  22.30  78.50
  23.30  78.30
  24.60  77.90
 100.00  78.90
  96.00  79.10
  93.50  79.60
  92.00  79.70
  94.10  80.00
  93.00  80.60
  96.00  81.30
  97.00  80.70
 100.00  79.90
 100.00  78.90
 100.00  78.50
 100.50  78.00
 104.00  78.20
 105.70  78.60
 102.50  79.50
 101.00  79.00
 100.00  78.50
 -55.40  51.60
 -56.70  51.30
 -57.60  50.40
 -58.20  49.40
 -58.70  48.60
 -59.00  48.10
 -59.30  47.60
 -58.00  47.70
 -56.70  47.60
 -55.50  47.50
 -55.00  47.50
 -56.00  47.00
 -55.90  46.80
 -55.00  47.20
 -54.50  47.50
 -53.90  47.50
 -54.10  46.80
 -53.60  46.60
 -52.90  47.00
 -52.60  47.50
 -52.80  47.80
 -53.00  47.60
 -53.20  47.70
 -53.30  48.00
 -53.60  47.50
 -53.60  48.20
 -53.00  48.50
 -53.90  48.90
 -54.00  49.50
 -55.00  49.40
 -56.60  49.60
 -55.50  50.00
 -56.80  49.60
 -56.20  50.50
 -55.40  51.60
 -74.10  20.20
 -75.30  20.70
 -75.60  21.10
 -76.80  21.40
 -77.60  22.10
 -78.60  22.60
 -78.70  22.40
 -79.80  22.80
 -81.00  23.10
 -82.20  23.20
 -83.30  22.90
 -84.40  22.30
 -84.00  22.00
 -82.70  22.70
 -81.60  22.50
 -81.20  22.10
 -79.70  21.70
 -78.40  21.00
 -77.00  20.60
 -76.00  20.00
 -74.10  20.20
  49.50 -18.00
  49.00 -19.30
  48.50 -20.50
  48.40 -21.50
  48.00 -22.20
  47.70 -23.50
  47.20 -24.20
  46.70 -25.20
  45.70 -25.30
  45.20 -25.60
  44.50 -25.20
  44.00 -25.10
  43.90 -24.60
  43.70 -24.00
  43.50 -23.20
  43.20 -22.60
  43.50 -21.60
  43.70 -21.20
  44.00 -20.70
  44.50 -19.50
  44.20 -18.60
  44.00 -18.00
  44.00 -17.60
  44.20 -17.00
  44.50 -16.60
  44.50 -16.20
  44.90 -16.20
  45.50 -15.80
  46.00 -15.80
  46.20 -15.60
  47.20 -15.10
  47.50 -14.60
  47.40 -15.00
  47.50 -15.10
  47.70 -14.30
  47.90 -14.10
  47.90 -13.80
  48.20 -13.50
  48.40 -13.80
  48.50 -13.50
  48.70 -13.30
  48.70 -13.10
  48.70 -12.30
  49.00 -12.50
  49.20 -12.30
  49.20 -12.00
  49.50 -12.30
  49.50 -12.60
  49.70 -12.80
  49.90 -13.00
  50.20 -13.80
  50.20 -14.60
  50.50 -15.30
  50.20 -16.00
  50.00 -15.60
  49.70 -15.30
  49.70 -15.80
  49.90 -16.20
  49.70 -16.70
  49.50 -17.20
  49.50 -18.00
  80.80   6.00
  81.30   6.10
  81.80   6.80
  81.90   7.30
  81.50   7.80
  81.40   8.10
  81.10   8.50
  80.90   9.00
  80.40   9.60
  80.00   9.80
  79.80   9.60
  80.10   9.50
  80.00   9.30
  79.90   8.80
  79.80   8.50
  79.80   7.50
  80.00   6.40
  80.80   6.00
  80.80   6.00
-155.80  20.20
-155.50  20.20
-155.10  19.80
-155.00  19.70
-155.00  19.30
-155.60  19.00
-155.80  19.10
-156.00  19.70
-155.80  20.00
-155.80  20.20
 -67.10  18.00
 -65.80  18.00
 -65.50  18.20
 -66.00  18.50
 -67.10  18.50
 -67.10  18.20
 -67.10  18.00
 -77.80  18.00
 -78.00  18.20
 -78.30  18.50
 -77.50  18.50
 -76.30  18.20
 -76.50  17.80
 -76.90  17.70
 -77.00  17.80
 -77.30  17.70
 -77.80  18.00
 -70.00  18.30
 -68.90  18.30
 -68.50  18.20
 -68.50  18.30
 -68.90  19.00
 -69.50  19.20
 -69.10  19.20
 -69.90  19.30
 -70.00  19.70
 -70.30  19.70
 -70.50  19.70
 -71.10  19.70
 -71.80  19.70
 -73.10  19.80
 -73.40  19.70
 -72.60  19.60
 -72.30  18.70
 -72.50  18.60
 -73.50  18.50
 -74.50  18.70
 -74.10  18.30
 -73.80  18.10
 -73.50  18.20
 -72.50  18.20
 -72.00  18.20
 -71.60  17.70
 -71.00  18.20
 -70.50  18.30
 -70.00  18.20
 -70.00  18.30
 119.50  -5.00
 119.40  -4.50
 119.50  -4.00
 119.50  -3.50
 118.90  -3.50
 118.90  -2.70
 118.60  -2.50
 119.00  -2.40
 119.10  -2.00
 119.10  -1.70
 119.50  -1.00
 119.90  -0.80
 119.80  -0.60
 119.80  -0.10
 119.50   0.  
 119.80  -0.10
 119.90   0.10
 119.90   0.20
 120.00   0.50
 120.30   0.80
 120.40   1.00
 120.50   0.80
 120.60   1.00
 120.80   1.20
 121.00   1.20
 121.50   1.10
 122.50   1.00
 123.00   0.80
 124.10   1.00
 124.30   1.20
 124.50   1.20
 124.50   1.30
 124.80   1.50
 125.00   1.70
 125.10   1.70
 125.30   1.50
 125.00   1.10
 124.50   0.50
 123.30   0.30
 122.00   0.50
 121.60   0.50
 121.00   0.40
 120.60   0.50
 120.10   0.30
 120.00   0.  
 120.00  -0.60
 120.50  -1.10
 120.60  -1.30
 121.00  -1.30
 121.10  -1.20
 121.50  -0.80
 122.10  -0.80
 122.90  -0.60
 123.00  -0.50
 123.50  -0.60
 123.30  -1.10
 122.80  -0.80
 122.40  -1.50
 121.60  -1.80
 121.50  -1.70
 121.30  -2.00
 121.50  -2.20
 121.80  -2.20
 122.00  -2.70
 122.30  -3.00
 122.40  -3.20
 122.10  -3.50
 122.60  -2.90
 122.60  -4.00
 122.80  -4.10
 122.90  -4.00
 122.60  -4.40
 122.60  -4.50
 122.00  -4.50
 122.00  -4.80
 121.50  -4.80
 121.50  -4.30
 121.30  -4.00
 120.90  -3.50
 121.00  -3.20
 121.00  -2.70
 121.00  -2.70
 120.10  -3.00
 120.40  -3.70
 120.40  -4.60
 120.50  -5.50
 120.10  -5.50
 119.80  -5.60
 119.50  -5.50
 119.40  -5.10
 119.50  -5.00
 142.00  46.00
 142.00  46.90
 142.10  47.20
 142.00  46.70
 142.00  48.50
 142.00  48.90
 142.10  50.20
 142.30  51.00
 141.80  51.70
 141.60  51.70
 141.80  52.50
 141.80  53.40
 142.30  53.40
 142.50  53.70
 142.10  54.20
 142.60  54.40
 143.00  54.00
 143.30  53.00
 143.10  52.40
 143.10  52.00
 143.30  51.70
 144.00  50.00
 144.30  49.20
 144.60  48.90
 144.60  48.70
 144.60  48.50
 144.10  49.20
 143.00  49.20
 142.60  48.00
 142.60  47.50
 143.10  47.00
 143.50  46.70
 143.30  46.00
 143.30  46.50
 142.80  46.50
 142.50  46.50
 142.10  45.90
 142.00  46.00
 105.10  -6.90
 106.30  -7.00
 106.50  -7.00
 106.40  -7.40
 107.50  -7.50
 108.50  -7.80
 109.00  -7.80
 110.00  -7.90
 111.00  -8.10
 112.40  -8.30
 113.00  -8.30
 114.00  -8.60
 114.30  -8.80
 114.50  -8.60
 114.40  -8.00
 114.00  -7.60
 113.00  -7.60
 112.80  -7.30
 112.50  -6.90
 111.90  -6.80
 111.50  -6.50
 111.40  -6.60
 111.00  -6.40
 110.40  -7.00
 110.00  -6.90
 109.50  -6.80
 109.00  -6.80
 108.30  -6.30
 108.00  -6.30
 107.60  -6.30
 107.00  -6.00
 106.60  -6.00
 106.00  -6.00
 106.00  -5.90
 105.80  -6.30
 105.60  -6.50
 105.40  -6.60
 105.10  -6.90
 105.80  -5.80
 105.90  -4.50
 105.90  -3.90
 105.80  -3.70
 106.00  -3.20
 105.90  -3.00
 105.60  -2.70
 105.50  -2.50
 104.60  -2.20
 104.60  -2.00
 104.50  -1.70
 104.00  -1.00
 103.30  -0.60
 103.80  -0.30
 103.50   0.  
 103.80   0.30
 103.30   0.60
 102.90   0.60
 102.10   1.00
 102.00   1.30
 101.50   1.60
 101.30   2.00
 101.00   2.20
 100.80   2.20
 100.90   2.00
 100.50   2.20
 100.10   2.70
 100.00   2.90
  99.50   3.40
  98.60   3.70
  98.50   4.00
  98.30   4.40
  98.00   4.50
  97.50   5.30
  97.00   5.30
  96.00   5.30
  95.50   5.50
  95.10   5.50
  95.40   4.80
  96.30   4.00
  96.80   3.70
  97.10   3.20
  97.40   2.90
  97.60   2.40
  97.90   2.20
  98.50   1.80
  98.80   1.70
  98.60   1.50
  99.00   0.80
  99.10   0.30
  99.80  -0.30
 100.40  -1.00
 100.90  -2.20
 101.50  -3.20
 102.30  -4.00
 103.10  -4.50
 103.90  -5.00
 104.50  -6.00
 104.50  -5.80
 104.50  -5.50
 105.30  -5.50
 105.50  -5.80
 105.80  -5.80
 137.80  -8.00
 137.60  -8.30
 138.80  -8.30
 139.10  -8.10
 139.50  -8.10
 140.00  -8.10
 140.50  -8.60
 140.80  -9.10
 142.10  -9.10
 142.60  -9.30
 143.10  -9.10
 143.30  -8.60
 142.60  -8.30
 143.80  -8.10
 143.80  -8.00
 144.10  -7.80
 144.30  -7.60
 145.30  -7.90
 145.80  -8.00
 146.00  -8.10
 146.30  -8.60
 146.60  -9.00
 146.80  -9.30
 147.10  -9.30
 147.30  -9.50
 148.00 -10.10
 149.50 -10.30
 149.80 -10.50
 150.10 -10.60
 150.60 -10.50
 150.30 -10.30
 150.80 -10.30
 150.30 -10.10
 150.00 -10.10
 150.10  -9.60
 149.50  -9.60
 149.10  -9.30
 149.30  -9.00
 148.50  -8.60
 148.10  -8.10
 147.60  -7.90
 147.30  -7.50
 147.10  -7.10
 146.80  -6.90
 147.80  -6.60
 147.60  -6.10
 147.30  -5.90
 146.50  -5.50
 146.00  -5.40
 145.80  -4.80
 145.00  -4.30
 144.60  -3.70
 143.80  -3.70
 143.60  -3.50
 142.50  -3.20
 141.10  -2.50
 140.60  -2.50
 139.80  -2.40
 138.80  -1.80
 138.10  -1.70
 137.80  -1.50
 137.10  -1.80
 137.10  -2.00
 136.50  -2.20
 136.30  -2.20
 136.00  -2.70
 135.80  -3.00
 135.50  -3.20
 135.10  -3.40
 134.80  -2.90
 134.60  -2.50
 134.30  -2.50
 134.60  -2.70
 134.30  -2.50
 134.10  -1.70
 134.10  -1.50
 134.10  -1.20
 134.10  -0.80
 133.30  -0.60
 132.60  -0.40
 132.10  -0.50
 131.30  -1.00
 131.10  -1.20
 131.60  -1.50
 131.80  -1.80
 133.60  -2.20
 133.80  -2.00
 133.80  -2.50
 133.10  -2.40
 132.80  -2.70
 132.60  -2.70
 132.00  -2.70
 132.30  -2.90
 132.60  -3.40
 132.80  -3.50
 132.60  -3.70
 132.80  -4.00
 133.00  -4.00
 133.30  -3.70
 133.60  -3.50
 134.10  -3.70
 134.10  -4.00
 135.10  -4.40
 136.10  -4.50
 136.80  -4.90
 137.50  -5.10
 138.10  -5.40
 138.30  -6.00
 138.60  -6.60
 138.60  -6.90
 138.80  -7.30
 138.80  -7.40
 138.80  -7.40
 138.30  -7.40
 137.80  -8.00
-125.00  66.00
-124.90  66.30
-124.60  66.40
-123.50  66.40
-122.00  66.50
-121.10  66.80
-120.00  67.00
-119.00  66.80
-120.00  66.50
-120.00  66.30
-119.00  66.30
-118.40  66.40
-117.60  66.50
-118.00  66.10
-118.10  65.80
-119.00  65.80
-120.00  65.60
-119.50  65.50
-120.00  65.30
-121.00  64.80
-121.30  64.60
-121.40  64.90
-121.00  65.10
-120.30  65.40
-120.30  65.50
-121.10  65.50
-121.40  65.00
-122.60  65.00
-123.00  65.30
-122.90  65.50
-123.60  65.80
-122.30  66.00
-121.60  65.90
-121.10  66.00
-121.50  66.10
-123.00  66.30
-123.00  66.00
-124.00  66.00
-124.50  66.10
-124.80  66.00
-125.00  66.00
  48.20  42.00
  47.90  42.50
  47.70  42.70
  47.50  43.50
  47.50  43.90
  47.40  44.00
  47.00  44.20
  46.70  44.40
  47.00  44.70
  47.20  45.20
  47.50  45.50
  48.00  45.70
  48.50  45.90
  48.70  46.00
  49.20  46.20
  50.00  46.50
  50.90  47.00
  51.20  47.00
  51.70  46.90
  52.00  46.70
  52.20  46.90
  52.40  47.00
  53.20  46.70
  53.20  46.40
  53.20  46.20
  53.00  46.00
  53.20  45.70
  52.70  45.50
  53.20  45.40
  52.90  45.20
  52.20  45.40
  51.50  45.20
  51.20  45.20
  51.20  45.00
  51.20  44.50
  51.00  44.50
  50.20  44.50
  50.20  44.20
  50.90  44.00
  51.20  43.50
  51.70  43.20
  52.20  42.90
  52.70  42.70
  52.50  41.70
  52.50  41.50
  52.90  41.00
  52.70  40.50
  52.70  40.00
  53.00  39.70
  53.50  40.00
  53.50  39.50
  53.20  39.70
  53.20  39.20
  53.50  39.20
  54.00  38.90
  53.70  38.00
  54.00  37.20
  53.40  36.70
  53.20  36.70
  52.00  36.50
  50.90  36.70
  50.20  37.00
  49.90  37.40
  49.20  37.50
  48.90  38.20
  48.90  39.20
  49.00  39.20
  49.00  38.90
  49.20  39.20
  49.40  39.40
  49.40  39.70
  49.50  40.20
  49.90  40.40
  50.20  40.20
  50.40  40.40
  50.00  40.50
  49.50  40.70
  49.20  41.00
  48.70  41.70
  48.20  42.00
  74.00  45.00
  74.00  45.20
  73.60  45.40
  73.50  45.50
  73.50  45.50
  73.40  45.70
  73.50  45.70
  73.50  46.00
  73.80  46.20
  74.00  46.20
  74.00  46.40
  74.50  46.50
  75.00  46.70
  75.10  46.70
  75.80  46.70
  76.10  46.70
  77.00  46.50
  77.30  46.50
  77.50  46.70
  78.10  46.50
  78.40  46.50
  78.50  46.50
  78.80  46.70
  79.10  46.70
  79.30  46.70
  79.00  46.50
  78.40  46.40
  78.40  46.20
  78.00  46.20
  77.50  46.50
  76.50  46.50
  75.60  46.50
  74.90  46.40
  74.50  46.00
  74.50  46.00
  74.30  45.50
  74.00  45.40
  74.10  45.00
  74.00  45.00
  53.00  40.70
  53.00  40.90
  52.70  41.40
  52.70  41.70
  53.20  42.00
  53.90  42.00
  54.00  41.70
  54.50  41.20
  54.70  41.00
  54.70  40.70
  54.50  40.70
  53.70  40.50
  53.70  40.70
  53.00  40.70
 103.60  51.70
 104.60  51.90
 106.00  52.50
 106.80  53.00
 107.50  53.50
 108.50  54.40
 109.00  55.00
 109.10  55.50
 110.00  55.70
 109.50  54.20
 109.40  53.90
 108.30  53.00
 107.50  52.70
 106.80  52.40
 106.50  52.40
 106.10  51.90
 105.40  51.50
 104.30  51.50
 103.60  51.70
  58.40  44.00
  58.20  44.20
  58.20  44.70
  58.40  45.20
  58.70  45.90
  59.00  45.90
  59.40  46.00
  59.20  45.90
  59.50  45.70
  59.50  46.20
  59.90  46.00
  60.00  46.20
  60.20  46.70
  60.70  46.50
  60.50  46.70
  60.70  46.50
  61.20  46.70
  61.20  46.70
  61.50  46.70
  61.50  46.50
  61.00  46.00
  61.20  45.50
  61.50  45.20
  61.70  45.00
  62.00  45.00
  61.00  44.50
  61.00  43.50
  60.20  43.50
  59.70  43.40
  59.70  43.50
  59.50  43.70
  59.00  43.70
  58.70  43.90
  59.00  43.70
  58.40  44.00
 145.00 -40.70
 145.60 -41.00
 146.60 -41.20
 147.50 -41.00
 147.80 -40.90
 148.10 -40.70
 148.30 -41.50
 148.10 -42.00
 147.80 -42.70
 148.00 -43.20
 147.60 -42.70
 147.30 -43.00
 147.00 -43.50
 146.60 -43.50
 146.00 -43.50
 145.80 -43.20
 145.30 -42.50
 145.00 -41.70
 144.60 -41.00
 145.00 -40.70
-116.00  60.70
-114.80  60.90
-114.30  61.00
-113.60  61.00
-113.30  61.50
-113.00  61.40
-111.50  62.00
-110.80  62.40
-110.00  62.50
-110.50  62.70
-111.30  62.50
-111.50  62.50
-111.00  62.70
-110.00  62.70
-109.00  62.70
-109.80  62.90
-111.00  62.70
-111.50  62.50
-112.00  62.20
-113.30  62.00
-114.00  62.20
-115.00  62.50
-115.90  62.70
-115.60  62.50
-115.10  62.50
-115.00  62.20
-114.50  61.90
-115.00  61.70
-116.00  61.20
-116.40  61.00
-116.00  60.70
</world>;
	}
	
}