/**
 * Copyright Hasufel ( http://wonderfl.net/user/Hasufel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Bf2
 */

package {
    //********************************************************
    //1k Lemmings: animated bitmaps with variable framerates
    //runs @60 fps under 1.3ghz Atom
    //runs @45 fps (Android Froyo 2.2) under Snapdragon 1 Ghz
    //lemmings animation is 8 frames of 6*10 pixels
    //@by Hasufel 2010
    //*******************************************************/
        
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;
    import flash.utils.getTimer;
    import flash.utils.Timer;
    import net.hires.debug.Stats;

    [SWF(width=465, height=465, backgroundColor=0,frameRate=60)]

    public class Lemming extends Sprite {
        private const _stageW:uint = stage.stageWidth;
        private const _stageH:uint = stage.stageHeight;
        private const _graphicsData:Array =["89504e470d0a1a0a0000000d49484452000000300000000a0806000000f2e3dd4c0000001974455874536f6674776172650041646f626520496d616765526561647971c9653c0000010e4944415478dab495d111c2200c861326d011ea188e6037d04757700c57f05137d071ec08ba416c8aa91002ca1de60ea93fe123f9f12a1011e4c61457a0702ee5d78e167c9c3e6ef8a6f9a00d21cf91de03cecf7c187f97390c29a8f7ec84d398ef22f0fa0ec906d17508c8d0a67c63fd1f7c7f0388408ffb67c3a2f30e291d97abc82506595ac2199d36f5167cb966066df714fd0eb51eb936ea32b4fe8dd392efa0109cbc3b74a6ce33af450e158273cfc7a14a4f6ec508071511ba916bccd239b8c8dc9ac5ffd508572ac8ea5e1f125e7fc9ad52f1b935d6ada6c27c57ea5c8abb9c1039870be491733f6c267caee1ebbd72568e9fbc851832ffc93c07d2ce8679bab84433de36adf92f01060061a1bafe090c09b10000000049454e44ae426082"];
        private var _renderData:BitmapData = new BitmapData(_stageW,_stageW,true,0xFFFFFFFF);
        private var _renderRect:Rectangle = new Rectangle(0,0,_stageW,_stageH);
        private var _loader:Loader;
        private var _assetsMemoryBank:Vector.<BitmapData> = new Vector.<BitmapData>;
        private var _assetsNum:uint = 0;
        private var _lemmingsNum:uint = 1000;
        private var _lemmings:Vector.<LemmingSprite> = new Vector.<LemmingSprite>(_lemmingsNum, true);

        public function Lemming (){
            setProps(stage, {quality:StageQuality.LOW,scaleMode:StageScaleMode.NO_SCALE,align:StageAlign.TOP_LEFT});
            var blackBg:Bitmap = new Bitmap(new BitmapData(465,465,false,0x000000));
            addChild(blackBg);
            prepareAsset(0);
        }

        private function prepareAsset(n:int):void{
            var bytes:ByteArray = new ByteArray();
            var data1:Array=_graphicsData[n].split("");
            var data2:Array=[];
            var d1l:int = data1.length;
            for (var i:int=0;i<d1l;i+=2){
                data2.push("0x"+data1[i]+data1[i+1]);
            }
            var d2l:int = data2.length;
            for (var j:int=0;j<d2l;j++){
                bytes[j] = data2[j];
            }
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE,assetLoaded);
            _loader.loadBytes(bytes);
        }

        private function assetLoaded(event:Event):void {
            var t:BitmapData = new BitmapData(_loader.content.width,_loader.content.height,true,0x00FFFFFF);
            t.draw(_loader.content,new Matrix());
            _assetsMemoryBank.push(t);
            _assetsNum++;
            if (_assetsNum<_graphicsData.length) {prepareAsset(_assetsNum);}
            else {initAnimation();}
        }

        private function initAnimation():void {
            addChild(new Bitmap(_renderData)) as Bitmap;
            addChild( new Stats() );
            for (var i:uint=0;i<_lemmingsNum;i++){
                _lemmings[i]=createLemming(randomNumber(0,_stageW),randomNumber(0,_stageH),[0,1,2,3,4,5,6,7],_assetsMemoryBank[0],70,randomNumber(0,8),6);
            }
            addEventListener(Event.ENTER_FRAME, renderDisplay);
        }

        private function renderDisplay(e:Event):void {
            var t:uint = getTimer();
            var z:uint=_lemmingsNum;
            _renderData.lock();
            _renderData.fillRect(_renderRect,0x00FFFFFF);
            while(z--){
                var a:LemmingSprite = _lemmings[z];
                a.x+=.4;
                if (t - a.ti >=a.spd){
                    a.im = (++a.im)%a.imArL; //update frame to display
                    a.ti = t; //update inner time
                }
                _renderData.copyPixels(a.bmd,new Rectangle(a.imAr[a.im]*a.imW,0,a.imW,a.imH),new Point(a.x,a.y),null, null, true);//null, null, true for transparency
                if (a.x>_stageW) {a.x = -6;}
            }
            _renderData.unlock();
        }

        private function createLemming(x:Number,y:Number,imAr:Array,bmd:BitmapData,spd:uint,im:uint,imW:uint):LemmingSprite {
            var p:LemmingSprite=new LemmingSprite();
            setProps(p, {x:x,y:y,imAr:imAr,imArL:imAr.length,bmd:bmd,spd:spd,ti:getTimer(),im:im,imW:imW,imH:bmd.height});
            return( p );
        }

        private function randomNumber(low:uint, high:uint):uint{
            return Math.round(Math.random() * (high - low) + low);
        }

        private function setProps(o:*,p:Object):void {
            for (var k:String in p) {o[k]=p[k];}
        }
    }
}

import flash.display.BitmapData;
class LemmingSprite {
    public var x:Number;//x
    public var y:Number;//y
    public var imAr:Array;//frames array
    public var imArL:uint;//number of frames
    public var bmd:BitmapData;//bitmapData reference
    public var spd:uint;//frequence in ms of animation
    public var ti:uint;//inner time
    public var im:uint;//current frame counter
    public var imW:uint;//width for subdivision
    public var imH:uint;//height for subdivision
}