/**
 * Copyright noenoe ( http://wonderfl.net/user/noenoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1BeJ
 */

package {
    /*
    Lightwave3DのオブジェクトをColladaで出力して
    Papervisionに読み込むと、どんな大きさで表示されるかのテスト。
    
    1メートル角のオブジェクトを表示したらこの有り様。
    画面の中央に小さな点が見えるんだけど、これです。
    つまり1ピクセル。Pv3DのCubeでいうと、１ｘ１ｘ１。
    
    http://www.ahiru.org/archives/260
    
    */
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
 
    import flash.display.Sprite;
    
    import flash.events.Event;
    public class FlashTest extends Sprite {
        private var _viewport:Viewport3D;
        private var _camera:Camera3D;
        private var _scene:Scene3D;
        private var _render:BasicRenderEngine;
        
        private var _cube:DAE;
        
        public function FlashTest() {
            // write as3 code here..
            
        
            if(stage){
                _init();
            }else{
                addEventListener(Event.ADDED_TO_STAGE, _init);
            }
        }
        
        /****************************************************************
         * 
         * 初期化
         * 
         * 
         * 
         */
        private function _init(e:Event = null):void{
            removeEventListener(Event.ADDED_TO_STAGE, _init);
            
            _viewport = new Viewport3D(stage.stageWidth,stage.stageHeight);
            this.addChild(_viewport);
            
            _scene = new Scene3D();
            _render = new BasicRenderEngine();
            _camera = new Camera3D(45,1000,10000,true);
            
            _cube = new DAE();
            _cube.load(_cubeDAE);
            _scene.addChild(_cube);
            
            _camera.target = _cube;
            
            
            this.addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }
        
        /****************************************************************
         * 
         * EnterFrameを処理
         * 
         * 
         * 
         */
        private function _onEnterFrame(e:Event):void{
            _cube.rotationY += 2;
            _render.renderScene(_scene, _camera, _viewport);
            
        }
        
        /****************************************************************
         * 
         * Unwrap3Dから出力したCube（1メートル角）
         * 
         * 
         * 
         */
        private var _cubeDAE:XML = 
        <COLLADA xmlns="http://www.collada.org/2005/11/COLLADASchema" version="1.4.1">
          <asset>
            <contributor>
              <author>Ultimate Unwrap3D</author>
              <authoring_tool>Ultimate Unwrap3D v2.50.05</authoring_tool>
              <comments>Exported from Ultimate Unwrap3D on Sun Feb 21 23:57:11 2010</comments>
              <source_data>cube_1m.dae</source_data>
            </contributor>
            <created>2010-02-21T14:57:11Z</created>
            <modified>2010-02-21T14:57:11Z</modified>
            <unit meter="1" name="meter"/>
            <up_axis>Y_UP</up_axis>
          </asset>
          
          <library_geometries>
            <geometry id="geomU3D_id" name="geomU3D">
              <mesh>
                <source id="PositionSrc_id" name="PositionSrc">
                  <float_array id="PositionSrc_id-array" count="24">-0.5 -0.5 0.5 0.5 -0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 0.5 -0.5</float_array>
                  <technique_common>
                    <accessor source="#PositionSrc_id-array" count="8" stride="3">
                      <param name="X" type="float"/>
                      <param name="Y" type="float"/>
                      <param name="Z" type="float"/>
                    </accessor>
                  </technique_common>
                </source>
                <source id="NormalSrc_id" name="NormalSrc">
                  <float_array id="NormalSrc_id-array" count="24">-0.57735 -0.57735 0.57735 0.57735 -0.57735 0.57735 0.57735 -0.57735 -0.57735 -0.57735 -0.57735 -0.57735 -0.57735 0.57735 0.57735 0.57735 0.57735 0.57735 0.57735 0.57735 -0.57735 -0.57735 0.57735 -0.57735</float_array>
                  <technique_common>
                    <accessor source="#NormalSrc_id-array" count="8" stride="3">
                      <param name="X" type="float"/>
                      <param name="Y" type="float"/>
                      <param name="Z" type="float"/>
                    </accessor>
                  </technique_common>
                </source>
                <source id="ColorSrc_id" name="ColorSrc">
                  <float_array id="ColorSrc_id-array" count="32">0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1</float_array>
                  <technique_common>
                    <accessor source="#ColorSrc_id-array" count="8" stride="4">
                      <param name="R" type="float"/>
                      <param name="G" type="float"/>
                      <param name="B" type="float"/>
                      <param name="A" type="float"/>
                    </accessor>
                  </technique_common>
                </source>
                <source id="Tex1Src_id" name="Tex1Src">
                  <float_array id="Tex1Src_id-array" count="48">0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0</float_array>
                  <technique_common>
                    <accessor source="#Tex1Src_id-array" count="24" stride="2">
                      <param name="S" type="float"/>
                      <param name="T" type="float"/>
                    </accessor>
                  </technique_common>
                </source>
                <source id="Tex2Src_id" name="Tex2Src">
                  <float_array id="Tex2Src_id-array" count="48">0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0</float_array>
                  <technique_common>
                    <accessor source="#Tex2Src_id-array" count="24" stride="2">
                      <param name="S" type="float"/>
                      <param name="T" type="float"/>
                    </accessor>
                  </technique_common>
                </source>
                <vertices id="geomU3D_id-vertices">
                  <input semantic="POSITION" source="#PositionSrc_id"/>
                </vertices>
                <triangles count="0">
                  <input semantic="VERTEX" source="#geomU3D_id-vertices" offset="0"/>
                  <input semantic="NORMAL" source="#NormalSrc_id" offset="1"/>
                  <input semantic="COLOR" source="#ColorSrc_id" offset="2" set="0"/>
                  <input semantic="TEXCOORD" source="#Tex1Src_id" offset="3" set="0"/>
                  <input semantic="TEXCOORD" source="#Tex2Src_id" offset="4" set="1"/>
                  <p/>
                </triangles>
                <polylist material="VisualMaterial0" count="6">
                  <input semantic="VERTEX" source="#geomU3D_id-vertices" offset="0"/>
                  <input semantic="NORMAL" source="#NormalSrc_id" offset="1"/>
                  <input semantic="COLOR" source="#ColorSrc_id" offset="2" set="0"/>
                  <input semantic="TEXCOORD" source="#Tex1Src_id" offset="3" set="0"/>
                  <input semantic="TEXCOORD" source="#Tex2Src_id" offset="4" set="1"/>
                  <vcount>4 4 4 4 4 4</vcount>
                  <p>3 3 3 0 0 2 2 2 1 1 1 1 1 2 2 0 0 0 3 3 1 1 1 4 4 5 5 5 5 5 4 4 4 6 6 0 0 0 7 7 2 2 2 8 8 6 6 6 9 9 5 5 5 10 10 1 1 1 11 11 7 7 7 12 12 6 6 6 13 13 2 2 2 14 14 3 3 3 15 15 4 4 4 16 16 7 7 7 17 17 3 3 3 18 18 0 0 0 19 19 5 5 5 20 20 6 6 6 21 21 7 7 7 22 22 4 4 4 23 23</p>
                </polylist>
              </mesh>
            </geometry>
          </library_geometries>
          <library_visual_scenes>
            <visual_scene id="VisualSceneNode" name="rootU3D">
              <node id="meshU3D_id" name="meshU3D" type="NODE">
                <translate>0 0 0</translate>
                <rotate>1 0 0 0</rotate>
                <scale>1 1 1</scale>
                <instance_geometry url="#geomU3D_id">
                  <bind_material>
                    <technique_common>
                      <instance_material symbol="VisualMaterial0" target="#VisualMaterial">
                        <bind_vertex_input semantic="UVSET0" input_semantic="TEXCOORD" input_set="0"/>
                      </instance_material>
                    </technique_common>
                  </bind_material>
                </instance_geometry>
              </node>
            </visual_scene>
          </library_visual_scenes>
          <scene>
            <instance_visual_scene url="#VisualSceneNode"/>
          </scene>
        </COLLADA>

    }
}