/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1BG9
 */

package   {
    
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Debug;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.Sorting;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.loaders.Parser3DS;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import flash.text.TextField;
    import flash.utils.ByteArray;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    /**
     * Saving of entire scene data into ByteArray. Press P key to save data to byteArray and 
     * output a Base64 string!
     */
    public class A3d7Serialization extends Sprite {
        
        private var rootContainer:Object3DContainer = new DistanceSortContainer();
        
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        
        private var distanceSortContainer:DistanceSortContainer;
        private var conflictContainer:ConflictContainer;
        
        public function A3d7Serialization() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            // Camera and view
            // Создание камеры и вьюпорта
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            // Initial position
            // Установка начального положения камеры
            camera.rotationX = -130*Math.PI/180;
            camera.y = -250;
            camera.z = 250;
            controller = new SimpleObjectController(stage, camera, 200);
            rootContainer.addChild(camera);
            
            setupScene();
            
            // Debug mode
            // Режим отладки
            camera.debug = true;
            camera.addToDebug(Debug.EDGES, Object3D);
            camera.addToDebug(Debug.BOUNDS, Object3D);
            
            // Listeners
            // Подписка на события

            stage.addEventListener(Event.RESIZE, onResize);

            
            run();
        }
        
        private function setupScene():void 
        {
            // Creating of containers
            // Создание контейнеров
            distanceSortContainer = new DistanceSortContainer();
            distanceSortContainer.x = -120;
            rootContainer.addChild(distanceSortContainer);
            
            conflictContainer = new ConflictContainer();
            conflictContainer.x = 120;
            rootContainer.addChild(conflictContainer);
            
            // Parsing of model
            // Парсинг модели
            var parser:Parser3DS = new Parser3DS();
            var byteArray:ByteArray = Base64.decodeToByteArray(embedModel);
            byteArray.uncompress();
            parser.parse(byteArray);
            
            var mesh:Mesh = parser.objects[0] as Mesh;
            //mesh.weldVerticesAndFaces(0.001, 0.001);
            mesh.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            mesh.sorting = Sorting.DYNAMIC_BSP;
            
            // Clone
            // Клонирование
            var box1:Mesh = mesh.clone() as Mesh;
            box1.x = -40;
            box1.y = -10;
            box1.scaleY = 0.6;
            box1.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            
            var box2:Mesh = mesh.clone() as Mesh;
            box2.x = -50;
            box2.y = 40;
            box2.rotationZ = Math.PI/2;
            box2.scaleY = 0.6;
            box2.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            
            var box3:Mesh = mesh.clone() as Mesh;
            box3.x = 25;
            box3.y = 50;
            box3.rotationZ = -0.6;
            box3.scaleY = 1.5;
            box3.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            
            var box4:Mesh = mesh.clone() as Mesh;
            box4.x = 80;
            box4.y = 65;
            box4.rotationZ = 0.5;
            box4.scaleY = 0.4;
            box4.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            
            var box5:Mesh = mesh.clone() as Mesh;
            box5.x = 30;
            box5.y = -48;
            box5.rotationZ = 2;
            box5.scaleY = 0.7;
            box5.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            
            var box6:Mesh = mesh.clone() as Mesh;
            box6.x = 50;
            box6.y = -40;
            box6.rotationZ = 1;
            box6.rotationY = -0.5;
            box6.scaleY = 0.6;
            box6.setMaterialToAllFaces( new FillMaterial(Math.random() * 0xFFFFFF, 1) );
            
            // Adding to containers
            // Добавление в контейнеры
            distanceSortContainer.addChild(box1.clone());
            distanceSortContainer.addChild(box2.clone());
            distanceSortContainer.addChild(box3.clone());
            distanceSortContainer.addChild(box4.clone());
            distanceSortContainer.addChild(box5.clone());
            distanceSortContainer.addChild(box6.clone());
            
            conflictContainer.addChild(box1.clone());
            conflictContainer.addChild(box2.clone());
            conflictContainer.addChild(box3.clone());
            conflictContainer.addChild(box4.clone());
            conflictContainer.addChild(box5.clone());
            conflictContainer.addChild(box6.clone());
            

        }
        
        private function run():void 
        {
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function saveScene():ByteArray {
            var byteArray:ByteArray = new ByteArray();
            
            var sceneSerializer:A3D7SceneSerializer = new A3D7SceneSerializer(rootContainer);
            sceneSerializer.writeExternal(byteArray);
            
            byteArray.position = 0;
            byteArray.compress();
        
            
            return byteArray;
        }
        
        private function onEnterFrame(e:Event):void {
            
            //distanceSortContainer.rotationZ += 0.002;
            //conflictContainer.rotationZ += 0.002;
            
            controller.update();
            camera.render();
        }
        
        private function onResize(e:Event = null):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            
            if (e.keyCode == Keyboard.TAB) {
                camera.debug = !camera.debug;
            }
            if (e.keyCode == 81) { // Q
                if (stage.quality == "HIGH") {
                    stage.quality = "LOW";
                } else {
                    stage.quality = "HIGH";
                }
            }
            
            if (e.keyCode == Keyboard.P) {
                var byteArray:ByteArray = saveScene();
                
                var str:String = Base64.encodeByteArray(byteArray);
                var field:TextField = new TextField();
                field.autoSize = "left";
                field.width = 600;
                field.text = str;
                addChild(field);
                
                /*
                var newScene:A3D7SceneSerializer  = new A3D7SceneSerializer();
                byteArray = Base64.decodeToByteArray(str);
                byteArray.uncompress();
                newScene.readExternal(byteArray);
                newScene.scene.addChild(camera);
                newScene.materials.loadTextureMaterials();
                */
                
            }
        }
        
        private var embedModel:String = "eNrFVl1MW2UYfluglFJooWM4/1ZwmxMBO9Qp03J6WsoYyM+AIZteuB9HTERMdPFnxjlZnFkzmdGR7MKkk6hcYGz82QVZnJAtarwYJotXXhkJerfojVFjfZ/vnLd+rW3lzi7fed7/73nf77Dz9fVd8xI5yUNEJbzCYV8lUUdY9PRHP/KTkgF+hNqCLcHOxw/vP/Lks+RP+thUQxX8nJmZCWarIU1dWVmJJKuRT25+esjUNKLBLG0oSxvO0ui8W7E6kWU9lXTx82TSo7RXDHq3LeM9RDRbyzgSHxvZMxRv7RncSbtn7dqzVgb/HJncyDPMODr5fGgbkTnOst/8jccwQnvbWxd//2vjUv/pqUjCbDVH3/AtTdZO7Vj9Y3LxwBlfVOyQYZf4K8Gr5obSp1U8ZImHjHiXIxgVO2JQB7lSX3KlvnBADHJFln2lJuzIFW5S0+u8ntlLOIhd6sMuNWGXvSRe7FJf4oVboV70uRXqS59nsR7X0q/eS77e9XMpNAf9vIrNZC3zkd71XnLt0oveV66s967PVrfr70kxWTgXkvWZSF+5duldn0murM9NcnW7zjkfn3xnWqiX3LnlnlHue5XPHjHnnPi7bzjWaWCmP11sN5xTPQawq/HljkvfbgpDh//PX/d0wP7p/JzCBfbBftSbVnGIh/25z4+p/OU3K4yZhRdUXeCZs2+rOPiRJzrigC9N71KIukDXyDqVL/vCDx37QYcfceBTcrFT6ZevDyk8+F2vkTgfVPj68qgBP/qAX/o5vjra8cMnQwqPn+s1vqk+oXDW71X+8Gtp5QeOfzCs6ny9uE/lN32/P1P3wnstap/QWIOqDx3x2B/x4IN46Ij/+NpBFd988mEVDx19dG99S/UFFB2zw7yA2FcQ/gPvBNScgaIf/Sqm+AGRJ4g8zA8IPoLIn7bPASg68uAHIk8QfuQiXt4XIPw4RyDOQ3T4FuxYvB+6Ln7ECyIPcUDEif6YuV2+XVm/f+uoJCtoJvjtbubPcxV/T128HCy7yE+1tJ5xPa1jGd/VSgowBqiUZRd/u31Uz1hPZSy7qJq8VMdYR+Usu/ge4eaPvkstJ68baAPdyL6b6Ga6hfFW2khBxgZqpNsYN9Fm2sJ4O22lOxib6E5mVU4t1Ep3MeIr7lS1tlEbYxXdTfcw3suMqxi3Mx+P4nUf3c/ooHbawfgAd+NQ/TxIYcYO7gv9GMzb4h8hU/UZpRhjJ/eLvuM29xrqop2M3Vy5jLGMdlEPYy973Ixueoj6GH3UTwOMg1zRx7hbscW/IRrmZ8icyL03NeO+wWElPFKULudiFbxNJY+yiofoY6I1TDfAlOqYVL09RGuE1gCt8VnDs0aHwQ2aFwhXOWuV2sttL7+9gvaK2Ot//0UG+DEw8dQTuHN1RXGXi102EkdeXFr+5XAUbyTRz6vjxpdX4kbilMfY12Xd1rpje20pGX2k658bXKZcm1bu0NX3o/PLry5a5VDmw/lm44tLRpFyj047DUp95uAra6qO9TLqM8eGY/H+OO6V5E5V2x1Aq0jJbdKZmsOZp6xbpj+FDe0bJc87nQ4oC8jKCqa2ZE3EkXdODammNUTh11ikHv5fsFZZaiLD08E8A9oxKKKbC5bRj6Mwef0Y9c2c+mZt/7mZfljFN5ND/hviE1B8";
        
    }
}


   import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.objects.Sprite3D;
    import flash.utils.describeType;
    import flash.utils.getQualifiedClassName;
    import flash.utils.IDataInput;
    import flash.utils.IDataOutput;
    import flash.utils.IExternalizable;
    import alternativ7.engine3d.alternativa3d;
    use namespace alternativa3d;
    /**
     * Binary scene serializer for A3D 7 onwards. Saves out entire scene in binary format which can be loaded again!
     * @author Glenn Ko
     */
    //public 
    class A3D7SceneSerializer implements IExternalizable
    {
        public var scene:Object3DContainer;
        public var materials:MaterialList;
        
        
        public function A3D7SceneSerializer(scene:Object3DContainer=null) 
        {
            this.scene = scene;
            RegisterAliases.check();
        }
        
        /* INTERFACE flash.utils.IExternalizable */
        
        public function writeExternal(output:IDataOutput):void 
        {
            // save out material list
            var matList:MaterialList = new MaterialList();
            MaterialList.current = matList;
            this.materials = matList;
            matList.collectMaterialsFromScene(scene);

            output.writeObject(matList);
            
            // save out class list of entire scene (reflection)
            var reflectMap:ReflectReadWrite = new ReflectReadWrite();
            ReflectReadWrite.current = reflectMap;
            describeObject3D(scene, reflectMap);
            describeContainer3D(scene, reflectMap);
            
            output.writeObject(reflectMap);
            
            // save out scene and it's descendant objects
            output.writeObject( new ExternalizableWrapper(scene) );
            writeContainer3D(scene, output);
        }
        
        public function readExternal(input:IDataInput):void 
        {
            MaterialList.current = this.materials = input.readObject();
            ReflectReadWrite.current = input.readObject();

            scene = (input.readObject() as ExternalizableWrapper).object;
            fillContainer(scene, input);
            
            
        }
        
        // -- Handy methods
        
        private function describeObject3D(obj:Object3D, reflectMap:ReflectReadWrite):void {
                //if (!reflectMap.cachedPropertyMaps[getQualifiedClassName(obj)]) {
                    var propMap:AbstractOrderedObject = reflectMap.propertyMap(obj);
                    
                    // this can be improved, (why not use "hasOwnProperty"??);
                    if (obj is Mesh) {  // only Mesh? may not be the case in the future...
                        propMap["vertexHeader"] = "vertexList";
                        propMap["faceHeader"] = "faceList";
                    }
                    else if (obj is Sprite3D) {
                        propMap["material"] = "material";
                    }
                //}
        
        }
        
        //recursive depth first traversal (consider: iterative..may be better in performance as it won't go so deep)
        private function describeContainer3D(cont:Object3DContainer, reflectMap:ReflectReadWrite):void {
            var lastObj:Object3D;
            for (var obj:Object3D = cont.childrenList; obj != null; obj = nextObj) {
                var nextObj:Object3D = obj.next;
                // Extended custom Mesh classes  must either extend from PublicMesh or implement IPublicMesh!
                if (obj is Mesh && !(obj is IPublicMesh) ) {  // do mesh replacement if required! 
                    obj._parent = null;
                    obj.next = null;
                    obj = PublicMesh.fromExistingMesh(obj as Mesh);
                    obj.next = nextObj;
                    obj._parent = cont;
                    if (lastObj != null) {
                        lastObj.next = obj;
                    }
                    else {
                        cont.childrenList = obj;
                    }
                }    
                describeObject3D(obj, reflectMap);
                
                if (obj is Object3DContainer) {
                    describeContainer3D(obj as Object3DContainer, reflectMap);
                }
                lastObj = obj;
            }
        }
        
        private function writeContainer3D(cont:Object3DContainer, output:IDataOutput):void {
            output.writeShort( cont.numChildren );
            for (var obj:Object3D = cont.childrenList; obj != null; obj = obj.next) {
                output.writeObject( new ExternalizableWrapper(obj) );
                if (obj is Object3DContainer) {
                    writeContainer3D(obj as Object3DContainer, output);
                }
            }
        }
        
        
        private function fillContainer(cont:Object3DContainer, input:IDataInput):void {
            var i:int = input.readShort();
            while (--i > -1) {
                var child:Object3D = cont.addChild( (input.readObject() as ExternalizableWrapper).object  );
                child.calculateBounds();
                var mesh:Mesh = child as Mesh;
                if (mesh != null) {
                    mesh.calculateFacesNormals();
                    mesh.calculateVerticesNormals();
                }
                if (child is Object3DContainer) {
                    fillContainer(child as Object3DContainer, input);
                }
            }
        }
        

        
    }

    /**
 * <p>Original Author:  jessefreeman</p>
 * <p>Class File: AbstractOrderedObject.as</p>
 *
 * <p>Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:</p>
 *
 * <p>The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.</p>
 *
 * <p>THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.</p>
 *
 * <p>Licensed under The MIT License</p>
 * <p>Redistributions of files must retain the above copyright notice.</p>
 *
 * <p>Revisions<br/>
 *        1.0.0  Initial version Feb 11, 2010</p>
 *
 */


    import flash.errors.IllegalOperationError;
    import flash.net.registerClassAlias;
    import flash.utils.IDataInput;
    import flash.utils.IDataOutput;
    import flash.utils.IExternalizable;
    import flash.utils.Proxy;
    import flash.utils.flash_proxy;

    /**
     * @author jessefreeman
     */
    dynamic class AbstractOrderedObject extends Proxy //implements IExternalizable
    {

        protected var properties:Object = new Object();

        protected var propertiesIndex:Array = new Array();

        /**
         *
         * <p>AbstractOrderedObject is a special object that keeps an ordered
         * list of each property added to it to allow ordered looping through
         * it's values. This assures that the order of the values set will be
         * correctly returned in the order expected.</p>
         *
         * @param properties
         * @param propertiesIndex
         *
         */
        public function AbstractOrderedObject()
        {
           
        

        }

        /**
         *
         * <p>Merges the properties of one group of properties with the current
         * instances values. The supplied properties have a higher importance and
         * will override any properties with the same name.</p>
         *
         * <p>It is important to note that this is a 1 to 1 copy so Arrays, Object
         * and other "complex" property values will not be cleanly copied over.
         * This is meant to be used when you know a merge is ok to have references
         * to the actualy object getting merged in.</p>
         *
         * @param style
         *
         */
        public function merge(object:Object):void
        {
            for (var prop:String in object)
            {
                this[prop] = object[prop];
            }
        }

        /**
         * @private
         */
        public function toString():String
        {
            var styleString:String = "{";
            var i:int;
            var total:int = propertiesIndex.length;
            var prop:String;
            for (i = 0; i < total; i++)
            {
                prop = propertiesIndex[i];
                styleString = styleString.concat(prop, ":", properties[prop].toString(), ";");
            }

            styleString = styleString.concat("}");

            return styleString;
        }

        /**
         * @private
         */
        protected function $deleteProperty(name:*):Boolean
        {
            var wasDeleted:Boolean = delete properties[name];
            if (wasDeleted)
            {
                propertiesIndex.splice(propertiesIndex.indexOf(name), 1);
            }
            return wasDeleted;
        }

        /**
         * @private
         *
         * @return
         *
         */
        protected function $setProperty(name:*, value:*):void
        {
            if (!properties.hasOwnProperty(name))
            {
                propertiesIndex.push(name.toString());
            }

            properties[name] = value;

        }

       

        /**
         *
         * @private
         *
         * @param name
         * @return
         *
         */
        flash_proxy override function deleteProperty(name:*):Boolean
        {
            return $deleteProperty(name);
        }

        /**
         *
         * @private
         *
         * @param name
         * @return
         *
         */
        flash_proxy override function getProperty(name:*):*
        {
            return properties[name];
        }

        /**
         *
         * @private
         *
         * @param name
         * @return
         *
         */
        flash_proxy override function hasProperty(name:*):Boolean
        {
            return properties.hasOwnProperty(name);
        }

        /**
         *
         * @private
         *
         * @param index
         * @return
         *
         */
        flash_proxy override function nextName(index:int):String
        {
            return propertiesIndex[index - 1];
        }

        /**
         *
         * @private
         *
         * @param index
         * @return
         *
         */
        flash_proxy override function nextNameIndex(index:int):int
        {
            if (index < propertiesIndex.length)
                return index + 1;
            else
                return 0;
        }

        /**
         *
         * @private
         *
         * @param index
         * @return
         *
         */
        flash_proxy override function nextValue(index:int):*
        {
            return properties[propertiesIndex[index - 1]];
        }

        /**
         *
         * @private
         *
         * @param name
         * @param value
         *
         */
        flash_proxy override function setProperty(name:*, value:*):void
        {
            $setProperty(name, value);
        }
        

    }

    /*
Base64 - 1.1.0

Copyright (c) 2006 Steve Webster

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions: 

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


    import flash.utils.ByteArray;
    
    class Base64 {
        
        private static const BASE64_CHARS:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

        public static const version:String = "1.1.0";

        public static function encode(data:String):String {
            // Convert string to ByteArray
            var bytes:ByteArray = new ByteArray();
            bytes.writeUTFBytes(data);
            
            // Return encoded ByteArray
            return encodeByteArray(bytes);
        }
        
        public static function encodeByteArray(data:ByteArray):String {
            // Initialise output
            var output:String = "";
            
            // Create data and output buffers
            var dataBuffer:Array;
            var outputBuffer:Array = new Array(4);
            
            // Rewind ByteArray
            data.position = 0;
            
            // while there are still bytes to be processed
            while (data.bytesAvailable > 0) {
                // Create new data buffer and populate next 3 bytes from data
                dataBuffer = new Array();
                for (var i:uint = 0; i < 3 && data.bytesAvailable > 0; i++) {
                    dataBuffer[i] = data.readUnsignedByte();
                }
                
                // Convert to data buffer Base64 character positions and 
                // store in output buffer
                outputBuffer[0] = (dataBuffer[0] & 0xfc) >> 2;
                outputBuffer[1] = ((dataBuffer[0] & 0x03) << 4) | ((dataBuffer[1]) >> 4);
                outputBuffer[2] = ((dataBuffer[1] & 0x0f) << 2) | ((dataBuffer[2]) >> 6);
                outputBuffer[3] = dataBuffer[2] & 0x3f;
                
                // If data buffer was short (i.e not 3 characters) then set
                // end character indexes in data buffer to index of '=' symbol.
                // This is necessary because Base64 data is always a multiple of
                // 4 bytes and is basses with '=' symbols.
                for (var j:uint = dataBuffer.length; j < 3; j++) {
                    outputBuffer[j + 1] = 64;
                }
                
                // Loop through output buffer and add Base64 characters to 
                // encoded data string for each character.
                for (var k:uint = 0; k < outputBuffer.length; k++) {
                    output += BASE64_CHARS.charAt(outputBuffer[k]);
                }
            }
            
            // Return encoded data
            return output;
        }
        
        public static function decode(data:String):String {
            // Decode data to ByteArray
            var bytes:ByteArray = decodeToByteArray(data);
            
            // Convert to string and return
            return bytes.readUTFBytes(bytes.length);
        }
        
        public static function decodeToByteArray(data:String):ByteArray {
            // Initialise output ByteArray for decoded data
            var output:ByteArray = new ByteArray();
            
            // Create data and output buffers
            var dataBuffer:Array = new Array(4);
            var outputBuffer:Array = new Array(3);

            // While there are data bytes left to be processed
            for (var i:uint = 0; i < data.length; i += 4) {
                // Populate data buffer with position of Base64 characters for
                // next 4 bytes from encoded data
                for (var j:uint = 0; j < 4 && i + j < data.length; j++) {
                    dataBuffer[j] = BASE64_CHARS.indexOf(data.charAt(i + j));
                }
                  
                  // Decode data buffer back into bytes
                outputBuffer[0] = (dataBuffer[0] << 2) + ((dataBuffer[1] & 0x30) >> 4);
                outputBuffer[1] = ((dataBuffer[1] & 0x0f) << 4) + ((dataBuffer[2] & 0x3c) >> 2);        
                outputBuffer[2] = ((dataBuffer[2] & 0x03) << 6) + dataBuffer[3];
                
                // Add all non-padded bytes in output buffer to decoded data
                for (var k:uint = 0; k < outputBuffer.length; k++) {
                    if (dataBuffer[k+1] == 64) break;
                    output.writeByte(outputBuffer[k]);
                }
            }
            
            // Rewind decoded data ByteArray
            output.position = 0;
            
            // Return decoded data
            return output;
        }
        
        public function Base64() {
            throw new Error("Base64 class is static container only");
        }
    }



    import flash.utils.ByteArray;
    import flash.utils.IDataInput;
    import flash.utils.IDataOutput;
    import flash.utils.IExternalizable;
    
    import alternativ7.engine3d.core.Face;
    import alternativ7.engine3d.core.Vertex;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.core.Wrapper;
    import alternativ7.engine3d.materials.Material;
    import alternativ7.engine3d.alternativa3d;
    use namespace alternativa3d;
    /**
     * ...
     * @author Glenn Ko
     */
    class DataIOProxy
    {
        public var input:IDataInput;
        public var output:IDataOutput;
        
        public function DataIOProxy(input:IDataInput, output:IDataOutput) 
        {
            setInputOutput(input, output);
        }
        
        public function setInputOutput(input:IDataInput, output:IDataOutput):void 
        {
            this.input = input;
            this.output = output;
        }
        
        public function setInput(input:IDataInput):void {
            this.input = input;
        }
        public function setOutput(output:IDataOutput):void {
            this.output = output;
        }
        
        /* flash.utils.IDataInput */
        
        public function readBoolean():Boolean 
        {
            return input.readBoolean();
        }
        
        public function readByte():int 
        {
            return input.readByte();
        }
        
        public function readDouble():Number 
        {
            return input.readDouble();
        }
        
        public function readFloat():Number 
        {
            return input.readFloat();
        }
        
        public function readInt():int 
        {
            return input.readInt();
        }
        
        public function readObject():* 
        {
            return input.readObject();
        }
        
        public function readShort():int 
        {
            return input.readShort();
        }
        
        public function readUnsignedByte():uint 
        {
            return input.readUnsignedByte();
        }
        
        public function readUnsignedInt():uint 
        {
            return input.readUnsignedInt();
        }
        
        public function readUnsignedShort():uint 
        {
            return input.readUnsignedShort();
        }
        
        public function readUTF():String 
        {
            return input.readUTF();
        }
        
        
        
        /* flash.utils.IDataOutput */
        
        public function writeBoolean(value:Boolean):void 
        {
            output.writeBoolean(value);
        }
        
        public function writeByte(value:int):void 
        {
            output.writeByte(value);
        }
        
        public function writeShort(value:int):void 
        {
            output.writeShort(value);
        }
        
        public function writeInt(value:int):void 
        {
            output.writeInt(value);
        }
        
        public function writeUnsignedInt(value:uint):void 
        {
            output.writeUnsignedInt(value);
        }
        
        public function writeFloat(value:Number):void 
        {
            output.writeFloat(value);
        }
        
        public function writeDouble(value:Number):void 
        {
            output.writeDouble(value);
        }
        
        
        public function writeUTF(value:String):void 
        {
            output.writeUTF(value);
        }
        
        public function writeUTFBytes(value:String):void 
        {
            output.writeUTFBytes(value);
        }
        
        public function writeObject(object:*):void 
        {
            output.writeObject(object);
        }
        
        
        // A3D  7 specific stuff
        
        public function writeVertexList(vertexList:Vertex):void {    
            
            var len:int = 0;
            for (var v:Vertex = vertexList; v != null; v = v.next) {
                len++;
            }
            output.writeInt(len);
            
            len = 0;
            for (v = vertexList; v != null; v = v.next) {
                output.writeFloat(v.x);
                output.writeFloat(v.y);
                output.writeFloat(v.z);
                
                output.writeFloat(v.u);
                output.writeFloat(v.v);
                v.index = len++;
            }
        }
        
        private var lastVertexStream:Vector.<Vertex> = new Vector.<Vertex>();
        
        public function readVertexList():Vertex {
            var head:Vertex;
            var len:int = input.readInt();
            if (len == 0) return null;
            
            var v:Vertex = new Vertex();
            head = v;
            v.x = input.readFloat();
            v.y = input.readFloat();
            v.z = input.readFloat();
            v.u = input.readFloat();
            v.v = input.readFloat();
            lastVertexStream[0] = v;
            v.index = 0;
            var tail:Vertex = v;
            
            for (var i:int = 1; i < len; i++) {
                v = new Vertex();
                v.x = input.readFloat();
                v.y = input.readFloat();
                v.z = input.readFloat();
                v.u = input.readFloat();
                v.v = input.readFloat();
                tail.next = v;
                tail = v;
                v.index = i;
                lastVertexStream[i] = v;
            }
            
            DUMMY_MESH.vertexList = head;
            return head;
        }
        
        private static var DUMMY_MESH:Mesh = new Mesh();
        public function writeFaceList(faceList:Face):void {
            var f:Face;
            var count:int;
            var w:Wrapper;
            
            count = 0;
            for (f = faceList; f != null; f = f.next) {
                count++;
            }
            output.writeInt(count);
            
            for (f = faceList; f != null; f = f.next) {
                count = 0;
                for (w = f.wrapper; w != null; w = w.next) {
                    count++;
                }
                output.writeInt(count);
                
                for (w = f.wrapper; w != null; w = w.next) {
                    output.writeInt( w.vertex.index );
                }
                
                writeMaterial(f.material);
            }
            
        }
        
        private static const verticesToRefer:Vector.<Vertex> = new Vector.<Vertex>();
        
        public function readFaceList():Face {
            const DUMMY_MESH:Mesh = DUMMY_MESH;
            DUMMY_MESH.faceList = null;
            
            var uLen:int;
            var m:int;
            
            var len:int = readInt();
            for (var i:int = 0; i < len; i++) {
                verticesToRefer.length = uLen =  input.readInt();
                for (var u:int = 0 ; u < uLen; u++) {
                    verticesToRefer[u] = lastVertexStream[input.readInt()];
                }
                var f:Face = DUMMY_MESH.addFace(verticesToRefer);
                f.material  = readMaterial();
            }
            
            return DUMMY_MESH.faceList;
        }
        
        public function writeMaterial(mat:Material):void { 
            output.writeInt( mat!=null ? MaterialList.current.vec.indexOf(mat)  : -1 );
        }
        
        public function readMaterial():Material 
        {
            var m:int = input.readInt();
            return m >= 0 ? MaterialList.current.vec[m] : null;
        }
        
        
        
    }




    import flash.utils.getDefinitionByName;
    import flash.utils.getQualifiedClassName;
    import flash.utils.IDataInput;
    import flash.utils.IDataOutput;
    import flash.utils.IExternalizable;
    /**
     * ...
     * @author Glenn Ko
     */
    class ExternalizableWrapper implements IExternalizable
    {
        private var _obj:Object;
        
        
        public function ExternalizableWrapper(obj:Object=null) 
        {
            _obj = obj;
            
        }
        
        /* INTERFACE flash.utils.IExternalizable */
        
        public function writeExternal(output:IDataOutput):void 
        {
            SerializableApplier.proxy.setOutput(output);
            const map:Object = SerializableApplier.MAP_WRITE;
            
            
            var index:int = ReflectReadWrite.current.classList.indexOf(getQualifiedClassName(_obj));
            if (index < 0) throw new Error("Valid class index not found in ReflectReadWrite class list!");
            output.writeInt( index );
            
            var orderedProps:AbstractOrderedObject = ReflectReadWrite.current.propertyMap(_obj);
            
            for (var prop:String in orderedProps) {
                
                var type:String = orderedProps[prop];
                if (map[type] != undefined) {
                
                    map[type]( _obj[prop] );
                }
                else {
                    output.writeObject( _obj[prop] );
                }
            }
        }
        
        public function readExternal(input:IDataInput):void 
        {
            SerializableApplier.proxy.setInput(input);
            const map:Object = SerializableApplier.MAP_READ;
            
            var index:int = input.readInt();

            // WonderFL hack to handle unpackaged classes (sob!)!!
            // I foresee if serializing KD/bsp tree , would need to resort to something like this!
            try {
                _obj = new (getDefinitionByName(ReflectReadWrite.current.classList[index]) as Class)();
            }
            catch (e:Error) {
                _obj =  new RegisterAliases.WONDER_FL[ReflectReadWrite.current.classList[index].split("::").pop()]();
            }
            
            var orderedProps:AbstractOrderedObject = ReflectReadWrite.current.propertyMaps[index];
            for (var prop:String in orderedProps) {
                var type:String = orderedProps[prop];
                _obj[prop] = map[type] != undefined ? map[type]() : input.readObject();
            }
        
        }
        
        public static function createList(arr:*):Vector.<ExternalizableWrapper> 
        {
            var len:int = arr.length;
            var vec:Vector.<ExternalizableWrapper> = new Vector.<ExternalizableWrapper>(len, true);
            for (var i:int = 0; i < len; i++) {
                vec[i] = new ExternalizableWrapper( arr[i] );
            }
            return vec;
        }
        
        public static function populateInto(vec:Vector.<ExternalizableWrapper>, arr:*):void {
            var len:int = vec.length;
            for (var i:int = 0; i < len; i++) {
                arr[i] = vec[i]._obj;
            }
        }
        
        public function get object():* 
        {
            return _obj;
        }
        
    }

    

    import alternativ7.engine3d.core.Face;
    import alternativ7.engine3d.core.Vertex;

    interface IPublicMesh 
    {
        function set vertexHeader(val:Vertex):void;
        function get vertexHeader():Vertex;
        function set faceHeader(val:Face):void;
        function get faceHeader():Face;
    }
    


    import alternativ7.engine3d.alternativa3d;
    import alternativ7.engine3d.core.EllipsoidCollider;
    import alternativ7.engine3d.core.Face;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.materials.Material;
    import alternativ7.engine3d.materials.TextureMaterial;
    import flash.geom.Vector3D;
    import flash.net.registerClassAlias;
    import flash.utils.Dictionary;
    import flash.utils.IDataInput;
    import flash.utils.IDataOutput;
    import flash.utils.IExternalizable;
    use namespace alternativa3d;
    /**
     * A saved out material list for loading and indexed referencing.
     * @author Glenn Ko
     */
    class MaterialList implements IExternalizable
    {
        private var hash:Object;
        alternativa3d var vec:Vector.<Material>;
        alternativa3d static var current:MaterialList = new MaterialList();
        
        public var textureMaterials:Vector.<TextureMaterial>;
        public var materialLoader:MaterialLoader;

        
        public function MaterialList(list:Vector.<Material> = null) 
        {
            setList( list ||  new Vector.<Material>() );
            
            registerClassAlias("alternativa.engine3d.materials.Material", Material);
            
        }
        
        public function getMaterialByName(name:String):Material {
            return hash[name];
        }
        
        public function setList(list:Vector.<Material>):void {
            vec = list;
            hash = { };
            textureMaterials =  new Vector.<TextureMaterial>();
        
            var len:int = list.length;
            for (var i:int = 0; i < len; i++) {
                var mat:Material = list[i];
                if (mat is TextureMaterial) textureMaterials.push(mat);
                if ( hash[mat.name] == undefined ) {
                    hash[mat.name] = i;
                }
                //else {
                //    throw new Error("Material found in list with duplicate name!");
                //}
            }
        }
        
        public function loadTextureMaterials():void {
            if (textureMaterials.length == 0) return;
            materialLoader = new MaterialLoader();
        
            materialLoader.load(textureMaterials);
        }
        
        /* INTERFACE flash.utils.IExternalizable */
        
        public function writeExternal(output:IDataOutput):void 
        {
            
            var readWriteMap:ReflectReadWrite = new ReflectReadWrite();
            var i:int = vec.length;
            while (--i > -1) {
                readWriteMap.propertyMap(vec[i]);
            }
            
            // write
            output.writeObject( readWriteMap );
            ReflectReadWrite.current = readWriteMap;
            
            output.writeObject( ExternalizableWrapper.createList(vec) );
        }
        
        public function readExternal(input:IDataInput):void 
        {
            // read
            var readWriteMap:ReflectReadWrite = input.readObject();
            ReflectReadWrite.current = readWriteMap;
        
            ExternalizableWrapper.populateInto(input.readObject(), vec);
            setList(vec);
        }
        
        // Other useful methods
        
        private static const COLLIDER:EllipsoidCollider = new EllipsoidCollider(999999999, 999999999, 999999999);
        
        
        public function collectMaterialsFromScene(scene:Object3DContainer):void {
            var materialDict:Dictionary = new Dictionary();
            var dummyContainer:DummyContainer = new DummyContainer();
            dummyContainer.addChild(scene);
            
            
    
            COLLIDER.getCollision( new Vector3D(), new Vector3D(2, 2, 2), new Vector3D(), new Vector3D(), dummyContainer);
            var collector:Vector.<Face> = dummyContainer.collectedFaceList;
            
            for each(var f:Face in collector) {
                if (f.material != null) materialDict[f.material] = true;
            }
            
            // should give unique naming if required
            var list:Vector.<Material> = new Vector.<Material>();
            for (var m:* in materialDict) {
                list.push(m);
            }
            
            dummyContainer.collectedFaceList = null;
            dummyContainer.removeChild(scene);
            
            setList(list);
        }
        
    }


import alternativ7.engine3d.alternativa3d;
import alternativ7.engine3d.core.Face;
import alternativ7.engine3d.core.Object3DContainer;
import flash.geom.Vector3D;
import flash.utils.Dictionary;
use namespace alternativa3d;

class DummyContainer extends Object3DContainer {
    
    public var collectedFaceList:Vector.<Face>;
    
    override alternativa3d function collectPlanes(center:Vector3D, a:Vector3D, b:Vector3D, c:Vector3D, d:Vector3D, collector:Vector.<Face> , excludedObjects:Dictionary = null):void {
        
        super.collectPlanes(center, a, b, c, d, collector, excludedObjects);
        
        collectedFaceList = collector.concat();
    }
}


    import alternativ7.engine3d.core.Face;
    import alternativ7.engine3d.core.Vertex;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.alternativa3d;
    use namespace alternativa3d;
    /**
     * This is necessary i guess to provide public namespace access to setup vertices/faces directly!
     * @author ...
     */
    class PublicMesh extends Mesh implements IPublicMesh
    {
        
        public function PublicMesh() 
        {
            
        }
        
        public function set vertexHeader(val:Vertex):void {
            vertexList = val;
        }
        public function get vertexHeader():Vertex {
            return vertexList;
        }
        public function set faceHeader(val:Face):void {
            faceList = val;
        }
        public function get faceHeader():Face {
            return faceList;
        }
        
        public static function fromExistingMesh(mesh:Mesh):PublicMesh {
            var pubMesh:PublicMesh = new PublicMesh();
            pubMesh.clonePropertiesFrom(mesh);
            return pubMesh;
        }
        
    }


    import flash.net.registerClassAlias;
    import flash.utils.Dictionary;
    import flash.utils.describeType;
    import flash.utils.getDefinitionByName;
    import flash.utils.getQualifiedClassName;
    import flash.utils.IDataInput;
    import flash.utils.IDataOutput;
    import flash.utils.IExternalizable;

    class ReflectReadWrite implements IExternalizable
    {
        public static var current:ReflectReadWrite;
        
        public var cachedPropertyMaps:Object = { };
        
        public var classList:Vector.<String> = new Vector.<String>();
        public var propertyMaps:Vector.<AbstractOrderedObject> = new Vector.<AbstractOrderedObject>;
        
        public function registerProperties(target:Object, map:Object):void {
            var className:String = getQualifiedClassName(target);
            var typeMap:Object = propertyMap(target);
            for (var i:String in map) {
                if (map[i] is String) continue;
                if (typeMap[i] != undefined) {
                    map[i] = typeMap[i];
                }
                else {
                    throw new Error("Serializable read/write property: " + i +" not found on:" + target);
                }
            }
            cachedPropertyMaps[className] =  map;
        }
        
        
        /**
         *
         * @param target
         * @return
         *
         */
        public function propertyMap(target:Object):AbstractOrderedObject
        {
            var propMap:AbstractOrderedObject;
            const MAP:Object = RegisterAliases.MAP;
           
            var className:String = getQualifiedClassName(target); // classXML.@name;

            if (!cachedPropertyMaps[className])
            {
                propMap = new AbstractOrderedObject();
                var classXML:XML = describeType(target);
                registerClassAlias(className, target as Class || target.constructor );
                var list:XMLList = classXML..*.((name() == "accessor") || (name() == "variable"));

                var item:XML;
                for each (item in list)
                {
                    var itemName:String = item.name().toString();
                    var prop:String = item.@name.toString();
                    // only serializable properties allowed!
                    var type:String =  item.@type.toString();
                    if (MAP[type] == undefined) continue;
                    
                    switch (itemName)
                    {
                        case "variable":
                            propMap[prop] =type;
                            
                            break;
                        case "accessor":
                            var access:String = item.@access;
                            if (access == "readwrite")  //|| (access == "writeonly")
                            {
                                propMap[prop] = type;
                            }
                            break;
                    }
                    cachedPropertyMaps[className] = propMap;
                }
                
                classList.push(className);
                propertyMaps.push( propMap);
            }
            else
            {
                propMap = cachedPropertyMaps[className];
            }

            return propMap;
        }
        
        /* INTERFACE flash.utils.IExternalizable */
        
        public function writeExternal(output:IDataOutput):void 
        {    
            output.writeObject(classList);
            output.writeObject(propertyMaps);
            
        }
        
        public function readExternal(input:IDataInput):void 
        {
            classList = input.readObject();
            propertyMaps = input.readObject();
    
            if (classList.length != propertyMaps.length) throw new Error("Class list / Property map vector length mismatch!" + classList.length + ", "+propertyMaps.length);

            cachedPropertyMaps = { };
            var count:int = classList.length;
            while (--count > -1) {
                cachedPropertyMaps[classList[count]] = propertyMaps[count];
            }
            
        }

       
        
    }



    import alternativ7.engine3d.core.Object3D;
    import flash.net.registerClassAlias;
    import flash.utils.getQualifiedClassName;
    /**
     * ...
     * @author Glenn Ko
     */
    class RegisterAliases 
    {
        // Primitive data-type map (will always spawn new instances/values when applied!)
        public static const MAP:Object = {
            "int": int,
            "Number": Number,
            "uint": uint,
            "Boolean": Boolean,
            "String": String
        };
        
        private static var CHECKED:Boolean = false;
        public static function check():void {
            if (CHECKED) return;
            CHECKED = true;
            
            registerClassAlias("String", String);    
            
            registerWonderFLAlias("portal.serialization.AbstractOrderedObject", AbstractOrderedObject);
            registerWonderFLAlias("portal.serialization.ExternalizableWrapper", ExternalizableWrapper);
            registerWonderFLAlias("portal.serialization.ReflectReadWrite", ReflectReadWrite);
            registerWonderFLAlias("portal.serialization.MaterialList", MaterialList);
            registerWonderFLAlias("portal.serialization.PublicMesh", PublicMesh);
            
            
            registerClassAlias("alternativa.engine3d.core.Object3D", Object3D);
        }
        
        public static function registerClass(classe:Class):void {
            registerClassAlias(getQualifiedClassName(classe), classe);
        }
        
        public static const WONDER_FL:Object = {};
        public static function registerWonderFLAlias(arg1:String, arg2:Class):void {
            WONDER_FL[arg1.split(".").pop()] = arg2;
            registerClassAlias(arg1, arg2);
        }
        
        public static function registerAsPrimitive(arg1:String, arg2:Class):void 
        {
            MAP[arg1] = arg2;
            registerClassAlias(arg1, arg2);
        }
        
        public static function unregisterPrimitive(arg1:String):void {
            delete MAP[arg1];
        }
        
        
        
    }
    
    

    import flash.utils.ByteArray;
    import flash.utils.Dictionary;
    /**
     * ...
     * @author Glenn Ko
     */
    class SerializableApplier
    {
        public static const proxy:DataIOProxy = new DataIOProxy(null, null);
        
        public static const MAP_READ:Object = {
            // primitive data types
            "int": proxy.readInt,
            "Number": proxy.readFloat,
            "uint": proxy.readUnsignedInt,
            "Boolean": proxy.readBoolean,
            "String": proxy.readObject,
            
            // a3d7 specific
            "faceList": proxy.readFaceList,
            "vertexList": proxy.readVertexList,
            "material": proxy.readMaterial
        };
        
        public static const MAP_WRITE:Object = {
            // primitive data types
            "int": proxy.writeInt,
            "Number": proxy.writeFloat, 
            "uint": proxy.writeUnsignedInt, 
            "Boolean": proxy.writeBoolean, 
            "String": proxy.writeObject,
            
            // a3d7 specific
            "faceList": proxy.writeFaceList,
            "vertexList": proxy.writeVertexList,
            "material": proxy.writeMaterial
        };
        
        
    }



