/**
 * Copyright wwbeyondww1 ( http://wonderfl.net/user/wwbeyondww1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1BDQ
 */

// forked from bkzen's Simple Matrix
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    
    /**
     * Simple Matrix
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class Test61 extends Sprite 
    {
        private static const BOX_SIZE: int = 10;
        private var bmd: BitmapData, bmd2: BitmapData;
        private var bmp: Bitmap;
        private var colorTf: ColorTransform;
        private var rect: Rectangle;
        private var wCnt: int;
        private var drawMatrix: Matrix;
        
        public function Test61() 
        {
            var w: int = stage.stageWidth, h: int = stage.stageHeight;
            bmd = new BitmapData(w, h, false, 0);
            bmd2 = new BitmapData(w, h + BOX_SIZE * 2, true, 0);
            bmp = new Bitmap(bmd, "auto", true);
            addChild(bmp);
            rect = new Rectangle(0, BOX_SIZE + 1, BOX_SIZE, BOX_SIZE);
            colorTf = new ColorTransform(1, 1, 1, 1, -4, -4, -4);
            drawMatrix = new Matrix(1, 0, 0, 1, 0, -BOX_SIZE * 2);
            wCnt = w / (BOX_SIZE + 1);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e: Event): void 
        {
            bmd.lock(), bmd2.lock();
            bmd.colorTransform(bmd.rect, colorTf);
            if (Math.random() < 0.2) 
            {
                rect.x = (Math.random() * wCnt | 0) * 11;
                bmd2.fillRect(rect, 0xFF30FF30);
            }
            bmd2.scroll(0, BOX_SIZE + 1);
            bmd.draw(bmd2, drawMatrix, null, null, null, true);
            bmd.unlock(), bmd2.unlock();
        }
    }
}