/**
 * Copyright baudon.thomas ( http://wonderfl.net/user/baudon.thomas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1Aio
 */

package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.events.Event;

    public class FlashTest extends Sprite {
        
        private var points  : Vector.<Point>;
        private var container : Object;
        private var oScaleX : Number;
        private var oScaleY : Number;
        private var oRotation : Number;
        private var oX : int;
        private var oY : int;
        private var oCX : int;
        private var oCY : int;
          
        public function FlashTest() {
            // write as3 code here..
            points = new Vector.<Point>();
            
            points.push(new Point(0,0));
            points.push(new Point(20,0));
            points.push(new Point(20,20))
            points.push(new Point(0,20));        
            
            container  = new Object();
            container.rotation = 0;
            container.x = 100;
            container.y = 100;
            container.scaleX = 2;
            container.scaleY = 1;
            container.cX = 50;
            container.cY = 50;
            
            oScaleX = 1;
            oScaleY = 0.5;
            oRotation = 0;
            oCX = 10;
            oCY = 10
            oX = 100;
            oY = 100;

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e : Event) : void
        {
           // oRotation+=0.1;
            //container.rotation-=0.2;
            oRotation += 0.04; 
            container.rotation-=0.05;
            draw();
        }

        
        private function draw() : void
        {
            graphics.clear();
            
            for(var i : uint = 0; i < points.length; i++)
            {
                var current : Point = points[i];
                
                var tSX = oScaleX * container.scaleX; 
                var tSY = oScaleY * container.scaleY;
                var tR : Number = oRotation + container.rotation;
                
                var tp : Point = new Point();
                
                tp.x = Math.cos(tR) * (current.x-oCX) - Math.sin(tR) * (current.y-oCY);
                tp.x += Math.cos(container.rotation) * (oX-container.cX) - Math.sin(container.rotation) * (oY-container.cY) + container.x;
                tp.x *= tSX;
                
                tp.y = Math.sin(tR) * (current.x-oCX) + Math.cos(tR) * (current.y-oCY);
                tp.y += Math.sin(container.rotation) * (oX-container.cX) + Math.cos(container.rotation) * (oY-container.cY) + container.y;         
                tp.y *= tSY;

                graphics.beginFill(0x6666ff);
                graphics.drawCircle(tp.x, tp.y, 2);
                graphics.endFill();
            }
        }

        
    }
}