/**
 * Copyright smakhtin ( http://wonderfl.net/user/smakhtin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1ASW
 */

// forked from shapevent's Mouse Toy
//Full screen please
package {

	import flash.display.*;
	import flash.events.*;
	import frocessing.color.ColorHSV;
	import net.hires.debug.Stats;
	
	[SWF(backgroundColor = "#000000")]
	
	public class MouseToy extends MovieClip {
		
		private var circles:Array;
		private var amount:uint = 100;
		private var hsv:ColorHSV;
		private var color:Number = 0;

		public function MouseToy(){
                  // init	  
			circles = [];
			hsv = new ColorHSV(0, 0, 0);
			hsv.v = color;
			for (var i:int = 0; i<amount; i++){
				var c:Sprite = makeCircle();
				c.x = stage.stageWidth / 2;
				c.y = stage.stageHeight / 2;
				c.scaleX = Math.random()*0.5 + i/2;
				c.scaleY = 0.5 + i/4;
				addChild(c);
				circles.push(c);
			}
			addEventListener(Event.ENTER_FRAME, onLoop);
			//Uncomment it to view FPS
			//this.addChild(new Stats());
        }
               
		// private methods

		private function onLoop(evt:Event):void {
			circles[0].y += (mouseY - circles[0].y) / 4;
			circles[0].x += (mouseX - circles[0].x) /4;
			for (var i:int = 1; i<circles.length; i++){
				var pre:Sprite = circles[i - 1];
				circles[i].y += (pre.y - circles[i].y) / 4;
				circles[i].x += (pre.x - circles[i].x) / 4;
			}
		}
		private function makeCircle():Sprite{
			var s:Sprite = new Sprite();
			with(s.graphics){
				lineStyle(5,hsv.value);
				drawCircle(0, 0, 10);
			}
			color += 1 / amount;
			hsv.v = color;
			trace(color);
			return s;
		}
		

       }

}