/**
 * Copyright wetcradle ( http://wonderfl.net/user/wetcradle )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1A1W
 */

package {
	import flash.display.Sprite;
	public class LoadingIconTest extends Sprite {
		public function LoadingIconTest():void {
			var temp:Sprite = new LoadingIcon();
			addChild(temp);
			temp = new LoadingIcon(0x666666, 20, 3, 3);
			temp.x = 30;
			addChild(temp);
			temp = new LoadingIcon(0x666666, 20, 20, 1, 50);
			temp.x = 80;
			addChild(temp);
			temp = new LoadingIcon(0x666666, 20, 2, 6, 20);
			temp.x = 130;
			addChild(temp);
			temp = new LoadingIcon(0x666666, 10, 1, 40, 20);
			temp.x = 190;
			temp.y = 10;
			addChild(temp);
		}
	}
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;

class LoadingIcon extends Sprite {
	
	protected var _radius:Number;
	protected var _barLength:Number;
	protected var _barThickness:Number;
	protected var _barColor:uint;
	protected var _barCount:uint;
	protected var _rotateDelay:uint;
	
	protected var counter:uint = 0;
	protected var bars:Shape;
	
	////////////////////////////////////////////////////////////
	//////////////コンストラクタ
	////////////////////////////////////////////////////////////
	
	public function LoadingIcon(barColor:uint=0x666666, radius:Number=10, barLength:Number=5, barThickness:Number=2, barCount:uint=12, rotateDelay:uint=2):void {
		_radius = radius;
		_barLength = barLength;
		_barThickness = barThickness;
		_barColor = barColor;
		_barCount = barCount;
		_rotateDelay = rotateDelay;
		bars = new Shape();
		addChild(bars);
		draw();
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
	}
	
	//______________ draw ______________//
	protected function draw():void {
		var radian:Number = Math.PI * 2 / _barCount;
		var p1:Point = new Point(_radius - _barLength, _barThickness / 2);
		var p2:Point = new Point(_radius, _barThickness / 2);
		var p3:Point = new Point(_radius, -_barThickness / 2);
		var p4:Point = new Point(_radius - _barLength, -_barThickness / 2);
		for (var i:int=0; i<_barCount; i++) {
			bars.graphics.beginFill(_barColor, (i + 1) / _barCount);
			var rp1:Point = rotatePoint(p1, radian * i);
			var rp2:Point = rotatePoint(p2, radian * i);
			var rp3:Point = rotatePoint(p3, radian * i);
			var rp4:Point = rotatePoint(p4, radian * i);
			with (bars.graphics) {
				moveTo(rp1.x, rp1.y);
				lineTo(rp2.x, rp2.y);
				lineTo(rp3.x, rp3.y);
				lineTo(rp4.x, rp4.y);
				endFill();
			}
		}
		bars.x = bars.y = _radius;
	}
	
	//______________ rotatePoint ______________//
	protected function rotatePoint(p:Point, radian:Number):Point {
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
		return new Point(cos * p.x - sin * p.y, sin * p.x + cos * p.y);
	}
	
	////////////////////////////////////////////////////////////
	//////////////イベントハンドラ
	////////////////////////////////////////////////////////////
	
	//______________ removedFromStageHandler ______________//
	protected function removedFromStageHandler(e:Event):void {
		removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
		removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
	}
	
	//______________ enterFrameHandler ______________//
	protected function enterFrameHandler(e:Event):void {
		if (!counter) {
			bars.rotation += 360 / _barCount;
		}
		counter = (counter + 1) % _rotateDelay;
	}
}
