/**
 * Copyright twistcube ( http://wonderfl.net/user/twistcube )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1A09
 */

////////////////////////////////////////////////////////////////////////////////
//
// ローディングで良く使うリングを回してみた 2
// ※以前のモノをアレンジしただけ
// http://wonderfl.net/code/25e6f40478b58b95e3a229fcaa92578a329a1927#
//
////////////////////////////////////////////////////////////////////////////////
package
{
	import flash.display.* ;
	import flash.events.* ;
	import flash.net.* ;
	import flash.system.* ;
	
	[SWF(width="500", height="500", backgroundColor="0x000000", frameRate="30")]
	public class MyRing2 extends Sprite
	{
		private var _list:Array ;
		private var _colorList:Array = [ 0x261818, 0x40352b, 0x99895e ] ;
		
		public function MyRing2( )
		{
			init( ) ;
		}
		
		private function init( ):void
		{
			stage.scaleMode = StageScaleMode.NO_SCALE ;
			stage.align     = StageAlign.TOP_LEFT ;
			stage.quality   = StageQuality.HIGH ;
			
			_list = new Array( ) ;
			
			addEventListener( Event.ENTER_FRAME, onRender ) ;
		}
		
		private function onRender( event:Event ):void
		{
			if ( _list.length < 50 )
			{
				if ( Math.random( ) < 0.15 )
				{
					ShuffleArray.shuffle( _colorList ) ;
					
					var sliceNum:uint = Math.floor( _colorList.length * Math.random( ) ) + 1 ;
					var obj:CircleManager = new CircleManager( _colorList, sliceNum, 20, 1, Math.PI/1.5*Math.random( )+Math.PI, 360 * Math.random( ) ) ;
					obj.addEventListener( CircleManager.ON_COMPLETE, onComplete ) ;
					obj.x = stage.mouseX + Math.random( ) * 300 - 150 ;
					obj.y = stage.mouseY + Math.random( ) * 300 - 150 ;
					
					addChild( obj ) ;
					
					_list.push( obj ) ;
				}
			}
			
			sortZ( ) ;
		}
		
		private function onComplete( event:Event ):void
		{
			var nLength:uint = _list.length ;
			var i:uint = 0 ;
			while ( i < nLength )
			{
				var obj:CircleManager = _list[ i ] ;
				if ( obj.isHide )
				{
					_list.splice( i, 1 ) ;
					
					obj.removeEventListener( CircleManager.ON_COMPLETE, onComplete ) ;
					removeChild( obj ) ;
					obj = null ;
					nLength = _list.length ;
				}
				else
				{
					i++ ;
				}
			}
		}
		
		private function sortZ( ):void
		{
			_list.sortOn( "scaleX", Array.DESCENDING | Array.NUMERIC ) ;
			var nLength:uint = _list.length ;
			for( var i:uint = 0; i < nLength; i++ )
			{
				var obj:CircleManager = _list[ i ] ;
				setChildIndex( obj, i ) ;
			}
		}
	}
}


import flash.display.* ;
import flash.events.* ;

class CircleManager extends Sprite
{
	public static const ON_COMPLETE:String = "on_complete" ;
	
	private var _num:uint ;
	private var _hankei:uint ;
	private var _hutosa:uint ;
	private var _nagasa:Number ;
	private var _rotation:Number ;
	private var _colorList:Array ;
	
	private var _list:Array ;
	private var _isHide:Boolean = false ;
	
	private var _rotationStep:Number ;
	private var _scaleStep:Number ;
	
	public function CircleManager( __colorList:Array, __num:uint = 1, __hankei:uint = 50, __hutosa:uint = 1, __nagasa:Number = 2 * Math.PI, __rotation:Number = 0 ):void
	{
		_colorList = __colorList ;
		_num       = __num ;
		_hankei    = __hankei ;
		_hutosa    = __hutosa ; 
		_nagasa    = __nagasa ;
		_rotation  = __rotation ;
		
		addEventListener( Event.ADDED_TO_STAGE, init ) ;
		addEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
	}

	private function init( event:Event ):void
	{
		removeEventListener( Event.ADDED_TO_STAGE, init ) ;
		
		// --
		
		_list = new Array( ) ;
		
		var _o:CircleObj ;
		for ( var i:uint = 0 ; i < _num; i++ )
		{
			_o = new CircleObj( _hankei, _hutosa, _nagasa / _num, (_nagasa / _num * i) / Math.PI * 180, _colorList[ i ] ) ;
			addChild( _o ) ;
			
			_list.push( _o ) ;
		}
		
		scaleX = scaleY = 0.1 ;
		_rotationStep = 16 * Math.random( ) - 8 ;
		_scaleStep = 0.12 * Math.random( ) + 1.02 ;
		
		rotation = _rotation ;
		
		addEventListener( Event.ENTER_FRAME, onRender ) ;
	}
	
	private function unload( event:Event = null ):void
	{
		removeEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
		removeEventListener( Event.ENTER_FRAME, onRender ) ;
		
		var _o:CircleObj ;
		var nLength:uint = _list.length ;
		for ( var i:uint = 0 ; i < nLength; i++ )
		{
			_o = _list[ i ] ;
			removeChild( _o ) ;
			_o = null ;
		}
	}
	
	public function get isHide( ):Boolean
	{
		return _isHide ;
	}
		
	private function onRender( event:Event ):void
	{
		scaleX = scaleY *= _scaleStep ;
		rotation += _rotationStep ;
		
		if ( scaleX > 25)
		{
			_isHide = true ;
			dispatchEvent( new Event( ON_COMPLETE ) ) ;
		}
	}
}



import flash.display.* ;
import flash.events.* ;

class CircleObj extends Sprite
{
	private var _hankei:uint ;
	private var _hutosa:uint ;
	private var _nagasa:Number ;
	private var _rotation:Number ;
	private var _color:Number ;
	
	private var _mask:Sprite ;
	private var _main:Sprite ;
	
	public function CircleObj( __hankei:uint = 50, __hutosa:uint = 1, __nagasa:Number = 2*Math.PI, __rotation:Number = 0, __color:Number = 0 ):void
	{
		_hankei   = __hankei ;
		_hutosa   = __hutosa ; 
		_nagasa   = __nagasa ;
		_rotation = __rotation ;
		_color    = __color ;
		
		addEventListener( Event.ADDED_TO_STAGE, init ) ;
		addEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
	}

	private function init( event:Event ):void
	{
		removeEventListener( Event.ADDED_TO_STAGE, init ) ;
		
		// --
		
		_mask = new Sprite( ) ;
		_main = new Sprite( ) ;
		
		addChild( _main ) ;
		addChild( _mask ) ;
		
		_main.mask = _mask ;
		
		xDrawMask( ) ;
		xDrawCircle( ) ;
		
		rotation = _rotation - 90 ;
	}
	
	private function unload( event:Event = null ):void
	{
		removeEventListener( Event.REMOVED_FROM_STAGE, unload ) ;
		
		removeChild( _main ) ;
		removeChild( _mask ) ;
		
		_main = null ;
		_mask = null ;
	}
	
	private function xDrawMask( ):void
	{
		var nHankei:Number = ( _hankei + _hutosa ) * 1.41422 ; // http://www.twist-cube.com/wonderfl/ring_sample.png
		var nTheta:Number ;
		var nX:Number ;
		var nY:Number ;
		
		_mask.graphics.clear( ) ;		
		_mask.graphics.beginFill( 0xFFFFFF ) ;
		
		// right bottom
		nTheta = Math.min( _nagasa, Math.PI / 2 ) ;
		nX = nHankei * Math.cos( nTheta ) ;
		nY = nHankei * Math.sin( nTheta ) ;
		_mask.graphics.moveTo( 0, 0 ) ;
		_mask.graphics.lineTo( nHankei, 0 ) ;
		_mask.graphics.lineTo( nX, nY ) ;
		_mask.graphics.lineTo( 0, 0 ) ;
		_main.graphics.endFill( ) ;
		
		// left bottom
		if ( _nagasa > Math.PI / 2 )
		{
			nTheta = Math.min( (_nagasa - Math.PI / 2), Math.PI / 2 ) + Math.PI / 2 ;
			nX = nHankei * Math.cos( nTheta ) ;
			nY = nHankei * Math.sin( nTheta ) ;
			_mask.graphics.moveTo( 0, 0 ) ;
			_mask.graphics.lineTo( 0, nHankei ) ;
			_mask.graphics.lineTo( nX, nY ) ;
			_mask.graphics.lineTo( 0, 0 ) ;
			_main.graphics.endFill( ) ;
		}
		
		// left top
		if ( _nagasa > Math.PI )
		{
			nTheta = Math.min( (_nagasa - Math.PI), Math.PI / 2 ) + Math.PI ;
			nX = nHankei * Math.cos( nTheta ) ;
			nY = nHankei * Math.sin( nTheta ) ;
			_mask.graphics.moveTo( 0, 0 ) ;
			_mask.graphics.lineTo( -nHankei, 0 ) ;
			_mask.graphics.lineTo( nX, nY ) ;
			_mask.graphics.lineTo( 0, 0 ) ;
			_main.graphics.endFill( ) ;
		}
		
		// right top
		if ( _nagasa > Math.PI + Math.PI/2 )
		{
			nTheta = Math.min( (_nagasa - (Math.PI + Math.PI/2)), Math.PI / 2 ) + Math.PI + Math.PI/2 ;
			nX = nHankei * Math.cos( nTheta ) ;
			nY = nHankei * Math.sin( nTheta ) ;
			_mask.graphics.moveTo( 0, 0 ) ;
			_mask.graphics.lineTo( 0, -nHankei ) ;
			_mask.graphics.lineTo( nX, nY ) ;
			_mask.graphics.lineTo( 0, 0 ) ;
			_main.graphics.endFill( ) ;
		}
	}
	
	private function xDrawCircle( ):void
	{
		_main.graphics.clear( ) ;
		_main.graphics.beginFill( _color );
		_main.graphics.drawCircle( 0, 0, _hankei + _hutosa ) ;
		_main.graphics.drawCircle( 0, 0, _hankei ) ;
		_main.graphics.endFill( ) ;
	}
}


class ShuffleArray
{
	public function ShuffleArray( )
	{
		
	}
	
	public static function shuffle( l_array:Array ):void
	{
		var n:uint = l_array.length ;
		var i:uint = n ;
		while ( i-- )
		{
			var j:uint = Math.floor( Math.random( ) * n ) ;
			var t:*    = l_array[i] ;
			l_array[i] = l_array[j] ;
			l_array[j] = t ;
		}
	}
}