/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/19aI
 */

package {
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(width=465, heigh=465, frameRate=60, backgroundColor=0x000000)]
    public class Main extends Sprite {
        private static const SCALE:int = 3;
        private static const SAMPLE_RATE:int = 44100;
        private static const SAMPLE_TIME:Number = 1 / 44100;
        private static const BUFFER:int = 3072;
        
        private var ghost:Ghost;
        private var canvas:BitmapData;
        private var sw:int, sh:int;
        private var cw:int, ch:int;
        private var sound:Sound = new Sound();
        private var sine:Vector.<Number> = new Vector.<Number>(SAMPLE_RATE);
        private var frequency:Number = 440;
        private var amplitude:Number = .2;
        private var soundPos:Number = 0;
        
        public function Main() {
            cw = stage.stageWidth / SCALE;
            ch = stage.stageHeight / SCALE;
            
            canvas = new BitmapData(155, 155, false);
            var bitmap:Bitmap = new Bitmap(canvas);
            bitmap.scaleX = bitmap.scaleY = 3;
            addChild(bitmap);
            
            ghost = new Ghost(canvas, 40, 40, 0xffff99ff);
            ghost.x = (cw - ghost.width) / 2;
            ghost.y = (ch - ghost.height) / 2;
            
            var pos:Number = 0;
            for (var i:int = 0; i < SAMPLE_RATE; i++) {
                pos = i / SAMPLE_RATE;
                sine[i] = Math.sin(Math.PI * 2 * pos);
            }
            
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
            sound.play();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x220055);
            ghost.draw();
            canvas.unlock();
        }
        
        private function onSampleData(e:SampleDataEvent):void {
            var pos:int;
            var mod1Pos:int;
            var sample:Number;
            var freq:Number;
            for (var i:int = 0; i < BUFFER; i++) {
                freq = frequency;
                mod1Pos = (SAMPLE_RATE * 1 * soundPos) % SAMPLE_RATE;
                freq += sine[mod1Pos];
                pos = (SAMPLE_RATE * freq * soundPos) % SAMPLE_RATE;              
                sample = sine[pos] * amplitude;
                e.data.writeFloat(sample);
                e.data.writeFloat(sample);
                soundPos += SAMPLE_TIME;
            }
        }
    }
}

import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.BitmapData;

class Ghost extends Object {
    public var color:uint;
    
    private var theWidth:Number;
    private var theHeight:Number;
    private var pos:Point = new Point();
    private var relY:Number;
    private var gfx:BitmapData;
    private var canvas:BitmapData;
    private var counter:int = 0;
    
    public function Ghost(canvas:BitmapData, width:int, height:int, color:uint) {
        this.canvas = canvas;
        this.color = color;
        theWidth = width;
        theHeight = height;
        
        gfx = new BitmapData(width, height, true, 0x00ff00ff);
    }
    
    public function draw():void {
        counter++;
        gfx.fillRect(gfx.rect, 0x00000000);
        var r:Number = (width-2) / 2;
        var r2:Number = r * r;
        var startY:Number;
        var endY:Number;
        for (var x:int = -r; x <= r; x++) {
            startY = r - Math.ceil(Math.sqrt( r2 - x * x ));
            endY = (theHeight - 2) + ( Math.sin((x + counter) * .4) * 2 );
            gfx.fillRect(new Rectangle(x+r, startY, 1, endY-startY), color);
        }
        
        drawBitmapCircle(gfx, 10, 15, 8, 0xffffffff);
        drawBitmapCircle(gfx, 26, 15, 8, 0xffffffff);
        drawBitmapCircle(gfx, 7, 15, 4, 0xff000000);
        drawBitmapCircle(gfx, 23, 15, 4, 0xff000000);
        drawBitmapCircle(gfx, 8, 14, 2, 0xffffffff);
        drawBitmapCircle(gfx, 24, 14, 2, 0xffffffff);
        
        pos.y = (Math.sin(counter * .2) * 3) + relY;
        
        canvas.copyPixels(gfx, gfx.rect, pos);
    }
    
    private function drawBitmapCircle(target:BitmapData, cX:Number, cY:Number, r:Number, color:Number):void {
        var x:Number = 0;
        var y:Number = 0;
        var r2:Number = r * r;
        var bmRect:Rectangle = new Rectangle();
        for (x = 1; x < r; x++) {
            y = Math.ceil(Math.sqrt(r2 - x * x));
            bmRect.topLeft = new Point(cX - x, cY - y);
            bmRect.size = new Point(2 * x, 2 * y);
            target.fillRect(bmRect, color);
        }
    }
    
    public function get width():Number { return theWidth; }
    public function get height():Number { return theHeight; }
    public function get x():Number { return pos.x; }
    public function set x(value:Number):void { pos.x = value; }
    public function get y():Number { return pos.y; }
    public function set y(value:Number):void { pos.y = relY = value; }
}
