/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1957
 */

// forked from DRAMBA's Gravity - Spheres
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;

    
    [SWF(stageQuality="BEST",backgroundColor="#000000",width="465",height="465",frameRate = "80")]
    
    public class Main extends Sprite
    {
        private var balls:Array;
        private var ball:Ball;
        
        private var _blur:BlurFilter = new BlurFilter(15,15,3);
        private var _glow:GlowFilter = new GlowFilter(0x000000,.6,50,50,1,3,false);
        
        private var gravity:Number = 0.5;
        private var bounce:Number = 0.5;
        private var friction:Number = 1;
        
        private var top:Number = 0;
        private var bottom:Number = stage.stageHeight;
        private var left:Number = 0;
        private var right:Number = stage.stageWidth;
        
        public function Main() 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;       
            init();
        }
        
        private function init():void
        {
            balls = [];
            
            for (var i:int = 0; i < 100; i++) 
            {
                var ball:Ball = new Ball( 20 );
                ball.vx = Math.random() * 2 - 1;
                ball.vy = Math.random() * 2 - 1;
                ball.x = mouseX;
                ball.y = mouseY; 
//                ball.x = Math.random() * stage.stageWidth;
//                ball.y = Math.random() * stage.stageHeight;
                ball.filters = [_blur, _glow];
                addChild(ball);
                balls[i] = ball;
            }

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, changeState);
        }
        
        private function changeState(e:MouseEvent):void 
        {
            if (gravity == 0)
            {
                gravity = 0.5;
                bounce = 0.5;
                friction = 0.99;
            }
            else
            {
                gravity = 0;
                friction = 1;
                bounce = .5;
                resetVelocities();
            }
        }
        
        private function onEnterFrame(e:Event):void 
        {
            for (var i:int = 0; i < 100; i++) 
            {
                ball = Ball(balls[i]);

                ball.vy += gravity;
                ball.vy *= friction;
                ball.vx *= friction;
                
                ball.x += ball.vx;
                ball.y += ball.vy;
                
                
                verifyBoundaries(ball);
            }
        }
        
        private function verifyBoundaries(ball:Ball):void
        {
            if (ball.x - ball.radius < left)
                {
                    ball.x = left + ball.radius;
                    ball.vx *= -1;
                    ball.blendMode = "INVERT"; 

                }
                else if (ball.x + ball.radius > right)
                {
                    ball.x = right - ball.radius;
                    ball.vx *= -1;
                }
                
                if (ball.y - ball.radius < top)
                {
                    ball.y = top + ball.radius;
                    ball.vy *= -1;
                }
                else if (ball.y + ball.radius > bottom)
                {
                    ball.y = bottom - ball.radius;
                    ball.vy *= bounce;
                    ball.vy *= -1;
                }
        }
        
        private function resetVelocities():void
        {
            for (var i:int = 0; i < 100; i++) 
            {
                balls[i].vy = Math.abs(Math.random() * 2); 
                balls[i].vx = Math.random() * 2 - 1;
            }
        }
    }
}
import flash.display.Sprite;

class Ball extends Sprite
    {
        private var _vx:Number = 0;
        private var _vy:Number = 0;
        private var _radius:int = 0;
        private var _friction:Number = 1;
        
        public function Ball(radius:int = 0, color:int = 0xFFFFFF) 
        {
            _radius = radius;
            graphics.beginFill(color*Math.random());
            graphics.drawCircle(0, 0, radius*Math.random());
            graphics.endFill();
        }
        
        public function get vx():Number { return _vx; }
        
        public function set vx(value:Number):void 
        {
            _vx = value;
        }
        
        public function get vy():Number { return _vy; }
        
        public function set vy(value:Number):void 
        {
            _vy = value;
        }
        
        public function get radius():int { return _radius; }
        
        public function get friction():Number { return _friction; }
        
        public function set friction(value:Number):void 
        {
            _friction = value;
        }
    }