/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/18aW
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.filters.BlurFilter;
    
    
    public class Professional extends Sprite {
		
		private var frontS:Sprite = new Sprite();
		private var middleS:Sprite = new Sprite();
		private var backS:Sprite = new Sprite();
		private var triangle:Sprite = new Sprite();
		
        public function Professional() {
			var g:Graphics;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
			frontS.scaleX = frontS.scaleY = 10;
			middleS.scaleX = middleS.scaleY = 6;
			backS.scaleX = backS.scaleY = 2;
			
			triangle.x = 80;
			triangle.y = 232;
			
            g = frontS.graphics;
            g.beginBitmapFill(pattern1());
            g.drawRect(-6,-6,54,54);
            g.endFill();
			
            g = middleS.graphics;
            g.beginBitmapFill(pattern2());
            g.drawRect(-10,-10,90,90);
            g.endFill();
			
            g = backS.graphics;
            g.beginBitmapFill(pattern3());
            g.drawRect(-30,-30,270,270);
            g.endFill();
			
			frontS.filters = [new BlurFilter(1, 1)];
			middleS.filters = [new BlurFilter(2, 2)];
			backS.filters = [new BlurFilter(4, 4)];
			
			this.addChild( backS );
			this.addChild( middleS );
			this.addChild( frontS );
			this.addChild( triangle );
			
			this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
		private var theta:Number = 0;
		private function onEnterFrame(e:Event):void {
			backS.x -= 1;
			backS.x = (backS.x + 12) % (12);
			middleS.x -= 2;
			middleS.x = (middleS.x + 36) % (36);
			frontS.x -= 4;
			frontS.x = (frontS.x + 60) % (60);
			
			theta += 0.1;
			triangle.graphics.clear();
			triangle.graphics.lineStyle( 3, 0x00FF44 );
			triangle.graphics.beginFill( 0x000100 * int(Math.sin( 2.8 + theta ) * 0x30 + 0x8F), 0.75);
			triangle.graphics.moveTo(0, -25);
			triangle.graphics.lineTo(0, 25);
			triangle.graphics.lineTo(80, 0);
			triangle.graphics.lineTo(0, -25);
			triangle.rotationX = -40 + 10 * Math.sin(theta);
		}
		
        public function pattern1():BitmapData {
            return BitmapPatternBuilder.build(
				[
					[0, 0, 0, 1, 1, 0],
					[0, 0, 0, 1, 0, 0],
					[0, 1, 1, 1, 0, 0],
					[0, 1, 0, 1, 0, 0],
					[1, 1, 0, 1, 1, 1],
					[0, 0, 0, 0, 1, 0]
				],
				[0x0, 0xff228822]
			);
        }
    
        public function pattern2():BitmapData {
            return BitmapPatternBuilder.build(
				[
					[0, 0, 0, 1, 0, 0],
					[1, 1, 0, 1, 0, 1],
					[0, 1, 1, 1, 1, 1],
					[0, 1, 0, 0, 0, 0],
					[0, 1, 1, 1, 0, 0],
					[0, 0, 0, 1, 0, 0]
				],
				[0x0, 0xff115511]
			);
        }
		
        public function pattern3():BitmapData {
            return BitmapPatternBuilder.build(
				[
					[0, 0, 0, 1, 1, 0],
					[0, 0, 0, 1, 0, 0],
					[0, 1, 1, 1, 0, 0],
					[0, 1, 0, 1, 0, 0],
					[1, 1, 0, 1, 1, 1],
					[0, 0, 0, 0, 1, 0]
				],
				[0xff000000, 0xff003300]
			);
        }

	}
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}

