/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/17wm
 */

// forked from USK's ベンハムの独楽
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.*;
    import gs.*;
    import gs.easing.*;
    
    public class Index extends Sprite {
        
        private static const IMG_URL :String = "http://www.theprintcircle.com/assets/images/PRINT_CIRCLE_LOGO02.jpg";
        
        private var _koma  :Sprite;
        private var _speed :Number = 0.1;
        private var _axcel :Number = 1.1;
        private var _maxSpeed :Number = 150;
        
        public function Index() {
            
            start();
        }
        
        private function start():void
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, loadComplete);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioError);
            
            try {
                loader.load(new URLRequest(IMG_URL), new LoaderContext(true));
            }catch (e:SecurityError) {
                errorText("securityError");
            }
        }
        
        private function ioError(e:IOErrorEvent):void 
        {
            e.target.removeEventListener(Event.INIT, loadComplete);
            e.target.removeEventListener(IOErrorEvent.IO_ERROR, ioError);
            errorText("ioError");
        }
        
        private function loadComplete(e:Event):void 
        {
            e.target.removeEventListener(Event.INIT, loadComplete);
            e.target.removeEventListener(IOErrorEvent.IO_ERROR, ioError);
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, init);
            loader.loadBytes(e.target.bytes);
        }
        
        private function init(e:Event):void 
        {
            e.target.removeEventListener(Event.INIT, loadComplete);
            
            var loader:Loader = e.currentTarget.loader;
            var bmd:BitmapData = new BitmapData(loader.width, loader.height, true, 0x0);
            bmd.draw(loader);
            var bm:Bitmap = new Bitmap(bmd);
            
            var sp:Sprite = new Sprite();
            this.addChild(sp);
            sp.addChild(loader);
            //loader.x = - Math.floor(loader.width / 2) - 2;
            loader.x = stage.stageWidth/2;
            //loader.y = - Math.floor(loader.height / 2) - 2;
            loader.y = stage.stageHeight/2;
            sp.x = stage.stageWidth / 2;
            sp.y = stage.stageHeight / 2;
            _koma = sp;
//
    TweenMax.to(sp, 1, {blurFilter:[10,10,3], ease:Quad.easeOut});
//                       
            var startBtn:BtnClass = new BtnClass("Start");
            this.addChild(startBtn);
            startBtn.addEventListener(Event.CHANGE, startClick);
            startBtn.y = 400;
            startBtn.x = 150;
            
            var stopBtn:BtnClass = new BtnClass("Stop");
            this.addChild(stopBtn);
            stopBtn.addEventListener(Event.CHANGE, stopClck);
            stopBtn.y = 400;
            stopBtn.x = 230;
            
            this.addEventListener(Event.ENTER_FRAME, startRotation);
        }
        
        private function startRotation(e:Event):void 
        {
            var r:Number = _koma.rotation;
            _speed *= _axcel;
            if (_speed >= _maxSpeed) _speed = _maxSpeed;
            if (_speed <= 0) _speed = 0;
            r += _speed;
            if (r >= 360) r -= 360;
            _koma.rotation = r;
        }
        
        private function startClick(e:Event):void 
        {
            _speed += 0.1;
            _axcel = 1.1;
        }
        
        private function stopClck(e:Event):void 
        {
            _axcel = 0.9;
        }
        
        
        private function errorText(str:String):void
        {
            var txt:TextField = new TextField();
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.wordWrap = false;
            
            var format:TextFormat = new TextFormat();
            format.color = 0x0;
            format.size = 12;
            
            txt.defaultTextFormat = format;
            
            txt.text = str;
            this.addChild(txt);
        }
    }
}


import flash.display.*;
import flash.text.*;
import flash.events.*;

class BtnClass extends Sprite {
    
    public function BtnClass(label:String):void
    {
        var btn:Sprite = new Sprite();
        this.addChild(btn);
        btn.graphics.lineStyle(1, 0x333333, 1);
        btn.graphics.beginFill(0xFFFFFF, 1);
        btn.graphics.drawRect(0, 0, 70, 20);
        btn.graphics.endFill();
        
        var txt:TextField = new TextField();
        txt.autoSize = TextFieldAutoSize.CENTER;
        txt.wordWrap = false;
        
        var format:TextFormat = new TextFormat();
        format.color = 0x333333;
        format.size = 14;
        txt.defaultTextFormat = format;
        txt.text = label;
        btn.addChild(txt);
        txt.x = 35 - Math.floor(txt.width / 2);
        txt.y = 10 - Math.floor(txt.height / 2);
        txt.selectable = false;
        
        this.addEventListener(MouseEvent.ROLL_OVER, over);
        this.addEventListener(MouseEvent.ROLL_OUT, our);
        this.addEventListener(MouseEvent.CLICK, click);
    }
    
    private function over(e:MouseEvent):void 
    {
        this.alpha = 0.5;
    }
    
    private function our(e:MouseEvent):void 
    {
        this.alpha = 1;
    }
    
    private function click(e:MouseEvent):void 
    {
        this.dispatchEvent(new Event(Event.CHANGE));
    }
    
}

