/**
 * Copyright yoshinakana ( http://wonderfl.net/user/yoshinakana )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/17rn
 */

// forked from mogera's 回転する丸い箱
    package 
{
    //参考にさせていただきました。
    //http://d.hatena.ne.jp/nitoyon/20090430/box2d_no_debug_draw
    
    //    激しく気持ちわるい物体ができました
    //    ソースにごみが多い。
    //    整形するのめんどーなので放置。
    //    スプライトにヌルが入っててえらってた。のでしゅうせい
    
    import Box2D.Dynamics.b2Body;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.DisplayObject;

    public class Main extends Sprite 
    {
        private var view:View ;
	private var count:int;
	private var donut:b2Body;
	private var loaded:Boolean;
	private var bmp:Bitmap;
		
	public function Main():void 
	{
            //Wonderfl.capture_delay( 12000 );
    
	    if (stage) init();
    	    else addEventListener(Event.ADDED_TO_STAGE, init);
	}
		
	private function init(e:Event = null):void 
	{
	    removeEventListener(Event.ADDED_TO_STAGE, init);
			
	    // entry point
			
	    CreateBackGround();
		
	    //	描画コンテナ
	    view = new View(true)
		
	    addEventListener(MouseEvent.CLICK, CreateMogera) ;
			
	    donut = view.GetWorldBody();
		
		
            view.CreateRegularPolygon(20, 
	        200 / View.SCALE,
		5 / View.SCALE,
		new Point(240 / View.SCALE, 240/ View.SCALE),
		donut);
		
		//donut.SetMassFromShapes();
			
		addEventListener(Event.ENTER_FRAME, RotateDonuts);
		addChild(view);
		
                //   描画物をロードします！	
		var loader:Loader = new Loader();
		
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, CompleteLoad);
			loader.load(new URLRequest("http://farm3.static.flickr.com/2457/3848593510_3b9d814d88_o.png"),
			new LoaderContext(true));
		
		}
		
		private function CompleteLoad(e:Event):void 
		{
			bmp = e.target.loader.content as Bitmap;
			loaded = true;
			trace("is loaded", loaded);
		}
		
		private function CreateMogera(event:MouseEvent) : void
		{
			if ( loaded )
			{
				view.CreateMogera(event.stageX / View.SCALE, event.stageY / View.SCALE, ToBmp(bmp));
			}
		}
		
		private function RotateDonuts(e:Event):void 
		{
			donut.SetXForm(donut.GetPosition(), donut.GetAngle() + 0.1);
		}
		
        /**
         * DisplayObject → ビットマップ
         * @param displayObject
         * @return
         */
        private function ToBmp( displayObject:DisplayObject ) : Bitmap
        {
            var rect:Rectangle;
            var bmp_data:BitmapData;
            var bmp:Bitmap;
            var mat:Matrix;
            
            rect = displayObject.getRect(null);
            
            bmp_data = new BitmapData( rect.width, rect.height, true, 0x00fffffff);
            
            mat = new Matrix(1, 0, 0, 1, -rect.left, -rect.top );
            
            bmp_data.draw( displayObject, mat );
            
            bmp = new Bitmap( bmp_data );
            
            bmp.x = rect.left;
            bmp.y = rect.top;
            
            return bmp;
        }
        
		
        private function CreateBackGround():void
	{
	    var sprite:Sprite = new Sprite();
	    addChild( sprite );
	    var shape:Shape = new Shape();
	    shape.graphics.beginFill(0x0fffff, 1);
	    shape.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
	
	    sprite.addChild(shape);
			
	}
		
		
	}
	
}
import authoring.authObject;
import Box2D.Collision.b2AABB;
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2DebugDraw;
import Box2D.Dynamics.b2World;
import flash.display.Bitmap;
import flash.display.Graphics;
import flash.display.Loader;
import flash.display.MovieClip;
import flash.display.Sprite;
import Box2D.Collision.Shapes.b2PolygonDef;
import flash.events.Event;
import flash.external.ExternalInterface;
import flash.net.URLRequest;
import flash.text.TextField;
import flash.utils.getTimer;


internal class View extends Sprite
{
	private var _world:b2World;
	private var _gravity:b2Vec2;
	private var _doSleep:Boolean;
	private var _worldAABB:b2AABB;
	private var _body:b2BodyDef;
	private var _bodyPolygon:b2Body;
	public static var SCALE:int = 100;
	
	public function View(debug:Boolean = false)
	{
		
            //	world;
            _worldAABB = new b2AABB();
		
            _worldAABB.lowerBound.Set( -500.0, -500.0);
            _worldAABB.upperBound.Set( 500.0, 500.0);
		
            _gravity = new b2Vec2(0.0, 5.0);
            _doSleep = true;
		
            _world = new b2World(_worldAABB, _gravity, _doSleep);
			
            _body = new b2BodyDef();
		
            _body.position.Set(0,0);
		
	    _bodyPolygon = _world.CreateBody(_body);
	
            if ( debug ) 
	    {
	        Debug();
	    }
		
            addEventListener(Event.ENTER_FRAME, EnterFrame);
	}
	
	public function GetWorldBody() :b2Body
	{
		return _world.CreateBody(_body);
	}
	
	//	忘れ物！
	private function EnterFrame(e:Event):void 
	{
            //    これを忘れると描画されない！
	    _world.Step(1 / 9, 10);
		
		
	    // Sprite の場所を更新する
	    for (var b:b2Body = _world.GetBodyList(); b; b = b.GetNext()) 
	    {
                trace("are-?", b)
                var sprite:Sprite = b.GetUserData() as Sprite;
		if (sprite){
		    sprite.x = b.GetWorldCenter().x * SCALE;
		    sprite.y = b.GetWorldCenter().y * SCALE;
		    sprite.rotation = b.GetAngle() * 180 / Math.PI;
	        }           
                // 画面外に出たオブジェクトを削除する
                if (sprite && sprite.y > 600){
                    _world.DestroyBody(b);
                    var bmp:Bitmap = Bitmap(sprite.getChildAt(0));
                    
                    if( bmp )
                    {
                       bmp.bitmapData.dispose();
                    }
                    else
                    {
                        
                        trace("あれｗｗｗビットマップじゃないｗｗｗｗｗｗｗｗｗ");
                    }
                        
                    removeChild(sprite);
                }
	    }
	}
	
	//debug
	private function Debug() : void
	{
		var dbgDraw:b2DebugDraw = new b2DebugDraw();
		
		dbgDraw.m_sprite = this;
		dbgDraw.m_drawScale = SCALE;
		dbgDraw.m_fillAlpha= 0.8;
		dbgDraw.m_lineThickness= 1.0;
		dbgDraw.m_alpha=1.0;
		dbgDraw.m_xformScale = 1.0;
		
		dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
		
		_world.SetDebugDraw(dbgDraw);
		
		trace("debug");
		
	}

	public function CreateRegularPolygon( num:int, radiusIn:Number, radiusWidth:Number,center:Point, b2body:b2Body = null ) : b2Body
	{
		if ( b2body == null )
		{
			b2body = _world.CreateBody(_body);
		}
		var divisionAngle:Number = 360 / num;
		
		for ( var a:int = 0; a < num; a ++ )
		{
			//	計算のためのtmp
			var angle:Number = ToRad(divisionAngle * a) ;
			
			var radiusOut:Number = radiusIn + radiusWidth;
			
			//	初期ﾎﾟｲﾝﾄ
			var cos:Number = Math.cos(angle);
			var sin:Number = Math.sin(angle);
			
			var rI:Point = new Point(cos * radiusIn, sin * radiusIn);
			var rO:Point = new Point(cos * radiusOut, sin * radiusOut);
			
			//	N 次のﾎﾟｲﾝﾄ
			var angleN:Number = ToRad(divisionAngle * (a+1)) ;
			var cosN:Number = Math.cos(angleN);
			var sinN:Number = Math.sin(angleN);
			
			var rIN:Point = new Point(cosN * radiusIn, sinN * radiusIn);
			var rON:Point = new Point(cosN * radiusOut, sinN * radiusOut);
			
			var poly:b2PolygonDef = new b2PolygonDef();

			poly.vertexCount = 4;
			poly.vertices[0].Set(rI.x, rI.y);
			poly.vertices[1].Set(rO.x, rO.y);
			poly.vertices[2].Set(rON.x, rON.y);
			poly.vertices[3].Set(rIN.x, rIN.y );
       
			poly.density = 1;
			poly.restitution = 0.4;
			poly.friction = 0.1;
		
			b2body.CreateShape(poly);
		}
			
		b2body.SetXForm(new b2Vec2(center.x, center.y),0)
			
		return b2body;
	}
	
	public function CreateMogera( x:Number, y:Number, bitmap:Bitmap) : void
	{
		var b2body:b2Body = _world.CreateBody(_body);
		
		var circle:b2CircleDef = new b2CircleDef();
		
		circle.radius = (Math.random() * 30 + 10) / SCALE;
		
		circle.density = 1;
		circle.restitution = 0.4;
		circle.friction = 0.1;
		
		bitmap.width = circle.radius * 2 * SCALE;	
		bitmap.height = circle.radius * 2 * SCALE;	
		bitmap.x = - circle.radius * SCALE;
		bitmap.y = - circle.radius * SCALE;
		
		b2body.CreateShape(circle);
		
		b2body.SetXForm(new b2Vec2(x ,y), 0);
		
		b2body.m_userData = new Sprite();
		b2body.GetUserData().x = b2body.GetWorldCenter().x;
		b2body.GetUserData().y = b2body.GetWorldCenter().y;
		
		b2body.GetUserData().addChild( bitmap );
		
		addChild(b2body.GetUserData());
		
		b2body.SetMassFromShapes();
	}
	
	public function ToRad( deg:Number ) : Number
	{
		return deg / 180 * (Math.PI)
	}
	
	
}

import flash.geom.Point;

internal class Polygon
{
	public var p0:Point;
	public var p1:Point;
	public var p2:Point;
}
