/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/17oq
 */

package {
    import flash.net.URLVariables;
    import flash.net.URLRequestMethod;
    import flash.net.URLRequest;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import com.bit101.components.*;
    public class FlashTest extends Sprite {
        private var _resetAction:Function;
        private var _resultField:TextArea;       
        
        public function FlashTest() {
            new PushButton(this, 0, 0, "search", onSearchClick);
            new PushButton(this, 120, 0, "resetAll", onResetAllClick);
            _resultField = new TextArea(this, 0, 30);
            _resultField.setSize(465, 400);
        }
        
        private function onSearchClick(e:MouseEvent):void {
            var query:URLVariables = new URLVariables;
            query.q = "wonderfl";
            query.rpp = 250;
            
            var req:URLRequest = new URLRequest('http://search.twitter.com/search.atom');
            req.data = query;
            
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            ldr.addEventListener(Event.COMPLETE, complete);
            ldr.load(req);
            
            // you can bind local variables by closures
            _resetAction = function ():void {
                ldr.close();
                _resultField.text = "canceled..";
            };
            
            function errorHandler(e:Event):void {
                removeListeners();
            }
            function complete(e:Event):void {
                removeListeners();
                _resultField.text = ldr.data;
            }
            function removeListeners():void {
                _resetAction = null;
                ldr.removeEventListener(Event.COMPLETE, complete);
                ldr.removeEventListener(IOErrorEvent.IO_ERROR, errorHandler);
            }
        }
        
        private function onResetAllClick(e:MouseEvent):void {
            _resultField.text = "";
            if (_resetAction != null) _resetAction();
        }
    }
}