/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/17cf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * Main
 	 * メインクラス.
	 */
	public class Main extends Sprite
	{
		private var particles:Array;
		private var numParticles:uint = 50;
		private var bounce:Number = -0.5;
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期設定.
		 */
		private function init():void
		{

			particles = new Array();
			//numParticlesの数だけボール生成
			for(var i:uint = 0; i < numParticles; i++)
			{
				var particle:Ball = new Ball(7);
				particle.x = Math.random() * stage.stageWidth;
				particle.y = Math.random() * stage.stageHeight;
				particle.mass = 1;
				addChild(particle);
				particles.push(particle);
			}
			//ENTER_FRAMEをリスナー登録
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
			for(var i:uint = 0; i < numParticles; i++)
			{
				var particle:Ball = particles[i];
				//加速
				particle.x += particle.vx;
				particle.y += particle.vy;
				//壁の接触判定
				checkWalls(particle);
			}
			for(i=0; i < numParticles - 1; i++)
			{
				var partA:Ball = particles[i];
				for(var j:uint = i + 1; j < numParticles; j++)
				{
					var partB:Ball = particles[j];
					//ボール間の引力
					gravitate(partA, partB);
				}
			}
		}
		/**
		 * ボール間引力.
		 * @param partA ボールA
		 * @param partB ボールB
		 */
		private function gravitate(partA:Ball, partB:Ball):void
		{
			//各座標の距離
			var dx:Number = partB.x - partA.x;
			var dy:Number = partB.y - partA.y;
			//直線距離
			var distSQ:Number = dx * dx + dy * dy;
			var dist:Number = Math.sqrt(distSQ);
			//引力
			var force:Number = partA.mass * partB.mass / distSQ;
			//各座標への分力
			var ax:Number = force * dx / dist;
			var ay:Number = force * dy / dist;
			//各ボールの加速度へ設定
			partA.vx += ax / partA.mass;
			partA.vy += ay / partA.mass;
			partB.vx -= ax / partB.mass;
			partB.vy -= ay / partB.mass;
		}
		/**
		 * 壁の接触判定.
		 * @param ball 判定するボール
		 */
		private function checkWalls(ball:Ball):void
		{
			if(ball.x + ball.radius > stage.stageWidth)
			{
				ball.x = stage.stageWidth - ball.radius;
				ball.vx *= bounce;
			}
			else if(ball.x - ball.radius < 0)
			{
				ball.x = ball.radius;
				ball.vx *= bounce;
			}
			if(ball.y + ball.radius > stage.stageHeight)
			{
				ball.y = stage.stageHeight - ball.radius;
				ball.vy *= bounce;
			}
			else if(ball.y - ball.radius < 0)
			{
				ball.y = ball.radius;
				ball.vy *= bounce;
			}
		}
	}
}


/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var mass:Number = 1;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}