/**
 * Copyright beinteractive ( http://wonderfl.net/user/beinteractive )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/172y
 */

package
{
    import flash.display.Sprite;
    
    import flash.display.BlendMode;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.system.Capabilities;
    
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            logField = new TextField();
            logField.x = 10;
            logField.y = 400;
            logField.width = stage.stageWidth - 20;
            addChild(logField);
            
            var os:String = Capabilities.os.toLowerCase();
            
            logField.appendText(os + "\n");
            
            if (os.indexOf('mac') != -1) {
                defaultFontName = 'Verdana';
                defaultProportinalFontName = 'ヒラギノ角ゴ Pro W3';
            }
            else {
//                defaultFontName = 'ＭＳ ゴシック';
//                defaultProportinalFontName = 'ＭＳ Ｐゴシック';
                defaultFontName = 'MS Gothic';
                defaultProportinalFontName = 'MS PGothic';
            }
            
            logField.appendText(defaultFontName + "\n");
            logField.appendText(defaultProportinalFontName + "\n");
            
            buildFields(10,  8, 24, false, false);
            buildFields(110,  8, 24, false, true);
            buildFields(210, 8, 24, true, false);
            buildFields(310, 8, 24, true, true);
        }
        
        protected var logField:TextField;
        protected var defaultFontName:String;
        protected var defaultProportinalFontName:String;
        
        protected function buildFields(fieldX:int, begin:uint, end:uint, proportinal:Boolean, bold:Boolean):void
        {
            var fieldY:int = 10;
            
            for (var size:uint = begin; size <= end; ++size) {
                
                var field:TextField = makeField(size, proportinal, bold);
                
                field.text = 'ABC…' + size;
                field.x = fieldX;
                field.y = fieldY;
                
                addChild(field);
                
                fieldY += field.textHeight;
            }
        }
        
        protected function makeField(size:uint, proportinal:Boolean, bold:Boolean):TextField
        {
            var tf:TextFormat = new TextFormat();
            tf.font = proportinal ? defaultProportinalFontName : defaultFontName;
            tf.size = size;
            tf.color = 0x000000;
            tf.bold = bold;
            
            var field:TextField = new TextField();
            
            field.autoSize = TextFieldAutoSize.LEFT;
            field.selectable = false;
            field.defaultTextFormat = tf;
            field.blendMode = BlendMode.LAYER;
            
            return field;
        }
    }
}