/**
 * Copyright imajuk ( http://wonderfl.net/user/imajuk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/16lI
 */

// forked from kiyobu's lightning
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
    public class FlashTest extends Sprite {
        private var source : Sprite;
        private var canvas : Bitmap;
        private var refresh : ColorTransform;
        private var amount : int = 0;

        public function FlashTest() {
	       	canvas = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000));
			source = new Sprite();
			source.filters = [new BlurFilter(2,2,1), new GlowFilter(0x2211ff, 1, 32, 32, 2, 2)];
			refresh = new ColorTransform(.7,.7,.7,1);
			addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0)));
			addChild(canvas);
        		addEventListener(Event.ENTER_FRAME, loop );
        }
        public function loop(e:Event):void{
        	    canvas.bitmapData.colorTransform(canvas.bitmapData.rect, refresh);
        	    if(amount == 0 && Math.random()>.8)
        	    		amount = Math.random()*6; 
        	    if (amount > 0)
        	       	draw();
        }

        private function draw() : void 
        {
    	    		source.graphics.clear();
        		lightning(mouseX, mouseY, 0xFF, Math.PI*.5, 5);
    	    		source.graphics.endFill();
    	    		canvas.bitmapData.draw(source, null, null, BlendMode.ADD);
    	    		amount--;
        }

        public function lightning(xx:Number, yy:Number, color:Number, rad:Number, tic:Number, strength:Number = 10):void{
          	if (strength < 2) return;
           	if (color < 0x55) return;
        		source.graphics.moveTo(xx, yy);
        		var max:Number = rad + 1.5;
        		var min:Number = rad - 1.5;
        		while(xx>0 && xx<stage.stageWidth && yy>0 && yy < stage.stageHeight){
              	tic *= .98;
             	if (tic < .1) return;
        			rad += Math.random()*1-.5;
        			if (rad > max) rad = max;
        			if (rad < min) rad = min;
        			var d:Number = Math.random()*strength*Math.random()*strength;
        			xx += Math.cos(rad) * d;
        			yy += Math.sin(rad) * d;
        			color *= .98;
        			source.graphics.lineStyle(tic, Math.max(color<<16 | color<<8 | color, 0x555555), 1);
        			source.graphics.lineTo(xx,yy);
        			if (Math.random() < .04)
        			     lightning(xx, yy, color*.98, Math.PI*.5, tic-1, strength*.5);
            		source.graphics.moveTo(xx, yy);
        		}
        }
    }
}