/**
 * Copyright nemu90kWw ( http://wonderfl.net/user/nemu90kWw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/16Q2
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;
    //import net.hires.debug.Stats;
    
    public class FlashTest extends Sprite {
        private var circles:Array = new Array();
        public function FlashTest() {
            graphics.beginFill(0xD0D0FF);
            graphics.drawRect(0, 0, 465, 465);
            
            for(var i:int = 0; i < 100; i++){
                circles.push(addChild(new Circle(465/2+Math.random()*100-50, 465/2+Math.random()*100-50, 3+Math.random()*Math.random()*50)));
            }
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            //addChild(new Stats());
        }
        
        private function onClick(e:MouseEvent):void {
            for each(var circle:Circle in circles){
                circle.x = mouseX+Math.random()*100-50;
                circle.y = mouseY+Math.random()*100-50;
            }
        }
        
        private function onEnterFrame(e:Event):void {
            for(var i:int = 0; i < circles.length-1; i++){
                for(var k:int = i+1; k < circles.length; k++){
                    var c1:Circle = circles[i], c2:Circle = circles[k];
                    var dist:Number = Point.distance(new Point(c1.x, c1.y), new Point(c2.x, c2.y));
                    
                    if(dist < c1.size+c2.size) {
                        var angle:Number = Math.atan2(c1.y - c2.y, c1.x - c2.x);
                        c1.x += Math.cos(angle) * ((c1.size+c2.size-dist)/2);
                        c1.y += Math.sin(angle) * ((c1.size+c2.size-dist)/2);
                        c2.x -= Math.cos(angle) * ((c1.size+c2.size-dist)/2);
                        c2.y -= Math.sin(angle) * ((c1.size+c2.size-dist)/2);
                    }
                }
            }
        }
    }
}
import flash.display.*;

class Circle extends Sprite {
    public var size:Number;
    function Circle(x:Number, y:Number, size:Number){
        this.x = x, this.y = y, this.size = size;
        
        graphics.beginFill(0xFFA000);
        graphics.lineStyle(3, 0x402000);
        graphics.drawCircle(0, 0, size);
    }
}
