/**
 * Copyright flashisobar ( http://wonderfl.net/user/flashisobar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/16Ii
 */

// forked from flashisobar's cloud effect
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.GradientType;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    [SWF(width="465",height="465",frameRate="60",backgroundColor="0xFFFFFF")]
    public class FlashTest extends Sprite {

        private const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/5/53/53a5/53a56a49f91cb35210ff81293171b9a690d5fdaf";
        
        private var flame1:Flame;
        private var flame2:Flame;
        private var mapflame:ScrollingPerlinNoise;
        private var dmfmap:BitmapData;
        private var dmf:DisplacementMapFilter;
        private var rect:Rectangle = new Rectangle(0, 0, 465, 465);
        private var viewbmd:BitmapData;
        private var shape:Shape;
        private var cmf:ColorMatrixFilter;
        private var preBlur:BlurFilter = new BlurFilter(3, 10);
        private var postBlur:BlurFilter = new BlurFilter(2, 2);
        private var p:Point = new Point();
        private var view:Bitmap
        private var loader:Loader;
        
        public function FlashTest() {
            // write as3 code here..
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, start);
            loader.load(new URLRequest(IMAGE_URL), new LoaderContext(true));            
        }
        private function start(e:Event):void 
        {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, start);
            
            // bg
            addChild(e.target.content);
            
            // flame effect
            flame1 = new Flame(465, 465, 1, -5, true, 0x0, 5, 30, 150, false);
            flame2 = new Flame(465, 465, -1, -6, true, 0x0, 5, 40, 100, false);
            // for dmfmap
            mapflame = new Flame(465, 465, 3, -14, true, 0x800000, 5, 120, 200, false);
            flame1.startScroll();
            flame2.startScroll();
            mapflame.startScroll();
            
            dmfmap = new BitmapData(465, 465, false, 0x000000);
            shape = new Shape();
            var mat:Matrix = new Matrix();
            var gw:Number = 465;
            var gh:Number = 465;
            mat.createGradientBox(gw, gh, 0, 0, 140);
            shape.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0], [0, 1], [0, 255], mat);
            shape.graphics.drawRect(0, 0, 465, 465);
            shape.graphics.endFill();
            dmfmap.draw(shape);
            
            dmf = new DisplacementMapFilter(dmfmap, new Point(), BitmapDataChannel.RED, BitmapDataChannel.BLUE, 120, 500, DisplacementMapFilterMode.COLOR);
            
            var a:Number = 16;
            var d:Number = -1024;
            cmf = new ColorMatrixFilter([a * 1, 0, 0, 0, d, a * 0.6, 0, 0, 0, d, a * 0.4, 0, 0, 0, d, 2.4, 0, 0, 0, 0]);
            
            // mask and display view
            viewbmd = new BitmapData(465, 465);
            view = new Bitmap(viewbmd);
            var mask:Shape = new Shape();
            mask.graphics.beginFill(0xFFFFFF);
            mask.graphics.drawRect(50, 125, 376, 300);
            mask.graphics.endFill();
            this.addChild(mask);
            view.mask = mask;
            addChild(view);
            
            // render
            this.addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function onEnter(e:Event):void
        {
            dmfmap.draw(mapflame);
            viewbmd.lock();
            viewbmd.draw(flame1);
            viewbmd.draw(flame2, null, null, "add");
            viewbmd.draw(shape);
            viewbmd.applyFilter(viewbmd, rect, p, cmf);
            viewbmd.applyFilter(viewbmd, rect, p, preBlur);
            viewbmd.applyFilter(viewbmd, rect, p, dmf);
            viewbmd.applyFilter(viewbmd, rect, p, postBlur);
            viewbmd.unlock();
        }
    }
}



import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.filters.ColorMatrixFilter;
import flash.geom.Point;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.Shape;

class ScrollingPerlinNoise extends Sprite
{
    
    public var numOctaves:int;
    public var skyColor:uint;
    public var cloudsHeight:int;
    public var cloudsWidth:int;
    public var periodX:Number;
    public var periodY:Number;
    public var scrollAmountX:int;
    public var scrollAmountY:int;
    public var cloudsBitmapData:BitmapData;
    private var cloudsBitmap:Bitmap;
    private var cmf:ColorMatrixFilter;
    private var colorBackground:Shape;
    private var displayWidth:Number;
    private var displayHeight:Number;
    private var seed:int;
    private var sliceDataH:BitmapData;
    private var sliceDataV:BitmapData;
    private var sliceDataCorner:BitmapData;
    private var horizCutRect:Rectangle;
    private var vertCutRect:Rectangle;
    private var cornerCutRect:Rectangle;
    private var horizPastePoint:Point;
    private var vertPastePoint:Point;
    private var cornerPastePoint:Point;
    private var origin:Point;
    private var cloudsMask:Shape;
    private var grayScale:Boolean;
    
    public function ScrollingPerlinNoise(w:int = 300, h:int = 200, scrollX:int = 0, scrollY:int = -4, useBG:Boolean = true, col:uint = 0x000000, nOctaves:Number = 5, perlinPeriodX:Number = 150, perlinPeriodY:Number = 150, gray:Boolean = true)
    {
        
        displayWidth = w;
        displayHeight = h;
        //the code can be modified so that the clouds are bigger than the display
        cloudsWidth = displayWidth;
        cloudsHeight = displayHeight;
        periodX = perlinPeriodX;
        periodY = perlinPeriodY;
        scrollAmountX = scrollX;
        scrollAmountY = scrollY;
        grayScale = gray;
        
        numOctaves = nOctaves;
        
        skyColor = col;
        
        cloudsBitmapData = new BitmapData(cloudsWidth, cloudsHeight, true);
        cloudsBitmap = new Bitmap(cloudsBitmapData);
        
        origin = new Point(0, 0);
        
        if (useBG)
        {
            colorBackground = new Shape();
            colorBackground.graphics.beginFill(skyColor);
            colorBackground.graphics.drawRect(0, 0, displayWidth, displayHeight);
            colorBackground.graphics.endFill();
            
            this.addChild(colorBackground);
        }
        this.addChild(cloudsBitmap);
        
        makeClouds();
        setRectangles();
    }
    
    public function startScroll():void
    {
        this.addEventListener(Event.ENTER_FRAME, onEnter);
    }
    
    public function stopScroll():void
    {
        this.removeEventListener(Event.ENTER_FRAME, onEnter);
    }
    
    private function setRectangles():void
    {
        
        if (scrollAmountX != 0)
        {
            sliceDataV = new BitmapData(Math.abs(scrollAmountX), cloudsHeight - Math.abs(scrollAmountY), true);
        }
        if (scrollAmountY != 0)
        {
            sliceDataH = new BitmapData(cloudsWidth, Math.abs(scrollAmountY), true);
        }
        if ((scrollAmountX != 0) && (scrollAmountY != 0))
        {
            sliceDataCorner = new BitmapData(Math.abs(scrollAmountX), Math.abs(scrollAmountY), true);
        }
        horizCutRect = new Rectangle(0, cloudsHeight - scrollAmountY, cloudsWidth - Math.abs(scrollAmountX), Math.abs(scrollAmountY));
        vertCutRect = new Rectangle(cloudsWidth - scrollAmountX, 0, Math.abs(scrollAmountX), cloudsHeight - Math.abs(scrollAmountY));
        cornerCutRect = new Rectangle(cloudsWidth - scrollAmountX, cloudsHeight - scrollAmountY, Math.abs(scrollAmountX), Math.abs(scrollAmountY));
        
        horizPastePoint = new Point(scrollAmountX, 0);
        vertPastePoint = new Point(0, scrollAmountY);
        cornerPastePoint = new Point(0, 0);
        
        if (scrollAmountX < 0)
        {
            cornerCutRect.x = vertCutRect.x = 0;
            cornerPastePoint.x = vertPastePoint.x = cloudsWidth + scrollAmountX;
            horizCutRect.x = -scrollAmountX;
            horizPastePoint.x = 0;
        }
        if (scrollAmountY < 0)
        {
            cornerCutRect.y = horizCutRect.y = 0;
            cornerPastePoint.y = horizPastePoint.y = cloudsHeight + scrollAmountY;
            vertCutRect.y = -scrollAmountY;
            vertPastePoint.y = 0;
        }
    
    }
    
    public function makeClouds():void
    {
        seed = int(Math.random() * 0xFFFFFF);
        
        //draw clouds
        if (grayScale)
        {
            cloudsBitmapData.perlinNoise(periodX, periodY, numOctaves, seed, true, true, 1, true);
        }
        else
        {
            cloudsBitmapData.perlinNoise(periodX, periodY, numOctaves, seed, true, true, 7, false);
        }
        alphaAdjust();
        colorAdjust();
    }
    
    //alpha adjust
    protected function alphaAdjust():void 
    {

    }

    // color adjust
    protected function colorAdjust():void 
    {
        
    }
    
    private function onEnter(evt:Event):void
    {
        cloudsBitmapData.lock();
        
        //copy to buffers the part that will be cut off
        if (scrollAmountX != 0)
        {
            sliceDataV.copyPixels(cloudsBitmapData, vertCutRect, origin);
        }
        if (scrollAmountY != 0)
        {
            sliceDataH.copyPixels(cloudsBitmapData, horizCutRect, origin);
        }
        if ((scrollAmountX != 0) && (scrollAmountY != 0))
        {
            sliceDataCorner.copyPixels(cloudsBitmapData, cornerCutRect, origin);
        }
        
        //scroll
        cloudsBitmapData.scroll(scrollAmountX, scrollAmountY);
        
        //draw the buffers on the opposite sides
        if (scrollAmountX != 0)
        {
            cloudsBitmapData.copyPixels(sliceDataV, sliceDataV.rect, vertPastePoint);
        }
        if (scrollAmountY != 0)
        {
            cloudsBitmapData.copyPixels(sliceDataH, sliceDataH.rect, horizPastePoint);
        }
        if ((scrollAmountX != 0) && (scrollAmountY != 0))
        {
            cloudsBitmapData.copyPixels(sliceDataCorner, sliceDataCorner.rect, cornerPastePoint);
        }
        
        cloudsBitmapData.unlock();
    }

}

class Flame extends ScrollingPerlinNoise
{
    public function Flame(w:int = 300, h:int = 200, scrollX:int = 0, scrollY:int = -4, useBG:Boolean = true, col:uint = 0x000000, nOctaves:Number = 5, perlinPeriodX:Number = 150, perlinPeriodY:Number = 150, gray:Boolean = true)
    {
        super(w, h, scrollX, scrollY, useBG, col, nOctaves, perlinPeriodX, perlinPeriodY, gray);
    }
    
    override protected function alphaAdjust():void 
    {
        var alphas:ColorMatrixFilter = new ColorMatrixFilter(
                                                [1, 0, 0, 0, 0,
                                                 0, 1, 0, 0, 0,
                                                 0, 0, 1, 0, 0,
                                                 1, 0, 0, 0, 0]);
                                                 
        cloudsBitmapData.applyFilter(cloudsBitmapData, cloudsBitmapData.rect, new Point(), alphas);
        
    }

}
