/**
 * Copyright k0rin ( http://wonderfl.net/user/k0rin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/169b
 */

// Flash Playerの10.0.12.36以前にあるバグ
// (10.0.22.87で直ったようです)
// Matrix3D.append/prependの乗算結果がおかしい。
// http://bugs.adobe.com/jira/browse/FP-670 参照

// 過去にMatrix3D.transformVectorに同根のバグあり。

package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.system.Capabilities;
	import flash.text.*;

	[SWF(width="465", height="465", backgroundColor="0xFFFFFF")]
	public class Matrix3DBug extends Sprite
	{
		public function Matrix3DBug()
		{
			var lhs:Matrix3D;
			var rhs:Matrix3D;
			var result:Matrix3D;
			
			print("Flash Player version : " + Capabilities.version + "\n\n");
			
			print("Matrix3D.append() test\n\n");
			function multiply(lhs:Matrix3D, rhs:Matrix3D):void {
				result = rhs.clone();
				result.append(lhs);
				printCalculation(lhs, rhs, result);
			}
			
//			print("Matrix3D.prepend() test\n\n");
//			function multiply(lhs:Matrix3D, rhs:Matrix3D):void {
//				result = lhs.clone();
//				result.prepend(rhs);
//				printCalculation(lhs, rhs, result);
//			}
			
			lhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 1,  0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0 ]));
			rhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 1, 0, 0, 0 ]));
			multiply(lhs, rhs);
			
			lhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0, 0, 0, 0, 0 ]));
			rhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 0, 1, 0, 0 ]));
			multiply(lhs, rhs);
			
			lhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1, 0, 0, 0, 0 ]));
			rhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 1, 0 ]));
			multiply(lhs, rhs);
			
			lhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 1 ]));
			rhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 1 ]));
			multiply(lhs, rhs);
			
			lhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 1,  0, 0, 0, 1,  0, 0, 0, 1, 0, 0, 0, 1 ]));
			rhs = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0, 1, 1, 1, 1 ]));
			multiply(lhs, rhs);
			
			print("PerspectiveProjection.toMatrix3D * translation matrix :\n\n");
			
			var projection:PerspectiveProjection = new PerspectiveProjection();
			projection.focalLength = 100;
			lhs = projection.toMatrix3D();
			rhs = new Matrix3D();
			rhs.appendTranslation(1, 2, 3);
			multiply(lhs, rhs);
			
			
			var format:TextFormat = new TextFormat();
			format.font = "_等幅";
			format.size = 12;
			output.setTextFormat(format);
			output.autoSize = TextFieldAutoSize.LEFT;
			addChild(output);
		}
		
		private var output:TextField = new TextField();
		
		private function print(string:String):void
		{
			output.appendText(string);
		}
		
		private function printCalculation(lhs:Matrix3D, rhs:Matrix3D, result:Matrix3D):void
		{
			function printRow(matrix:Matrix3D, row:int):void
			{
				print("[");
				for (var column:int = 0; column < 4; column++) {
					print(("   " + matrix.rawData[column * 4 + row]).substr(-4, 4));
				}
				print(" ]");
			}
			
			for (var row:int = 0; row < 4; row++) {
				printRow(lhs, row);
				printRow(rhs, row);
				print((row == 1) ? " = " : "   ");
				printRow(result, row);
				print("\n");
			}
			print("\n");
		}
	}
}
