/**
 * Copyright kenbu ( http://wonderfl.net/user/kenbu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/166I
 */

package 
{ 
    import flash.display.Bitmap; 
    import flash.display.BitmapData; 
    import flash.display.Sprite; 
    import flash.display.StageAlign; 
    import flash.display.StageScaleMode; 
    import flash.events.Event; 
    import flash.geom.Rectangle; 
         import flash.geom.Point; 
     
        // [SWF(width="500", height="500", backgroundColor="0xFFFFFF", frameRate="40")]  

    public class Main extends Sprite 
    { 
         
        private var maze:Maze; 
        private var bitmap:Bitmap; 
         
        private const WIDTH:Number = 105; 
        private const HEIGHT:Number = 105; 
        private const SCALE:Number = 4; 
         
        public function Main() 
        { 
            stage.scaleMode = StageScaleMode.NO_SCALE; 
            stage.align = StageAlign.TOP_LEFT; 
             
            var progressArray:Array = []; 
            maze = new PPDMaze(WIDTH,HEIGHT,progressArray); 
             
            var bitmapData:BitmapData = new BitmapData(WIDTH*SCALE, HEIGHT*SCALE); 
            bitmap = new Bitmap(bitmapData); 
            addChild(bitmap); 
             
         
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler); 
        } 
         
         

        private var cnt:int = 0; 
        private function enterFrameHandler(event:Event):void 
        { 
            var l:int = 50; 
            for(var i:int = 0; i<l; i++) 
            { 
                draw(); 
            } 
            if(cnt == maze.buildProgressArray.length) 
            { 
                this.removeEventListener(Event.ENTER_FRAME, enterFrameHandler); 
            } 
        } 
         
         
        private var rect:Rectangle = new Rectangle(0,0,0,0); 
        private function draw():void 
        { 
            if(cnt == maze.buildProgressArray.length) 
            { 
                return; 
            } 
             
            var point:MazePoint = maze.buildProgressArray[cnt]; 
            var color:Number; 
            if(point.value == 0) 
            { 
                color = 0xffffffff; 
            } 
            else 
            { 
                color = 0xff000000; 
            } 
            var scale:Number = 3; 
             
            var bitmapData:BitmapData = bitmap.bitmapData; 
             
            rect.x = point.x * SCALE; 
            rect.y = point.y * SCALE; 
            rect.width = SCALE; 
            rect.height = SCALE; 
             
             
            bitmapData.fillRect(rect, color); 

             
            cnt++; 


         
        } 
    } 
} 

    class Maze 
    { 
         
        public var width:uint; 
        public var height:uint; 
        public var data:Array; 
        public var buildProgressArray:Array; 
         

        public function Maze(width:uint, height:uint, buildProgressArray:Array = null) 
        { 
            this.width = width; 
            this.height = height; 
            this.buildProgressArray = buildProgressArray; 
            initialize(); 
        } 
         
        protected function initialize():void 
        { 
            data = []; 
        } 
         
         
        protected function setData(x:uint, y:uint, value:uint):void 
        {     
            //value : 1(壁)　, 0(道) 
            data[x + width*y] = value; 

            if(buildProgressArray) 
            { 
                buildProgressArray.push(new MazePoint(x, y, value)); 
            } 
        } 

        public function getData(x:uint, y:uint):uint 
        { 
            return data[x + width*y]; 
        } 

    } 



    import flash.geom.Point; 
     
	
	class PPDMaze extends Maze
	{
		
		public var density:Number;
		

		public function PPDMaze(width:uint, height:uint, buildProgressArray:Array = null,density:Number = 1)
		{
			this.density = density
			super(width, height, buildProgressArray);
			//密度
			
		}
		
		override protected function initialize():void
		{
			super.initialize();
			
			setDefWall();
			setWall();
		}
		
		private function setDefWall():void
		{
			//まず外枠を作る。
			for(var y:int = 0; y< height; y++)
			{
				for(var x:int = 0; x< width; x++)
				{
					if(y==0 || y == height-1 || x==0 || x == width-1)
					{
						//外枠を作る。
						setData(x,y,1);
					}
					else if(x%2 == 0 && y%2 == 0)
					{
						//中壁を作る。
						setData(x,y,1);
					}
					else
					{
						setData(x,y,0);
					}
				}	
			}
		}
		
		private function setWall():void
		{
			//左端の壁の処理
			for(var y:int = 0; y< height; y++)
			{
				for(var x:int = 0; x< width; x++)
				{
					if(y==0 || y == height-1 || x==0 || x == width-1)
					{
						continue;
					}
					if(x%2 == 0 && y%2 == 0)
					{
						setRandomWall(x,y);
					}
				}	
			}
		}
		
		
		private var tmpLeftPoint:Point = new Point(0,0);
		private var tmpTopPoint:Point = new Point(0,0);
		private var tmpRightPoint:Point = new Point(0,0);
		private var tmpBottomPoint:Point = new Point(0,0);
		
		private function setRandomWall(x:uint, y:uint):void
		{
			// ～1:上 ,～2:右 ～3:下, ～4:左
			
			if(density > Math.random())
			{
				//配置が可能なマスを見つける
				var enabledArray:Array = [];
				if(x == 2)
				{
					//左端
					if(!getData(x-1, y))
					{
						tmpLeftPoint.x = x-1;
						tmpLeftPoint.y = y;
						enabledArray.push(tmpLeftPoint);
					}
				}
				//上を調べる。
				if(!getData(x, y-1))
				{
					tmpTopPoint.x = x;
					tmpTopPoint.y = y-1;
					enabledArray.push(tmpTopPoint);
				}
				
				//右を調べる。
				if(!getData(x+1, y))
				{
					tmpRightPoint.x = x+1;
					tmpRightPoint.y = y;
					enabledArray.push(tmpRightPoint);
				}
				//下を調べる。
				if(!getData(x, y+1))
				{
					tmpBottomPoint.x = x;
					tmpBottomPoint.y = y+1;
					enabledArray.push(tmpBottomPoint);
				}
				

				
				if(enabledArray.length > 0)
				{
					var point:Point = enabledArray[int(enabledArray.length*Math.random())];
					setData(point.x, point.y, 1);
				}
			}
		}
		

	}


     




     
         import flash.geom.Point; 
    class MazePoint extends Point 
    { 
        public var value:int; 
        public function MazePoint(x:Number,y:Number,value:int) 
        { 
            super(x,y); 
            this.value = value; 
        } 
         
    } 

