/**
 * Copyright yurij.shaulov ( http://wonderfl.net/user/yurij.shaulov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/150x
 */

package{

    import flash.display.*;

    import flash.events.*;

    import flash.media.*;

    import flash.system.*;

    import flash.text.*;

    import flash.geom.*;

    import flash.filters.*;

    [SWF(width="320", height="240")]

    public class Threshold extends Sprite {

    private var video:Video;

    private var camera:Camera;

    private var msg:String;

    public var txtArea:TextField = new TextField();

    public var bdTmp:BitmapData;

    public var bmp:Bitmap;



    public function Threshold()

    {

        stage.scaleMode = StageScaleMode.NO_SCALE;

        stage.align = StageAlign.TOP_LEFT;

        camera = Camera.getCamera();

        if(camera != null){

        camera.addEventListener(StatusEvent.STATUS, statusHandler);

        camera.setMode(500, 500, 10);

        camera.setMotionLevel(10);

        camera.setQuality(0, 50);

        video = new Video(camera.width, camera.height);

        video.attachCamera(camera);

        addEventListener(Event.ENTER_FRAME, tick);

        }else{

        msg = "使用可能なカメラがありません。";

        txtArea.text = msg;

        }

        txtArea.autoSize = TextFieldAutoSize.LEFT;

        txtArea.text = "Threshold";

        txtArea.textColor = 0xffffff;

        txtArea.x = 2;

        txtArea.y = this.height - txtArea.textHeight - 10;

        this.addChild(txtArea);

        bdTmp = new BitmapData(video.width, video.height, false, 0xffffff);

        bmp = new Bitmap(bdTmp);

        this.addChild(bmp);

    }

    private function statusHandler(evt:StatusEvent):void{

        if(camera.muted){

        msg = "カメラへのアクセスが拒否されました。";

        msg += "カメラの映像を表示するにはアクセスを許可してください。";

        txtArea.text = msg;

        Security.showSettings(SecurityPanel.PRIVACY);

        }else{

        msg = "使用中のカメラ : " + camera.name + "\n";

        msg += "幅x高さ : " + camera.width + "x" + camera.width;

        txtArea.text = msg;

        }

    }

    private function tick(event:Event):void{

        if(video == null || camera == null){

        return;

        }

        if(camera.muted == true){

        return;

        }

        bdTmp.draw(video);

        var rect:Rectangle = new Rectangle(bmp.width/2, 0, 

                           bmp.width/2, bmp.height);

        var target:Point = new Point(bmp.width/2, 0);

        var filter:ColorMatrixFilter = new ColorMatrixFilter();

        filter.matrix = new Array(3, 0, 0, 0, 3,1,1);

        bdTmp.applyFilter(bdTmp, rect, target, filter);

    }

    }

}