/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/14Nm
 */

// forked from hachi's forked from: forked from: [PV3D] Simple Sphere
// forked from yes_i_can's forked from: [PV3D] Simple Sphere
package 
{
    // 必要なライブラリをインポートします
    import flash.events.Event;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    
    /**
     * シンプルな球面デモ(BasicViewを継承すると最低限の必要な3D設定が済んでます)
     */
    public class Main extends BasicView
    {
        public function Main():void 
        {
            // ライトを作成します
            var light:PointLight3D = new PointLight3D();
            
            // 球面のポリゴンに貼り付けるテクスチャ(フラットポリゴンを使用)を作成します
            // 引数はライト、明るい部分の色、暗い部分の色です。
            var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF3B77, 0x111111);
            
            // 球面を作成(引数はテクスチャ、半径、横方向のポリゴン分割数、縦方向のポリゴン分割数)
            var sphere:Sphere = new Sphere(material, 400, 6, 6);
            
            // 3Dシーンに表示(PV3DではsceneにaddChildします)
            scene.addChild(sphere);
            
            // レンダリング開始
            startRendering();
            
            // ループ処理を設定します
            addEventListener(Event.ENTER_FRAME, function(e:Event):void 
                {
                // 球面がY軸に回転します
                sphere.rotationX += 3;
                sphere.rotationZ += 1;
                });
         }
    }
}