/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/14E8
 */

package
{
	import flash.display.*
	import flash.events.*;
	import flash.geom.*
	import frocessing.color.ColorHSV;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var prev:Point = new Point();
		private var frame:int = 0;
 
		public function Main()
		{	
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
			addChild(new Bitmap(bd));
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private var color:ColorHSV = new ColorHSV();
 
		private function onMouseMove(event:MouseEvent):void
		{
			if (frame++ % 3 == 0)
			{
				color.h = frame;
 
				var circle:Sprite = new Sprite();
				circle.graphics.lineStyle(3.0, color.value);
				circle.graphics.drawCircle(prev.x + (mouseX - prev.x) / 2, prev.y + (mouseY - prev.y) / 2, Math.sqrt(Math.pow(mouseX - prev.x, 2) + Math.pow(mouseY - prev.y, 2)) / 2);
 
				bd.draw(circle); 
				prev.x = mouseX;
				prev.y = mouseY;
			}
 
 
			bd.colorTransform(bd.rect, new ColorTransform(1, 1, 1, 0.999));
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
