/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/137M
 */

// forked from ProjectNya's 輪になって回るひよこちゃん
//本当は首だけ回したかった…
////////////////////////////////////////////////////////////////////////////////
// 輪になって回るひよこちゃん
////////////////////////////////////////////////////////////////////////////////

package {

	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.system.Security;

	[SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

	public class Main extends Sprite {
		private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
		private static var sunshinePath:String = "9/9b/9bbe/9bbec77d53bddc5e7a5f2c00abbade6bd641c549";
		private var perspective:Perspective;
		private static var max:uint = 12;
		private var objList:Array;
		private var id:uint = 0;
		private static var chickPath:String = "http://www.project-nya.jp/images/flash/chick.swf";
		private var radius:uint = 30;
		private static var radian:Number = Math.PI/180;
		private static var speed:Number = 10;
		private var completed:uint = 0;

		public function Main() {
			Wonderfl.capture_delay(4);
			init();
		}

		private function init():void {
			var sky:Sky = new Sky(465, 250);
			addChild(sky);
			var ground:Ground = new Ground(465, 215);
			addChild(ground);
			ground.y = 250;
			var sun:Sun = new Sun(100);
			addChild(sun);
			sun.x = 10;
			sun.y = 10;
			var shine:PhotoLoader = new PhotoLoader();
			addChild(shine);
			shine.alpha = 0.5;
			shine.load(basePath + sunshinePath);
			perspective = new Perspective();
			perspective.init(232, 232);
			objList = new Array();
			for (var n:uint = 0; n < max; n++) {
				var obj:Object3D = new Object3D();
				addChild(obj);
				obj.angle = n*360/max + 180;
				obj.px = radius * Math.cos(obj.angle * radian);
				obj.py = -200 + radius * Math.sin(obj.angle * radian);
				obj.pz = n * 100;
				perspective.register(obj, n);
				objList.push(obj);
				load(n);
			}
			perspective.setView(0, radius*0.5, 0);
			perspective.transform();
		}
		private function load(id:uint):void {
			var loader:ChickLoader = new ChickLoader(id);
			//loader.addEventListener(ChickLoader.COMPLETE, complete, false, 0, true);
			loader.addEventListener(ChickLoader.COMPLETE, complete, false, 0, false);
			var time:Number = new Date().time;
			loader.load(chickPath + "?time=" + time);
		}
		private function complete(evt:Event):void {
			var loader:ChickLoader = ChickLoader(evt.target);
			loader.removeEventListener(ChickLoader.COMPLETE, complete);
			var chick:MovieClip = loader.content;
			//addChild(chick);
			chick.scaleX = chick.scaleY = 2;
			var id:uint = loader.id;
			var obj:Object3D = objList[id];
			obj.addChild(chick);
			completed ++;
			if (completed < max) {
				addEventListener(Event.ENTER_FRAME, update, false, 0, true);
			}
			//loader = null;
		}
		private function update(evt:Event):void {
			for (var n:uint = 0; n < max; n++) {
				var obj:Object3D = objList[n];
				rotate(obj);
			}
			perspective.transform();
		}
		private function rotate(obj:Object3D):void {
			var radian:Number = Math.PI/180;
			obj.angle += speed;
			obj.px = radius*Math.sin(obj.angle*radian);
			obj.py = -200 + radius*Math.cos(obj.angle*radian) + radius;
		}

	}

}


import flash.display.Sprite;
import flash.display.MovieClip;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.Security;
import flash.system.LoaderContext;

class ChickLoader extends Sprite {
	public var id:uint;
	private var loader:Loader;
	private var info:LoaderInfo;
	public var content:MovieClip;
	public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
	public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
	public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
	public static const INIT:String = Event.INIT;
	public static const COMPLETE:String = Event.COMPLETE;

	public function ChickLoader(n:uint) {
		Security.allowDomain("www.project-nya.jp");
		id = n;
		loader = new Loader();
		info = loader.contentLoaderInfo;
	}

	public function load(file:String):void {
		info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
		info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
		info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
		info.addEventListener(Event.INIT, initialize, false, 0, true);
		//info.addEventListener(Event.COMPLETE, complete, false, 0, true);
		info.addEventListener(Event.COMPLETE, complete, false, 0, false);
		try {
			loader.load(new URLRequest(file), new LoaderContext(true));
		} catch (err:Error) {
			trace(err.message);
			//load(file);
		}
	}
	public function unload():void {
		loader.unload();
	}
	private function ioerror(evt:IOErrorEvent):void {
		loader.unload();
		dispatchEvent(new Event(ChickLoader.IO_ERROR));
	}
	private function httpstatus(evt:HTTPStatusEvent):void {
		dispatchEvent(new Event(ChickLoader.HTTP_STATUS));
	}
	private function securityerror(evt:SecurityErrorEvent):void {
		dispatchEvent(new Event(ChickLoader.SECURITY_ERROR));
	}
	private function initialize(evt:Event):void {
		content = MovieClip(info.content);
		dispatchEvent(new Event(ChickLoader.INIT));
	}
	private function complete(evt:Event):void {
		info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
		info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
		info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
		info.removeEventListener(Event.INIT, initialize);
		info.removeEventListener(Event.COMPLETE, complete);
		//addChild(loader);
		dispatchEvent(new Event(ChickLoader.COMPLETE));
	}

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Sky extends Shape {
	private static var _width:uint;
	private static var _height:uint;
	private static var color1:uint = 0x3F68AB;
	private static var color2:uint = 0x77B2EE;

	public function Sky(w:uint, h:uint) {
		_width = w;
		_height = h;
		draw();
	}

	private function draw():void {
		var colors:Array = [color1, color2];
		var alphas:Array = [1, 1];
		var ratios:Array = [0, 255];
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(_width, _height, 0.5*Math.PI, 0, 0);
		graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
		graphics.drawRect(0, 0, _width, _height);
		graphics.endFill();
	}

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Ground extends Shape {
	private static var _width:uint;
	private static var _height:uint;
	private static var color1:uint = 0x99CC33;
	private static var color2:uint = 0x7EB133;

	public function Ground(w:uint, h:uint) {
		_width = w;
		_height = h;
		draw();
	}

	private function draw():void {
		var colors:Array = [color1, color2];
		var alphas:Array = [1, 1];
		var ratios:Array = [0, 255];
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(_width, _height, 0.5*Math.PI, 0, 0);
		graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
		graphics.drawRect(0, 0, _width, _height);
		graphics.endFill();
	}

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Sun extends Shape {
	private static var radius:uint;
	private static var color:uint = 0xFFFFFF;

	public function Sun(r:uint) {
		radius = r;
		draw();
	}

	private function draw():void {
		var colors:Array = [color, color, color];
		var alphas:Array = [1, 0.3, 0];
		var ratios:Array = [25, 102, 231];
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
		graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}

}


import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.display.Bitmap;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
	private var loader:Loader;
	private var info:LoaderInfo;
	public var content:Bitmap;
	private var smoothing:Boolean;
	public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
	public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
	public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
	public static const INIT:String = Event.INIT;
	public static const COMPLETE:String = Event.COMPLETE;

	public function PhotoLoader() {
		loader = new Loader();
		info = loader.contentLoaderInfo;
	}

	public function load(file:String, s:Boolean = false):void {
		smoothing = s;
		info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
		info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
		info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
		info.addEventListener(Event.INIT, initialize, false, 0, true);
		info.addEventListener(Event.COMPLETE, complete, false, 0, true);
		try {
			loader.load(new URLRequest(file), new LoaderContext(true));
		} catch (err:Error) {
			trace(err.message);
		}
	}
	public function unload():void {
		loader.unload();
	}
	private function ioerror(evt:IOErrorEvent):void {
		loader.unload();
		dispatchEvent(new Event(PhotoLoader.IO_ERROR));
	}
	private function httpstatus(evt:HTTPStatusEvent):void {
		dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
	}
	private function securityerror(evt:SecurityErrorEvent):void {
		dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
	}
	private function initialize(evt:Event):void {
		content = Bitmap(info.content);
		if (smoothing) content.smoothing = true;
		dispatchEvent(new Event(PhotoLoader.INIT));
	}
	private function complete(evt:Event):void {
		info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
		info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
		info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
		info.removeEventListener(Event.INIT, initialize);
		info.removeEventListener(Event.COMPLETE, complete);
		addChild(loader);
		dispatchEvent(new Event(PhotoLoader.COMPLETE));
	}

}


//////////////////////////////////////////////////
//	Perspectiveクラス
//////////////////////////////////////////////////

import flash.display.Sprite;

class Perspective {
	private var objList:Array;
	private var fl:Number = 250;
	private var vp:Object;
	private var view:Object;
	private var ax:Number = 0;
	private var ay:Number = 0;
	private var az:Number = 0;
	private var brighted:Boolean = false;
	private var front:Number = -100;
	private var back:Number = 100;
	private var depthList:Array;

	public function Perspective() {
		objList = new Array();
		vp = {x: 0, y: 0};
		view = {x: 0, y: 0, z: 0};
		depthList = new Array();
	}

	public function init(x:int, y:int):void {
		vp = {x: x, y: -y};
	}
	public function register(obj:Object3D, n:uint):void {
		objList.push(obj);
		obj.id = n;
	}
	public function transform():void {
		for (var n:uint = 0; n < objList.length; n++) {
			var obj:Object3D = objList[n];
			setPerspective(obj);
		}
		manageDepths();
	}
	private function setPerspective(obj:Object3D):void {
		if (obj.pz + view.z > - fl + 50) {
			var scale:Number = fl/(fl + obj.pz + view.z);
			obj.scale = scale;
			obj.x = vp.x + (obj.px - view.x)*scale;
			obj.y = - vp.y - (obj.py + view.y)*scale;
			if (brighted) obj.brightness = -100*(obj.pz + view.z - front)/(back - front);
			obj.visible = true;
		} else {
			obj.visible = false;
		}
	}
	private function manageDepths():void {
		objList.sortOn(["pz", "id"], [Array.DESCENDING | Array.NUMERIC, Array.DESCENDING | Array.NUMERIC]);
		for (var n:uint = 0; n < objList.length; n++) {
			var obj:Object3D = objList[n];
			obj.stage.addChildAt(obj, n+1);
		}
	}
	public function screen(f:Number, b:Number):void {
		if (front == back) {
			brighted = false;
		} else {
			brighted = true;
			front = f;
			back = b;
		}
	}
	public function setView(x:Number, y:Number, z:Number):void {
		view.x = x;
		view.y = -y;
		view.z = -z;
		transform();
	}
	public function rotate(x:Number, y:Number, z:Number):void {
		for (var n:uint = 0; n < objList.length; n++) {
			var obj:Object3D = objList[n];
			angleX(obj, x - ax);
			angleY(obj, y - ay);
			angleZ(obj, z - az);
			setPerspective(obj);
		}
		manageDepths();
		ax = x%360;
		ay = y%360;
		az = z%360;
	}
	public function rotateX(angle:Number):void {
		var a:Number = angle - ax;
		for (var n:uint = 0; n < objList.length; n++) {
			var obj:Object3D = objList[n];
			angleX(obj, a);
			setPerspective(obj);
		}
		manageDepths();
		ax = angle%360;
	}
	public function rotateY(angle:Number):void {
		var a:Number = angle - ay;
		for (var n:uint = 0; n < objList.length; n++) {
			var obj:Object3D = objList[n];
			angleY(obj, a);
			setPerspective(obj);
		}
		manageDepths();
		ay = angle%360;
	}
	public function rotateZ(angle:Number):void {
		var a:Number = angle - az;
		for (var n:uint = 0; n < objList.length; n++) {
			var obj:Object3D = objList[n];
			angleZ(obj, a);
			setPerspective(obj);
		}
		manageDepths();
		az = angle%360;
	}
	private function angleX(obj:Object3D, angle:Number):void {
		var radian:Number = -angle*Math.PI/180;
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
		var ry:Number = obj.py*cos - obj.pz*sin;
		var rz:Number = obj.pz*cos + obj.py*sin;
		obj.py = ry;
		obj.pz = rz;
	}
	private function angleY(obj:Object3D, angle:Number):void {
		var radian:Number = -angle*Math.PI/180;
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
		var rx:Number = obj.px*cos - obj.pz*sin;
		var rz:Number = obj.pz*cos + obj.px*sin;
		obj.px = rx;
		obj.pz = rz;
	}
	private function angleZ(obj:Object3D, angle:Number):void {
		var radian:Number = -angle*Math.PI/180;
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
		var rx:Number = obj.px*cos - obj.py*sin;
		var ry:Number = obj.py*cos + obj.px*sin;
		obj.px = rx;
		obj.py = ry;
	}

}


//////////////////////////////////////////////////
//	Object3Dクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.ColorTransform;

class Object3D extends Sprite {
	public var id:uint;
	public var px:Number;
	public var py:Number;
	public var pz:Number;
	public var angle:Number;
	private var _scale:Number = 1;
	private var colorTrans:ColorTransform;
	private var _brightness:Number = 0;

	public function Object3D() {
		colorTrans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
	}

	public function get scale():Number {
		return _scale;
	}
	public function set scale(param:Number):void {
		_scale = param;
		scaleX = scaleY = _scale;
	}
	public function get brightness():Number {
		return _brightness;
	}
	public function set brightness(param:Number):void {
		_brightness = param;
		var percent:uint = 100 - Math.abs(param);
		var offset:uint = (param > 0) ? (255*param*0.01) : 0;
		setColorTrans(percent, offset);
	}
	private function setColorTrans(percent:Number, offset:Number):void {
		colorTrans.redMultiplier = percent*0.01;
		colorTrans.greenMultiplier = percent*0.01;
		colorTrans.blueMultiplier = percent*0.01;
		colorTrans.redOffset = offset;
		colorTrans.greenOffset = offset;
		colorTrans.blueOffset = offset;
		colorTrans.alphaMultiplier = alpha;
		colorTrans.alphaOffset = 0;
		transform.colorTransform = colorTrans;
	}

}
