/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/12jy
 */

package {
    import flash.utils.describeType;
    import flash.utils.getQualifiedClassName;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        
        public function FlashTest() {
            addChild(_textField);
            _textField.width = stage.stageWidth;
            _textField.height = stage.stageHeight;
            intMadness();
            uintMadness();
        }
        
        public function intMadness():void {   
            /**
                From adobe docs: http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/int.html
              
                MAX_VALUE : int = 2147483647
                [static] The largest representable 32-bit signed integer, which is 2,147,483,647.
                
                MIN_VALUE : int = -2147483648
                [static] The smallest representable 32-bit signed integer, which is -2,147,483,648.
            */
            t( "\n--- int tests ---" );
            t( "int.MIN_VALUE should be 'int' but is: '"+getQualifiedClassName(int.MIN_VALUE)+"'" );
            t( "int.MAX_VALUE should be 'int' but is: '"+getQualifiedClassName(int.MAX_VALUE)+"'" );
            t( "Consequences:" );
            t( "int.MIN_VALUE - 1 should be int.MAX_VALUE, is it: "+((int.MIN_VALUE -1)== int.MAX_VALUE) );
            var a: int = int.MIN_VALUE;
            --a;
            t( "it works however with a variable: "+(a==int.MAX_VALUE) );
            a = int.MAX_VALUE;
            t( "it does not work in an operation(int is transformed to Number!): "+((a-1)==int.MAX_VALUE) );
            a = 0;
            t( a is uint );
            --a;
            t( a is uint );
        }
        
        public function uintMadness(a:uint = 0):void {
            var b:uint = 0;
            const c:uint = 0.0;
            t( "\n--- uint tests ---" );
            t( "method parameter typed 'uint' is of type: "+getQualifiedClassName(a));
            t( "and is it a uint?: "+(a is uint) );
            t( "and is it a int?: "+(a is int) );
            t( "and is it a number?: "+(a is Number) );
            t( "variable typed 'uint' is of type: "+getQualifiedClassName(b));
            t( "and is it a uint?: "+(b is uint) );
            t( "and is it a int?: "+(b is int) );
            t( "and is it a number?: "+(b is Number) );
            t( "constant typed 'uint' is of type: "+getQualifiedClassName(c));
            t( "and is it a uint?: "+(c is uint) );
            t( "and is it a int?: "+(c is int) );
            t( "and is it a number?: "+(c is Number) );
            /**
                From Adobe docs: http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/uint.html
                
                MAX_VALUE : uint = 4294967295
                [static] The largest representable 32-bit unsigned integer, which is 4,294,967,295.
                
                MIN_VALUE : uint = 0
                [static] The smallest representable unsigned integer, which is 0.
            */
            t( "uint.MAX_VALUE should be 'uint' but is: "+getQualifiedClassName(uint.MAX_VALUE));
            t( "uint.MIN_VALUE should be 'uint' but is: "+getQualifiedClassName(uint.MIN_VALUE));
        }
    }
}
import flash.text.TextField;

const _textField: TextField = new TextField();
function t( text: * ):void {
    _textField.appendText( text + "\n" );
}
